/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.Main;
import com.android.tools.lint.Warning;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.annotations.Beta;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class Reporter {
    protected final Main mClient;
    protected final File mOutput;
    protected String mTitle = "Lint Report";
    protected boolean mSimpleFormat;
    protected boolean mBundleResources;
    protected Map<String, String> mUrlMap;
    protected File mResources;
    protected final Map<File, String> mResourceUrl = new HashMap<File, String>();
    protected final Map<String, File> mNameToFile = new HashMap<String, File>();

    public abstract void write(int var1, int var2, List<Warning> var3) throws IOException;

    protected Reporter(Main main, File file) {
        this.mClient = main;
        this.mOutput = file;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setBundleResources(boolean bl) {
        this.mBundleResources = bl;
        this.mSimpleFormat = false;
    }

    public void setSimpleFormat(boolean bl) {
        this.mSimpleFormat = bl;
    }

    public boolean isSimpleFormat() {
        return this.mSimpleFormat;
    }

    String getUrl(File file) {
        String string;
        if (this.mBundleResources && !this.mSimpleFormat && (string = this.getRelativeResourceUrl(file)) != null) {
            return string;
        }
        if (this.mUrlMap != null) {
            string = file.getAbsolutePath();
            try {
                String string2 = URLEncoder.encode(string, "UTF-8");
                for (Map.Entry<String, String> entry : this.mUrlMap.entrySet()) {
                    String string3 = entry.getKey();
                    String string4 = URLEncoder.encode(string3, "UTF-8");
                    if (!string2.startsWith(string4)) continue;
                    String string5 = string2.substring(string4.length());
                    return entry.getValue() + string5.replace("%2F", "/");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("Invalid URL map specification - " + unsupportedEncodingException.getLocalizedMessage());
            }
        }
        return null;
    }

    static String encodeUrl(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Invalid string " + unsupportedEncodingException.getLocalizedMessage());
            return string;
        }
    }

    void setUrlMap(Map<String, String> map) {
        this.mUrlMap = map;
    }

    File getResourceDir() {
        if (this.mResources == null && this.mBundleResources) {
            this.mResources = this.computeResourceDir();
            if (this.mResources == null) {
                this.mBundleResources = false;
            }
        }
        return this.mResources;
    }

    File computeResourceDir() {
        File file;
        String string = this.mOutput.getName();
        int n = string.indexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (!(file = new File(this.mOutput.getParentFile(), string + "_files")).exists() && !file.mkdir()) {
            file = null;
        }
        return file;
    }

    protected String getRelativeResourceUrl(File file) {
        String string = this.mResourceUrl.get(file);
        if (string != null) {
            return string;
        }
        String string2 = file.getName();
        if (!LintUtils.endsWith((String)string2, (String)".png") || LintUtils.endsWith((String)string2, (String)".9.png")) {
            return null;
        }
        File file2 = this.getResourceDir();
        if (file2 != null) {
            String string3 = file.getName();
            File file3 = this.mNameToFile.get(string3);
            if (file3 != null && !file3.equals(file)) {
                for (int i = 0; i < 100 && (file3 = this.mNameToFile.get(string3 = '_' + string3)) != null && !file3.equals(file); ++i) {
                }
            }
            File file4 = new File(file2, string3);
            try {
                Files.copy((File)file, (File)file4);
            }
            catch (IOException iOException) {
                return null;
            }
            return file2.getName() + '/' + Reporter.encodeUrl(string3);
        }
        return null;
    }

    protected String addLocalResources(URL uRL) {
        File file = this.computeResourceDir();
        if (file != null) {
            String string = uRL.getFile();
            string = string.substring(string.lastIndexOf(47) + 1);
            this.mNameToFile.put(string, new File(uRL.toExternalForm()));
            File file2 = new File(file, string);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                InputStream inputStream = uRL.openStream();
                ByteStreams.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                Closeables.closeQuietly((Closeable)fileOutputStream);
                Closeables.closeQuietly((Closeable)inputStream);
            }
            catch (IOException iOException) {
                return null;
            }
            return file.getName() + '/' + Reporter.encodeUrl(string);
        }
        return null;
    }
}

