/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

@Beta
public class DefaultConfiguration
extends Configuration {
    private final LintClient mClient;
    private static final String CONFIG_FILE_NAME = "lint.xml";
    @NonNull
    private static final String TAG_ISSUE = "issue";
    @NonNull
    private static final String ATTR_ID = "id";
    @NonNull
    private static final String ATTR_SEVERITY = "severity";
    @NonNull
    private static final String ATTR_PATH = "path";
    @NonNull
    private static final String TAG_IGNORE = "ignore";
    @NonNull
    private static final String VALUE_ALL = "all";
    private final Configuration mParent;
    private final Project mProject;
    private final File mConfigFile;
    private boolean mBulkEditing;
    private Map<String, List<String>> mSuppressed;
    private Map<String, Severity> mSeverity;

    protected DefaultConfiguration(@NonNull LintClient lintClient, @Nullable Project project, @Nullable Configuration configuration, @NonNull File file) {
        this.mClient = lintClient;
        this.mProject = project;
        this.mParent = configuration;
        this.mConfigFile = file;
    }

    protected DefaultConfiguration(@NonNull LintClient lintClient, @NonNull Project project, @Nullable Configuration configuration) {
        this(lintClient, project, configuration, new File(project.getDir(), CONFIG_FILE_NAME));
    }

    @NonNull
    public static DefaultConfiguration create(@NonNull LintClient lintClient, @NonNull Project project, @Nullable Configuration configuration) {
        return new DefaultConfiguration(lintClient, project, configuration);
    }

    @NonNull
    public static DefaultConfiguration create(@NonNull LintClient lintClient, @NonNull File file) {
        return new DefaultConfiguration(lintClient, null, null, file);
    }

    public boolean isIgnored(@NonNull Context context, @NonNull Issue issue, @Nullable Location location, @NonNull String string, @Nullable Object object) {
        this.ensureInitialized();
        String string2 = issue.getId();
        List<String> list = this.mSuppressed.get(string2);
        if (list == null) {
            list = this.mSuppressed.get(VALUE_ALL);
        }
        if (list != null && location != null) {
            File file = location.getFile();
            String string3 = context.getProject().getRelativePath(file);
            for (String string4 : list) {
                if (!string4.equals(string3)) continue;
                return true;
            }
        }
        if (this.mParent != null) {
            return this.mParent.isIgnored(context, issue, location, string, object);
        }
        return false;
    }

    @NonNull
    protected Severity getDefaultSeverity(@NonNull Issue issue) {
        if (!issue.isEnabledByDefault()) {
            return Severity.IGNORE;
        }
        return issue.getDefaultSeverity();
    }

    @NonNull
    public Severity getSeverity(@NonNull Issue issue) {
        this.ensureInitialized();
        Severity severity = this.mSeverity.get(issue.getId());
        if (severity == null) {
            severity = this.mSeverity.get(VALUE_ALL);
        }
        if (severity != null) {
            return severity;
        }
        if (this.mParent != null) {
            return this.mParent.getSeverity(issue);
        }
        return this.getDefaultSeverity(issue);
    }

    private void ensureInitialized() {
        if (this.mSuppressed == null) {
            this.readConfig();
        }
    }

    private void formatError(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        string = "Failed to parse lint.xml configuration file: " + string;
        LintDriver lintDriver = new LintDriver(new IssueRegistry(){

            @Override
            @NonNull
            public List<Issue> getIssues() {
                return Collections.emptyList();
            }
        }, this.mClient);
        this.mClient.report(new Context(lintDriver, this.mProject, this.mProject, this.mConfigFile), IssueRegistry.LINT_ERROR, this.mProject.getConfiguration().getSeverity(IssueRegistry.LINT_ERROR), Location.create(this.mConfigFile), string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readConfig() {
        this.mSuppressed = new HashMap<String, List<String>>();
        this.mSeverity = new HashMap<String, Severity>();
        if (!this.mConfigFile.exists()) {
            return;
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            bufferedInputStream = new BufferedInputStream(new FileInputStream(this.mConfigFile));
            InputSource inputSource = new InputSource(bufferedInputStream);
            documentBuilderFactory.setNamespaceAware(false);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            NodeList nodeList = document.getElementsByTagName(TAG_ISSUE);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                Node node = nodeList.item(i);
                Element element = (Element)node;
                String string = element.getAttribute(ATTR_ID);
                if (string.isEmpty()) {
                    this.formatError("Invalid lint config file: Missing required issue id attribute", new Object[0]);
                    continue;
                }
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n2 = namedNodeMap.getLength();
                block7: for (int j = 0; j < n2; ++j) {
                    Node node2 = namedNodeMap.item(j);
                    object2 = node2.getNodeName();
                    object = node2.getNodeValue();
                    if (ATTR_ID.equals(object2)) continue;
                    if (ATTR_SEVERITY.equals(object2)) {
                        for (Severity severity : Severity.values()) {
                            if (!((String)object).equalsIgnoreCase(severity.name())) continue;
                            this.mSeverity.put(string, severity);
                            continue block7;
                        }
                        continue;
                    }
                    this.formatError("Unexpected attribute \"%1$s\"", object2);
                }
                NodeList nodeList2 = element.getChildNodes();
                if (nodeList2.getLength() <= 0) continue;
                int n3 = nodeList2.getLength();
                for (n2 = 0; n2 < n3; ++n2) {
                    object2 = nodeList2.item(n2);
                    if (object2.getNodeType() != 1) continue;
                    object = (Element)object2;
                    String string2 = object.getAttribute(ATTR_PATH);
                    if (string2.isEmpty()) {
                        this.formatError("Missing required %1$s attribute under %2$s", ATTR_PATH, string);
                        continue;
                    }
                    List<String> list = this.mSuppressed.get(string);
                    if (list == null) {
                        list = new ArrayList<String>(n3 / 2 + 1);
                        this.mSuppressed.put(string, list);
                    }
                    list.add(string2);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            this.formatError(sAXParseException.getMessage(), new Object[0]);
            Closeables.closeQuietly((Closeable)bufferedInputStream);
        }
        catch (Exception exception) {
            this.mClient.log(exception, null, new Object[0]);
            {
                catch (Throwable throwable) {
                    Closeables.closeQuietly(bufferedInputStream);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)bufferedInputStream);
        }
        Closeables.closeQuietly((Closeable)bufferedInputStream);
    }

    private void writeConfig() {
        try {
            boolean bl;
            Serializable serializable;
            File file = new File(this.mConfigFile.getParentFile(), this.mConfigFile.getName() + ".new");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<lint>\n");
            if (!this.mSuppressed.isEmpty() || !this.mSeverity.isEmpty()) {
                serializable = new HashSet<String>();
                for (String object2 : this.mSuppressed.keySet()) {
                    serializable.add(object2);
                }
                for (String string : this.mSeverity.keySet()) {
                    serializable.add(string);
                }
                ArrayList arrayList = new ArrayList(serializable);
                Collections.sort(arrayList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    List<String> list;
                    String string = (String)iterator.next();
                    bufferedWriter.write("    <");
                    bufferedWriter.write(TAG_ISSUE);
                    DefaultConfiguration.writeAttribute(bufferedWriter, ATTR_ID, string);
                    Severity severity = this.mSeverity.get(string);
                    if (severity != null) {
                        DefaultConfiguration.writeAttribute(bufferedWriter, ATTR_SEVERITY, severity.name().toLowerCase(Locale.US));
                    }
                    if ((list = this.mSuppressed.get(string)) != null && !list.isEmpty()) {
                        ((Writer)bufferedWriter).write(62);
                        ((Writer)bufferedWriter).write(10);
                        for (String string2 : list) {
                            bufferedWriter.write("        <");
                            bufferedWriter.write(TAG_IGNORE);
                            DefaultConfiguration.writeAttribute(bufferedWriter, ATTR_PATH, string2);
                            bufferedWriter.write(" />\n");
                        }
                        bufferedWriter.write("    </");
                        bufferedWriter.write(TAG_ISSUE);
                        ((Writer)bufferedWriter).write(62);
                        ((Writer)bufferedWriter).write(10);
                        continue;
                    }
                    bufferedWriter.write(" />\n");
                }
            }
            bufferedWriter.write("</lint>");
            ((Writer)bufferedWriter).close();
            serializable = new File(this.mConfigFile.getParentFile(), this.mConfigFile.getName() + '~');
            if (((File)serializable).exists()) {
                ((File)serializable).delete();
            }
            if (this.mConfigFile.exists()) {
                this.mConfigFile.renameTo((File)serializable);
            }
            if ((bl = file.renameTo(this.mConfigFile)) && ((File)serializable).exists()) {
                ((File)serializable).delete();
            }
        }
        catch (Exception exception) {
            this.mClient.log(exception, null, new Object[0]);
        }
    }

    private static void writeAttribute(@NonNull Writer writer, @NonNull String string, @NonNull String string2) throws IOException {
        writer.write(32);
        writer.write(string);
        writer.write(61);
        writer.write(34);
        writer.write(string2);
        writer.write(34);
    }

    public void ignore(@NonNull Context context, @NonNull Issue issue, @Nullable Location location, @NonNull String string, @Nullable Object object) {
        if (location != null) {
            this.ignore(issue, location.getFile());
        }
    }

    public void ignore(@NonNull Issue issue, @NonNull File file) {
        this.ensureInitialized();
        String string = this.mProject != null ? this.mProject.getRelativePath(file) : file.getPath();
        List<String> list = this.mSuppressed.get(issue.getId());
        if (list == null) {
            list = new ArrayList<String>();
            this.mSuppressed.put(issue.getId(), list);
        }
        list.add(string);
        Collections.sort(list);
        if (!this.mBulkEditing) {
            this.writeConfig();
        }
    }

    public void setSeverity(@NonNull Issue issue, @Nullable Severity severity) {
        this.ensureInitialized();
        String string = issue.getId();
        if (severity == null) {
            this.mSeverity.remove(string);
        } else {
            this.mSeverity.put(string, severity);
        }
        if (!this.mBulkEditing) {
            this.writeConfig();
        }
    }

    public void startBulkEditing() {
        this.mBulkEditing = true;
    }

    public void finishBulkEditing() {
        this.mBulkEditing = false;
        this.writeConfig();
    }
}

