/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OtherFileVisitor {
    @NonNull
    private final List<Detector> mDetectors;
    @NonNull
    private Map<Scope, List<File>> mFiles = new EnumMap<Scope, List<File>>(Scope.class);

    OtherFileVisitor(@NonNull List<Detector> list) {
        this.mDetectors = list;
    }

    void scan(@NonNull LintDriver lintDriver, @NonNull Project project, @Nullable Project project2) {
        File file = project.getDir();
        EnumSet<Scope> enumSet = EnumSet.noneOf(Scope.class);
        for (Detector object32 : this.mDetectors) {
            Detector.OtherFileScanner otherFileScanner = (Detector.OtherFileScanner)((Object)object32);
            EnumSet<Scope> enumSet2 = otherFileScanner.getApplicableFiles();
            if (enumSet2.contains((Object)Scope.OTHER)) {
                enumSet = Scope.ALL;
                break;
            }
            enumSet.addAll(enumSet2);
        }
        List<File> list = project.getSubset();
        if (enumSet.contains((Object)Scope.RESOURCE_FILE)) {
            if (list != null && !list.isEmpty()) {
                ArrayList<File> arrayList = new ArrayList<File>(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    File file2 = (File)iterator.next();
                    if (!SdkUtils.endsWith((CharSequence)file2.getPath(), (CharSequence)".xml") || file2.getName().equals("AndroidManifest.xml")) continue;
                    arrayList.add(file2);
                }
                if (!arrayList.isEmpty()) {
                    this.mFiles.put(Scope.RESOURCE_FILE, arrayList);
                }
            } else {
                ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)100);
                for (File file3 : project.getResourceFolders()) {
                    OtherFileVisitor.collectFiles(arrayList, file3);
                }
                File file4 = new File(file, "assets");
                if (file4.exists()) {
                    OtherFileVisitor.collectFiles(arrayList, file4);
                }
                if (!arrayList.isEmpty()) {
                    this.mFiles.put(Scope.RESOURCE_FILE, arrayList);
                }
            }
        }
        if (enumSet.contains((Object)Scope.JAVA_FILE)) {
            if (list != null && !list.isEmpty()) {
                ArrayList<File> arrayList = new ArrayList<File>(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    File file5 = (File)iterator.next();
                    if (!file5.getPath().endsWith(".java")) continue;
                    arrayList.add(file5);
                }
                if (!arrayList.isEmpty()) {
                    this.mFiles.put(Scope.JAVA_FILE, arrayList);
                }
            } else {
                ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)100);
                for (File file6 : project.getJavaSourceFolders()) {
                    OtherFileVisitor.collectFiles(arrayList, file6);
                }
                if (!arrayList.isEmpty()) {
                    this.mFiles.put(Scope.JAVA_FILE, arrayList);
                }
            }
        }
        if (enumSet.contains((Object)Scope.CLASS_FILE)) {
            if (list != null && !list.isEmpty()) {
                ArrayList<File> arrayList = new ArrayList<File>(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    File file7 = (File)iterator.next();
                    if (!file7.getPath().endsWith(".class")) continue;
                    arrayList.add(file7);
                }
                if (!arrayList.isEmpty()) {
                    this.mFiles.put(Scope.CLASS_FILE, arrayList);
                }
            } else {
                ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)100);
                for (File file8 : project.getJavaClassFolders()) {
                    OtherFileVisitor.collectFiles(arrayList, file8);
                }
                if (!arrayList.isEmpty()) {
                    this.mFiles.put(Scope.CLASS_FILE, arrayList);
                }
            }
        }
        if (enumSet.contains((Object)Scope.MANIFEST)) {
            if (list != null && !list.isEmpty()) {
                ArrayList<File> arrayList = new ArrayList<File>(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    File file9 = (File)iterator.next();
                    if (!file9.getName().equals("AndroidManifest.xml")) continue;
                    arrayList.add(file9);
                }
                if (!arrayList.isEmpty()) {
                    this.mFiles.put(Scope.MANIFEST, arrayList);
                }
            } else {
                File file10 = project.getManifestFile();
                if (file10 != null) {
                    this.mFiles.put(Scope.MANIFEST, Collections.singletonList(file10));
                }
            }
        }
        for (Map.Entry<Scope, List<File>> entry : this.mFiles.entrySet()) {
            Object object;
            Scope scope = entry.getKey();
            List<File> list2 = entry.getValue();
            ArrayList<Detector> arrayList = new ArrayList<Detector>(this.mDetectors.size());
            for (Detector detector : this.mDetectors) {
                object = (Detector.OtherFileScanner)((Object)detector);
                EnumSet<Scope> enumSet3 = object.getApplicableFiles();
                if (!enumSet3.contains((Object)Scope.OTHER) && !enumSet3.contains((Object)scope)) continue;
                arrayList.add(detector);
            }
            if (arrayList.isEmpty()) continue;
            for (File file11 : list2) {
                object = new Context(lintDriver, project, project2, file11);
                for (Detector detector : arrayList) {
                    detector.beforeCheckFile((Context)object);
                    detector.run((Context)object);
                    detector.afterCheckFile((Context)object);
                }
                if (!lintDriver.isCanceled()) continue;
                return;
            }
        }
    }

    private static void collectFiles(List<File> list, File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    OtherFileVisitor.collectFiles(list, file2);
                }
            }
        } else {
            list.add(file);
        }
    }
}

