/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.annotations.NonNull;
import com.android.tools.lint.client.api.IDomParser;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.annotations.Beta;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
class XmlVisitor {
    private final Map<String, List<Detector.XmlScanner>> mElementToCheck = new HashMap<String, List<Detector.XmlScanner>>();
    private final Map<String, List<Detector.XmlScanner>> mAttributeToCheck = new HashMap<String, List<Detector.XmlScanner>>();
    private final List<Detector.XmlScanner> mDocumentDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<Detector.XmlScanner> mAllElementDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<Detector.XmlScanner> mAllAttributeDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<? extends Detector> mAllDetectors;
    private final IDomParser mParser;

    XmlVisitor(@NonNull IDomParser iDomParser, @NonNull List<? extends Detector> list) {
        this.mParser = iDomParser;
        this.mAllDetectors = list;
        for (Detector detector : list) {
            Object object;
            Detector.XmlScanner xmlScanner = (Detector.XmlScanner)((Object)detector);
            Collection<String> collection = xmlScanner.getApplicableAttributes();
            if (collection == Detector.XmlScanner.ALL) {
                this.mAllAttributeDetectors.add(xmlScanner);
            } else if (collection != null) {
                for (String string : collection) {
                    object = this.mAttributeToCheck.get(string);
                    if (object == null) {
                        object = new ArrayList<Detector.XmlScanner>();
                        this.mAttributeToCheck.put(string, (List<Detector.XmlScanner>)object);
                    }
                    object.add(xmlScanner);
                }
            }
            Collection<String> collection2 = xmlScanner.getApplicableElements();
            if (collection2 == Detector.XmlScanner.ALL) {
                this.mAllElementDetectors.add(xmlScanner);
            } else if (collection2 != null) {
                Iterator iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    List<Detector.XmlScanner> list2 = this.mElementToCheck.get(object);
                    if (list2 == null) {
                        list2 = new ArrayList<Detector.XmlScanner>();
                        this.mElementToCheck.put((String)object, list2);
                    }
                    list2.add(xmlScanner);
                }
            }
            if (collection != null && (!collection.isEmpty() || collection == Detector.XmlScanner.ALL) || collection2 != null && (!collection2.isEmpty() || collection2 == Detector.XmlScanner.ALL)) continue;
            this.mDocumentDetectors.add(xmlScanner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitFile(@NonNull XmlContext xmlContext, @NonNull File file) {
        assert (LintUtils.isXmlFile(file));
        xmlContext.parser = this.mParser;
        try {
            if (xmlContext.document == null) {
                xmlContext.document = this.mParser.parseXml(xmlContext);
                if (xmlContext.document == null) {
                    return;
                }
                if (xmlContext.document.getDocumentElement() == null) {
                    return;
                }
            }
            for (Detector object : this.mAllDetectors) {
                object.beforeCheckFile(xmlContext);
            }
            for (Detector.XmlScanner xmlScanner : this.mDocumentDetectors) {
                xmlScanner.visitDocument(xmlContext, xmlContext.document);
            }
            if (!(this.mElementToCheck.isEmpty() && this.mAttributeToCheck.isEmpty() && this.mAllAttributeDetectors.isEmpty() && this.mAllElementDetectors.isEmpty())) {
                this.visitElement(xmlContext, xmlContext.document.getDocumentElement());
            }
            for (Detector detector : this.mAllDetectors) {
                detector.afterCheckFile(xmlContext);
            }
        }
        finally {
            if (xmlContext.document != null) {
                this.mParser.dispose(xmlContext, xmlContext.document);
                xmlContext.document = null;
            }
        }
    }

    private void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        Node node;
        int n;
        Object object;
        List<Detector.XmlScanner> list = this.mElementToCheck.get(element.getTagName());
        if (list != null) {
            assert (list instanceof RandomAccess);
            for (Detector.XmlScanner xmlScanner : list) {
                xmlScanner.visitElement(xmlContext, element);
            }
        }
        if (!this.mAllElementDetectors.isEmpty()) {
            for (Detector.XmlScanner xmlScanner : this.mAllElementDetectors) {
                xmlScanner.visitElement(xmlContext, element);
            }
        }
        if (!this.mAttributeToCheck.isEmpty() || !this.mAllAttributeDetectors.isEmpty()) {
            object = element.getAttributes();
            n = object.getLength();
            for (int i = 0; i < n; ++i) {
                List<Detector.XmlScanner> list2;
                node = (Attr)object.item(i);
                String string = node.getLocalName();
                if (string == null) {
                    string = node.getName();
                }
                if ((list2 = this.mAttributeToCheck.get(string)) != null) {
                    for (Detector.XmlScanner xmlScanner : list2) {
                        xmlScanner.visitAttribute(xmlContext, (Attr)node);
                    }
                }
                if (this.mAllAttributeDetectors.isEmpty()) continue;
                for (Detector.XmlScanner xmlScanner : this.mAllAttributeDetectors) {
                    xmlScanner.visitAttribute(xmlContext, (Attr)node);
                }
            }
        }
        object = element.getChildNodes();
        n = object.getLength();
        for (int i = 0; i < n; ++i) {
            node = object.item(i);
            if (node.getNodeType() != 1) continue;
            this.visitElement(xmlContext, (Element)node);
        }
        if (list != null) {
            for (Detector.XmlScanner xmlScanner : list) {
                xmlScanner.visitElementAfter(xmlContext, element);
            }
        }
        if (!this.mAllElementDetectors.isEmpty()) {
            for (Detector.XmlScanner xmlScanner : this.mAllElementDetectors) {
                xmlScanner.visitElementAfter(xmlContext, element);
            }
        }
    }
}

