/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.google.common.annotations.Beta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Category
implements Comparable<Category> {
    private final String mName;
    private final int mPriority;
    private final Category mParent;
    public static final Category LINT = Category.create("Lint", 110);
    public static final Category CORRECTNESS = Category.create("Correctness", 100);
    public static final Category SECURITY = Category.create("Security", 90);
    public static final Category PERFORMANCE = Category.create("Performance", 80);
    public static final Category USABILITY = Category.create("Usability", 70);
    public static final Category A11Y = Category.create("Accessibility", 60);
    public static final Category I18N = Category.create("Internationalization", 50);
    public static final Category ICONS = Category.create(USABILITY, "Icons", 73);
    public static final Category TYPOGRAPHY = Category.create(USABILITY, "Typography", 76);
    public static final Category MESSAGES = Category.create(CORRECTNESS, "Messages", 95);

    private Category(@Nullable Category category, @NonNull String string, int n) {
        this.mParent = category;
        this.mName = string;
        this.mPriority = n;
    }

    @NonNull
    public static Category create(@NonNull String string, int n) {
        return new Category(null, string, n);
    }

    @NonNull
    public static Category create(@Nullable Category category, @NonNull String string, int n) {
        return new Category(category, string, n);
    }

    public Category getParent() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public String getFullName() {
        if (this.mParent != null) {
            return this.mParent.getFullName() + ':' + this.mName;
        }
        return this.mName;
    }

    @Override
    public int compareTo(Category category) {
        if (category.mPriority == this.mPriority) {
            if (this.mParent == category) {
                return 1;
            }
            if (category.mParent == this) {
                return -1;
            }
        }
        return category.mPriority - this.mPriority;
    }
}

