/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Beta
public class ClassContext
extends Context {
    private final File mBinDir;
    private final ClassNode mClassNode;
    private final byte[] mBytes;
    private File mSourceFile;
    private String mSourceContents;
    private boolean mSearchedForSource;
    private final File mJarFile;
    private final boolean mFromLibrary;

    public ClassContext(@NonNull LintDriver lintDriver, @NonNull Project project, @Nullable Project project2, @NonNull File file, @Nullable File file2, @NonNull File file3, @NonNull byte[] byArray, @NonNull ClassNode classNode, boolean bl, @Nullable String string) {
        super(lintDriver, project, project2, file);
        this.mJarFile = file2;
        this.mBinDir = file3;
        this.mBytes = byArray;
        this.mClassNode = classNode;
        this.mFromLibrary = bl;
        this.mSourceContents = string;
    }

    @NonNull
    public byte[] getBytecode() {
        return this.mBytes;
    }

    @NonNull
    public ClassNode getClassNode() {
        return this.mClassNode;
    }

    @Nullable
    public File getJarFile() {
        return this.mJarFile;
    }

    public boolean isFromClassLibrary() {
        return this.mFromLibrary;
    }

    @Nullable
    public File getSourceFile() {
        block9: {
            if (this.mSourceFile != null || this.mSearchedForSource) break block9;
            this.mSearchedForSource = true;
            String string = this.mClassNode.sourceFile;
            if (string == null) {
                int n;
                string = this.file.getName();
                if (string.endsWith(".class")) {
                    string = string.substring(0, string.length() - ".class".length()) + ".java";
                }
                if ((n = string.indexOf(36)) != -1) {
                    string = string.substring(0, n) + ".java";
                }
            }
            if (string != null) {
                if (this.mJarFile != null) {
                    String string2 = this.file.getParent() + File.separator + string;
                    List<File> list = this.getProject().getJavaSourceFolders();
                    for (File file : list) {
                        File file2 = new File(file, string2);
                        if (!file2.exists()) continue;
                        this.mSourceFile = file2;
                        break;
                    }
                } else {
                    String string3 = this.mBinDir.getPath();
                    String string4 = this.file.getParentFile().getPath();
                    if (string4.startsWith(string3)) {
                        int n = string3.length() + 1;
                        String string5 = n > string4.length() ? "" : string4.substring(n);
                        List<File> list = this.getProject().getJavaSourceFolders();
                        for (File file : list) {
                            File file3 = new File(file, string5 + File.separator + string);
                            if (!file3.exists()) continue;
                            this.mSourceFile = file3;
                            break;
                        }
                    }
                }
            }
        }
        return this.mSourceFile;
    }

    @NonNull
    public String getSourceContents() {
        if (this.mSourceContents == null) {
            File file = this.getSourceFile();
            if (file != null) {
                this.mSourceContents = this.getClient().readFile(this.mSourceFile);
            }
            if (this.mSourceContents == null) {
                this.mSourceContents = "";
            }
        }
        return this.mSourceContents;
    }

    @Nullable
    public String getSourceContents(boolean bl) {
        if (bl) {
            return this.getSourceContents();
        }
        return this.mSourceContents;
    }

    @NonNull
    public Location getLocationForLine(int n, @Nullable String string, @Nullable String string2, @Nullable Location.SearchHints searchHints) {
        File file = this.getSourceFile();
        if (file != null) {
            if (n != -1) {
                return Location.create(file, this.getSourceContents(), n - 1, string, string2, searchHints);
            }
            return Location.create(file);
        }
        return Location.create(this.file);
    }

    public void report(@NonNull Issue issue, @Nullable Location location, @NonNull String string, @Nullable Object object) {
        if (this.mDriver.isSuppressed(issue, this.mClassNode)) {
            return;
        }
        ClassNode classNode = this.mClassNode;
        while (classNode != null) {
            ClassNode classNode2 = classNode;
            if ((classNode = this.mDriver.getOuterClassNode(classNode)) == null) continue;
            if (classNode2.outerMethod != null) {
                List list = classNode.methods;
                for (Object e : list) {
                    MethodNode methodNode = (MethodNode)e;
                    if (!methodNode.name.equals(classNode2.outerMethod) || !methodNode.desc.equals(classNode2.outerMethodDesc)) continue;
                    if (methodNode == null || !this.mDriver.isSuppressed(issue, this.mClassNode, methodNode, null)) break;
                    return;
                }
            }
            if (!this.mDriver.isSuppressed(issue, classNode)) continue;
            return;
        }
        super.report(issue, location, string, object);
    }

    public void report(@NonNull Issue issue, @Nullable MethodNode methodNode, @Nullable AbstractInsnNode abstractInsnNode, @Nullable Location location, @NonNull String string, @Nullable Object object) {
        if (methodNode != null && this.mDriver.isSuppressed(issue, this.mClassNode, methodNode, abstractInsnNode)) {
            return;
        }
        this.report(issue, location, string, object);
    }

    public void report(@NonNull Issue issue, @Nullable FieldNode fieldNode, @Nullable Location location, @NonNull String string, @Nullable Object object) {
        if (fieldNode != null && this.mDriver.isSuppressed(issue, fieldNode)) {
            return;
        }
        this.report(issue, location, string, object);
    }

    public static int findLineNumber(@NonNull AbstractInsnNode abstractInsnNode) {
        AbstractInsnNode abstractInsnNode2;
        for (abstractInsnNode2 = abstractInsnNode; abstractInsnNode2 != null; abstractInsnNode2 = abstractInsnNode2.getPrevious()) {
            if (abstractInsnNode2.getType() != 15) continue;
            return ((LineNumberNode)abstractInsnNode2).line;
        }
        for (abstractInsnNode2 = abstractInsnNode; abstractInsnNode2 != null; abstractInsnNode2 = abstractInsnNode2.getNext()) {
            if (abstractInsnNode2.getType() != 15) continue;
            return ((LineNumberNode)abstractInsnNode2).line;
        }
        return -1;
    }

    public static int findLineNumber(@NonNull MethodNode methodNode) {
        if (methodNode.instructions != null && methodNode.instructions.size() > 0) {
            return ClassContext.findLineNumber(methodNode.instructions.get(0));
        }
        return -1;
    }

    public static int findLineNumber(@NonNull ClassNode classNode) {
        MethodNode methodNode;
        if (classNode.methods != null && !classNode.methods.isEmpty() && (methodNode = ClassContext.getFirstRealMethod(classNode)) != null) {
            return ClassContext.findLineNumber(methodNode);
        }
        return -1;
    }

    @NonNull
    public Location getLocation(@NonNull ClassNode classNode) {
        String string = ClassContext.isAnonymousClass(classNode.name) ? classNode.superName : classNode.name;
        int n = string.lastIndexOf(36);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(47)) != -1) {
            string = string.substring(n + 1);
        }
        return this.getLocationForLine(ClassContext.findLineNumber(classNode), string, null, Location.SearchHints.create(Location.SearchDirection.BACKWARD).matchJavaSymbol());
    }

    @Nullable
    private static MethodNode getFirstRealMethod(@NonNull ClassNode classNode) {
        if (classNode.methods != null) {
            List list = classNode.methods;
            for (Object e : list) {
                MethodNode methodNode = (MethodNode)e;
                if (methodNode.name.charAt(0) == '<') continue;
                return methodNode;
            }
            if (!classNode.methods.isEmpty()) {
                return (MethodNode)classNode.methods.get(0);
            }
        }
        return null;
    }

    @NonNull
    public Location getLocation(@NonNull MethodNode methodNode, @NonNull ClassNode classNode) {
        String string;
        Location.SearchDirection searchDirection;
        if (methodNode.name.equals("<init>")) {
            searchDirection = Location.SearchDirection.EOL_BACKWARD;
            string = ClassContext.isAnonymousClass(classNode.name) ? classNode.superName.substring(classNode.superName.lastIndexOf(47) + 1) : classNode.name.substring(classNode.name.lastIndexOf(36) + 1);
        } else {
            searchDirection = Location.SearchDirection.BACKWARD;
            string = methodNode.name;
        }
        return this.getLocationForLine(ClassContext.findLineNumber(methodNode), string, null, Location.SearchHints.create(searchDirection).matchJavaSymbol());
    }

    @NonNull
    public Location getLocation(@NonNull AbstractInsnNode abstractInsnNode) {
        Location.SearchHints searchHints = Location.SearchHints.create(Location.SearchDirection.FORWARD).matchJavaSymbol();
        String string = null;
        if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (methodInsnNode.name.equals("<init>")) {
                string = methodInsnNode.owner;
                searchHints = searchHints.matchConstructor();
            } else {
                string = methodInsnNode.name;
            }
            int n = string.lastIndexOf(36);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            if ((n = string.lastIndexOf(47)) != -1) {
                string = string.substring(n + 1);
            }
        }
        int n = ClassContext.findLineNumber(abstractInsnNode);
        return this.getLocationForLine(n, string, null, searchHints);
    }

    private static boolean isAnonymousClass(@NonNull String string) {
        int n = string.lastIndexOf(36);
        return n != -1 && n < string.length() - 1 && Character.isDigit(string.charAt(n + 1));
    }

    @NonNull
    public static String getFqcn(@NonNull String string) {
        return string.replace('/', '.').replace('$', '.');
    }

    public static String createSignature(String string, String string2, String string3) {
        Type[] typeArray;
        StringBuilder stringBuilder = new StringBuilder(100);
        if (string3 != null) {
            typeArray = Type.getReturnType((String)string3);
            stringBuilder.append(ClassContext.getTypeString((Type)typeArray));
            stringBuilder.append(' ');
        }
        if (string != null) {
            stringBuilder.append(ClassContext.getFqcn(string));
        }
        if (string2 != null) {
            stringBuilder.append('#');
            stringBuilder.append(string2);
            if (string3 != null && (typeArray = Type.getArgumentTypes((String)string3)) != null && typeArray.length > 0) {
                stringBuilder.append('(');
                boolean bl = true;
                for (Type type : typeArray) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(ClassContext.getTypeString(type));
                }
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    private static String getTypeString(Type type) {
        String string = type.getClassName();
        if (string.startsWith("java.lang.")) {
            string = string.substring("java.lang.".length());
        }
        return string;
    }

    @NonNull
    public static String getInternalName(@NonNull String string) {
        if (string.indexOf(46) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        String string2 = null;
        for (String string3 : Splitter.on((char)'.').split((CharSequence)string)) {
            if (string2 != null && string2.length() > 0) {
                if (Character.isUpperCase(string2.charAt(0))) {
                    stringBuilder.append('$');
                } else {
                    stringBuilder.append('/');
                }
            }
            stringBuilder.append(string3);
            string2 = string3;
        }
        return stringBuilder.toString();
    }
}

