/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Position;
import com.google.common.annotations.Beta;
import java.io.File;

@Beta
public class Location {
    private static final String SUPER_KEYWORD = "super";
    private final File mFile;
    private final Position mStart;
    private final Position mEnd;
    private String mMessage;
    private Location mSecondary;
    private Object mClientData;

    protected Location(@NonNull File file, @Nullable Position position, @Nullable Position position2) {
        this.mFile = file;
        this.mStart = position;
        this.mEnd = position2;
    }

    @NonNull
    public File getFile() {
        return this.mFile;
    }

    @Nullable
    public Position getStart() {
        return this.mStart;
    }

    @Nullable
    public Position getEnd() {
        return this.mEnd;
    }

    @Nullable
    public Location getSecondary() {
        return this.mSecondary;
    }

    public void setSecondary(@Nullable Location location) {
        this.mSecondary = location;
    }

    public void setMessage(@NonNull String string) {
        this.mMessage = string;
    }

    @Nullable
    public String getMessage() {
        return this.mMessage;
    }

    public void setClientData(@Nullable Object object) {
        this.mClientData = object;
    }

    @Nullable
    public Object getClientData() {
        return this.mClientData;
    }

    public String toString() {
        return "Location [file=" + this.mFile + ", start=" + this.mStart + ", end=" + this.mEnd + ", message=" + this.mMessage + ']';
    }

    @NonNull
    public static Location create(@NonNull File file) {
        return new Location(file, null, null);
    }

    @NonNull
    public static Location create(@NonNull File file, @NonNull Position position, @Nullable Position position2) {
        return new Location(file, position, position2);
    }

    @NonNull
    public static Location create(@NonNull File file, @Nullable String string, int n, int n2) {
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException("Invalid offsets");
        }
        if (string == null) {
            return new Location(file, new DefaultPosition(-1, -1, n), new DefaultPosition(-1, -1, n2));
        }
        int n3 = string.length();
        n2 = Math.min(n2, n3);
        n = Math.min(n, n2);
        DefaultPosition defaultPosition = null;
        int n4 = 0;
        int n5 = 0;
        char c = '\u0000';
        for (int i = 0; i <= n3; ++i) {
            if (i == n) {
                defaultPosition = new DefaultPosition(n4, i - n5, i);
            }
            if (i == n2) {
                DefaultPosition defaultPosition2 = new DefaultPosition(n4, i - n5, i);
                return new Location(file, defaultPosition, defaultPosition2);
            }
            char c2 = string.charAt(i);
            if (c2 == '\n') {
                n5 = i + 1;
                if (c != '\r') {
                    ++n4;
                }
            } else if (c2 == '\r') {
                ++n4;
                n5 = i + 1;
            }
            c = c2;
        }
        return Location.create(file);
    }

    @NonNull
    public static Location create(@NonNull File file, @NonNull String string, int n) {
        return Location.create(file, string, n, null, null, null);
    }

    @NonNull
    public static Location create(@NonNull File file, @NonNull String string, int n, @Nullable String string2, @Nullable String string3, @Nullable SearchHints searchHints) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if ((n3 = string.indexOf(10, n3)) == -1) {
                return Location.create(file);
            }
            ++n2;
            ++n3;
        }
        if (n == n2) {
            Object object;
            if (string2 != null) {
                int n4;
                int n5;
                int n6;
                object = SearchDirection.NEAREST;
                if (searchHints != null) {
                    object = searchHints.mDirection;
                }
                if (object == SearchDirection.BACKWARD) {
                    n6 = Location.findPreviousMatch(string, n3, string2, searchHints);
                    n = Location.adjustLine(string, n, n3, n6);
                } else if (object == SearchDirection.EOL_BACKWARD) {
                    n5 = string.indexOf(10, n3);
                    if (n5 == -1) {
                        n5 = string.length();
                    }
                    n6 = Location.findPreviousMatch(string, n5, string2, searchHints);
                    n = Location.adjustLine(string, n, n3, n6);
                } else if (object == SearchDirection.FORWARD) {
                    n6 = Location.findNextMatch(string, n3, string2, searchHints);
                    n = Location.adjustLine(string, n, n3, n6);
                } else {
                    assert (object == SearchDirection.NEAREST);
                    n5 = Location.findPreviousMatch(string, n3, string2, searchHints);
                    n4 = Location.findNextMatch(string, n3, string2, searchHints);
                    if (n5 == -1) {
                        n6 = n4;
                        n = Location.adjustLine(string, n, n3, n6);
                    } else if (n4 == -1) {
                        n6 = n5;
                        n = Location.adjustLine(string, n, n3, n6);
                    } else if (n3 - n5 < n4 - n3) {
                        n6 = n5;
                        n = Location.adjustLine(string, n, n3, n6);
                    } else {
                        n6 = n4;
                        n = Location.adjustLine(string, n, n3, n6);
                    }
                }
                if (n6 != -1) {
                    n5 = string.lastIndexOf(10, n6);
                    n5 = n5 == -1 ? 0 : ++n5;
                    n4 = n6 - n5;
                    if (string3 != null) {
                        int n7 = string.indexOf(string3, n3 + string2.length());
                        if (n7 != -1) {
                            return new Location(file, new DefaultPosition(n, n4, n6), new DefaultPosition(n, -1, n7 + string3.length()));
                        }
                    } else if (searchHints != null && (searchHints.isJavaSymbol() || searchHints.isWholeWord())) {
                        if (searchHints.isConstructor() && string.startsWith(SUPER_KEYWORD, n6)) {
                            string2 = SUPER_KEYWORD;
                        }
                        return new Location(file, new DefaultPosition(n, n4, n6), new DefaultPosition(n, n4 + string2.length(), n6 + string2.length()));
                    }
                    return new Location(file, new DefaultPosition(n, n4, n6), new DefaultPosition(n, n4, n6 + string2.length()));
                }
            }
            object = new DefaultPosition(n, -1, n3);
            return new Location(file, (Position)object, (Position)object);
        }
        return Location.create(file);
    }

    private static int findPreviousMatch(@NonNull String string, int n, String string2, @Nullable SearchHints searchHints) {
        int n2;
        while ((n2 = string.lastIndexOf(string2, n)) != -1) {
            if (Location.isMatch(string, n2, string2, searchHints)) {
                return n2;
            }
            n = n2 - string2.length();
        }
        return -1;
    }

    private static int findNextMatch(@NonNull String string, int n, String string2, @Nullable SearchHints searchHints) {
        int n2;
        int n3 = -1;
        if (searchHints != null && searchHints.isConstructor()) {
            assert (searchHints.isWholeWord());
            n2 = string.indexOf(SUPER_KEYWORD, n);
            if (n2 != -1 && Location.isMatch(string, n2, SUPER_KEYWORD, searchHints)) {
                n3 = n2;
            }
        }
        while ((n2 = string.indexOf(string2, n)) != -1) {
            if (Location.isMatch(string, n2, string2, searchHints)) {
                if (n3 != -1) {
                    return Math.min(n3, n2);
                }
                return n2;
            }
            n = n2 + string2.length();
        }
        return n3;
    }

    private static boolean isMatch(@NonNull String string, int n, String string2, @Nullable SearchHints searchHints) {
        if (!string.startsWith(string2, n)) {
            return false;
        }
        if (searchHints != null) {
            char c;
            char c2 = n > 0 ? string.charAt(n - 1) : (char)'\u0000';
            int n2 = n + string2.length() - 1;
            char c3 = c = n2 < string.length() - 1 ? string.charAt(n2 + 1) : (char)'\u0000';
            if (searchHints.isWholeWord() && (Character.isLetter(c2) || Character.isLetter(c))) {
                return false;
            }
            if (searchHints.isJavaSymbol()) {
                if (Character.isJavaIdentifierPart(c2) || Character.isJavaIdentifierPart(c)) {
                    return false;
                }
                if (c2 == '\"') {
                    return false;
                }
            }
            if (searchHints.isConstructor() && SUPER_KEYWORD.equals(string2)) {
                char c4;
                for (int i = n2 + 1; i < string.length() - 1 && (c4 = string.charAt(i)) != '('; ++i) {
                    if (Character.isWhitespace(c4)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static int adjustLine(String string, int n, int n2, int n3) {
        if (n3 == -1) {
            return n;
        }
        if (n3 < n2) {
            return n - Location.countLines(string, n3, n2);
        }
        return n + Location.countLines(string, n2, n3);
    }

    private static int countLines(String string, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '\n') continue;
            ++n3;
        }
        return n3;
    }

    public static Location reverse(Location location) {
        Location location2 = location.getSecondary();
        location.setSecondary(null);
        while (location2 != null) {
            Location location3 = location2.getSecondary();
            location2.setSecondary(location);
            location = location2;
            location2 = location3;
        }
        return location;
    }

    public static class SearchHints {
        @NonNull
        private final SearchDirection mDirection;
        private boolean mWholeWord;
        private boolean mJavaSymbol;
        private boolean mConstructor;

        private SearchHints(@NonNull SearchDirection searchDirection) {
            this.mDirection = searchDirection;
        }

        @NonNull
        public static SearchHints create(@NonNull SearchDirection searchDirection) {
            return new SearchHints(searchDirection);
        }

        @NonNull
        public SearchHints matchWholeWord() {
            this.mWholeWord = true;
            return this;
        }

        public boolean isWholeWord() {
            return this.mWholeWord;
        }

        @NonNull
        public SearchHints matchJavaSymbol() {
            this.mJavaSymbol = true;
            this.mWholeWord = true;
            return this;
        }

        public boolean isJavaSymbol() {
            return this.mJavaSymbol;
        }

        @NonNull
        public SearchHints matchConstructor() {
            this.mConstructor = true;
            this.mWholeWord = true;
            this.mJavaSymbol = true;
            return this;
        }

        public boolean isConstructor() {
            return this.mConstructor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchDirection {
        FORWARD,
        BACKWARD,
        EOL_BACKWARD,
        NEAREST;

    }

    public static class DefaultLocationHandle
    implements Handle {
        private final File mFile;
        private final String mContents;
        private final int mStartOffset;
        private final int mEndOffset;
        private Object mClientData;

        public DefaultLocationHandle(@NonNull Context context, int n, int n2) {
            this.mFile = context.file;
            this.mContents = context.getContents();
            this.mStartOffset = n;
            this.mEndOffset = n2;
        }

        @NonNull
        public Location resolve() {
            return Location.create(this.mFile, this.mContents, this.mStartOffset, this.mEndOffset);
        }

        public void setClientData(@Nullable Object object) {
            this.mClientData = object;
        }

        @Nullable
        public Object getClientData() {
            return this.mClientData;
        }
    }

    public static interface Handle {
        @NonNull
        public Location resolve();

        public void setClientData(@Nullable Object var1);

        @Nullable
        public Object getClientData();
    }
}

