/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.google.common.annotations.Beta;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public enum Scope {
    RESOURCE_FILE,
    ALL_RESOURCE_FILES,
    JAVA_FILE,
    ALL_JAVA_FILES,
    CLASS_FILE,
    ALL_CLASS_FILES,
    MANIFEST,
    PROGUARD_FILE,
    JAVA_LIBRARIES,
    OTHER;

    public static final EnumSet<Scope> ALL;
    public static final EnumSet<Scope> RESOURCE_FILE_SCOPE;
    public static final EnumSet<Scope> ALL_RESOURCES_SCOPE;
    public static final EnumSet<Scope> JAVA_FILE_SCOPE;
    public static final EnumSet<Scope> CLASS_FILE_SCOPE;
    public static final EnumSet<Scope> MANIFEST_SCOPE;
    public static final EnumSet<Scope> OTHER_SCOPE;

    public static boolean checkSingleFile(@NonNull EnumSet<Scope> enumSet) {
        int n = enumSet.size();
        if (n == 2) {
            return enumSet.contains((Object)JAVA_FILE) && enumSet.contains((Object)CLASS_FILE);
        }
        return n == 1 && (enumSet.contains((Object)JAVA_FILE) || enumSet.contains((Object)CLASS_FILE) || enumSet.contains((Object)RESOURCE_FILE) || enumSet.contains((Object)PROGUARD_FILE) || enumSet.contains((Object)MANIFEST));
    }

    @NonNull
    public static EnumSet<Scope> intersect(@NonNull EnumSet<Scope> enumSet, @NonNull EnumSet<Scope> enumSet2) {
        EnumSet<Scope> enumSet3 = EnumSet.copyOf(enumSet);
        enumSet3.retainAll(enumSet2);
        return enumSet3;
    }

    static {
        ALL = EnumSet.allOf(Scope.class);
        RESOURCE_FILE_SCOPE = EnumSet.of(RESOURCE_FILE);
        ALL_RESOURCES_SCOPE = EnumSet.of(ALL_RESOURCE_FILES);
        JAVA_FILE_SCOPE = EnumSet.of(JAVA_FILE);
        CLASS_FILE_SCOPE = EnumSet.of(CLASS_FILE);
        MANIFEST_SCOPE = EnumSet.of(MANIFEST);
        OTHER_SCOPE = EnumSet.of(OTHER);
    }
}

