/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.ast.Annotation;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationValue;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.Case;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.ImportDeclaration;
import lombok.ast.InlineIfExpression;
import lombok.ast.IntegralLiteral;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Switch;
import lombok.ast.TypeReference;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiDetector
extends ResourceXmlDetector
implements Detector.ClassScanner,
Detector.JavaScanner {
    private static final boolean CHECK_DECLARATIONS = false;
    private static final boolean AOSP_BUILD = System.getenv("ANDROID_BUILD_TOP") != null;
    public static final Issue UNSUPPORTED = Issue.create((String)"NewApi", (String)"Finds API accesses to APIs that are not supported in all targeted API versions", (String)"This check scans through all the Android API calls in the application and warns about any calls that are not available on *all* versions targeted by this application (according to its minimum SDK attribute in the manifest).\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `AndroidManifest.xml` file.\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n\nIf you are deliberately setting `android:` attributes in style definitions, make sure you place this in a `values-v11` folder in order to avoid running into runtime conflicts on certain devices where manufacturers have added custom attributes whose ids conflict with the new ones on later platforms.\n\nSimilarly, you can use tools:targetApi=\"11\" in an XML file to indicate that the element will only be inflated in an adequate context.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, ApiDetector.class, EnumSet.of(Scope.CLASS_FILE, Scope.RESOURCE_FILE, Scope.MANIFEST)).addAnalysisScope(Scope.RESOURCE_FILE_SCOPE).addAnalysisScope(Scope.CLASS_FILE_SCOPE);
    public static final Issue INLINED = Issue.create((String)"InlinedApi", (String)"Finds inlined fields that may or may not work on older platforms", (String)"This check scans through all the Android API field references in the application and flags certain constants, such as static final integers and Strings, which were introduced in later versions. These will actually be copied into the class files rather than being referenced, which means that the value is available even when running on older devices. In some cases that's fine, and in other cases it can result in a runtime crash or incorrect behavior. It depends on the context, so consider the code carefully and device whether it's safe and can be suppressed or whether the code needs tbe guarded.\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `AndroidManifest.xml` file.\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, ApiDetector.class, EnumSet.of(Scope.JAVA_FILE)).addAnalysisScope(Scope.JAVA_FILE_SCOPE);
    public static final Issue OVERRIDE = Issue.create((String)"Override", (String)"Finds method declarations that will accidentally override methods in later versions", (String)"Suppose you are building against Android API 8, and you've subclassed Activity. In your subclass you add a new method called `isDestroyed`(). At some later point, a method of the same name and signature is added to Android. Your method will now override the Android method, and possibly break its contract. Your method is not calling `super.isDestroyed()`, since your compilation target doesn't know about the method.\n\nThe above scenario is what this lint detector looks for. The above example is real, since `isDestroyed()` was added in API 17, but it will be true for *any* method you have added to a subclass of an Android class where your build target is lower than the version the method was introduced in.\n\nTo fix this, either rename your method, or if you are really trying to augment the builtin method if available, switch to a higher build target where you can deliberately add `@Override` on your overriding method, and call `super` if appropriate etc.\n", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, ApiDetector.class, (EnumSet)Scope.CLASS_FILE_SCOPE);
    private static final String TARGET_API_VMSIG = "/TargetApi;";
    private static final String SWITCH_TABLE_PREFIX = "$SWITCH_TABLE$";
    private static final String ORDINAL_METHOD = "ordinal";
    protected ApiLookup mApiDatabase;
    private int mMinApi = -1;
    private Map<String, List<Pair<String, Location>>> mPendingFields;

    @NonNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    public void beforeCheckProject(@NonNull Context context) {
        this.mApiDatabase = ApiLookup.get(context.getClient());
    }

    public boolean appliesTo(@NonNull ResourceFolderType resourceFolderType) {
        return true;
    }

    public Collection<String> getApplicableElements() {
        return ALL;
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    public void visitAttribute(@NonNull XmlContext xmlContext, @NonNull Attr attr) {
        int n;
        int n2;
        String string;
        if (this.mApiDatabase == null) {
            return;
        }
        String string2 = attr.getValue();
        String string3 = null;
        String string4 = null;
        if (string2.startsWith("@android:")) {
            string = "@android:";
        } else if (string2.startsWith("?android:")) {
            string = "?android:";
        } else if (string2.startsWith("android:") && "name".equals(attr.getName()) && "item".equals(attr.getOwnerElement().getTagName()) && attr.getOwnerElement().getParentNode() != null && "style".equals(attr.getOwnerElement().getParentNode().getNodeName())) {
            string3 = "android/R$attr";
            string4 = string2.substring("android:".length());
            string = "android:";
        } else {
            return;
        }
        if (string3 == null) {
            n2 = string2.indexOf(47, string.length());
            if (n2 != -1) {
                string3 = "android/R$" + string2.substring(string.length(), n2);
                string4 = string2.substring(n2 + 1);
                if (string4.indexOf(46) != -1) {
                    string4 = string4.replace('.', '_');
                }
            } else if (string2.startsWith("?android:")) {
                string3 = "android/R$attr";
                string4 = string2.substring("?android:".length());
            } else {
                return;
            }
        }
        assert (string4 != null);
        n2 = this.mApiDatabase.getFieldVersion(string3, string4);
        if (n2 > (n = this.getMinSdk((Context)xmlContext)) && n2 > xmlContext.getFolderVersion() && n2 > ApiDetector.getLocalMinSdk(attr.getOwnerElement())) {
            if ("http://schemas.android.com/tools".equals(attr.getNamespaceURI())) {
                return;
            }
            Location location = xmlContext.getLocation((org.w3c.dom.Node)attr);
            String string5 = String.format("%1$s requires API level %2$d (current min is %3$d)", string2, n2, n);
            xmlContext.report(UNSUPPORTED, (org.w3c.dom.Node)attr, location, string5, null);
        }
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        if (this.mApiDatabase == null) {
            return;
        }
        String string = element.getTagName();
        ResourceFolderType resourceFolderType = xmlContext.getResourceFolderType();
        if (resourceFolderType != ResourceFolderType.LAYOUT) {
            if (element.getParentNode().getNodeType() != 1) {
                return;
            }
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                int n4;
                String string2;
                org.w3c.dom.Node node = nodeList.item(i);
                if (node.getNodeType() != 3 || (string2 = node.getNodeValue()).indexOf("@android:") == -1 || (n4 = (string2 = string2.trim()).indexOf(47, "@android:".length())) == -1) continue;
                String string3 = "android/R$" + string2.substring("@android:".length(), n4);
                String string4 = string2.substring(n4 + 1);
                if (string4.indexOf(46) != -1) {
                    string4 = string4.replace('.', '_');
                }
                if ((n3 = this.mApiDatabase.getFieldVersion(string3, string4)) <= (n2 = this.getMinSdk((Context)xmlContext)) || n3 <= xmlContext.getFolderVersion() || n3 <= ApiDetector.getLocalMinSdk(element)) continue;
                Location location = xmlContext.getLocation(node);
                String string5 = String.format("%1$s requires API level %2$d (current min is %3$d)", string2, n3, n2);
                xmlContext.report(UNSUPPORTED, (org.w3c.dom.Node)element, location, string5, null);
            }
        } else if (resourceFolderType == ResourceFolderType.LAYOUT) {
            int n;
            if ("view".equals(string) && ((string = element.getAttribute("class")) == null || string.isEmpty())) {
                return;
            }
            if (string.indexOf(46) != -1 || resourceFolderType != ResourceFolderType.LAYOUT) {
                return;
            }
            int n5 = this.mApiDatabase.getCallVersion("android/widget/" + string, "<init>", "(Landroid/content/Context;)");
            if (n5 > (n = this.getMinSdk((Context)xmlContext)) && n5 > xmlContext.getFolderVersion() && n5 > ApiDetector.getLocalMinSdk(element)) {
                Location location = xmlContext.getLocation((org.w3c.dom.Node)element);
                String string6 = String.format("View requires API level %1$d (current min is %2$d): <%3$s>", n5, n, string);
                xmlContext.report(UNSUPPORTED, (org.w3c.dom.Node)element, location, string6, null);
            }
        }
    }

    protected int getMinSdk(Context context) {
        if (this.mMinApi == -1) {
            this.mMinApi = context.getMainProject().getMinSdk();
        }
        return this.mMinApi;
    }

    public void checkClass(@NonNull ClassContext classContext, @NonNull ClassNode classNode) {
        List list;
        if (this.mApiDatabase == null) {
            return;
        }
        if (AOSP_BUILD && classNode.name.startsWith("android/support/")) {
            return;
        }
        int n = ApiDetector.getClassMinSdk(classContext, classNode);
        if (n == -1) {
            n = this.getMinSdk((Context)classContext);
        }
        if ((list = classNode.methods).isEmpty()) {
            return;
        }
        boolean bl = classContext.isEnabled(UNSUPPORTED) || classContext.isEnabled(INLINED);
        boolean bl2 = classContext.isEnabled(OVERRIDE) && classContext.getMainProject().getBuildSdk() >= 1;
        String string = null;
        if (bl2) {
            LintDriver lintDriver = classContext.getDriver();
            String string2 = classNode.superName;
            while (string2 != null) {
                if (string2.startsWith("android/") && !string2.startsWith("android/support/") || string2.startsWith("java/") || string2.startsWith("javax/")) {
                    string = string2;
                    break;
                }
                string2 = lintDriver.getSuperClass(string2);
            }
            if (string == null) {
                bl2 = false;
            }
        }
        for (String string2 : list) {
            String string3;
            String string4;
            Object object;
            int n2;
            MethodNode methodNode = (MethodNode)string2;
            int n3 = ApiDetector.getLocalMinSdk(methodNode.invisibleAnnotations);
            if (n3 == -1) {
                n3 = n;
            }
            InsnList insnList = methodNode.instructions;
            if (bl2 && Character.isJavaIdentifierStart(methodNode.name.charAt(0))) {
                n2 = classContext.getMainProject().getBuildSdk();
                String string5 = methodNode.name;
                assert (string != null);
                int n4 = this.mApiDatabase.getCallVersion(string, string5, methodNode.desc);
                if (n4 > n2 && n2 != -1) {
                    object = classNode.name;
                    String string6 = "<init>".equals(string5) ? "new " + ClassContext.getFqcn((String)object) : ClassContext.getFqcn((String)object) + '#' + string5;
                    string4 = String.format("This method is not overriding anything with the current build target, but will in API level %1$d (current target is %2$d): %3$s", n4, n2, string6);
                    string3 = classContext.getLocation(methodNode, classNode);
                    classContext.report(OVERRIDE, methodNode, null, (Location)string3, string4, null);
                }
            }
            if (!bl) continue;
            int n5 = insnList.size();
            block2: for (n2 = 0; n2 < n5; ++n2) {
                int n6;
                AbstractInsnNode abstractInsnNode = insnList.get(n2);
                int n7 = abstractInsnNode.getType();
                if (n7 == 5) {
                    object = (MethodInsnNode)abstractInsnNode;
                    string4 = object.name;
                    string3 = object.owner;
                    String string7 = object.desc;
                    if (object.getOpcode() == 182 && string3.equals(classNode.name)) {
                        string3 = classNode.superName;
                    }
                    boolean bl3 = false;
                    while (string3 != null) {
                        int n8 = this.mApiDatabase.getCallVersion(string3, string4, string7);
                        if (n8 > n3) {
                            if (methodNode.name.startsWith(SWITCH_TABLE_PREFIX) || !bl3 && object.getOpcode() == 182 && ApiDetector.methodDefinedLocally(classNode, string4, string7)) continue block2;
                            String string8 = "<init>".equals(string4) ? "new " + ClassContext.getFqcn((String)string3) : ClassContext.getFqcn((String)string3) + '#' + string4;
                            String string9 = String.format("Call requires API level %1$d (current min is %2$d): %3$s", n8, n3, string8);
                            if (string4.equals(ORDINAL_METHOD) && abstractInsnNode.getNext() != null && abstractInsnNode.getNext().getNext() != null && abstractInsnNode.getNext().getOpcode() == 46 && abstractInsnNode.getNext().getNext().getOpcode() == 170) {
                                string9 = String.format("Enum for switch requires API level %1$d (current min is %2$d): %3$s", n8, n3, ClassContext.getFqcn((String)string3));
                            }
                            ApiDetector.report(classContext, string9, (AbstractInsnNode)object, methodNode, string4, null, Location.SearchHints.create((Location.SearchDirection)Location.SearchDirection.FORWARD).matchJavaSymbol());
                        }
                        if (string3.startsWith("android/") || string3.startsWith("javax/")) {
                            string3 = string3.startsWith("android/support/") ? classContext.getDriver().getSuperClass(string3) : null;
                        } else if (string3.startsWith("java/")) {
                            if (string3.equals("java/text/SimpleDateFormat")) {
                                ApiDetector.checkSimpleDateFormat(classContext, methodNode, object, n3);
                            }
                            string3 = null;
                        } else {
                            string3 = object.getOpcode() == 182 ? classContext.getDriver().getSuperClass(string3) : (object.getOpcode() == 184 && n8 == -1 ? classContext.getDriver().getSuperClass(string3) : null);
                        }
                        bl3 = true;
                    }
                    continue;
                }
                if (n7 == 4) {
                    object = (FieldInsnNode)abstractInsnNode;
                    string3 = object.owner;
                    string4 = object.name;
                    int n9 = this.mApiDatabase.getFieldVersion(string3, string4);
                    if (n9 <= n3) continue;
                    if (methodNode.name.startsWith(SWITCH_TABLE_PREFIX)) {
                        ApiDetector.checkSwitchBlock(classContext, classNode, (FieldInsnNode)object, methodNode, string4, string3, n9, n3);
                        continue;
                    }
                    String string10 = ClassContext.getFqcn((String)string3) + '#' + string4;
                    if (this.mPendingFields != null) {
                        this.mPendingFields.remove(string10);
                    }
                    String string11 = String.format("Field requires API level %1$d (current min is %2$d): %3$s", n9, n3, string10);
                    ApiDetector.report(classContext, string11, (AbstractInsnNode)object, methodNode, string4, null, Location.SearchHints.create((Location.SearchDirection)Location.SearchDirection.FORWARD).matchJavaSymbol());
                    continue;
                }
                if (n7 != 9) continue;
                object = (LdcInsnNode)abstractInsnNode;
                if (!(object.cst instanceof Type) || (n6 = this.mApiDatabase.getClassVersion(string3 = (string4 = (Type)object.cst).getInternalName())) <= n3) continue;
                String string12 = ClassContext.getFqcn((String)string3);
                String string13 = String.format("Class requires API level %1$d (current min is %2$d): %3$s", n6, n3, string12);
                ApiDetector.report(classContext, string13, (AbstractInsnNode)object, methodNode, string3.substring(string3.lastIndexOf(47) + 1), null, Location.SearchHints.create((Location.SearchDirection)Location.SearchDirection.FORWARD).matchJavaSymbol());
            }
        }
    }

    private static void checkSimpleDateFormat(ClassContext classContext, MethodNode methodNode, MethodInsnNode methodInsnNode, int n) {
        if (n >= 9) {
            return;
        }
        if (methodInsnNode.name.equals("<init>") && !methodInsnNode.desc.equals("()V")) {
            AbstractInsnNode abstractInsnNode = LintUtils.getPrevInstruction((AbstractInsnNode)methodInsnNode);
            if (abstractInsnNode != null && !methodInsnNode.desc.equals("(Ljava/lang/String;)V")) {
                abstractInsnNode = LintUtils.getPrevInstruction((AbstractInsnNode)abstractInsnNode);
            }
            if (abstractInsnNode != null && abstractInsnNode.getOpcode() == 18) {
                LdcInsnNode ldcInsnNode = (LdcInsnNode)abstractInsnNode;
                Object object = ldcInsnNode.cst;
                if (object instanceof String) {
                    String string = (String)object;
                    boolean bl = false;
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (c == '\'') {
                            bl = !bl;
                            continue;
                        }
                        if (bl || c != 'L' && c != 'c') continue;
                        String string2 = String.format("The pattern character '%1$c' requires API level 9 (current min is %2$d) : \"%3$s\"", Character.valueOf(c), n, string);
                        ApiDetector.report(classContext, string2, (AbstractInsnNode)methodInsnNode, methodNode, string, null, Location.SearchHints.create((Location.SearchDirection)Location.SearchDirection.FORWARD));
                        return;
                    }
                }
            }
        }
    }

    private static boolean methodDefinedLocally(ClassNode classNode, String string, String string2) {
        List list = classNode.methods;
        for (Object e : list) {
            MethodNode methodNode = (MethodNode)e;
            if (!string.equals(methodNode.name) || !string2.equals(methodNode.desc)) continue;
            return true;
        }
        return false;
    }

    private static void checkSwitchBlock(ClassContext classContext, ClassNode classNode, FieldInsnNode fieldInsnNode, MethodNode methodNode, String string, String string2, int n, int n2) {
        Object object;
        int n3;
        AbstractInsnNode abstractInsnNode = fieldInsnNode.getNext();
        if (abstractInsnNode == null || abstractInsnNode.getOpcode() != 182) {
            return;
        }
        if ((abstractInsnNode = abstractInsnNode.getNext()) == null) {
            return;
        }
        switch (abstractInsnNode.getOpcode()) {
            case 3: {
                n3 = 0;
                break;
            }
            case 4: {
                n3 = 1;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
            case 6: {
                n3 = 3;
                break;
            }
            case 7: {
                n3 = 4;
                break;
            }
            case 8: {
                n3 = 5;
                break;
            }
            case 16: {
                object = (IntInsnNode)abstractInsnNode;
                n3 = ((IntInsnNode)object).operand;
                break;
            }
            default: {
                return;
            }
        }
        object = classNode.methods;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            InsnList insnList = ((MethodNode)e).instructions;
            int n4 = insnList.size();
            block10: for (int i = 0; i < n4; ++i) {
                AbstractInsnNode abstractInsnNode2 = insnList.get(i);
                if (abstractInsnNode2.getOpcode() != 184) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode2;
                if (!methodInsnNode.name.equals(methodNode.name) || !methodInsnNode.desc.equals(methodNode.desc) || !methodInsnNode.owner.equals(classNode.name)) continue;
                AbstractInsnNode abstractInsnNode3 = LintUtils.getNextInstruction((AbstractInsnNode)methodInsnNode);
                while (abstractInsnNode3 != null) {
                    if (abstractInsnNode3.getOpcode() == 171) {
                        LookupSwitchInsnNode lookupSwitchInsnNode = (LookupSwitchInsnNode)abstractInsnNode3;
                        List list = lookupSwitchInsnNode.keys;
                        if (list != null && list.contains(n3)) {
                            String string3 = ClassContext.getFqcn((String)string2) + '#' + string;
                            String string4 = String.format("Enum value requires API level %1$d (current min is %2$d): %3$s", n, n2, string3);
                            ApiDetector.report(classContext, string4, (AbstractInsnNode)lookupSwitchInsnNode, (MethodNode)e, string, null, Location.SearchHints.create((Location.SearchDirection)Location.SearchDirection.FORWARD).matchJavaSymbol());
                            continue block10;
                        }
                    }
                    abstractInsnNode3 = LintUtils.getNextInstruction((AbstractInsnNode)abstractInsnNode3);
                }
            }
        }
    }

    private static int getClassMinSdk(ClassContext classContext, ClassNode classNode) {
        int n = ApiDetector.getLocalMinSdk(classNode.invisibleAnnotations);
        if (n != -1) {
            return n;
        }
        LintDriver lintDriver = classContext.getDriver();
        while (classNode != null) {
            ClassNode classNode2 = classNode;
            if ((classNode = lintDriver.getOuterClassNode(classNode)) == null) continue;
            if (classNode2.outerMethod != null) {
                List list = classNode.methods;
                for (Object e : list) {
                    MethodNode methodNode = (MethodNode)e;
                    if (!methodNode.name.equals(classNode2.outerMethod) || !methodNode.desc.equals(classNode2.outerMethodDesc)) continue;
                    int n2 = ApiDetector.getLocalMinSdk(methodNode.invisibleAnnotations);
                    if (n2 == -1) break;
                    return n2;
                }
            }
            if ((n = ApiDetector.getLocalMinSdk(classNode.invisibleAnnotations)) == -1) continue;
            return n;
        }
        return -1;
    }

    private static int getLocalMinSdk(List list) {
        if (list != null) {
            for (AnnotationNode annotationNode : list) {
                String string = annotationNode.desc;
                if (!string.endsWith(TARGET_API_VMSIG) || annotationNode.values == null) continue;
                int n = annotationNode.values.size();
                for (int i = 0; i < n; i += 2) {
                    Object e;
                    String string2 = (String)annotationNode.values.get(i);
                    if (!string2.equals("value") || !((e = annotationNode.values.get(i + 1)) instanceof Integer)) continue;
                    return (Integer)e;
                }
            }
        }
        return -1;
    }

    private static int getLocalMinSdk(@NonNull Element element) {
        while (element != null) {
            org.w3c.dom.Node node;
            String string = element.getAttributeNS("http://schemas.android.com/tools", "targetApi");
            if (string != null && !string.isEmpty()) {
                if (Character.isDigit(string.charAt(0))) {
                    try {
                        return Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                }
                for (int i = 1; i <= 17; ++i) {
                    String string2 = LintUtils.getBuildCode((int)i);
                    if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
                    return i;
                }
            }
            if ((node = element.getParentNode()) == null || node.getNodeType() != 1) break;
            element = (Element)node;
        }
        return -1;
    }

    private static void report(ClassContext classContext, String string, AbstractInsnNode abstractInsnNode, MethodNode methodNode, String string2, String string3, Location.SearchHints searchHints) {
        int n;
        int n2 = n = abstractInsnNode != null ? ClassContext.findLineNumber((AbstractInsnNode)abstractInsnNode) : -1;
        if (string2 != null && string2.equals("<init>") && abstractInsnNode instanceof MethodInsnNode) {
            if (searchHints != null) {
                searchHints = searchHints.matchConstructor();
            }
            string2 = ((MethodInsnNode)abstractInsnNode).owner;
        }
        if (string2 != null) {
            int n3 = string2.lastIndexOf(36);
            if (n3 != -1) {
                string2 = string2.substring(n3 + 1);
            }
            if ((n3 = string2.lastIndexOf(47)) != -1) {
                string2 = string2.substring(n3 + 1);
            }
        }
        Location location = classContext.getLocationForLine(n, string2, string3, searchHints);
        classContext.report(UNSUPPORTED, methodNode, abstractInsnNode, location, string, null);
    }

    public void afterCheckProject(@NonNull Context context) {
        if (this.mPendingFields != null) {
            for (List<Pair<String, Location>> list : this.mPendingFields.values()) {
                for (Pair<String, Location> pair : list) {
                    String string = (String)pair.getFirst();
                    Location location = (Location)pair.getSecond();
                    context.report(INLINED, location, string, null);
                }
            }
        }
        super.afterCheckProject(context);
    }

    @Nullable
    public AstVisitor createJavaVisitor(@NonNull JavaContext javaContext) {
        return new ApiVisitor(javaContext);
    }

    @Nullable
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        ArrayList<Class<? extends Node>> arrayList = new ArrayList<Class<? extends Node>>(2);
        arrayList.add(ImportDeclaration.class);
        arrayList.add(Select.class);
        arrayList.add(MethodDeclaration.class);
        arrayList.add(ConstructorDeclaration.class);
        arrayList.add(VariableDefinitionEntry.class);
        arrayList.add(VariableReference.class);
        return arrayList;
    }

    public boolean isBenignConstantUsage(@Nullable Node node, @NonNull String string, @NonNull String string2) {
        if (string2.equals("android/os/Build$VERSION_CODES")) {
            return true;
        }
        if (string2.equals("android/view/ViewGroup$LayoutParams") && string.equals("MATCH_PARENT")) {
            return true;
        }
        if (string2.equals("android/widget/AbsListView") && (string.equals("CHOICE_MODE_NONE") || string.equals("CHOICE_MODE_MULTIPLE") || string.equals("CHOICE_MODE_SINGLE"))) {
            return true;
        }
        if (node == null) {
            return false;
        }
        for (Node node2 = node.getParent(); node2 != null; node2 = node2.getParent()) {
            Class<?> clazz = node2.getClass();
            if (clazz == Case.class) {
                Case case_ = (Case)node2;
                Expression expression = case_.astCondition();
                return expression != null && ApiDetector.isAncestor((Node)expression, node);
            }
            if (clazz == If.class) {
                If if_ = (If)node2;
                Expression expression = if_.astCondition();
                return expression != null && ApiDetector.isAncestor((Node)expression, node);
            }
            if (clazz != InlineIfExpression.class) continue;
            InlineIfExpression inlineIfExpression = (InlineIfExpression)node2;
            Expression expression = inlineIfExpression.astCondition();
            return expression != null && ApiDetector.isAncestor((Node)expression, node);
        }
        return false;
    }

    private static boolean isAncestor(@NonNull Node node, @Nullable Node node2) {
        while (node2 != null) {
            if (node2 == node) {
                return true;
            }
            node2 = node2.getParent();
        }
        return false;
    }

    private static int codeNameToApi(String string) {
        for (int i = 1; i <= 17; ++i) {
            String string2 = LintUtils.getBuildCode((int)i);
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    private final class ApiVisitor
    extends ForwardingAstVisitor {
        private JavaContext mContext;
        private Map<String, String> mClassToImport = Maps.newHashMap();
        private List<String> mStarImports;
        private Set<String> mLocalVars;
        private Node mCurrentMethod;
        private Set<String> mFields;
        private List<String> mStaticStarImports;

        private ApiVisitor(JavaContext javaContext) {
            this.mContext = javaContext;
        }

        public boolean visitImportDeclaration(ImportDeclaration importDeclaration) {
            if (importDeclaration.astStarImport()) {
                String string;
                String string2 = importDeclaration.asFullyQualifiedName();
                int n = string2.lastIndexOf(42);
                if (n != -1 && (n = string2.lastIndexOf(46, n)) != -1 && ApiLookup.isRelevantOwner(string = ClassContext.getInternalName((String)string2.substring(0, n)))) {
                    if (importDeclaration.astStaticImport()) {
                        if (this.mStaticStarImports == null) {
                            this.mStaticStarImports = Lists.newArrayList();
                        }
                        this.mStaticStarImports.add(string);
                    } else {
                        if (this.mStarImports == null) {
                            this.mStarImports = Lists.newArrayList();
                        }
                        this.mStarImports.add(string);
                    }
                }
            } else if (importDeclaration.astStaticImport()) {
                String string = importDeclaration.asFullyQualifiedName();
                String string3 = ClassContext.getInternalName((String)string);
                int n = string3.lastIndexOf(36);
                if (n != -1) {
                    String string4 = string3.substring(0, n);
                    String string5 = string3.substring(n + 1);
                    this.checkField((Node)importDeclaration, string5, string4);
                }
            } else {
                String string = importDeclaration.asFullyQualifiedName();
                int n = string.lastIndexOf(46);
                if (n != -1) {
                    String string6 = string.substring(n + 1);
                    this.mClassToImport.put(string6, string);
                }
            }
            return super.visitImportDeclaration(importDeclaration);
        }

        public boolean visitSelect(Select select) {
            Object object;
            Object object2;
            Select select2;
            boolean bl = super.visitSelect(select);
            if (select.getParent() instanceof Select) {
                return bl;
            }
            String string = select.astIdentifier().astValue();
            boolean bl2 = Character.isUpperCase(string.charAt(0));
            if (!bl2) {
                select2 = select;
                while (select2 != null) {
                    object2 = select2.astOperand();
                    if (object2 instanceof Select) {
                        select2 = (Select)object2;
                        if (!"R".equals(select2.astIdentifier().astValue())) continue;
                        bl2 = true;
                        break;
                    }
                    if (!(object2 instanceof VariableReference) || !"R".equals((object = (VariableReference)object2).astIdentifier().astValue())) break;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                select2 = select.astOperand();
                if (select2.getClass() == Select.class) {
                    int n;
                    object2 = select2.toString();
                    if (Character.isUpperCase(((String)object2).charAt(0)) && (n = ((String)object2).indexOf(46)) != -1) {
                        String string2 = ((String)object2).substring(0, n);
                        String string3 = this.mClassToImport.get(string2);
                        if (string3 != null) {
                            String string4 = ClassContext.getInternalName((String)(string3 + ((String)object2).substring(n)));
                            this.checkField((Node)select, string, string4);
                            return bl;
                        }
                        if (this.mStarImports != null) {
                            for (String string5 : this.mStarImports) {
                                String string6 = ClassContext.getInternalName((String)(string5 + '/' + (String)object2));
                                if (!this.checkField((Node)select, string, string6)) continue;
                                this.mClassToImport.put(string, string6);
                                return bl;
                            }
                        }
                    }
                    object = ClassContext.getInternalName((String)object2);
                    this.checkField((Node)select, string, (String)object);
                    return bl;
                }
                if (select2.getClass() == VariableReference.class) {
                    object2 = ((VariableReference)select2).astIdentifier().astValue();
                    object = this.mClassToImport.get(object2);
                    if (object != null) {
                        String string7 = ClassContext.getInternalName((String)object);
                        this.checkField((Node)select, string, string7);
                        return bl;
                    }
                    if (Character.isUpperCase(((String)object2).charAt(0)) && this.mStarImports != null) {
                        for (String string8 : this.mStarImports) {
                            String string9 = ClassContext.getInternalName((String)string8) + '/' + (String)object2;
                            if (!this.checkField((Node)select, string, string9)) continue;
                            this.mClassToImport.put(string, string9);
                            return bl;
                        }
                    }
                }
            }
            return bl;
        }

        public boolean visitVariableReference(VariableReference variableReference) {
            boolean bl;
            block5: {
                String string;
                Class<?> clazz;
                Object object;
                bl = super.visitVariableReference(variableReference);
                if (variableReference.getParent() != null) {
                    object = variableReference.getParent();
                    clazz = object.getClass();
                    if (clazz == Select.class || clazz == Switch.class || clazz == Case.class || clazz == ConstructorInvocation.class || clazz == SuperConstructorInvocation.class || clazz == AnnotationElement.class) {
                        return bl;
                    }
                    if (object instanceof MethodInvocation && ((MethodInvocation)object).astOperand() == variableReference) {
                        return bl;
                    }
                    if (object instanceof BinaryExpression && (string = (BinaryExpression)object).astLeft() == variableReference) {
                        return bl;
                    }
                }
                if (!Character.isUpperCase(((String)(object = variableReference.astIdentifier().astValue())).charAt(0)) || this.mLocalVars != null && this.mLocalVars.contains(object) || this.mFields != null && this.mFields.contains(object) || this.mStaticStarImports == null) break block5;
                clazz = this.mStaticStarImports.iterator();
                while (clazz.hasNext() && !this.checkField((Node)variableReference, (String)object, string = (String)clazz.next())) {
                }
            }
            return bl;
        }

        public boolean visitVariableDefinitionEntry(VariableDefinitionEntry variableDefinitionEntry) {
            if (this.mCurrentMethod != null) {
                if (this.mLocalVars == null) {
                    this.mLocalVars = Sets.newHashSet();
                }
                this.mLocalVars.add(variableDefinitionEntry.astName().astValue());
            } else {
                if (this.mFields == null) {
                    this.mFields = Sets.newHashSet();
                }
                this.mFields.add(variableDefinitionEntry.astName().astValue());
            }
            return super.visitVariableDefinitionEntry(variableDefinitionEntry);
        }

        public boolean visitMethodDeclaration(MethodDeclaration methodDeclaration) {
            this.mLocalVars = null;
            this.mCurrentMethod = methodDeclaration;
            return super.visitMethodDeclaration(methodDeclaration);
        }

        public boolean visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
            this.mLocalVars = null;
            this.mCurrentMethod = constructorDeclaration;
            return super.visitConstructorDeclaration(constructorDeclaration);
        }

        public void endVisit(Node node) {
            if (node == this.mCurrentMethod) {
                this.mCurrentMethod = null;
            }
            super.endVisit(node);
        }

        private boolean checkField(@NonNull Node node, @NonNull String string, @NonNull String string2) {
            int n = ApiDetector.this.mApiDatabase.getFieldVersion(string2, string);
            if (n != -1) {
                int n2 = ApiDetector.this.getMinSdk((Context)this.mContext);
                if (n > n2 && n > this.getLocalMinSdk(node)) {
                    Object object;
                    Object object2;
                    if (ApiDetector.this.isBenignConstantUsage(node, string, string2)) {
                        return true;
                    }
                    Location location = this.mContext.getLocation(node);
                    String string3 = ClassContext.getFqcn((String)string2) + '#' + string;
                    if (node instanceof ImportDeclaration) {
                        object2 = (ImportDeclaration)node;
                        int n3 = ((Identifier)object2.astParts().first()).getPosition().getStart();
                        object = location.getStart();
                        int n4 = object.getColumn();
                        int n5 = object.getLine();
                        object = new DefaultPosition(n5, n4 + n3 - object.getOffset(), n3);
                        int n6 = string3.length();
                        DefaultPosition defaultPosition = new DefaultPosition(n5, object.getColumn() + n6, object.getOffset() + n6);
                        location = Location.create((File)location.getFile(), (Position)object, (Position)defaultPosition);
                    }
                    object2 = String.format("Field requires API level %1$d (current min is %2$d): %3$s", n, n2, string3);
                    LintDriver lintDriver = this.mContext.getDriver();
                    if (lintDriver.isSuppressed(INLINED, node)) {
                        return true;
                    }
                    if (lintDriver.isSuppressed(UNSUPPORTED, node)) {
                        return true;
                    }
                    if (ApiDetector.this.mPendingFields == null) {
                        ApiDetector.this.mPendingFields = Maps.newHashMapWithExpectedSize((int)20);
                    }
                    if ((object = (List)ApiDetector.this.mPendingFields.get(string3)) == null) {
                        object = new ArrayList();
                        ApiDetector.this.mPendingFields.put(string3, object);
                    }
                    object.add(Pair.of((Object)object2, (Object)location));
                }
                return true;
            }
            return false;
        }

        public int getLocalMinSdk(@Nullable Node node) {
            while (node != null) {
                VariableDefinition variableDefinition;
                int n;
                Class<?> clazz = node.getClass();
                if (clazz == VariableDefinition.class ? (n = this.getLocalMinSdk((variableDefinition = (VariableDefinition)node).astModifiers())) != -1 : (clazz == MethodDeclaration.class ? (n = this.getLocalMinSdk((variableDefinition = (MethodDeclaration)node).astModifiers())) != -1 : (clazz == ConstructorDeclaration.class ? (n = this.getLocalMinSdk((variableDefinition = (ConstructorDeclaration)node).astModifiers())) != -1 : clazz == ClassDeclaration.class && (n = this.getLocalMinSdk((variableDefinition = (ClassDeclaration)node).astModifiers())) != -1))) {
                    return n;
                }
                node = node.getParent();
            }
            return -1;
        }

        private int getLocalMinSdk(@Nullable Modifiers modifiers) {
            if (modifiers == null) {
                return -1;
            }
            StrictListAccessor strictListAccessor = modifiers.astAnnotations();
            if (strictListAccessor == null) {
                return -1;
            }
            for (Annotation annotation : strictListAccessor) {
                StrictListAccessor strictListAccessor2;
                TypeReference typeReference = annotation.astAnnotationTypeReference();
                String string = typeReference.getTypeName();
                if (!string.endsWith("TargetApi") || (strictListAccessor2 = annotation.astElements()) == null) continue;
                for (AnnotationElement annotationElement : strictListAccessor2) {
                    AnnotationValue annotationValue = annotationElement.astValue();
                    if (annotationValue == null) continue;
                    if (annotationValue instanceof IntegralLiteral) {
                        IntegralLiteral integralLiteral = (IntegralLiteral)annotationValue;
                        return integralLiteral.astIntValue();
                    }
                    if (annotationValue instanceof StringLiteral) {
                        String string2 = ((StringLiteral)annotationValue).astValue();
                        return ApiDetector.codeNameToApi(string2);
                    }
                    if (annotationValue instanceof Select) {
                        Select select = (Select)annotationValue;
                        String string3 = select.astIdentifier().astValue();
                        return ApiDetector.codeNameToApi(string3);
                    }
                    if (!(annotationValue instanceof VariableReference)) continue;
                    VariableReference variableReference = (VariableReference)annotationValue;
                    String string4 = variableReference.astIdentifier().astValue();
                    return ApiDetector.codeNameToApi(string4);
                }
            }
            return -1;
        }
    }
}

