/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecationDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"Deprecated", (String)"Looks for usages of deprecated layouts, attributes, and so on.", (String)"Deprecated views, attributes and so on are deprecated because there is a better way to do something. Do it that new way. You've been warned.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.WARNING, DeprecationDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("AbsoluteLayout");
    }

    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("editable", "inputMethod", "autoText", "capitalize", "numeric", "phoneNumber", "password");
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        xmlContext.report(ISSUE, (Node)element, xmlContext.getLocation((Node)element), String.format("%1$s is deprecated", element.getTagName()), null);
    }

    public void visitAttribute(@NonNull XmlContext xmlContext, @NonNull Attr attr) {
        String string;
        if (!"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI())) {
            return;
        }
        String string2 = attr.getLocalName();
        int n = 1;
        if (string2.equals("editable")) {
            string = !"EditText".equals(attr.getOwnerElement().getTagName()) ? "Use an <EditText> to make it editable" : ("true".equals(attr.getValue()) ? "<EditText> is already editable" : "Use inputType instead");
        } else if (string2.equals("enabled")) {
            string = "Use state_enabled instead";
        } else if (string2.equals("singleLine")) {
            string = "Use maxLines=\"1\" instead";
        } else {
            assert (string2.equals("inputMethod") || string2.equals("capitalize") || string2.equals("numeric") || string2.equals("phoneNumber") || string2.equals("password") || string2.equals("autoText"));
            string = "Use inputType instead";
            n = 3;
        }
        if (xmlContext.getProject().getMinSdk() < n) {
            return;
        }
        xmlContext.report(ISSUE, (Node)attr, xmlContext.getLocation((Node)attr), String.format("%1$s is deprecated: %2$s", attr.getName(), string), null);
    }
}

