/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.EnumSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DosLineEndingDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"MangledCRLF", (String)"Checks that files with DOS line endings are consistent", (String)"On Windows, line endings are typically recorded as carriage return plus newline: \\r\\n.\n\nThis detector looks for invalid line endings with repeated carriage return characters (without newlines). Previous versions of the ADT plugin could accidentally introduce these into the file, and when editing the file, the editor could produce confusing visual artifacts.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.ERROR, DosLineEndingDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE).setMoreInfo("https://bugs.eclipse.org/bugs/show_bug.cgi?id=375421");

    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    public void visitDocument(@NonNull XmlContext xmlContext, @NonNull Document document) {
        String string = xmlContext.getContents();
        if (string == null) {
            return;
        }
        char c = '\u0000';
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == '\r' && c == '\r') {
                int n2;
                int n3;
                String string2 = "Incorrect line ending: found carriage return (\\r) without corresponding newline (\\n)";
                boolean bl = true;
                for (n3 = i - 2; n3 < i; ++n3) {
                    n2 = string.charAt(n3);
                    if (Character.isWhitespace((char)n2)) continue;
                    bl = false;
                }
                n3 = i;
                for (n2 = i - 2; n2 >= 0; --n2) {
                    char c3 = string.charAt(n2);
                    if (c3 == '\n') {
                        n3 = n2 + 1;
                        if (bl) continue;
                        break;
                    }
                    if (Character.isWhitespace(c3)) continue;
                    bl = false;
                }
                n2 = Math.min(string.length(), i + 1);
                Location location = Location.create((File)xmlContext.file, (String)string, (int)n3, (int)n2);
                xmlContext.report(ISSUE, (Node)document.getDocumentElement(), location, string2, null);
                return;
            }
            c = c2;
        }
    }
}

