/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldGetterDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"FieldGetter", (String)"Suggests replacing uses of getters with direct field access within a class", (String)"Accessing a field within the class that defines a getter for that field is at least 3 times faster than calling the getter. For simple getters that do nothing other than return the field, you might want to just reference the local field directly instead.\n\nNOTE: As of Android 2.3 (Gingerbread), this optimization is performed automatically by Dalvik, so there is no need to change your code; this is only relevant if you are targeting older versions of Android.", (Category)Category.PERFORMANCE, (int)4, (Severity)Severity.WARNING, FieldGetterDetector.class, (EnumSet)Scope.CLASS_FILE_SCOPE).setEnabledByDefault(false).setMoreInfo("http://developer.android.com/guide/practices/design/performance.html#internal_get_set");
    private ArrayList<Entry> mPendingCalls;

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public int[] getApplicableAsmNodeTypes() {
        return new int[]{5};
    }

    public void checkInstruction(@NonNull ClassContext classContext, @NonNull ClassNode classNode, @NonNull MethodNode methodNode, @NonNull AbstractInsnNode abstractInsnNode) {
        if (classContext.getProject().getMinSdk() >= 9) {
            return;
        }
        if ((methodNode.access & 8) != 0) {
            return;
        }
        if (abstractInsnNode.getOpcode() != 182) {
            return;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        String string = methodInsnNode.name;
        String string2 = methodInsnNode.owner;
        AbstractInsnNode abstractInsnNode2 = LintUtils.getPrevInstruction((AbstractInsnNode)abstractInsnNode);
        if (abstractInsnNode2 == null || abstractInsnNode2.getOpcode() != 25) {
            return;
        }
        VarInsnNode varInsnNode = (VarInsnNode)abstractInsnNode2;
        if (varInsnNode.var != 0) {
            return;
        }
        if ((string.startsWith("get") && string.length() > 3 && Character.isUpperCase(string.charAt(3)) || string.startsWith("is") && string.length() > 2 && Character.isUpperCase(string.charAt(2))) && string2.equals(classNode.name)) {
            if (this.mPendingCalls == null) {
                this.mPendingCalls = new ArrayList();
            }
            this.mPendingCalls.add(new Entry(string, methodInsnNode, methodNode));
        }
        super.checkInstruction(classContext, classNode, methodNode, abstractInsnNode);
    }

    public void afterCheckFile(@NonNull Context context) {
        ClassContext classContext = (ClassContext)context;
        if (this.mPendingCalls != null) {
            HashSet<String> hashSet = new HashSet<String>(this.mPendingCalls.size());
            for (Entry object : this.mPendingCalls) {
                hashSet.add(object.name);
            }
            Map<String, String> map = FieldGetterDetector.checkMethods(classContext.getClassNode(), hashSet);
            if (!map.isEmpty()) {
                for (String string : map.keySet()) {
                    for (Entry entry : this.mPendingCalls) {
                        String string2 = entry.name;
                        if (!string2.equals(string)) continue;
                        Location location = classContext.getLocation((AbstractInsnNode)entry.call);
                        String string3 = (String)map.get(string);
                        if (string3 == null) {
                            string3 = "";
                        }
                        classContext.report(ISSUE, entry.method, (AbstractInsnNode)entry.call, location, String.format("Calling getter method %1$s() on self is slower than field access (%2$s)", string, string3), (Object)string3);
                    }
                }
            }
        }
        this.mPendingCalls = null;
    }

    private static Map<String, String> checkMethods(ClassNode classNode, Set<String> set) {
        HashMap hashMap = Maps.newHashMap();
        List list = classNode.methods;
        String string = null;
        block6: for (Object e : list) {
            MethodNode methodNode = (MethodNode)e;
            if (!set.contains(methodNode.name) || !methodNode.desc.startsWith("()")) continue;
            InsnList insnList = methodNode.instructions;
            int n = 1;
            block7: for (AbstractInsnNode abstractInsnNode = insnList.getFirst(); abstractInsnNode != null; abstractInsnNode = abstractInsnNode.getNext()) {
                switch (abstractInsnNode.getOpcode()) {
                    case -1: {
                        continue block7;
                    }
                    case 25: {
                        if (n != true) continue block6;
                        string = null;
                        n = 2;
                        continue block7;
                    }
                    case 180: {
                        if (n != 2) continue block6;
                        FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
                        string = fieldInsnNode.name;
                        n = 3;
                        continue block7;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        if (n != 3) continue block6;
                        hashMap.put(methodNode.name, string);
                        continue block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
        }
        return hashMap;
    }

    private static class Entry {
        public final String name;
        public final MethodNode method;
        public final MethodInsnNode call;

        public Entry(String string, MethodInsnNode methodInsnNode, MethodNode methodNode) {
            this.name = string;
            this.call = methodInsnNode;
            this.method = methodNode;
        }
    }
}

