/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import lombok.ast.AstVisitor;
import lombok.ast.ConstructorInvocation;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.VariableReference;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    private static final boolean INCLUDE_LDPI;
    private static final Pattern DENSITY_PATTERN;
    private static final String[] REQUIRED_DENSITIES;
    private static final String[] DENSITY_QUALIFIERS;
    private static final EnumSet<Scope> ICON_TYPE_SCOPE;
    public static final Issue ICON_EXPECTED_SIZE;
    public static final Issue ICON_DIP_SIZE;
    public static final Issue ICON_LOCATION;
    public static final Issue ICON_DENSITIES;
    public static final Issue ICON_MISSING_FOLDER;
    public static final Issue GIF_USAGE;
    public static final Issue DUPLICATES_NAMES;
    public static final Issue DUPLICATES_CONFIGURATIONS;
    public static final Issue ICON_NODPI;
    public static final Issue ICON_XML_AND_PNG;
    public static final Issue ICON_EXTENSION;
    public static final Issue ICON_COLORS;
    public static final Issue ICON_LAUNCHER_SHAPE;
    private Map<File, BufferedImage> mImageCache;
    private Set<String> mActionBarIcons;
    private Set<String> mNotificationIcons;
    private Set<String> mLauncherIcons;
    private Multimap<String, String> mMenuToIcons;
    private static final String NOTIFICATION_CLASS = "Notification";
    private static final String NOTIFICATION_COMPAT_CLASS = "NotificationCompat";
    private static final String BUILDER_CLASS = "Builder";
    private static final String SET_SMALL_ICON = "setSmallIcon";
    private static final String ON_CREATE_OPTIONS_MENU = "onCreateOptionsMenu";

    @NonNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    public void beforeCheckProject(@NonNull Context context) {
        this.mLauncherIcons = null;
        this.mActionBarIcons = null;
        this.mNotificationIcons = null;
    }

    public void afterCheckLibraryProject(@NonNull Context context) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        this.checkResourceFolder(context, context.getProject());
    }

    public void afterCheckProject(@NonNull Context context) {
        this.checkResourceFolder(context, context.getProject());
    }

    private void checkResourceFolder(Context context, @NonNull Project project) {
        List list = project.getResourceFolders();
        for (File file : list) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) continue;
            boolean bl = context.isEnabled(ICON_DENSITIES) || context.isEnabled(ICON_MISSING_FOLDER) || context.isEnabled(ICON_NODPI) || context.isEnabled(ICON_XML_AND_PNG);
            boolean bl2 = context.isEnabled(ICON_DIP_SIZE);
            boolean bl3 = context.isEnabled(DUPLICATES_NAMES) || context.isEnabled(DUPLICATES_CONFIGURATIONS);
            HashMap<File, Dimension> hashMap = null;
            HashMap<File, Long> hashMap2 = null;
            if (bl2 || bl3) {
                hashMap = new HashMap<File, Dimension>();
                hashMap2 = new HashMap<File, Long>();
            }
            HashMap<File, Set<String>> hashMap3 = new HashMap<File, Set<String>>();
            HashMap<File, Set<String>> hashMap4 = new HashMap<File, Set<String>>();
            for (File file2 : fileArray) {
                String string;
                HashSet<String> hashSet;
                File[] fileArray2;
                String string2 = file2.getName();
                if (!string2.startsWith("drawable") || (fileArray2 = file2.listFiles()) == null) continue;
                this.checkDrawableDir(context, file2, fileArray2, hashMap, hashMap2);
                if (bl && DENSITY_PATTERN.matcher(string2).matches()) {
                    hashSet = new HashSet(fileArray2.length);
                    for (File file3 : fileArray2) {
                        string = file3.getName();
                        if (!IconDetector.isDrawableFile(string)) continue;
                        hashSet.add(string);
                    }
                    hashMap3.put(file2, hashSet);
                    continue;
                }
                if (!bl) continue;
                hashSet = new HashSet<String>(fileArray2.length);
                for (File file3 : fileArray2) {
                    string = file3.getName();
                    if (!IconDetector.isDrawableFile(string)) continue;
                    hashSet.add(string);
                }
                hashMap4.put(file2, hashSet);
            }
            if (bl2) {
                IconDetector.checkDipSizes(context, hashMap);
            }
            if (bl3) {
                IconDetector.checkDuplicates(context, hashMap, hashMap2);
            }
            if (!bl || hashMap3.isEmpty()) continue;
            IconDetector.checkDensities(context, file, hashMap3, hashMap4);
        }
    }

    private static boolean isDrawableFile(String string) {
        return LintUtils.endsWith((String)string, (String)".png") || LintUtils.endsWith((String)string, (String)".jpg") || LintUtils.endsWith((String)string, (String)".gif") || LintUtils.endsWith((String)string, (String)".xml") || LintUtils.endsWith((String)string, (String)".jpeg");
    }

    private static void checkDuplicates(Context context, Map<File, Dimension> map, Map<File, Long> map2) {
        Set<Object> set;
        Serializable serializable;
        Object object;
        HashMap hashMap = new HashMap();
        HashMap<Long, Object> hashMap2 = new HashMap<Long, Object>(map2.size());
        for (Map.Entry<File, Long> object22 : map2.entrySet()) {
            object = object22.getKey();
            serializable = object22.getValue();
            if (hashMap2.containsKey(serializable)) {
                set = (Set)hashMap.get(serializable);
                if (set == null) {
                    set = new HashSet<Object>();
                    set.add(hashMap2.get(serializable));
                    hashMap.put(serializable, set);
                }
                set.add(object);
                continue;
            }
            hashMap2.put((Long)serializable, object);
        }
        if (hashMap.isEmpty()) {
            return;
        }
        Collection collection = hashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Serializable serializable2;
            object = (Set)iterator.next();
            serializable = new HashMap(object.size());
            set = new ArrayList();
            List list = object.iterator();
            while (list.hasNext()) {
                serializable2 = (File)list.next();
                Dimension dimension = map.get(serializable2);
                if (dimension != null) {
                    Set<HashSet<Object>> set2 = (HashSet<HashSet<Object>>)serializable.get(dimension);
                    if (set2 == null) {
                        set2 = new HashSet<HashSet<Object>>();
                        serializable.put(dimension, set2);
                    }
                    set2.add((HashSet<Object>)serializable2);
                    continue;
                }
                set.add(serializable2);
            }
            list = serializable.values();
            if (!set.isEmpty()) {
                if (!list.isEmpty()) {
                    for (Set set3 : list) {
                        set3.addAll(set);
                    }
                } else {
                    serializable2 = new HashSet(set);
                    list = Collections.singletonList(serializable2);
                }
            }
            serializable2 = new HashMap();
            for (Set<HashSet<Object>> set2 : list) {
                Object object2;
                Object object32;
                ArrayList<byte[]> arrayList;
                if (set2.size() < 2) continue;
                for (File file : set2) {
                    byte[] byArray = (byte[])serializable2.get(file);
                    if (byArray != null) continue;
                    try {
                        byArray = context.getClient().readBytes(file);
                        serializable2.put(file, byArray);
                    }
                    catch (IOException iOException) {
                        context.log((Throwable)iOException, null, new Object[0]);
                    }
                }
                HashMap hashMap3 = new HashMap();
                ArrayList arrayList2 = new ArrayList(set2);
                Collections.sort(arrayList2);
                for (int i = 0; i < arrayList2.size() - 1; ++i) {
                    for (int j = i + 1; j < arrayList2.size(); ++j) {
                        arrayList = (File)arrayList2.get(i);
                        File file = (File)arrayList2.get(j);
                        object32 = (byte[])serializable2.get(arrayList);
                        object2 = (byte[])serializable2.get(file);
                        if (object32 == null || object2 == null || ((byte[])object32).length != ((byte[])object2).length) continue;
                        boolean bl = true;
                        for (int k = 0; k < ((Object)object32).length; ++k) {
                            if (object32[k] == object2[k]) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        hashMap3.put(arrayList, file);
                    }
                }
                if (hashMap3.isEmpty()) continue;
                HashMap<Object, HashSet<HashSet<Object>>> hashMap4 = new HashMap<Object, HashSet<HashSet<Object>>>();
                ArrayList<HashSet<HashSet<Object>>> arrayList3 = new ArrayList<HashSet<HashSet<Object>>>();
                for (Map.Entry entry : hashMap3.entrySet()) {
                    object32 = (File)entry.getKey();
                    object2 = (File)entry.getValue();
                    Set set4 = (Set)hashMap4.get(object32);
                    Set set5 = (Set)hashMap4.get(object2);
                    if (set4 != null) {
                        set4.add(object2);
                        continue;
                    }
                    if (set5 != null) {
                        set5.add(object32);
                        continue;
                    }
                    set2 = new HashSet();
                    arrayList3.add((HashSet<HashSet<Object>>)set2);
                    set2.add((HashSet<Object>)object32);
                    set2.add((HashSet<Object>)object2);
                    hashMap4.put(object32, (HashSet<HashSet<Object>>)set2);
                    hashMap4.put(object2, (HashSet<HashSet<Object>>)set2);
                }
                arrayList = new ArrayList<byte[]>();
                Iterator iterator2 = arrayList3.iterator();
                while (iterator2.hasNext()) {
                    object32 = (Set)iterator2.next();
                    assert (!object32.isEmpty());
                    object2 = new ArrayList(object32);
                    Collections.sort(object2);
                    arrayList.add((byte[])object2);
                }
                Collections.sort(arrayList, new Comparator<List<File>>(){

                    @Override
                    public int compare(List<File> list, List<File> list2) {
                        return list.get(0).compareTo(list2.get(0));
                    }
                });
                for (Object object32 : arrayList) {
                    Object object4;
                    Object object5;
                    object2 = null;
                    boolean bl = true;
                    String string = null;
                    Object object6 = object32.iterator();
                    while (object6.hasNext()) {
                        object5 = (File)object6.next();
                        if (string != null && !string.equals(((File)object5).getName())) {
                            bl = false;
                        }
                        string = ((File)object5).getName();
                        object4 = object2;
                        object2 = Location.create((File)object5);
                        object2.setSecondary((Location)object4);
                    }
                    if (bl) {
                        object6 = new StringBuilder(object32.size() * 16);
                        object5 = object32.iterator();
                        while (object5.hasNext()) {
                            object4 = (File)object5.next();
                            if (((StringBuilder)object6).length() > 0) {
                                ((StringBuilder)object6).append(", ");
                            }
                            ((StringBuilder)object6).append(((File)object4).getParentFile().getName());
                        }
                        object5 = String.format("The %1$s icon has identical contents in the following configuration folders: %2$s", string, ((StringBuilder)object6).toString());
                        context.report(DUPLICATES_CONFIGURATIONS, (Location)object2, (String)object5, null);
                        continue;
                    }
                    object6 = new StringBuilder(object32.size() * 16);
                    object5 = object32.iterator();
                    while (object5.hasNext()) {
                        object4 = (File)object5.next();
                        if (((StringBuilder)object6).length() > 0) {
                            ((StringBuilder)object6).append(", ");
                        }
                        ((StringBuilder)object6).append(((File)object4).getName());
                    }
                    object5 = String.format("The following unrelated icon files have identical contents: %1$s", ((StringBuilder)object6).toString());
                    context.report(DUPLICATES_NAMES, (Location)object2, (String)object5, null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkDipSizes(Context context, Map<File, Dimension> map) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap hashMap = new HashMap();
        for (File serializable2 : map.keySet()) {
            void var6_7;
            object4 = serializable2.getName();
            List list = (List)hashMap.get(object4);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                hashMap.put(object4, arrayList);
            }
            var6_7.add(serializable2);
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList);
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        for (Map.Entry entry : hashMap.entrySet()) {
            object3 = (String)entry.getKey();
            List list = (List)entry.getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ArrayList<Object> arrayList2;
                object2 = (File)iterator.next();
                object = ((File)object2).getParentFile().getName();
                n = -1;
                for (String string : DENSITY_QUALIFIERS) {
                    n = ((String)object).indexOf(string);
                    if (n == -1) continue;
                    object = ((String)object).substring(0, n) + ((String)object).substring(n + string.length());
                    break;
                }
                if (n == -1) continue;
                Object object5 = (Map)hashMap2.get(object3);
                if (object5 == null) {
                    object5 = new HashMap();
                    hashMap2.put(object3, object5);
                }
                if ((arrayList2 = (ArrayList<Object>)object5.get(object)) == null) {
                    arrayList2 = new ArrayList<Object>();
                    object5.put(object, arrayList2);
                }
                arrayList2.add(object2);
            }
        }
        object4 = arrayList.iterator();
        while (object4.hasNext()) {
            String string = (String)object4.next();
            object3 = (Map)hashMap2.get(string);
            if (object3 == null) continue;
            for (Map.Entry entry : object3.entrySet()) {
                object2 = (List)entry.getValue();
                object = new HashMap();
                n = 0;
                int n2 = 0;
                int n3 = 0;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Dimension dimension;
                    File file = (File)iterator.next();
                    float f = IconDetector.getMdpiScalingFactor(file.getParentFile().getName());
                    if (!(f > 0.0f) || (dimension = map.get(file)) == null) continue;
                    Dimension dimension2 = new Dimension(Math.round((float)dimension.width / f), Math.round((float)dimension.height / f));
                    n += dimension2.width;
                    n2 += dimension2.height;
                    object.put(file, dimension2);
                    ++n3;
                }
                if (n3 == 0) continue;
                int n4 = n / n3;
                int n5 = n2 / n3;
                int n6 = 0;
                int n7 = 0;
                for (Dimension dimension : object.values()) {
                    n6 += (dimension.width - n4) * (dimension.width - n4);
                    n7 += (dimension.height - n5) * (dimension.height - n5);
                }
                double d = Math.sqrt(n6 / n3);
                double d2 = Math.sqrt(n7 / n3);
                if (!(d > (double)(n4 / 10)) && !(d2 > (double)n5)) continue;
                Location location = null;
                StringBuilder stringBuilder = new StringBuilder(100);
                ArrayList arrayList3 = new ArrayList();
                for (Map.Entry entry2 : object.entrySet()) {
                    arrayList3.add(entry2);
                }
                Collections.sort(arrayList3, new Comparator<Map.Entry<File, Dimension>>(){

                    @Override
                    public int compare(Map.Entry<File, Dimension> entry, Map.Entry<File, Dimension> entry2) {
                        Dimension dimension = entry.getValue();
                        Dimension dimension2 = entry2.getValue();
                        if (dimension.width != dimension2.width) {
                            return dimension2.width - dimension.width;
                        }
                        return dimension2.height - dimension.height;
                    }
                });
                for (Map.Entry entry2 : arrayList3) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    File file = (File)entry2.getKey();
                    Location location2 = location;
                    location = Location.create((File)file);
                    location.setSecondary(location2);
                    Dimension dimension = (Dimension)entry2.getValue();
                    Dimension dimension3 = map.get(file);
                    String string2 = file.getParentFile().getName() + File.separator + file.getName();
                    stringBuilder.append(String.format("%1$s: %2$dx%3$d dp (%4$dx%5$d px)", string2, dimension.width, dimension.height, dimension3.width, dimension3.height));
                }
                String string3 = String.format("The image %1$s varies significantly in its density-independent (dip) size across the various density versions: %2$s", string, stringBuilder.toString());
                context.report(ICON_DIP_SIZE, location, string3, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkDensities(Context context, File file, Map<File, Set<String>> map, Map<File, Set<String>> map2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Cloneable cloneable;
        HashSet<String> hashSet = new HashSet<String>();
        for (File object52 : map.keySet()) {
            hashSet.add(object52.getName());
        }
        if (context.isEnabled(ICON_MISSING_FOLDER)) {
            cloneable = new ArrayList();
            for (String string : REQUIRED_DENSITIES) {
                if (hashSet.contains(string)) continue;
                cloneable.add(string);
            }
            if (!cloneable.isEmpty()) {
                context.report(ICON_MISSING_FOLDER, Location.create((File)file), String.format("Missing density variation folders in %1$s: %2$s", context.getProject().getDisplayPath(file), LintUtils.formatList((List)((Object)cloneable), (int)-1)), null);
            }
        }
        if (context.isEnabled(ICON_NODPI)) {
            cloneable = new HashSet();
            for (Map.Entry<File, Set<String>> entry : map.entrySet()) {
                if (!IconDetector.isNoDpiFolder(entry.getKey())) continue;
                cloneable.addAll((Collection)entry.getValue());
            }
            if (!cloneable.isEmpty()) {
                HashSet hashSet2 = new HashSet();
                ArrayList<File> arrayList = new ArrayList<File>();
                for (Map.Entry<File, Set<String>> entry : map.entrySet()) {
                    object4 = entry.getKey();
                    object3 = ((File)object4).getName();
                    if (IconDetector.isNoDpiFolder((File)object4)) continue;
                    assert (DENSITY_PATTERN.matcher((CharSequence)object3).matches());
                    object2 = IconDetector.nameIntersection((Set<String>)((Object)cloneable), entry.getValue());
                    hashSet2.addAll(object2);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        arrayList.add(new File((File)object4, string));
                    }
                }
                if (!hashSet2.isEmpty()) {
                    void var9_31;
                    ArrayList arrayList2 = new ArrayList(hashSet2);
                    Collections.sort(arrayList2);
                    Collections.sort(arrayList);
                    Object var9_30 = null;
                    object4 = arrayList.iterator();
                    while (object4.hasNext()) {
                        object3 = (File)object4.next();
                        object2 = var9_31;
                        Location location = Location.create((File)object3);
                        location.setSecondary((Location)object2);
                    }
                    context.report(ICON_NODPI, (Location)var9_31, String.format("The following images appear in both -nodpi and in a density folder: %1$s", LintUtils.formatList((List)arrayList2, (int)(context.getDriver().isAbbreviating() ? 10 : -1))), null);
                }
            }
        }
        if (context.isEnabled(ICON_XML_AND_PNG)) {
            cloneable = Maps.newHashMap(map);
            cloneable.putAll(map2);
            HashSet hashSet3 = Sets.newHashSetWithExpectedSize((int)100);
            HashSet hashSet4 = Sets.newHashSetWithExpectedSize((int)100);
            Object object5 = cloneable.entrySet().iterator();
            while (object5.hasNext()) {
                Map.Entry entry = object5.next();
                object4 = (Set)entry.getValue();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    if (LintUtils.endsWith((String)object2, (String)".xml")) {
                        hashSet3.add(object2);
                        continue;
                    }
                    if (!IconDetector.isDrawableFile((String)object2)) continue;
                    hashSet4.add(object2);
                }
            }
            if (!(hashSet3.isEmpty() || hashSet4.isEmpty() || (object5 = IconDetector.nameIntersection(hashSet3, hashSet4)).isEmpty())) {
                Map.Entry<File, Set<String>> entry4;
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                object4 = Sets.newHashSetWithExpectedSize((int)object5.size());
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    object4.add((String)LintUtils.getBaseName((String)object2));
                }
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    for (Map.Entry entry2 : cloneable.entrySet()) {
                        entry4 = (File)entry2.getKey();
                        for (String string : (Set)entry2.getValue()) {
                            if (!((String)object2).equals(LintUtils.getBaseName((String)string))) continue;
                            arrayListMultimap.put(object2, (Object)new File((File)((Object)entry4), string));
                        }
                    }
                }
                object3 = new ArrayList(arrayListMultimap.keySet());
                Collections.sort(object3);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    ArrayList arrayList = Lists.newArrayList((Iterable)arrayListMultimap.get(object));
                    Collections.sort(arrayList);
                    entry4 = null;
                    for (File file2 : arrayList) {
                        Map.Entry<File, Set<String>> entry3 = entry4;
                        entry4 = Location.create((File)file2);
                        entry4.setSecondary((Location)entry3);
                    }
                    ArrayList arrayList3 = Lists.newArrayList();
                    boolean bl = false;
                    boolean bl2 = false;
                    for (File file3 : arrayList) {
                        boolean bl3 = LintUtils.endsWith((String)file3.getPath(), (String)".xml");
                        if (bl3 && !bl) {
                            arrayList3.add(context.getProject().getDisplayPath(file3));
                            bl = true;
                            continue;
                        }
                        if (bl3 || bl2) continue;
                        arrayList3.add(context.getProject().getDisplayPath(file3));
                        bl2 = true;
                    }
                    context.report(ICON_XML_AND_PNG, (Location)entry4, String.format("The following images appear both as density independent .xml files and as bitmap files: %1$s", LintUtils.formatList((List)arrayList3, (int)(context.getDriver().isAbbreviating() ? 10 : -1))), null);
                }
            }
        }
        if (context.isEnabled(ICON_DENSITIES)) {
            cloneable = new HashSet();
            for (Map.Entry<File, Set<String>> entry : map.entrySet()) {
                if (IconDetector.isNoDpiFolder(entry.getKey())) continue;
                Set<String> set = entry.getValue();
                cloneable.addAll(set);
            }
            for (Map.Entry<File, Set<String>> entry : map.entrySet()) {
                Set<String> set;
                File file4 = entry.getKey();
                if (IconDetector.isNoDpiFolder(file4) || (set = entry.getValue()).size() == cloneable.size() || (object4 = new ArrayList<String>(IconDetector.nameDifferences((Set<String>)((Object)cloneable), set))).isEmpty()) continue;
                Collections.sort(object4);
                object3 = "";
                if (object4.size() == 1) {
                    object2 = new ArrayList();
                    object = (String)object4.get(0);
                    for (Map.Entry<File, Set<String>> entry4 : map.entrySet()) {
                        if (!((Set)entry4.getValue()).contains(object)) continue;
                        object2.add(((File)entry4.getKey()).getName());
                    }
                    if (!object2.isEmpty()) {
                        object3 = String.format(" (found in %1$s)", LintUtils.formatList((List)object2, (int)(context.getDriver().isAbbreviating() ? 5 : -1)));
                    }
                }
                context.report(ICON_DENSITIES, Location.create((File)file4), String.format("Missing the following drawables in %1$s: %2$s%3$s", file4.getName(), LintUtils.formatList((List)object4, (int)(context.getDriver().isAbbreviating() ? 5 : -1)), object3), null);
            }
        }
    }

    private static Set<String> nameDifferences(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (String hashSet2 : set) {
            hashSet.add(LintUtils.getBaseName((String)hashSet2));
        }
        HashSet hashSet3 = new HashSet(set2.size());
        for (String string : set2) {
            hashSet3.add(LintUtils.getBaseName((String)string));
        }
        hashSet.removeAll(hashSet3);
        if (!hashSet.isEmpty()) {
            HashSet<String> hashSet2 = new HashSet<String>(hashSet.size());
            for (String string : set) {
                if (!hashSet.contains(LintUtils.getBaseName((String)string))) continue;
                hashSet2.add(string);
            }
            for (String string : set2) {
                if (!hashSet.contains(LintUtils.getBaseName((String)string))) continue;
                hashSet2.add(string);
            }
            return hashSet2;
        }
        return Collections.emptySet();
    }

    private static Set<String> nameIntersection(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (String hashSet2 : set) {
            hashSet.add(LintUtils.getBaseName((String)hashSet2));
        }
        HashSet hashSet3 = new HashSet(set2.size());
        for (String string : set2) {
            hashSet3.add(LintUtils.getBaseName((String)string));
        }
        hashSet.retainAll(hashSet3);
        if (!hashSet.isEmpty()) {
            HashSet<String> hashSet2 = new HashSet<String>(hashSet.size());
            for (String string : set) {
                if (!hashSet.contains(LintUtils.getBaseName((String)string))) continue;
                hashSet2.add(string);
            }
            for (String string : set2) {
                if (!hashSet.contains(LintUtils.getBaseName((String)string))) continue;
                hashSet2.add(string);
            }
            return hashSet2;
        }
        return Collections.emptySet();
    }

    private static boolean isNoDpiFolder(File file) {
        return file.getName().contains("-nodpi");
    }

    @Nullable
    private BufferedImage getImage(@Nullable File file) throws IOException {
        BufferedImage bufferedImage;
        if (this.mImageCache == null) {
            this.mImageCache = Maps.newHashMap();
        } else {
            bufferedImage = this.mImageCache.get(file);
            if (bufferedImage != null) {
                return bufferedImage;
            }
        }
        bufferedImage = ImageIO.read(file);
        this.mImageCache.put(file, bufferedImage);
        return bufferedImage;
    }

    private void checkDrawableDir(Context context, File file, File[] fileArray, Map<File, Dimension> map, Map<File, Long> map2) {
        Object object;
        String string;
        if (file.getName().equals("drawable") && context.isEnabled(ICON_LOCATION) && context.getProject().getMinSdk() >= 4) {
            for (File file2 : fileArray) {
                string = file2.getName();
                if (string.endsWith(".xml") || !LintUtils.endsWith((String)string, (String)".png") && !LintUtils.endsWith((String)string, (String)".jpg") && !LintUtils.endsWith((String)string, (String)".jpeg") && !LintUtils.endsWith((String)string, (String)".gif")) continue;
                context.report(ICON_LOCATION, Location.create((File)file2), String.format("Found bitmap drawable res/drawable/%1$s in densityless folder", file2.getName()), null);
            }
        }
        if (context.isEnabled(GIF_USAGE)) {
            for (File file2 : fileArray) {
                string = file2.getName();
                if (!LintUtils.endsWith((String)string, (String)".gif")) continue;
                context.report(GIF_USAGE, Location.create((File)file2), "Using the .gif format for bitmaps is discouraged", null);
            }
        }
        if (context.isEnabled(ICON_EXTENSION)) {
            for (File file2 : fileArray) {
                string = file2.getPath();
                if (!IconDetector.isDrawableFile(string) || LintUtils.endsWith((String)string, (String)".xml")) continue;
                IconDetector.checkExtension(context, file2);
            }
        }
        if (context.isEnabled(ICON_COLORS)) {
            for (File file2 : fileArray) {
                Dimension dimension;
                boolean bl;
                string = file2.getName();
                if (!IconDetector.isDrawableFile(string) || LintUtils.endsWith((String)string, (String)".xml") || LintUtils.endsWith((String)string, (String)".9.png") || !(bl = this.isActionBarIcon(context, (String)(object = IconDetector.getBaseName(string)), file2)) && !this.isNotificationIcon((String)object) || (dimension = this.checkColor(context, file2, bl)) == null || map == null) continue;
                map.put(file2, dimension);
            }
        }
        if (context.isEnabled(ICON_LAUNCHER_SHAPE)) {
            for (File file2 : fileArray) {
                string = file2.getName();
                if (!this.isLauncherIcon(IconDetector.getBaseName(string)) || LintUtils.endsWith((String)string, (String)".xml") || LintUtils.endsWith((String)string, (String)".9.png")) continue;
                this.checkLauncherShape(context, file2);
            }
        }
        if (context.isEnabled(ICON_EXPECTED_SIZE)) {
            this.checkExpectedSizes(context, file, fileArray);
        }
        if (map != null || map2 != null) {
            for (File file2 : fileArray) {
                string = file2.getName();
                if (!LintUtils.endsWith((String)string, (String)".png") && !LintUtils.endsWith((String)string, (String)".jpg") && !LintUtils.endsWith((String)string, (String)".jpeg")) continue;
                if (map != null && !LintUtils.endsWith((String)string, (String)".9.png") && !map.containsKey(file2)) {
                    object = IconDetector.getSize(file2);
                    map.put(file2, (Dimension)object);
                }
                if (map2 == null) continue;
                map2.put(file2, file2.length());
            }
        }
        this.mImageCache = null;
    }

    private void checkLauncherShape(Context context, File file) {
        try {
            BufferedImage bufferedImage = this.getImage(file);
            if (bufferedImage != null) {
                int n = bufferedImage.getHeight();
                for (int i = 0; i < n; ++i) {
                    int n2 = bufferedImage.getWidth();
                    for (int j = 0; j < n2; ++j) {
                        int n3 = bufferedImage.getRGB(j, i);
                        if ((n3 & 0xFF000000) != 0) continue;
                        return;
                    }
                }
                String string = "Launcher icons should not fill every pixel of their square region; see the design guide for details";
                context.report(ICON_LAUNCHER_SHAPE, Location.create((File)file), string, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Dimension checkColor(Context context, File file, boolean bl) {
        block13: {
            int n = Context.getFolderVersion((File)file);
            if (bl ? n != -1 && n < 11 || !IconDetector.isAndroid30(context, n) : n != -1 && n < 9 || !IconDetector.isAndroid23(context, n) && !IconDetector.isAndroid30(context, n)) {
                return null;
            }
            try {
                BufferedImage bufferedImage;
                block14: {
                    bufferedImage = this.getImage(file);
                    if (bufferedImage == null) break block13;
                    if (bl) {
                        int n2 = bufferedImage.getHeight();
                        for (int i = 0; i < n2; ++i) {
                            int n3 = bufferedImage.getWidth();
                            for (int j = 0; j < n3; ++j) {
                                int n4 = bufferedImage.getRGB(j, i);
                                if ((n4 & 0xFF000000) == 0) continue;
                                int n5 = (n4 & 0xFF0000) >>> 16;
                                int n6 = (n4 & 0xFF00) >>> 8;
                                int n7 = n4 & 0xFF;
                                if (n5 == n6 && n5 == n7) continue;
                                String string = "Action Bar icons should use a single gray color (#333333 for light themes (with 60%/30% opacity for enabled/disabled), and #FFFFFF with opacity 80%/30% for dark themes";
                                context.report(ICON_COLORS, Location.create((File)file), string, null);
                                break block14;
                            }
                        }
                    } else if (n >= 11 || IconDetector.isAndroid30(context, n)) {
                        int n8 = bufferedImage.getHeight();
                        for (int i = 0; i < n8; ++i) {
                            int n9 = bufferedImage.getWidth();
                            for (int j = 0; j < n9; ++j) {
                                int n10 = bufferedImage.getRGB(j, i);
                                if ((n10 & 0xFF000000) == 0 || n10 == -1) continue;
                                int n11 = (n10 & 0xFF0000) >>> 16;
                                int n12 = (n10 & 0xFF00) >>> 8;
                                int n13 = n10 & 0xFF;
                                if (n11 == n12 && n11 == n13 && (j < n9 - 1 && n10 != bufferedImage.getRGB(j + 1, i) || j > 0 && n10 != bufferedImage.getRGB(j - 1, i) || i < n8 - 1 && n10 != bufferedImage.getRGB(j, i + 1) || i > 0 && n10 != bufferedImage.getRGB(j, i - 1))) continue;
                                String string = "Notification icons must be entirely white";
                                context.report(ICON_COLORS, Location.create((File)file), string, null);
                                break block14;
                            }
                        }
                    } else {
                        int n14 = bufferedImage.getHeight();
                        for (int i = 0; i < n14; ++i) {
                            int n15 = bufferedImage.getWidth();
                            for (int j = 0; j < n15; ++j) {
                                int n16 = bufferedImage.getRGB(j, i);
                                if ((n16 & 0xFF000000) == 0) continue;
                                int n17 = (n16 & 0xFF0000) >>> 16;
                                int n18 = (n16 & 0xFF00) >>> 8;
                                int n19 = n16 & 0xFF;
                                if (n17 == n18 && n17 == n19) continue;
                                String string = "Notification icons should not use colors";
                                context.report(ICON_COLORS, Location.create((File)file), string, null);
                                break block14;
                            }
                        }
                    }
                }
                return new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkExtension(Context context, File file) {
        block14: {
            try {
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
                if (imageInputStream == null) break block14;
                try {
                    Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                    while (iterator.hasNext()) {
                        ImageReader imageReader = iterator.next();
                        try {
                            int n;
                            imageReader.setInput(imageInputStream);
                            String string = imageReader.getFormatName();
                            if (string == null || string.isEmpty()) continue;
                            String string2 = file.getPath();
                            String string3 = string2.substring((n = string2.lastIndexOf(46)) + 1).toLowerCase(Locale.US);
                            if (!string.equalsIgnoreCase(string3)) {
                                if (LintUtils.endsWith((String)string2, (String)".jpg") && string.equals("JPEG")) {
                                    return;
                                }
                                String string4 = String.format("Misleading file extension; named .%1$s but the file format is %2$s", string3, string);
                                Location location = Location.create((File)file);
                                context.report(ICON_EXTENSION, location, string4, null);
                            }
                            break;
                        }
                        finally {
                            imageReader.dispose();
                        }
                    }
                }
                finally {
                    if (imageInputStream != null) {
                        imageInputStream.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getBaseName(String string) {
        String string2 = string;
        int n = string2.indexOf(46);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private void checkExpectedSizes(Context context, File file, File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        String string = file.getName();
        int n = Context.getFolderVersion((File)fileArray[0]);
        for (File file2 : fileArray) {
            String string2 = file2.getName();
            String string3 = IconDetector.getBaseName(string2);
            if (this.isLauncherIcon(string3)) {
                IconDetector.checkSize(context, string, file2, 48, 48, true);
                continue;
            }
            if (this.isActionBarIcon(string3)) {
                IconDetector.checkSize(context, string, file2, 32, 32, true);
                continue;
            }
            if (string2.startsWith("ic_dialog_")) {
                IconDetector.checkSize(context, string, file2, 32, 32, true);
                continue;
            }
            if (string2.startsWith("ic_tab_")) {
                IconDetector.checkSize(context, string, file2, 32, 32, true);
                continue;
            }
            if (this.isNotificationIcon(string3)) {
                if (IconDetector.isAndroid30(context, n)) {
                    IconDetector.checkSize(context, string, file2, 24, 24, true);
                    continue;
                }
                if (IconDetector.isAndroid23(context, n)) {
                    IconDetector.checkSize(context, string, file2, 16, 25, false);
                    continue;
                }
                IconDetector.checkSize(context, string, file2, 25, 25, true);
                continue;
            }
            if (!string2.startsWith("ic_menu_")) continue;
            if (IconDetector.isAndroid30(context, n)) {
                IconDetector.checkSize(context, string, file2, 32, 32, true);
                continue;
            }
            if (IconDetector.isAndroid23(context, n)) {
                IconDetector.checkSize(context, string, file2, 48, 48, true);
                continue;
            }
            IconDetector.checkSize(context, string, file2, 48, 48, true);
        }
    }

    private static boolean isAndroid30(Context context, int n) {
        return n >= 11 || context.getMainProject().getMinSdk() >= 11;
    }

    private static boolean isAndroid23(Context context, int n) {
        if (IconDetector.isAndroid30(context, n)) {
            return false;
        }
        if (n == 9 || n == 10) {
            return true;
        }
        int n2 = context.getMainProject().getMinSdk();
        return n2 == 9 || n2 == 10;
    }

    private static float getMdpiScalingFactor(String string) {
        if (string.contains("-mdpi")) {
            return 1.0f;
        }
        if (string.contains("-hdpi")) {
            return 1.5f;
        }
        if (string.contains("-xhdpi")) {
            return 2.0f;
        }
        if (string.contains("-ldpi")) {
            return 0.75f;
        }
        return 0.0f;
    }

    private static void checkSize(Context context, String string, File file, int n, int n2, boolean bl) {
        int n3;
        int n4;
        String string2 = file.getName();
        if (!(LintUtils.endsWith((String)string2, (String)".png") && !LintUtils.endsWith((String)string2, (String)".9.png") || LintUtils.endsWith((String)string2, (String)".jpg") || LintUtils.endsWith((String)string2, (String)".jpeg"))) {
            return;
        }
        if (string.startsWith("drawable-mdpi")) {
            n4 = n;
            n3 = n2;
        } else if (string.startsWith("drawable-hdpi")) {
            n4 = Math.round((float)n * 3.0f / 2.0f);
            n3 = Math.round((float)n2 * 3.0f / 2.0f);
        } else if (string.startsWith("drawable-xhdpi")) {
            n4 = n * 2;
            n3 = n2 * 2;
        } else if (string.startsWith("drawable-ldpi")) {
            n4 = Math.round((float)n * 3.0f / 4.0f);
            n3 = Math.round((float)n2 * 3.0f / 4.0f);
        } else {
            return;
        }
        Dimension dimension = IconDetector.getSize(file);
        if (dimension != null) {
            if (bl && dimension.width != n4 || dimension.height != n3) {
                context.report(ICON_EXPECTED_SIZE, Location.create((File)file), String.format("Incorrect icon size for %1$s: expected %2$dx%3$d, but was %4$dx%5$d", string + File.separator + file.getName(), n4, n3, dimension.width, dimension.height), null);
            } else if (!bl && dimension.width > n4 || dimension.height > n3) {
                context.report(ICON_EXPECTED_SIZE, Location.create((File)file), String.format("Incorrect icon size for %1$s: icon size should be at most %2$dx%3$d, but was %4$dx%5$d", string + File.separator + file.getName(), n4, n3, dimension.width, dimension.height), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static Dimension getSize(File file) {
        try {
            Object object;
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            if (imageInputStream != null) {
                try {
                    object = ImageIO.getImageReaders(imageInputStream);
                    if (object.hasNext()) {
                        ImageReader imageReader = (ImageReader)object.next();
                        try {
                            imageReader.setInput(imageInputStream);
                            Dimension dimension = new Dimension(imageReader.getWidth(0), imageReader.getHeight(0));
                            imageReader.dispose();
                            return dimension;
                        }
                        catch (Throwable throwable) {
                            imageReader.dispose();
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (imageInputStream != null) {
                        imageInputStream.close();
                    }
                }
            }
            if ((object = ImageIO.read(file)) != null) {
                return new Dimension(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean isLauncherIcon(String string) {
        assert (string.indexOf(46) == -1);
        if (string.startsWith("ic_launcher")) {
            return true;
        }
        return this.mLauncherIcons != null && this.mLauncherIcons.contains(string);
    }

    private boolean isNotificationIcon(String string) {
        assert (string.indexOf(46) == -1);
        if (string.startsWith("ic_stat_")) {
            return true;
        }
        return this.mNotificationIcons != null && this.mNotificationIcons.contains(string);
    }

    private boolean isActionBarIcon(String string) {
        assert (string.indexOf(46) == -1);
        if (string.startsWith("ic_action_")) {
            return true;
        }
        return this.mActionBarIcons != null && this.mActionBarIcons.contains(string);
    }

    private boolean isActionBarIcon(Context context, String string, File file) {
        if (this.isActionBarIcon(string)) {
            return true;
        }
        return file != null && string.startsWith("ic_menu_") && IconDetector.isAndroid30(context, Context.getFolderVersion((File)file));
    }

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return file.getName().equals("AndroidManifest.xml");
    }

    public boolean appliesTo(@NonNull ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.MENU;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("application", "activity", "service", "provider", "receiver", "item");
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        String string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "icon");
        if (string != null && string.startsWith("@drawable/")) {
            string = string.substring("@drawable/".length());
            String string2 = element.getTagName();
            if (string2.equals("item")) {
                if (this.mMenuToIcons == null) {
                    this.mMenuToIcons = ArrayListMultimap.create();
                }
                String string3 = IconDetector.getBaseName(xmlContext.file.getName());
                this.mMenuToIcons.put((Object)string3, (Object)string);
            } else {
                if (this.mLauncherIcons == null) {
                    this.mLauncherIcons = Sets.newHashSet();
                }
                this.mLauncherIcons.add(string);
            }
        }
    }

    @Nullable
    public AstVisitor createJavaVisitor(@NonNull JavaContext javaContext) {
        return new NotificationFinder();
    }

    @Nullable
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        ArrayList<Class<? extends Node>> arrayList = new ArrayList<Class<? extends Node>>(3);
        arrayList.add(MethodDeclaration.class);
        arrayList.add(ConstructorInvocation.class);
        return arrayList;
    }

    private boolean handleSelect(Select select) {
        if (select.toString().startsWith("R.drawable.")) {
            String string = select.astIdentifier().astValue();
            if (this.mNotificationIcons == null) {
                this.mNotificationIcons = Sets.newHashSet();
            }
            this.mNotificationIcons.add(string);
            return true;
        }
        return false;
    }

    static {
        String[] stringArray;
        boolean bl = false;
        String string = System.getenv("ANDROID_LINT_INCLUDE_LDPI");
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        INCLUDE_LDPI = bl;
        DENSITY_PATTERN = Pattern.compile("^drawable-(nodpi|xhdpi|hdpi|mdpi" + (INCLUDE_LDPI ? "|ldpi" : "") + ")$");
        if (INCLUDE_LDPI) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "drawable-ldpi";
            stringArray2[1] = "drawable-mdpi";
            stringArray2[2] = "drawable-hdpi";
            stringArray = stringArray2;
            stringArray2[3] = "drawable-xhdpi";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "drawable-mdpi";
            stringArray3[1] = "drawable-hdpi";
            stringArray = stringArray3;
            stringArray3[2] = "drawable-xhdpi";
        }
        REQUIRED_DENSITIES = stringArray;
        DENSITY_QUALIFIERS = new String[]{"-ldpi", "-mdpi", "-hdpi", "-xhdpi"};
        ICON_TYPE_SCOPE = EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE, Scope.MANIFEST);
        ICON_EXPECTED_SIZE = Issue.create((String)"IconExpectedSize", (String)"Ensures that launcher icons, notification icons etc have the correct size", (String)"There are predefined sizes (for each density) for launcher icons. You should follow these conventions to make sure your icons fit in with the overall look of the platform.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, IconDetector.class, ICON_TYPE_SCOPE).setEnabledByDefault(false).setMoreInfo("http://developer.android.com/design/style/iconography.html");
        ICON_DIP_SIZE = Issue.create((String)"IconDipSize", (String)"Ensures that icons across densities provide roughly the same density-independent size", (String)"Checks the all icons which are provided in multiple densities, all compute to roughly the same density-independent pixel (`dip`) size. This catches errors where images are either placed in the wrong folder, or icons are changed to new sizes but some folders are forgotten.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, IconDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE);
        ICON_LOCATION = Issue.create((String)"IconLocation", (String)"Ensures that images are not defined in the density-independent drawable folder", (String)"The res/drawable folder is intended for density-independent graphics such as shapes defined in XML. For bitmaps, move it to `drawable-mdpi` and consider providing higher and lower resolution versions in `drawable-ldpi`, `drawable-hdpi` and `drawable-xhdpi`. If the icon *really* is density independent (for example a solid color) you can place it in `drawable-nodpi`.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, IconDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE).setMoreInfo("http://developer.android.com/guide/practices/screens_support.html");
        ICON_DENSITIES = Issue.create((String)"IconDensities", (String)"Ensures that icons provide custom versions for all supported densities", (String)"Icons will look best if a custom version is provided for each of the major screen density classes (low, medium, high, extra high). This lint check identifies icons which do not have complete coverage across the densities.\n\nLow density is not really used much anymore, so this check ignores the ldpi density. To force lint to include it, set the environment variable `ANDROID_LINT_INCLUDE_LDPI=true`. For more information on current density usage, see http://developer.android.com/resources/dashboard/screens.html", (Category)Category.ICONS, (int)4, (Severity)Severity.WARNING, IconDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE).setMoreInfo("http://developer.android.com/guide/practices/screens_support.html");
        ICON_MISSING_FOLDER = Issue.create((String)"IconMissingDensityFolder", (String)"Ensures that all the density folders are present", (String)"Icons will look best if a custom version is provided for each of the major screen density classes (low, medium, high, extra high). This lint check identifies folders which are missing, such as `drawable-hdpi`.\nLow density is not really used much anymore, so this check ignores the ldpi density. To force lint to include it, set the environment variable `ANDROID_LINT_INCLUDE_LDPI=true`. For more information on current density usage, see http://developer.android.com/resources/dashboard/screens.html", (Category)Category.ICONS, (int)3, (Severity)Severity.WARNING, IconDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE).setMoreInfo("http://developer.android.com/guide/practices/screens_support.html");
        GIF_USAGE = Issue.create((String)"GifUsage", (String)"Checks for images using the GIF file format which is discouraged", (String)"The `.gif` file format is discouraged. Consider using `.png` (preferred) or `.jpg` (acceptable) instead.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, IconDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE).setMoreInfo("http://developer.android.com/guide/topics/resources/drawable-resource.html#Bitmap");
        DUPLICATES_NAMES = Issue.create((String)"IconDuplicates", (String)"Finds duplicated icons under different names", (String)"If an icon is repeated under different names, you can consolidate and just use one of the icons and delete the others to make your application smaller. However, duplicated icons usually are not intentional and can sometimes point to icons that were accidentally overwritten or accidentally not updated.", (Category)Category.ICONS, (int)3, (Severity)Severity.WARNING, IconDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE);
        DUPLICATES_CONFIGURATIONS = Issue.create((String)"IconDuplicatesConfig", (String)"Finds icons that have identical bitmaps across various configuration parameters", (String)"If an icon is provided under different configuration parameters such as `drawable-hdpi` or `-v11`, they should typically be different. This detector catches cases where the same icon is provided in different configuration folder which is usually not intentional.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, IconDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE);
        ICON_NODPI = Issue.create((String)"IconNoDpi", (String)"Finds icons that appear in both a -nodpi folder and a dpi folder", (String)"Bitmaps that appear in `drawable-nodpi` folders will not be scaled by the Android framework. If a drawable resource of the same name appears *both* in a `-nodpi` folder as well as a dpi folder such as `drawable-hdpi`, then the behavior is ambiguous and probably not intentional. Delete one or the other, or use different names for the icons.", (Category)Category.ICONS, (int)7, (Severity)Severity.WARNING, IconDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE);
        ICON_XML_AND_PNG = Issue.create((String)"IconXmlAndPng", (String)"Finds icons that appear both as a drawable .xml file and as bitmaps", (String)"If a drawable resource appears as an .xml file in the drawable/ folder, it's usually not intentional for it to also appear as a bitmap using the same name; generally you expect the drawable XML file to define states and each state has a corresponding drawable bitmap.", (Category)Category.ICONS, (int)7, (Severity)Severity.WARNING, IconDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE);
        ICON_EXTENSION = Issue.create((String)"IconExtension", (String)"Checks that the icon file extension matches the actual image format in the file", (String)"Ensures that icons have the correct file extension (e.g. a .png file is really in the PNG format and not for example a GIF file named .png.)", (Category)Category.ICONS, (int)3, (Severity)Severity.WARNING, IconDetector.class, (EnumSet)Scope.ALL_RESOURCES_SCOPE);
        ICON_COLORS = Issue.create((String)"IconColors", (String)"Checks that icons follow the recommended visual style", (String)"Notification icons and Action Bar icons should only white and shades of gray. See the Android Design Guide for more details. Note that the way Lint decides whether an icon is an action bar icon or a notification icon is based on the filename prefix: `ic_menu_` for action bar icons, `ic_stat_` for notification icons etc. These correspond to the naming conventions documented in http://developer.android.com/guide/practices/ui_guidelines/icon_design.html", (Category)Category.ICONS, (int)6, (Severity)Severity.WARNING, IconDetector.class, ICON_TYPE_SCOPE).setMoreInfo("http://developer.android.com/design/style/iconography.html");
        ICON_LAUNCHER_SHAPE = Issue.create((String)"IconLauncherShape", (String)"Checks that launcher icons follow the recommended visual style", (String)"According to the Android Design Guide (http://developer.android.com/design/style/iconography.html) your launcher icons should \"use a distinct silhouette\", a \"three-dimensional, front view, with a slight perspective as if viewed from above, so that users perceive some depth.\"\n\nThe unique silhouette implies that your launcher icon should not be a filled square.", (Category)Category.ICONS, (int)6, (Severity)Severity.WARNING, IconDetector.class, ICON_TYPE_SCOPE).setMoreInfo("http://developer.android.com/design/style/iconography.html");
    }

    private final class MenuFinder
    extends ForwardingAstVisitor {
        private MenuFinder() {
        }

        public boolean visitSelect(Select select) {
            String string;
            VariableReference variableReference;
            Select select2;
            if (select.astOperand() instanceof Select && (select2 = (Select)select.astOperand()).astOperand() instanceof VariableReference && (variableReference = (VariableReference)select2.astOperand()).astIdentifier().astValue().equals("R") && (string = select2.astIdentifier().astValue()).equals("menu")) {
                Collection collection;
                String string2 = select.astIdentifier().astValue();
                if (IconDetector.this.mMenuToIcons != null && (collection = IconDetector.this.mMenuToIcons.get((Object)string2)) != null) {
                    if (IconDetector.this.mActionBarIcons == null) {
                        IconDetector.this.mActionBarIcons = Sets.newHashSet();
                    }
                    IconDetector.this.mActionBarIcons.addAll(collection);
                }
            }
            return super.visitSelect(select);
        }
    }

    private final class SetIconFinder
    extends ForwardingAstVisitor {
        private SetIconFinder() {
        }

        public boolean visitMethodInvocation(MethodInvocation methodInvocation) {
            StrictListAccessor strictListAccessor;
            if (IconDetector.SET_SMALL_ICON.equals(methodInvocation.astName().astValue()) && (strictListAccessor = methodInvocation.astArguments()).size() == 1 && strictListAccessor.first() instanceof Select) {
                IconDetector.this.handleSelect((Select)strictListAccessor.first());
            }
            return super.visitMethodInvocation(methodInvocation);
        }
    }

    private final class NotificationFinder
    extends ForwardingAstVisitor {
        private NotificationFinder() {
        }

        public boolean visitMethodDeclaration(MethodDeclaration methodDeclaration) {
            if (IconDetector.ON_CREATE_OPTIONS_MENU.equals(methodDeclaration.astMethodName().astValue())) {
                methodDeclaration.accept((AstVisitor)new MenuFinder());
            }
            return super.visitMethodDeclaration(methodDeclaration);
        }

        public boolean visitConstructorInvocation(ConstructorInvocation constructorInvocation) {
            TypeReference typeReference = constructorInvocation.astTypeReference();
            StrictListAccessor strictListAccessor = typeReference.astParts();
            String string = ((TypeReferencePart)strictListAccessor.last()).astIdentifier().astValue();
            if (IconDetector.NOTIFICATION_CLASS.equals(string)) {
                StrictListAccessor strictListAccessor2 = constructorInvocation.astArguments();
                if (strictListAccessor2.size() == 3) {
                    String string2;
                    if (strictListAccessor2.first() instanceof Select && IconDetector.this.handleSelect((Select)strictListAccessor2.first())) {
                        return super.visitConstructorInvocation(constructorInvocation);
                    }
                    Node node = StringFormatDetector.getParentMethod((Node)constructorInvocation);
                    if (node != null && (string2 = StringFormatDetector.getResourceForFirstArg(node, (Node)constructorInvocation)) != null) {
                        if (IconDetector.this.mNotificationIcons == null) {
                            IconDetector.this.mNotificationIcons = Sets.newHashSet();
                        }
                        IconDetector.this.mNotificationIcons.add(string2);
                    }
                }
            } else if (IconDetector.BUILDER_CLASS.equals(string)) {
                Object object;
                boolean bl = false;
                if (strictListAccessor.size() == 1) {
                    bl = true;
                } else if (strictListAccessor.size() == 2 && (IconDetector.NOTIFICATION_CLASS.equals(object = ((TypeReferencePart)strictListAccessor.first()).astIdentifier().astValue()) || IconDetector.NOTIFICATION_COMPAT_CLASS.equals(object))) {
                    bl = true;
                }
                if (bl && (object = StringFormatDetector.getParentMethod((Node)constructorInvocation)) != null) {
                    SetIconFinder setIconFinder = new SetIconFinder();
                    object.accept((AstVisitor)setIconFinder);
                }
            }
            return super.visitConstructorInvocation(constructorInvocation);
        }
    }
}

