/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"FloatMath", (String)"Suggests replacing android.util.FloatMath calls with java.lang.Math", (String)"In older versions of Android, using android.util.FloatMath was recommended for performance reasons when operating on floats. However, on modern hardware doubles are just as fast as float (though they take more memory), and in recent versions of Android, FloatMath is actually slower than using java.lang.Math due to the way the JIT optimizes java.lang.Math. Therefore, you should use Math instead of FloatMath if you are only targeting Froyo and above.", (Category)Category.PERFORMANCE, (int)3, (Severity)Severity.WARNING, MathDetector.class, (EnumSet)Scope.CLASS_FILE_SCOPE).setMoreInfo("http://developer.android.com/guide/practices/design/performance.html#avoidfloat");

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Nullable
    public List<String> getApplicableCallNames() {
        return Arrays.asList("sin", "cos", "ceil", "sqrt", "floor");
    }

    public void checkCall(@NonNull ClassContext classContext, @NonNull ClassNode classNode, @NonNull MethodNode methodNode, @NonNull MethodInsnNode methodInsnNode) {
        String string = methodInsnNode.owner;
        if (string.equals("android/util/FloatMath") && classContext.getProject().getMinSdk() >= 8) {
            String string2 = String.format("Use java.lang.Math#%1$s instead of android.util.FloatMath#%1$s() since it is faster as of API 8", methodInsnNode.name);
            classContext.report(ISSUE, methodNode, (AbstractInsnNode)methodInsnNode, classContext.getLocation((AbstractInsnNode)methodInsnNode), string2, null);
        }
    }
}

