/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceDetector
extends LayoutDetector {
    public static final Issue TYPO = Issue.create((String)"NamespaceTypo", (String)"Looks for misspellings in namespace declarations", (String)"Accidental misspellings in namespace declarations can lead to some very obscure error messages. This check looks for potential misspellings to help track these down.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.WARNING, NamespaceDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);
    public static final Issue UNUSED = Issue.create((String)"UnusedNamespace", (String)"Finds unused namespaces in XML documents", (String)"Unused namespace declarations take up space and require processing that is not necessary", (Category)Category.PERFORMANCE, (int)1, (Severity)Severity.WARNING, NamespaceDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);
    public static final Issue CUSTOMVIEW = Issue.create((String)"LibraryCustomView", (String)"Flags custom attributes in libraries, which must use the res-auto-namespace instead", (String)"When using a custom view with custom attributes in a library project, the layout must use the special namespace http://schemas.android.com/apk/res-auto instead of a URI which includes the library project's own package. This will be used to automatically adjust the namespace of the attributes when the library resources are merged into the application project.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, NamespaceDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);
    private static final String XMLNS_ANDROID = "xmlns:android";
    private static final String XMLNS_A = "xmlns:a";
    private Map<String, Attr> mUnusedNamespaces;
    private boolean mCheckUnused;

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void visitDocument(@NonNull XmlContext xmlContext, @NonNull Document document) {
        Attr attr;
        String string;
        int n;
        boolean bl = false;
        Element element = document.getDocumentElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        for (n = 0; n < n2; ++n) {
            Node object = namedNodeMap.item(n);
            if (!object.getNodeName().startsWith("xmlns:") || (string = object.getNodeValue()).equals("http://schemas.android.com/apk/res/android")) continue;
            attr = (Attr)object;
            if (string.startsWith("http://schemas.android.com/apk/res/")) {
                bl = true;
                if (this.mUnusedNamespaces == null) {
                    this.mUnusedNamespaces = new HashMap<String, Attr>();
                }
                this.mUnusedNamespaces.put(object.getNodeName().substring("xmlns:".length()), attr);
            } else if (!string.startsWith("http://")) {
                xmlContext.report(TYPO, (Node)attr, xmlContext.getLocation((Node)attr), "Suspicious namespace: should start with http://", null);
                continue;
            }
            String string2 = attr.getName();
            if (!string2.equals(XMLNS_ANDROID) && !string2.equals(XMLNS_A)) {
                String string3;
                int n3 = string.indexOf("/res/");
                if (n3 == -1 || string.length() + 5 <= "http://schemas.android.com/apk/res/".length() || (string3 = string.substring(0, n3 + 5)).equals("http://schemas.android.com/apk/res/") || LintUtils.editDistance((String)"http://schemas.android.com/apk/res/", (String)string3) > 3) continue;
                String string4 = "http://schemas.android.com/apk/res/" + string.substring(n3 + 5);
                xmlContext.report(TYPO, (Node)attr, xmlContext.getLocation((Node)attr), String.format("Possible typo in URL: was \"%1$s\", should probably be \"%2$s\"", string, string4), null);
                continue;
            }
            if (!xmlContext.isEnabled(TYPO) || string2.equals(XMLNS_A) && LintUtils.editDistance((String)"http://schemas.android.com/apk/res/android", (String)string) > 4) continue;
            if (string.equalsIgnoreCase("http://schemas.android.com/apk/res/android")) {
                xmlContext.report(TYPO, (Node)attr, xmlContext.getLocation((Node)attr), String.format("URI is case sensitive: was \"%1$s\", expected \"%2$s\"", string, "http://schemas.android.com/apk/res/android"), null);
                continue;
            }
            xmlContext.report(TYPO, (Node)attr, xmlContext.getLocation((Node)attr), String.format("Unexpected namespace URI bound to the \"android\" prefix, was %1$s, expected %2$s", string, "http://schemas.android.com/apk/res/android"), null);
        }
        if (bl) {
            n = xmlContext.isEnabled(CUSTOMVIEW) && xmlContext.getProject().isLibrary() ? 1 : 0;
            this.mCheckUnused = xmlContext.isEnabled(UNUSED);
            if (n != 0) {
                NamespaceDetector.checkCustomNamespace(xmlContext, element);
            }
            this.checkElement(xmlContext, element);
            if (this.mCheckUnused && !this.mUnusedNamespaces.isEmpty()) {
                for (Map.Entry<String, Attr> entry : this.mUnusedNamespaces.entrySet()) {
                    string = entry.getKey();
                    attr = entry.getValue();
                    xmlContext.report(UNUSED, (Node)attr, xmlContext.getLocation((Node)attr), String.format("Unused namespace %1$s", string), null);
                }
            }
        }
    }

    private static void checkCustomNamespace(XmlContext xmlContext, Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!attr.getName().startsWith("xmlns:") || (string = attr.getValue()) == null || string.isEmpty() || !string.startsWith("http://schemas.android.com/apk/res/") || string.equals("http://schemas.android.com/apk/res/android")) continue;
            xmlContext.report(CUSTOMVIEW, (Node)attr, xmlContext.getLocation((Node)attr), "When using a custom namespace attribute in a library project, use the namespace \"http://schemas.android.com/apk/res-auto\" instead.", null);
        }
    }

    private void checkElement(XmlContext xmlContext, Node node) {
        if (node.getNodeType() == 1) {
            int n;
            int n2;
            Object object;
            if (this.mCheckUnused) {
                object = node.getAttributes();
                n2 = object.getLength();
                for (n = 0; n < n2; ++n) {
                    Attr attr = (Attr)object.item(n);
                    String string = attr.getPrefix();
                    if (string == null) continue;
                    this.mUnusedNamespaces.remove(string);
                }
            }
            object = node.getChildNodes();
            n2 = object.getLength();
            for (n = 0; n < n2; ++n) {
                this.checkElement(xmlContext, object.item(n));
            }
        }
    }
}

