/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class OverrideDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"DalvikOverride", (String)"Looks for methods treated as overrides by Dalvik", (String)"The Android virtual machine will treat a package private method in one class as overriding a package private method in its super class, even if they are in separate packages. This may be surprising, but for compatibility reasons the behavior has not been changed (yet).\n\nIf you really did intend for this method to override the other, make the method `protected` instead.\n\nIf you did *not* intend the override, consider making the method private, or changing its name or signature.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.ERROR, OverrideDetector.class, EnumSet.of(Scope.ALL_CLASS_FILES));
    private final Map<String, Set<String>> mPackagePrivateMethods = Maps.newHashMap();
    private Map<String, Map<String, String>> mErrors;
    private Map<String, Map<String, Location>> mLocations;

    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    public void afterCheckProject(@NonNull Context context) {
        if (context.getPhase() == 1) {
            Set<String> set = this.mPackagePrivateMethods.keySet();
            LintDriver lintDriver = context.getDriver();
            for (String string : set) {
                Set<String> set2 = this.mPackagePrivateMethods.get(string);
                String string2 = lintDriver.getSuperClass(string);
                int n = string.lastIndexOf(47);
                while (string2 != null) {
                    Sets.SetView setView;
                    Set<String> set3;
                    int n2 = string2.lastIndexOf(47);
                    if (!(n != -1 && n2 == n && string.regionMatches(0, string2, 0, n) || (set3 = this.mPackagePrivateMethods.get(string2)) == null || (setView = Sets.intersection(set2, set3)).isEmpty())) {
                        if (this.mLocations == null) {
                            this.mLocations = Maps.newHashMap();
                        }
                        if (this.mErrors == null) {
                            this.mErrors = Maps.newHashMap();
                        }
                        for (String string3 : setView) {
                            Map<Object, Object> map = this.mLocations.get(string);
                            if (map == null) {
                                map = Maps.newHashMap();
                                this.mLocations.put(string, (Map<String, Location>)map);
                            }
                            map.put(string3, null);
                            map = this.mLocations.get(string2);
                            if (map == null) {
                                map = Maps.newHashMap();
                                this.mLocations.put(string2, map);
                            }
                            map.put(string3, null);
                            HashMap hashMap = this.mErrors.get(string);
                            if (hashMap == null) {
                                hashMap = Maps.newHashMap();
                                this.mErrors.put(string, hashMap);
                            }
                            hashMap.put(string3, string2);
                        }
                    }
                    string2 = lintDriver.getSuperClass(string2);
                }
            }
            if (this.mErrors != null) {
                context.requestRepeat((Detector)this, ISSUE.getScope());
            }
        } else {
            assert (context.getPhase() == 2);
            for (Map.Entry<String, Map<String, String>> entry : this.mErrors.entrySet()) {
                String string = entry.getKey();
                Map<String, String> map = entry.getValue();
                for (Map.Entry<String, String> entry2 : map.entrySet()) {
                    int n;
                    String string4;
                    Location location;
                    String string5 = entry2.getKey();
                    String string6 = entry2.getValue();
                    Map<String, Location> map2 = this.mLocations.get(string);
                    if (map2 == null || (location = map2.get(string5)) == null) continue;
                    Map<String, Location> map3 = this.mLocations.get(string6);
                    if (map3 != null && (string4 = map3.get(string5)) != null) {
                        location.setSecondary((Location)string4);
                        string4.setMessage("This method is treated as overridden");
                    }
                    if ((n = (string4 = string5).indexOf(40)) != -1) {
                        string4 = string4.substring(0, n);
                    }
                    String string7 = String.format("This package private method may be unintentionally overriding %1$s in %2$s", string4, ClassContext.getFqcn((String)string6));
                    context.report(ISSUE, location, string7, null);
                }
            }
        }
    }

    public void checkClass(@NonNull ClassContext classContext, @NonNull ClassNode classNode) {
        if (!classContext.getProject().getReportIssues()) {
            return;
        }
        List list = classNode.methods;
        if (classContext.getPhase() == 1) {
            for (Object e : list) {
                MethodNode methodNode = (MethodNode)e;
                int n = methodNode.access;
                if ((n & 0xF) != 0 || "<init>".equals(methodNode.name)) continue;
                String string = classNode.name;
                HashSet hashSet = this.mPackagePrivateMethods.get(string);
                if (hashSet == null) {
                    hashSet = Sets.newHashSetWithExpectedSize((int)list.size());
                    this.mPackagePrivateMethods.put(string, hashSet);
                }
                hashSet.add(methodNode.name + methodNode.desc);
            }
        } else {
            assert (classContext.getPhase() == 2);
            Map<String, Location> map = this.mLocations.get(classNode.name);
            if (map == null) {
                return;
            }
            for (Object e : list) {
                Object object;
                MethodNode methodNode = (MethodNode)e;
                String string = methodNode.name + methodNode.desc;
                if (!map.containsKey(string)) continue;
                if (classContext.getDriver().isSuppressed(ISSUE, classNode, methodNode, null)) {
                    object = this.mErrors.get(classNode.name);
                    if (object == null) continue;
                    object.remove(string);
                    continue;
                }
                object = classContext.getLocation(methodNode, classNode);
                map.put(string, (Location)object);
                String string2 = ClassContext.createSignature((String)classNode.name, (String)methodNode.name, (String)methodNode.desc);
                object.setClientData((Object)string2);
            }
        }
    }
}

