/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivateResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create((String)"PrivateResource", (String)"Looks for references to private resources", (String)"Private resources should not be referenced; the may not be present everywhere, and even where they are they may disappear without notice.\n\nTo fix this, copy the resource into your own project. You can find the platform resources under `$ANDROID_SK/platforms/android-$VERSION/data/res/.`", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.FATAL, PrivateResourceDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE);

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    public void visitAttribute(@NonNull XmlContext xmlContext, @NonNull Attr attr) {
        String string = attr.getNodeValue();
        if (string.startsWith("@*android:")) {
            xmlContext.report(ISSUE, (Node)attr, xmlContext.getLocation((Node)attr), "Illegal resource reference: @*android resources are private and not always present", null);
        }
    }
}

