/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.VariableReference;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredAttributeDetector
extends LayoutDetector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"RequiredSize", (String)"Ensures that the layout_width and layout_height are specified for all views", (String)"All views must specify an explicit layout_width and layout_height attribute. There is a runtime check for this, so if you fail to specify a size, an exception is thrown at runtime.\n\nIt's possible to specify these widths via styles as well. GridLayout, as a special case, does not require you to specify a size.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.ERROR, RequiredAttributeDetector.class, EnumSet.of(Scope.JAVA_FILE, Scope.ALL_RESOURCE_FILES));
    @Nullable
    private Map<String, String> mStyleParents;
    @Nullable
    private Set<String> mWidthStyles;
    @Nullable
    private Set<String> mHeightStyles;
    @Nullable
    private Set<String> mIncludedWidths;
    @Nullable
    private Set<String> mIncludedHeights;
    @Nullable
    private Set<String> mNotIncludedWidths;
    @Nullable
    private Set<String> mNotIncludedHeights;
    private boolean mSetWidthInTheme;
    private boolean mSetHeightInTheme;

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public boolean appliesTo(@NonNull ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.LAYOUT || resourceFolderType == ResourceFolderType.VALUES;
    }

    public void afterCheckProject(@NonNull Context context) {
        if (context.getPhase() == 1) {
            this.checkSizeSetInTheme();
            context.requestRepeat((Detector)this, Scope.RESOURCE_FILE_SCOPE);
        }
    }

    private boolean isWidthStyle(String string) {
        return this.isSizeStyle(string, this.mWidthStyles);
    }

    private boolean isHeightStyle(String string) {
        return this.isSizeStyle(string, this.mHeightStyles);
    }

    private boolean isSizeStyle(String string, Set<String> set) {
        if (RequiredAttributeDetector.isFrameworkSizeStyle(string)) {
            return true;
        }
        if (set == null) {
            return false;
        }
        return this.isSizeStyle(RequiredAttributeDetector.stripStylePrefix(string), set, 0);
    }

    private static boolean isFrameworkSizeStyle(String string) {
        if (string.equals("?android:attr/listSeparatorTextViewStyle") || string.equals("?android/listSeparatorTextViewStyle")) {
            return true;
        }
        return string.startsWith("?android:attr/quickContactBadgeStyle");
    }

    private boolean isSizeStyle(@NonNull String string, @NonNull Set<String> set, int n) {
        String string2;
        if (n == 30) {
            return false;
        }
        assert (!string.startsWith("@style/") && !string.startsWith("@android:style/"));
        if (set.contains(string)) {
            return true;
        }
        if (this.mStyleParents != null && (string2 = this.mStyleParents.get(string)) != null && this.isSizeStyle(string2 = RequiredAttributeDetector.stripStylePrefix(string2), set, n + 1)) {
            return true;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            return this.isSizeStyle(string.substring(0, n2), set, n + 1);
        }
        return false;
    }

    private void checkSizeSetInTheme() {
        if (this.mStyleParents == null) {
            return;
        }
        HashMap hashMap = Maps.newHashMap();
        for (String string : this.mStyleParents.keySet()) {
            if (!this.isTheme(RequiredAttributeDetector.stripStylePrefix(string), hashMap, 0)) continue;
            this.mSetWidthInTheme = true;
            this.mSetHeightInTheme = true;
            break;
        }
    }

    private boolean isTheme(String string, Map<String, Boolean> map, int n) {
        String string2;
        if (n == 30) {
            return false;
        }
        assert (!string.startsWith("@style/") && !string.startsWith("@android:style/"));
        Boolean bl = map.get(string);
        if (bl != null) {
            return bl;
        }
        if (string.contains("Theme")) {
            map.put(string, true);
            return true;
        }
        if (this.mStyleParents != null && (string2 = this.mStyleParents.get(string)) != null && this.isTheme(string2 = RequiredAttributeDetector.stripStylePrefix(string2), map, n + 1)) {
            map.put(string, true);
            return true;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            String string3 = string.substring(0, n2);
            boolean bl2 = this.isTheme(string3, map, n + 1);
            map.put(string, bl2);
            return bl2;
        }
        return false;
    }

    private static boolean hasLayoutVariations(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return false;
        }
        File file3 = file.getParentFile();
        if (file3 == null) {
            return false;
        }
        String string = file.getName();
        File[] fileArray = file3.listFiles();
        if (fileArray == null) {
            return false;
        }
        for (File file4 : fileArray) {
            File file5;
            if (!file4.getName().startsWith("layout") || file4.equals(file2) || !(file5 = new File(file4, string)).exists()) continue;
            return true;
        }
        return false;
    }

    private static String stripStylePrefix(@NonNull String string) {
        if (string.startsWith("@style/")) {
            string = string.substring("@style/".length());
        } else if (string.startsWith("@android:style/")) {
            string = string.substring("@android:style/".length());
        }
        return string;
    }

    private static boolean isRootElement(@NonNull org.w3c.dom.Node node) {
        return node == node.getOwnerDocument().getDocumentElement();
    }

    public Collection<String> getApplicableElements() {
        return ALL;
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        ResourceFolderType resourceFolderType = xmlContext.getResourceFolderType();
        int n = xmlContext.getPhase();
        if (n == 1 && resourceFolderType == ResourceFolderType.VALUES) {
            String string = element.getTagName();
            if ("style".equals(string)) {
                String string2;
                String string3 = element.getAttribute("parent");
                if (string3 != null && !string3.isEmpty() && (string2 = element.getAttribute("name")) != null && !string2.isEmpty()) {
                    if (this.mStyleParents == null) {
                        this.mStyleParents = Maps.newHashMap();
                    }
                    this.mStyleParents.put(string2, string3);
                }
            } else if ("item".equals(string) && "style".equals(element.getParentNode().getNodeName())) {
                String string4;
                String string5 = element.getAttribute("name");
                if (string5.endsWith("layout_width") && string5.equals("android:layout_width")) {
                    if (this.mWidthStyles == null) {
                        this.mWidthStyles = Sets.newHashSet();
                    }
                    string4 = ((Element)element.getParentNode()).getAttribute("name");
                    this.mWidthStyles.add(string4);
                }
                if (string5.endsWith("layout_height") && string5.equals("android:layout_height")) {
                    if (this.mHeightStyles == null) {
                        this.mHeightStyles = Sets.newHashSet();
                    }
                    string4 = ((Element)element.getParentNode()).getAttribute("name");
                    this.mHeightStyles.add(string4);
                }
            }
        } else if (resourceFolderType == ResourceFolderType.LAYOUT) {
            if (n == 1) {
                String string;
                if (element.getTagName().equals("include") && (string = element.getAttribute("layout")) != null && !string.isEmpty()) {
                    this.recordIncludeWidth(string, element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_width"));
                    this.recordIncludeHeight(string, element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_height"));
                }
            } else {
                String string;
                String string6;
                assert (n == 2);
                boolean bl = element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_width");
                boolean bl2 = element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_height");
                if (this.mSetWidthInTheme) {
                    bl = true;
                }
                if (this.mSetHeightInTheme) {
                    bl2 = true;
                }
                if (bl && bl2) {
                    return;
                }
                String string7 = element.getTagName();
                if ("merge".equals(string7) || "include".equals(string7) || "requestFocus".equals(string7)) {
                    return;
                }
                String string8 = string6 = element.getParentNode() != null ? element.getParentNode().getNodeName() : "";
                if ("TableLayout".equals(string6) || "TableRow".equals(string6) || "GridLayout".equals(string6) || "android.support.v7.widget.GridLayout".equals(string6)) {
                    return;
                }
                if (!xmlContext.getProject().getReportIssues()) {
                    return;
                }
                boolean bl3 = true;
                boolean bl4 = RequiredAttributeDetector.isRootElement(element);
                if (bl4 || RequiredAttributeDetector.isRootElement(element.getParentNode()) && "merge".equals(string6)) {
                    string = "@layout/" + LintUtils.getLayoutName((File)xmlContext.file);
                    if (!bl && this.mIncludedWidths != null) {
                        bl = this.mIncludedWidths.contains(string);
                        if (this.mNotIncludedWidths != null && this.mNotIncludedWidths.contains(string)) {
                            bl = false;
                            boolean bl5 = bl3 = !RequiredAttributeDetector.hasLayoutVariations(xmlContext.file);
                        }
                    }
                    if (!bl2 && this.mIncludedHeights != null) {
                        bl2 = this.mIncludedHeights.contains(string);
                        if (this.mNotIncludedHeights != null && this.mNotIncludedHeights.contains(string)) {
                            bl2 = false;
                            boolean bl6 = bl3 = !RequiredAttributeDetector.hasLayoutVariations(xmlContext.file);
                        }
                    }
                    if (bl && bl2) {
                        return;
                    }
                }
                if (!bl || !bl2) {
                    string = element.getAttribute("style");
                    if (string != null && !string.isEmpty()) {
                        if (!bl) {
                            bl = this.isWidthStyle(string);
                        }
                        if (!bl2) {
                            bl2 = this.isHeightStyle(string);
                        }
                    }
                    if (bl && bl2) {
                        return;
                    }
                }
                if (!bl && !bl2) {
                    string = bl3 ? "The required layout_width and layout_height attributes are missing" : "The required layout_width and layout_height attributes *may* be missing";
                } else {
                    String string9 = bl ? "layout_height" : "layout_width";
                    string = bl3 ? String.format("The required %1$s attribute is missing", string9) : String.format("The required %1$s attribute *may* be missing", string9);
                }
                xmlContext.report(ISSUE, (org.w3c.dom.Node)element, xmlContext.getLocation((org.w3c.dom.Node)element), string, null);
            }
        }
    }

    private void recordIncludeWidth(String string, boolean bl) {
        if (bl) {
            if (this.mIncludedWidths == null) {
                this.mIncludedWidths = Sets.newHashSet();
            }
            this.mIncludedWidths.add(string);
        } else {
            if (this.mNotIncludedWidths == null) {
                this.mNotIncludedWidths = Sets.newHashSet();
            }
            this.mNotIncludedWidths.add(string);
        }
    }

    private void recordIncludeHeight(String string, boolean bl) {
        if (bl) {
            if (this.mIncludedHeights == null) {
                this.mIncludedHeights = Sets.newHashSet();
            }
            this.mIncludedHeights.add(string);
        } else {
            if (this.mNotIncludedHeights == null) {
                this.mNotIncludedHeights = Sets.newHashSet();
            }
            this.mNotIncludedHeights.add(string);
        }
    }

    @Nullable
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("inflate");
    }

    public void visitMethod(@NonNull JavaContext javaContext, @Nullable AstVisitor astVisitor, @NonNull MethodInvocation methodInvocation) {
        int n;
        Object object;
        Expression expression;
        StrictListAccessor strictListAccessor = methodInvocation.astArguments();
        String string = null;
        int n2 = 0;
        for (Object object2 : strictListAccessor) {
            VariableReference variableReference;
            Select select;
            if (object2 instanceof Select && (expression = (object = (Select)object2).astOperand()) instanceof Select && (select = (Select)expression).astOperand() instanceof VariableReference && "R".equals((variableReference = (VariableReference)select.astOperand()).astIdentifier().astValue()) && "layout".equals(select.astIdentifier().astValue())) {
                string = "@layout/" + object.astIdentifier().astValue();
                break;
            }
            ++n2;
        }
        if (string == null) {
            Iterator iterator = StringFormatDetector.getParentMethod((Node)methodInvocation);
            if (iterator != null) {
                Object object2;
                n2 = 0;
                object2 = StringFormatDetector.getResourceArg((Node)iterator, (Node)methodInvocation, n2);
                if (object2 == null) {
                    n2 = 1;
                    object2 = StringFormatDetector.getResourceArg((Node)iterator, (Node)methodInvocation, n2);
                }
                if (object2 != null) {
                    string = "@layout/" + (String)object2;
                }
            }
            if (string == null) {
                return;
            }
        }
        if ((n = n2 + 1) < strictListAccessor.size()) {
            object = strictListAccessor.iterator();
            for (int i = 0; object.hasNext() && i < n; ++i) {
                object.next();
            }
            if (object.hasNext() && (expression = (Expression)object.next()) instanceof NullLiteral) {
                this.recordIncludeWidth(string, true);
                this.recordIncludeHeight(string, true);
            }
        }
    }
}

