/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.Return;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedPrefsDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"CommitPrefEdits", (String)"Looks for code editing a SharedPreference but forgetting to call commit() on it", (String)"After calling `edit()` on a `SharedPreference`, you must call `commit()` or `apply()` on the editor to save the results.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, SharedPrefsDetector.class, (EnumSet)Scope.JAVA_FILE_SCOPE);

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("edit");
    }

    @Nullable
    private static NormalTypeBody findSurroundingTypeBody(Node node) {
        while (node != null) {
            Class<?> clazz = node.getClass();
            if (clazz == NormalTypeBody.class) {
                return (NormalTypeBody)node;
            }
            node = node.getParent();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitMethod(@NonNull JavaContext javaContext, @Nullable AstVisitor astVisitor, @NonNull MethodInvocation methodInvocation) {
        boolean bl;
        Object object;
        String string;
        assert (methodInvocation.astName().astValue().equals("edit"));
        Expression expression = methodInvocation.astOperand();
        if (expression == null) {
            return;
        }
        Node node = methodInvocation.getParent();
        VariableDefinition variableDefinition = SharedPrefsDetector.getLhs(node);
        if (variableDefinition == null) {
            if (!(expression instanceof VariableReference)) return;
            string = SharedPrefsDetector.findSurroundingTypeBody(node);
            if (string == null) {
                return;
            }
            object = ((VariableReference)expression).astIdentifier().astValue();
            String string2 = SharedPrefsDetector.getFieldType((NormalTypeBody)string, (String)object);
            if (string2 == null || !string2.equals("SharedPreferences")) {
                return;
            }
            bl = true;
        } else {
            string = variableDefinition.astTypeReference().toString();
            if (!(string.endsWith("SharedPreferences.Editor") || string.equals("Editor") && LintUtils.isImported((Node)javaContext.compilationUnit, (String)"android.content.SharedPreferences.Editor"))) {
                return;
            }
            bl = false;
        }
        string = JavaContext.findSurroundingMethod((Node)node);
        if (string == null) {
            return;
        }
        object = new CommitFinder(methodInvocation, bl);
        string.accept((AstVisitor)object);
        if (((CommitFinder)((Object)object)).isCommitCalled()) return;
        javaContext.report(ISSUE, (Node)string, javaContext.getLocation((Node)methodInvocation), "SharedPreferences.edit() without a corresponding commit() or apply() call", null);
    }

    @Nullable
    private static String getFieldType(@NonNull NormalTypeBody normalTypeBody, @NonNull String string) {
        List list = normalTypeBody.getChildren();
        for (Node node : list) {
            if (node.getClass() != VariableDeclaration.class) continue;
            VariableDeclaration variableDeclaration = (VariableDeclaration)node;
            VariableDefinition variableDefinition = variableDeclaration.astDefinition();
            return variableDefinition.astTypeReference().toString();
        }
        return null;
    }

    @Nullable
    private static VariableDefinition getLhs(@NonNull Node node) {
        while (node != null) {
            Class<?> clazz = node.getClass();
            if (clazz == MethodDeclaration.class || clazz == ConstructorDeclaration.class) {
                return null;
            }
            if (clazz == VariableDefinition.class) {
                return (VariableDefinition)node;
            }
            node = node.getParent();
        }
        return null;
    }

    private static class CommitFinder
    extends ForwardingAstVisitor {
        private final MethodInvocation mTarget;
        private final boolean mAllowCommitBeforeTarget;
        private boolean mFound;
        private boolean mSeenTarget;

        private CommitFinder(MethodInvocation methodInvocation, boolean bl) {
            this.mTarget = methodInvocation;
            this.mAllowCommitBeforeTarget = bl;
        }

        public boolean visitMethodInvocation(MethodInvocation methodInvocation) {
            String string;
            if (methodInvocation == this.mTarget) {
                this.mSeenTarget = true;
            } else if ((this.mAllowCommitBeforeTarget || this.mSeenTarget || methodInvocation.astOperand() == this.mTarget) && ("commit".equals(string = methodInvocation.astName().astValue()) || "apply".equals(string))) {
                this.mFound = true;
            }
            return super.visitMethodInvocation(methodInvocation);
        }

        public boolean visitReturn(Return return_) {
            if (return_.astValue() == this.mTarget) {
                this.mFound = true;
            }
            return super.visitReturn(return_);
        }

        boolean isCommitCalled() {
            return this.mFound;
        }
    }
}

