/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedResourceDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"UnusedResources", (String)"Looks for unused resources", (String)"Unused resources make applications larger and slow down builds.", (Category)Category.PERFORMANCE, (int)3, (Severity)Severity.WARNING, UnusedResourceDetector.class, EnumSet.of(Scope.MANIFEST, Scope.ALL_RESOURCE_FILES, Scope.ALL_JAVA_FILES));
    public static final Issue ISSUE_IDS = Issue.create((String)"UnusedIds", (String)"Looks for unused id's", (String)"This resource id definition appears not to be needed since it is not referenced from anywhere. Having id definitions, even if unused, is not necessarily a bad idea since they make working on layouts and menus easier, so there is not a strong reason to delete these.", (Category)Category.PERFORMANCE, (int)1, (Severity)Severity.WARNING, UnusedResourceDetector.class, EnumSet.of(Scope.MANIFEST, Scope.ALL_RESOURCE_FILES, Scope.ALL_JAVA_FILES)).setEnabledByDefault(false);
    private Set<String> mDeclarations;
    private Set<String> mReferences;
    private Map<String, Location> mUnused;
    private static final String ANALYTICS_FILE = "analytics.xml";

    public void run(@NonNull Context context) {
        assert (false);
    }

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    public void beforeCheckProject(@NonNull Context context) {
        if (context.getPhase() == 1) {
            this.mDeclarations = new HashSet<String>(300);
            this.mReferences = new HashSet<String>(300);
        }
    }

    public void beforeCheckFile(@NonNull Context context) {
        int n;
        String string;
        String string2;
        ResourceType resourceType;
        File file = context.file;
        String string3 = file.getName();
        boolean bl = LintUtils.endsWith((String)string3, (String)".xml");
        if ((bl || LintUtils.endsWith((String)string3, (String)".png") || LintUtils.endsWith((String)string3, (String)".jpg") || LintUtils.endsWith((String)string3, (String)".gif")) && (resourceType = ResourceType.getEnum((String)(string2 = string.substring(0, (n = (string = file.getParentFile().getName()).indexOf(45)) == -1 ? string.length() : n)))) != null && LintUtils.isFileBasedResourceType((ResourceType)resourceType)) {
            String string4 = string3.substring(0, string3.length() - ".xml".length());
            String string5 = "R." + string2 + '.' + string4;
            if (context.getPhase() == 1) {
                this.mDeclarations.add(string5);
            } else {
                assert (context.getPhase() == 2);
                if (this.mUnused.containsKey(string5)) {
                    if (bl && context instanceof XmlContext) {
                        XmlContext xmlContext = (XmlContext)context;
                        if (xmlContext.document != null && xmlContext.document.getDocumentElement() != null) {
                            Element element = xmlContext.document.getDocumentElement();
                            if (xmlContext.getDriver().isSuppressed(ISSUE, (org.w3c.dom.Node)element)) {
                                this.mUnused.remove(string5);
                                return;
                            }
                        }
                    }
                    if (!context.getProject().getReportIssues()) {
                        this.mUnused.remove(string5);
                        return;
                    }
                    this.recordLocation(string5, Location.create((File)file));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void afterCheckProject(@NonNull Context context) {
        if (context.getPhase() == 1) {
            this.mDeclarations.removeAll(this.mReferences);
            Set<String> set = this.mDeclarations;
            this.mReferences = null;
            this.mDeclarations = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : set) {
                if (!string.startsWith("R.style") && !string.startsWith("R.attr")) continue;
                arrayList.add(string);
            }
            set.removeAll(arrayList);
            if (!set.isEmpty() && !context.isEnabled(ISSUE_IDS)) {
                Iterator<String> iterator = new ArrayList();
                for (String string : set) {
                    if (!string.startsWith("R.id.")) continue;
                    iterator.add(string);
                }
                set.removeAll((Collection<?>)((Object)iterator));
            }
            if (!set.isEmpty() && !context.getDriver().hasParserErrors()) {
                this.mUnused = new HashMap<String, Location>(set.size());
                for (String string : set) {
                    this.mUnused.put(string, null);
                }
                context.requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
            }
        } else {
            assert (context.getPhase() == 2);
            if (!this.mUnused.isEmpty()) {
                Object object;
                ResourceType resourceType2;
                Object object2;
                for (Map.Entry<String, Location> object42 : this.mUnused.entrySet()) {
                    File[] fileArray;
                    int n;
                    object2 = object42.getKey();
                    Location location = object42.getValue();
                    if (location != null || (resourceType2 = ResourceType.getEnum((String)(object = ((String)object2).substring(2, n = ((String)object2).indexOf(46, 2))))) == null || !LintUtils.isFileBasedResourceType((ResourceType)resourceType2)) continue;
                    String string = ((String)object2).substring(n + 1);
                    ArrayList arrayList = Lists.newArrayList();
                    List list = context.getProject().getResourceFolders();
                    for (File file : list) {
                        fileArray = file.listFiles();
                        if (fileArray == null) continue;
                        arrayList.addAll(Arrays.asList(fileArray));
                    }
                    if (arrayList == null) continue;
                    Collections.sort(arrayList, new Comparator<File>(){

                        @Override
                        public int compare(File file, File file2) {
                            return file.getName().compareTo(file2.getName());
                        }
                    });
                    for (File file : arrayList) {
                        if (!file.getName().startsWith((String)object) || (fileArray = file.listFiles()) == null) continue;
                        for (File file2 : fileArray) {
                            String string2 = file2.getName();
                            if (!string2.startsWith(string) || !string2.startsWith(".", string.length())) continue;
                            this.recordLocation((String)object2, Location.create((File)file2));
                        }
                    }
                }
                ArrayList<String> arrayList = new ArrayList<String>(this.mUnused.keySet());
                Collections.sort(arrayList);
                Object var3_6 = null;
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    String string = (String)object2.next();
                    Location location = this.mUnused.get(string);
                    if (location != null) {
                        location = Location.reverse((Location)location);
                    }
                    if (location == null) {
                        void var3_7;
                        if (var3_7 == null) {
                            Boolean bl = false;
                            for (ResourceType resourceType2 : context.getDriver().getProjects()) {
                                if (resourceType2.getReportIssues()) continue;
                                Boolean bl2 = true;
                                break;
                            }
                        }
                        if (var3_7.booleanValue()) continue;
                    }
                    object = String.format("The resource %1$s appears to be unused", string);
                    resourceType2 = UnusedResourceDetector.getIssue(string);
                    context.report((Issue)resourceType2, location, (String)object, (Object)string);
                }
            }
        }
    }

    private static Issue getIssue(String string) {
        return string.startsWith("R.id.") ? ISSUE_IDS : ISSUE;
    }

    private void recordLocation(String string, Location location) {
        Location location2 = this.mUnused.get(string);
        if (location2 != null) {
            location.setSecondary(location2);
        }
        this.mUnused.put(string, location);
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("style", "resources", "array", "string-array", "plurals");
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        block15: {
            block14: {
                if (!"resources".equals(element.getTagName())) break block14;
                for (Element element2 : LintUtils.getChildren((org.w3c.dom.Node)element)) {
                    String string;
                    Attr attr = element2.getAttributeNode("name");
                    if (attr == null) continue;
                    String string2 = attr.getValue();
                    if (string2.indexOf(46) != -1) {
                        string2 = string2.replace('.', '_');
                    }
                    if ((string = element2.getTagName()).equals("item")) {
                        string = "id";
                    } else if (string.equals("declare-styleable")) {
                        string = "styleable";
                    } else if (string.contains("array")) {
                        string = "array";
                    }
                    String string3 = "R." + string + '.' + string2;
                    if (xmlContext.getPhase() == 1) {
                        this.mDeclarations.add(string3);
                        this.checkChildRefs(element2);
                        continue;
                    }
                    assert (xmlContext.getPhase() == 2);
                    if (!this.mUnused.containsKey(string3)) continue;
                    if (xmlContext.getDriver().isSuppressed(UnusedResourceDetector.getIssue(string3), (org.w3c.dom.Node)element2)) {
                        this.mUnused.remove(string3);
                        continue;
                    }
                    if (!xmlContext.getProject().getReportIssues()) {
                        this.mUnused.remove(string3);
                        continue;
                    }
                    if (UnusedResourceDetector.isAnalyticsFile((Context)xmlContext)) {
                        this.mUnused.remove(string3);
                        continue;
                    }
                    this.recordLocation(string3, xmlContext.getLocation((org.w3c.dom.Node)attr));
                }
                break block15;
            }
            if (this.mReferences == null) break block15;
            assert ("style".equals(element.getTagName()) || "array".equals(element.getTagName()) || "plurals".equals(element.getTagName()) || "string-array".equals(element.getTagName()));
            for (Element element3 : LintUtils.getChildren((org.w3c.dom.Node)element)) {
                this.checkChildRefs(element3);
            }
        }
    }

    public static boolean isAnalyticsFile(Context context) {
        File file = context.file;
        return file.getPath().endsWith(ANALYTICS_FILE) && file.getName().equals(ANALYTICS_FILE);
    }

    private void checkChildRefs(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            org.w3c.dom.Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            String string2 = node.getNodeValue();
            int n2 = string2.indexOf("?attr/");
            if (n2 != -1) {
                string = string2.substring(n2 + "?attr/".length()).trim();
                this.mReferences.add("R.attr." + string);
                continue;
            }
            n2 = string2.indexOf(64);
            if (n2 == -1 || string2.indexOf(47, n2) == -1 || string2.startsWith("@android:", n2)) continue;
            string = string2.substring(n2 + 1).trim().replace('/', '.');
            String string3 = "R." + string;
            this.mReferences.add(string3);
        }
    }

    public void visitAttribute(@NonNull XmlContext xmlContext, @NonNull Attr attr) {
        String string = attr.getValue();
        if (string.startsWith("@+") && !string.startsWith("@+android")) {
            String string2 = "R." + string.substring(2).replace('/', '.');
            if (xmlContext.getPhase() == 1) {
                this.mDeclarations.add(string2);
            } else if (this.mUnused.containsKey(string2)) {
                if (xmlContext.getDriver().isSuppressed(UnusedResourceDetector.getIssue(string2), (org.w3c.dom.Node)attr)) {
                    this.mUnused.remove(string2);
                    return;
                }
                if (!xmlContext.getProject().getReportIssues()) {
                    this.mUnused.remove(string2);
                    return;
                }
                this.recordLocation(string2, xmlContext.getLocation((org.w3c.dom.Node)attr));
                return;
            }
        } else if (this.mReferences != null) {
            if (string.startsWith("@") && !string.startsWith("@android:")) {
                String string3 = "R." + string.substring(1).replace('/', '.');
                this.mReferences.add(string3);
            } else if (string.startsWith("?attr/")) {
                this.mReferences.add("R.attr." + string.substring("?attr/".length()));
            }
        }
        if (attr.getNamespaceURI() != null && !"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI()) && this.mReferences != null) {
            this.mReferences.add("R.attr." + attr.getLocalName());
        }
    }

    @NonNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(ClassDeclaration.class);
    }

    public boolean appliesToResourceRefs() {
        return true;
    }

    public void visitResourceReference(@NonNull JavaContext javaContext, @Nullable AstVisitor astVisitor, @NonNull Node node, @NonNull String string, @NonNull String string2, boolean bl) {
        if (this.mReferences != null && !bl) {
            String string3 = "R." + string + '.' + string2;
            this.mReferences.add(string3);
        }
    }

    public AstVisitor createJavaVisitor(@NonNull JavaContext javaContext) {
        if (this.mReferences != null) {
            return new UnusedResourceVisitor();
        }
        return null;
    }

    private class UnusedResourceVisitor
    extends ForwardingAstVisitor {
        private UnusedResourceVisitor() {
        }

        public boolean visitClassDeclaration(ClassDeclaration classDeclaration) {
            String string = classDeclaration.getDescription();
            if (string.equals("R")) {
                for (Node node : classDeclaration.getChildren()) {
                    if (!(node instanceof NormalTypeBody)) continue;
                    for (Node node2 : node.getChildren()) {
                        if (!(node2 instanceof ClassDeclaration)) continue;
                        String string2 = ((ClassDeclaration)node2).getDescription();
                        for (Node node3 : node2.getChildren()) {
                            if (!(node3 instanceof NormalTypeBody)) continue;
                            for (Node node4 : node3.getChildren()) {
                                if (!(node4 instanceof VariableDeclaration)) continue;
                                for (Node node5 : node4.getChildren()) {
                                    if (!(node5 instanceof VariableDefinition)) continue;
                                    VariableDefinition variableDefinition = (VariableDefinition)node5;
                                    String string3 = ((VariableDefinitionEntry)variableDefinition.astVariables().first()).astName().astValue();
                                    String string4 = "R." + string2 + '.' + string3;
                                    UnusedResourceDetector.this.mDeclarations.add(string4);
                                }
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }
}

