/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrongCaseDetector
extends LayoutDetector {
    public static final Issue WRONGCASE = Issue.create((String)"WrongCase", (String)"Ensures that the correct case is used for special layout tags such as <fragment>", (String)"Most layout tags, such as <Button>, refer to actual view classes and are therefore capitalized. However, there are exceptions such as <fragment> and <include>. This lint check looks for incorrect capitalizations.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.WARNING, WrongCaseDetector.class, (EnumSet)Scope.RESOURCE_FILE_SCOPE).setMoreInfo("http://developer.android.com/guide/components/fragments.html");

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("Fragment", "RequestFocus", "Include", "Merge");
    }

    public void visitElement(@NonNull XmlContext xmlContext, @NonNull Element element) {
        String string = element.getTagName();
        String string2 = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        xmlContext.report(WRONGCASE, (Node)element, xmlContext.getLocation((Node)element), String.format("Invalid tag <%1$s>; should be <%2$s>", string, string2), null);
    }
}

