/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.libs.org.parboiled.Context;
import lombok.ast.libs.org.parboiled.ContextAware;
import lombok.ast.libs.org.parboiled.Node;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.support.Checks;
import lombok.ast.libs.org.parboiled.support.LabelPrefixPredicate;
import lombok.ast.libs.org.parboiled.support.ParseTreeUtils;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseActions<V>
implements ContextAware<V> {
    private Context<V> context;

    public Context<V> getContext() {
        return this.context;
    }

    @Override
    public void setContext(@NotNull Context<V> context) {
        if (context == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.BaseActions.setContext(...) corresponds to @NotNull parameter and must not be null");
        }
        this.context = context;
    }

    public Node<V> node(String path) {
        this.check();
        return this.context.getNodeByPath(path);
    }

    @NotNull
    public List<Node<V>> nodes(String path) {
        this.check();
        List list = ParseTreeUtils.collectNodesByPath(this.context.getSubNodes(), path, new ArrayList());
        if (list == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.BaseActions.nodes must not return null");
        }
        return list;
    }

    public Node<V> nodeByLabel(String labelPrefix) {
        this.check();
        return this.context.getNodeByLabel(labelPrefix);
    }

    @NotNull
    public List<Node<V>> nodesByLabel(String labelPrefix) {
        this.check();
        List list = ParseTreeUtils.collectNodes(this.context.getSubNodes(), new LabelPrefixPredicate(labelPrefix), new ArrayList());
        if (list == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.BaseActions.nodesByLabel must not return null");
        }
        return list;
    }

    public Node<V> lastNode() {
        this.check();
        return this.context.getLastNode();
    }

    public V value() {
        this.check();
        return this.context.getTreeValue();
    }

    public V value(Node<V> node) {
        return node == null ? null : (V)node.getValue();
    }

    public V value(String path) {
        return this.value(this.node(path));
    }

    @NotNull
    public List<V> values(List<Node<V>> nodes) {
        ArrayList<V> values = new ArrayList<V>();
        for (Node<V> node : nodes) {
            values.add(node.getValue());
        }
        ArrayList<V> arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.BaseActions.values must not return null");
        }
        return arrayList;
    }

    @NotNull
    public List<V> values(String path) {
        List<V> list = this.values(this.nodes(path));
        if (list == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.BaseActions.values must not return null");
        }
        return list;
    }

    public V lastValue() {
        return this.value(this.lastNode());
    }

    public String text(Node<V> node) {
        this.check();
        return this.context.getNodeText(node);
    }

    public String text(String path) {
        return this.text(this.node(path));
    }

    @NotNull
    public List<String> texts(List<Node<V>> nodes) {
        this.check();
        ArrayList<String> values = new ArrayList<String>();
        for (Node<V> node : nodes) {
            values.add(this.context.getNodeText(node));
        }
        ArrayList<String> arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.BaseActions.texts must not return null");
        }
        return arrayList;
    }

    @NotNull
    public List<String> texts(String path) {
        List<String> list = this.texts(this.nodes(path));
        if (list == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.BaseActions.texts must not return null");
        }
        return list;
    }

    public String lastText() {
        return this.text(this.lastNode());
    }

    public Character character(Node<V> node) {
        String text = this.text(node);
        return StringUtils.isEmpty(text) ? null : Character.valueOf(text.charAt(0));
    }

    public Character character(String path) {
        return this.character(this.node(path));
    }

    @NotNull
    public List<Character> chars(List<Node<V>> nodes) {
        this.check();
        ArrayList<Character> values = new ArrayList<Character>();
        for (Node<V> node : nodes) {
            values.add(this.character(node));
        }
        ArrayList<Character> arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.BaseActions.chars must not return null");
        }
        return arrayList;
    }

    @NotNull
    public List<Character> chars(String path) {
        List<Character> list = this.chars(this.nodes(path));
        if (list == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.BaseActions.chars must not return null");
        }
        return list;
    }

    public Character lastChar() {
        return this.character(this.lastNode());
    }

    public V prevValue() {
        this.check();
        return this.context.getPrevValue();
    }

    public String prevText() {
        this.check();
        return this.context.getPrevText();
    }

    public Character prevChar() {
        String text = this.prevText();
        return StringUtils.isEmpty(text) ? null : Character.valueOf(text.charAt(0));
    }

    public int prevStart() {
        this.check();
        return this.context.getPrevStartIndex();
    }

    public int prevEnd() {
        this.check();
        return this.context.getPrevEndIndex();
    }

    public boolean set() {
        return this.set(this.prevValue());
    }

    public boolean set(V value) {
        this.check();
        this.context.setNodeValue(value);
        return true;
    }

    public Character currentChar() {
        this.check();
        return Character.valueOf(this.context.getCurrentChar());
    }

    public boolean inPredicate() {
        this.check();
        return this.context.inPredicate();
    }

    public boolean nodeSuppressed() {
        this.check();
        return this.context.isNodeSuppressed();
    }

    public boolean hasError() {
        this.check();
        return this.context.hasError();
    }

    private void check() {
        Checks.ensure(this.context != null && this.context.getMatcher() != null, "Illegal rule definition: Unwrapped action expression!");
    }
}

