/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.libs.org.parboiled.Context;
import lombok.ast.libs.org.parboiled.MatchHandler;
import lombok.ast.libs.org.parboiled.Node;
import lombok.ast.libs.org.parboiled.NodeImpl;
import lombok.ast.libs.org.parboiled.common.Reference;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.errors.BasicParseError;
import lombok.ast.libs.org.parboiled.errors.ErrorUtils;
import lombok.ast.libs.org.parboiled.errors.ParseError;
import lombok.ast.libs.org.parboiled.errors.ParserRuntimeException;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.google.collect.ImmutableList;
import lombok.ast.libs.org.parboiled.matchers.ActionMatcher;
import lombok.ast.libs.org.parboiled.matchers.Matcher;
import lombok.ast.libs.org.parboiled.matchers.ProxyMatcher;
import lombok.ast.libs.org.parboiled.matchers.SequenceMatcher;
import lombok.ast.libs.org.parboiled.matchers.TestMatcher;
import lombok.ast.libs.org.parboiled.matchers.TestNotMatcher;
import lombok.ast.libs.org.parboiled.matchers.VarFramingMatcher;
import lombok.ast.libs.org.parboiled.support.Checks;
import lombok.ast.libs.org.parboiled.support.InputBuffer;
import lombok.ast.libs.org.parboiled.support.LabelPrefixPredicate;
import lombok.ast.libs.org.parboiled.support.MatcherPath;
import lombok.ast.libs.org.parboiled.support.ParseTreeUtils;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatcherContext<V>
implements Context<V> {
    private final InputBuffer inputBuffer;
    private final List<ParseError> parseErrors;
    private final MatchHandler<V> matchHandler;
    private final Reference<Node<V>> lastNodeRef;
    private final MatcherContext<V> parent;
    private final int level;
    private MatcherContext<V> subContext;
    private int startIndex;
    private int currentIndex;
    private char currentChar;
    private Matcher<V> matcher;
    private Node<V> node;
    private List<Node<V>> subNodes;
    private V nodeValue;
    private V treeValue;
    private int intTag;
    private boolean hasError;
    private boolean nodeSuppressed;

    public MatcherContext(@NotNull InputBuffer inputBuffer, @NotNull List<ParseError> parseErrors, @NotNull MatchHandler<V> matchHandler, @NotNull Matcher<V> matcher) {
        if (inputBuffer == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.MatcherContext.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        if (parseErrors == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.MatcherContext.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        if (matchHandler == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.MatcherContext.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("3th argument of method org.parboiled.MatcherContext.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        this(inputBuffer, parseErrors, matchHandler, new Reference<Node<V>>(), null, 0);
        this.currentChar = inputBuffer.charAt(0);
        this.matcher = ProxyMatcher.unwrap(matcher);
        this.nodeSuppressed = matcher.isNodeSuppressed();
    }

    private MatcherContext(@NotNull InputBuffer inputBuffer, @NotNull List<ParseError> parseErrors, @NotNull MatchHandler<V> matchHandler, @NotNull Reference<Node<V>> lastNodeRef, MatcherContext<V> parent, int level) {
        if (inputBuffer == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.MatcherContext.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        if (parseErrors == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.MatcherContext.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        if (matchHandler == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.MatcherContext.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        if (lastNodeRef == null) {
            throw new IllegalArgumentException("3th argument of method org.parboiled.MatcherContext.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        this.subNodes = ImmutableList.of();
        this.inputBuffer = inputBuffer;
        this.parseErrors = parseErrors;
        this.matchHandler = matchHandler;
        this.lastNodeRef = lastNodeRef;
        this.parent = parent;
        this.level = level;
    }

    public String toString() {
        return this.getPath().toString();
    }

    @Override
    public MatcherContext<V> getParent() {
        return this.parent;
    }

    @Override
    public MatcherContext<V> getSubContext() {
        return this.subContext != null && this.subContext.matcher != null ? this.subContext : null;
    }

    @Override
    @NotNull
    public InputBuffer getInputBuffer() {
        InputBuffer inputBuffer = this.inputBuffer;
        if (inputBuffer == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.MatcherContext.getInputBuffer must not return null");
        }
        return inputBuffer;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public Matcher<V> getMatcher() {
        return this.matcher;
    }

    @Override
    public char getCurrentChar() {
        return this.currentChar;
    }

    @Override
    @NotNull
    public List<ParseError> getParseErrors() {
        List<ParseError> list = this.parseErrors;
        if (list == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.MatcherContext.getParseErrors must not return null");
        }
        return list;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public String getNodeText(Node<V> node) {
        return ParseTreeUtils.getNodeText(node, this.inputBuffer);
    }

    @Override
    @NotNull
    public MatcherPath<V> getPath() {
        MatcherPath matcherPath = new MatcherPath(this);
        if (matcherPath == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.MatcherContext.getPath must not return null");
        }
        return matcherPath;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public V getNodeValue() {
        return this.nodeValue;
    }

    @Override
    public void setNodeValue(V value) {
        this.nodeValue = value;
    }

    @Override
    public V getTreeValue() {
        return this.nodeValue != null ? this.nodeValue : this.treeValue;
    }

    @Override
    public Node<V> getNodeByPath(String path) {
        return ParseTreeUtils.findNodeByPath(this.subNodes, path);
    }

    @Override
    public Node<V> getNodeByLabel(String labelPrefix) {
        return ParseTreeUtils.findNode(this.subNodes, new LabelPrefixPredicate(labelPrefix));
    }

    @Override
    public Node<V> getLastNode() {
        return this.lastNodeRef.get();
    }

    @Override
    @NotNull
    public List<Node<V>> getSubNodes() {
        List<Node<V>> list = this.subNodes;
        if (list == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.MatcherContext.getSubNodes must not return null");
        }
        return list;
    }

    @Override
    public boolean inPredicate() {
        return this.matcher instanceof TestMatcher || this.matcher instanceof TestNotMatcher || this.parent != null && this.parent.inPredicate();
    }

    @Override
    public boolean isNodeSuppressed() {
        return this.nodeSuppressed;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public V getPrevValue() {
        MatcherContext<V> sequenceContext = this.getPrevSequenceContext();
        return sequenceContext.subContext.nodeValue;
    }

    @Override
    public String getPrevText() {
        MatcherContext<V> sequenceContext = this.getPrevSequenceContext();
        MatcherContext<V> prevContext = sequenceContext.subContext;
        return sequenceContext.hasError ? sequenceContext.getNodeText(this.getLastNode()) : this.inputBuffer.extract(prevContext.startIndex, prevContext.currentIndex);
    }

    @Override
    public int getPrevStartIndex() {
        MatcherContext<V> sequenceContext = this.getPrevSequenceContext();
        return sequenceContext.subContext.startIndex;
    }

    @Override
    public int getPrevEndIndex() {
        MatcherContext<V> sequenceContext = this.getPrevSequenceContext();
        return sequenceContext.subContext.currentIndex;
    }

    private MatcherContext<V> getPrevSequenceContext() {
        MatcherContext<V> actionContext = this;
        while (actionContext.subContext != null && actionContext.subContext.matcher != null) {
            actionContext = actionContext.subContext;
        }
        Context sequenceContext = actionContext.getParent();
        Checks.ensure(ProxyMatcher.unwrap(VarFramingMatcher.unwrap(((MatcherContext)sequenceContext).matcher)) instanceof SequenceMatcher && ((MatcherContext)sequenceContext).intTag > 0 && actionContext.matcher instanceof ActionMatcher, "Illegal getPrevValue() call, only valid in Sequence rule actions that are not in first position");
        return sequenceContext;
    }

    public void setMatcher(Matcher<V> matcher) {
        this.matcher = matcher;
    }

    public void setStartIndex(int startIndex) {
        Preconditions.checkArgument(startIndex >= 0);
        this.startIndex = startIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        Preconditions.checkArgument(currentIndex >= 0);
        this.currentIndex = currentIndex;
        this.currentChar = this.inputBuffer.charAt(currentIndex);
    }

    public void advanceIndex() {
        if (this.currentIndex < this.inputBuffer.getLength()) {
            ++this.currentIndex;
        }
        this.currentChar = this.inputBuffer.charAt(this.currentIndex);
    }

    public Node<V> getNode() {
        return this.node;
    }

    public int getIntTag() {
        return this.intTag;
    }

    public void setIntTag(int intTag) {
        this.intTag = intTag;
    }

    public void markError() {
        if (!this.hasError) {
            this.hasError = true;
            if (this.parent != null) {
                this.parent.markError();
            }
        }
    }

    public void clearNodeSuppression() {
        if (this.nodeSuppressed) {
            this.nodeSuppressed = false;
            if (this.parent != null) {
                this.parent.clearNodeSuppression();
            }
        }
    }

    public void createNode() {
        this.nodeValue = this.getTreeValue();
        if (this.nodeValue != null && this.parent != null) {
            this.parent.treeValue = this.nodeValue;
        }
        if (!this.nodeSuppressed && !this.matcher.isNodeSkipped()) {
            this.node = new NodeImpl<V>(this.matcher, this.subNodes, this.startIndex, this.currentIndex, this.nodeValue, this.hasError);
            Context<V> context = this.parent;
            if (context != null) {
                while (context.getMatcher().isNodeSkipped()) {
                    Checks.ensure((context = context.getParent()) != null, "Root rule must not be marked @SkipNode");
                }
                super.addChildNode(this.node);
            }
            this.lastNodeRef.set(this.node);
        }
    }

    public final MatcherContext<V> getBasicSubContext() {
        return this.subContext == null ? (this.subContext = new MatcherContext<V>(this.inputBuffer, this.parseErrors, this.matchHandler, this.lastNodeRef, this, this.level + 1)) : this.subContext;
    }

    public final MatcherContext<V> getSubContext(Matcher<V> matcher) {
        MatcherContext<V> sc = this.getBasicSubContext();
        sc.matcher = matcher;
        sc.startIndex = sc.currentIndex = this.currentIndex;
        sc.currentChar = this.currentChar;
        sc.node = null;
        sc.subNodes = ImmutableList.of();
        sc.nodeValue = null;
        sc.treeValue = null;
        sc.nodeSuppressed = this.nodeSuppressed || this.matcher.areSubnodesSuppressed() || matcher.isNodeSuppressed();
        sc.hasError = false;
        return sc;
    }

    public boolean runMatcher() {
        try {
            if (this.matchHandler.match(this)) {
                if (this.parent != null) {
                    this.parent.currentIndex = this.currentIndex;
                    this.parent.currentChar = this.currentChar;
                }
                this.matcher = null;
                return true;
            }
            this.matcher = null;
            return false;
        }
        catch (ParserRuntimeException parserRuntimeException) {
            throw parserRuntimeException;
        }
        catch (Throwable throwable) {
            throw new ParserRuntimeException(throwable, ErrorUtils.printParseError(new BasicParseError(this.inputBuffer, this.currentIndex, StringUtils.escape(String.format("Error while parsing %s '%s' at input position", this.matcher instanceof ActionMatcher ? "action" : "rule", this.getPath()))), this.inputBuffer), new Object[0]);
        }
    }

    private void addChildNode(@NotNull Node<V> node) {
        if (node == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.MatcherContext.addChildNode(...) corresponds to @NotNull parameter and must not be null");
        }
        int n = this.subNodes.size();
        if (n == 0) {
            this.subNodes = ImmutableList.of(node);
            return;
        }
        if (n == 1) {
            Node<V> node2 = this.subNodes.get(0);
            this.subNodes = new ArrayList<Node<V>>(4);
            this.subNodes.add(node2);
        }
        this.subNodes.add(node);
    }
}

