/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.ast.libs.org.parboiled.asm.Type;
import lombok.ast.libs.org.parboiled.asm.tree.AbstractInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.analysis.AnalyzerException;
import lombok.ast.libs.org.parboiled.asm.tree.analysis.BasicInterpreter;
import lombok.ast.libs.org.parboiled.asm.tree.analysis.BasicValue;
import lombok.ast.libs.org.parboiled.asm.tree.analysis.Value;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.support.Checks;
import lombok.ast.libs.org.parboiled.transform.InstructionGraphNode;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import lombok.ast.libs.org.parboiled.transform.Types;

class RuleMethodInterpreter
extends BasicInterpreter
implements Types {
    private final RuleMethod method;
    private final List<Edge> additionalEdges = new ArrayList<Edge>();

    public RuleMethodInterpreter(RuleMethod method) {
        this.method = method;
    }

    public Value newValue(Type type) {
        BasicValue basicValue = (BasicValue)super.newValue(type);
        if (basicValue == BasicValue.REFERENCE_VALUE) {
            basicValue = new BasicValue(type);
        }
        return basicValue;
    }

    public Value newOperation(AbstractInsnNode insn) throws AnalyzerException {
        return this.createNode(insn, super.newOperation(insn), new Value[0]);
    }

    public Value copyOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        return this.createNode(insn, super.copyOperation(insn, value), value);
    }

    public Value unaryOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        return this.createNode(insn, super.unaryOperation(insn, null), value);
    }

    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) throws AnalyzerException {
        return this.createNode(insn, super.binaryOperation(insn, null, null), value1, value2);
    }

    public Value ternaryOperation(AbstractInsnNode insn, Value v1, Value v2, Value v3) throws AnalyzerException {
        this.additionalEdges.add(new Edge(insn, this.findArrayCreatorPredecessor(v1)));
        return this.createNode(insn, super.ternaryOperation(insn, null, null, null), v1, v2, v3);
    }

    public Value naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
        return this.createNode(insn, super.naryOperation(insn, null), values.toArray(new Value[values.size()]));
    }

    public void returnOperation(AbstractInsnNode insn, Value value, Value expected) throws AnalyzerException {
        Preconditions.checkState(insn.getOpcode() == 176);
        Preconditions.checkState(this.unwrap(value).getType().equals(RULE));
        Preconditions.checkState(this.unwrap(expected).getType().equals(RULE));
        Preconditions.checkState(this.method.getReturnInstructionNode() == null);
        this.method.setReturnInstructionNode(this.createNode(insn, null, value));
    }

    private InstructionGraphNode createNode(AbstractInsnNode insn, Value resultValue, Value ... prevNodes) {
        return this.method.setGraphNode(insn, this.unwrap(resultValue), Arrays.asList(prevNodes));
    }

    public Value merge(Value v, Value w) {
        return v;
    }

    public void newControlFlowEdge(int instructionIndex, int successorIndex) {
        AbstractInsnNode fromInsn = this.method.instructions.get(instructionIndex);
        AbstractInsnNode toInsn = this.method.instructions.get(successorIndex);
        if (fromInsn.getType() == 7 || fromInsn.getType() == 6 || toInsn.getType() == 7 || toInsn.getType() == 6) {
            this.additionalEdges.add(new Edge(fromInsn, toInsn));
        }
    }

    private AbstractInsnNode findArrayCreatorPredecessor(Value value) {
        int opcode;
        String errorMessage = "Internal error during analysis of rule method '" + this.method.name + "', please report this error to info@parboiled.org! Thank you!";
        Checks.ensure(value instanceof InstructionGraphNode, errorMessage);
        InstructionGraphNode node = (InstructionGraphNode)value;
        while ((opcode = node.getInstruction().getOpcode()) != 189 && opcode != 188 && opcode != 197) {
            Checks.ensure(node.getPredecessors().size() == 1, errorMessage);
            node = node.getPredecessors().get(0);
        }
        return node.getInstruction();
    }

    public void finish() {
        for (Edge edge : this.additionalEdges) {
            InstructionGraphNode succ;
            InstructionGraphNode node = this.getGraphNode(edge.from);
            if (node == null) {
                node = this.createNode(edge.from, null, new Value[0]);
            }
            if ((succ = this.getGraphNode(edge.to)) == null) {
                succ = this.createNode(edge.to, null, new Value[0]);
            }
            succ.addPredecessor(node);
        }
    }

    private InstructionGraphNode getGraphNode(AbstractInsnNode insn) {
        return this.method.getGraphNodes().get(this.method.instructions.indexOf(insn));
    }

    private BasicValue unwrap(Value resultValue) {
        return resultValue == null || resultValue instanceof BasicValue ? (BasicValue)resultValue : ((InstructionGraphNode)resultValue).getResultValue();
    }

    private class Edge {
        public final AbstractInsnNode from;
        public final AbstractInsnNode to;

        public Edge(AbstractInsnNode from, AbstractInsnNode to) {
            this.from = from;
            this.to = to;
        }
    }
}

