/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.manifmerger.ICallback;
import com.android.manifmerger.IMergerLog;
import com.android.manifmerger.MergerXmlUtils;
import com.android.utils.XmlUtils;
import com.android.xml.AndroidXPathFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestMerger {
    private final IMergerLog mLog;
    private final ICallback mCallback;
    private XPath mXPath;
    private Document mMainDoc;
    private boolean mExtractPackagePrefix;
    private static final String NS_URI = "http://schemas.android.com/apk/res/android";
    private static final String NS_PREFIX = "android";
    private static final String TOOLS_URI = "http://schemas.android.com/tools";
    private static final String MERGE_ATTR = "merge";
    private static final String MERGE_OVERRIDE = "override";
    private static final String MERGE_REMOVE = "remove";
    private static final String[] sClassAttributes = new String[]{"application/name", "application/backupAgent", "activity/name", "activity-alias/name", "receiver/name", "service/name", "provider/name", "instrumentation/name"};

    public ManifestMerger(@NonNull IMergerLog iMergerLog, @Nullable ICallback iCallback) {
        this.mLog = iMergerLog;
        this.mCallback = iCallback;
    }

    public ManifestMerger setExtractPackagePrefix(boolean bl) {
        this.mExtractPackagePrefix = bl;
        return this;
    }

    public boolean process(File file, File file2, File[] fileArray, Map<String, String> map) {
        Document document = MergerXmlUtils.parseDocument(file2, this.mLog);
        if (document == null) {
            return false;
        }
        boolean bl = this.process(document, fileArray, map);
        if (!MergerXmlUtils.printXmlFile(document, file, this.mLog)) {
            bl = false;
        }
        return bl;
    }

    public boolean process(Document document, File[] fileArray, Map<String, String> map) {
        boolean bl = true;
        this.mMainDoc = document;
        MergerXmlUtils.decorateDocument(document, "@main");
        MergerXmlUtils.injectAttributes(document, map, this.mLog);
        String string = XmlUtils.lookupNamespacePrefix((Node)document, (String)NS_URI);
        this.mXPath = AndroidXPathFactory.newXPath((String)string);
        this.expandFqcns(document);
        for (File file : fileArray) {
            Document document2 = MergerXmlUtils.parseDocument(file, this.mLog);
            if (document2 != null && this.mergeLibDoc(this.cleanupToolsAttributes(document2))) continue;
            bl = false;
        }
        this.cleanupToolsAttributes(document);
        if (this.mExtractPackagePrefix) {
            this.extractFqcns(document);
        }
        this.mXPath = null;
        this.mMainDoc = null;
        return bl;
    }

    public boolean process(@NonNull Document document, Document ... documentArray) {
        boolean bl = true;
        this.mMainDoc = document;
        MergerXmlUtils.decorateDocument(document, "@main");
        String string = XmlUtils.lookupNamespacePrefix((Node)document, (String)NS_URI);
        this.mXPath = AndroidXPathFactory.newXPath((String)string);
        this.expandFqcns(document);
        for (Document document2 : documentArray) {
            MergerXmlUtils.decorateDocument(document2, "@library");
            if (this.mergeLibDoc(this.cleanupToolsAttributes(document2))) continue;
            bl = false;
        }
        this.cleanupToolsAttributes(document);
        this.mXPath = null;
        this.mMainDoc = null;
        return bl;
    }

    private boolean mergeLibDoc(Document document) {
        boolean bl = false;
        this.expandFqcns(document);
        bl |= !this.checkApplication(document);
        bl |= !this.doNotMergeCheckEqual("/manifest/uses-configuration", document);
        bl |= !this.doNotMergeCheckEqual("/manifest/supports-screens", document);
        bl |= !this.doNotMergeCheckEqual("/manifest/compatible-screens", document);
        bl |= !this.doNotMergeCheckEqual("/manifest/supports-gl-texture", document);
        boolean bl2 = this.hasOverrideOrRemoveTag(this.findFirstElement(this.mMainDoc, "/manifest/application"));
        if (!bl2) {
            bl |= !this.mergeNewOrEqual("/manifest/application/activity", "name", document, true);
            bl |= !this.mergeNewOrEqual("/manifest/application/activity-alias", "name", document, true);
            bl |= !this.mergeNewOrEqual("/manifest/application/service", "name", document, true);
            bl |= !this.mergeNewOrEqual("/manifest/application/receiver", "name", document, true);
            bl |= !this.mergeNewOrEqual("/manifest/application/provider", "name", document, true);
        }
        bl |= !this.mergeNewOrEqual("/manifest/permission", "name", document, false);
        bl |= !this.mergeNewOrEqual("/manifest/permission-group", "name", document, false);
        bl |= !this.mergeNewOrEqual("/manifest/permission-tree", "name", document, false);
        bl |= !this.mergeNewOrEqual("/manifest/uses-permission", "name", document, false);
        if (!bl2) {
            bl |= !this.mergeAdjustRequired("/manifest/application/uses-library", "name", "required", document, null);
            bl |= !this.mergeNewOrEqual("/manifest/application/meta-data", "name", document, true);
        }
        bl |= !this.mergeAdjustRequired("/manifest/uses-feature", "name", "required", document, "glEsVersion");
        bl |= !this.checkSdkVersion(document);
        return !(bl |= !this.checkGlEsVersion(document));
    }

    private void expandFqcns(Document document) {
        String string = null;
        Element element = this.findFirstElement(document, "/manifest");
        if (element != null) {
            string = element.getAttribute("package");
        }
        if (string == null || string.length() == 0) {
            assert (element != null);
            this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(element), "Missing 'package' attribute in manifest.", new Object[0]);
            return;
        }
        for (String string2 : sClassAttributes) {
            String[] stringArray = string2.split("/");
            if (stringArray.length != 2) continue;
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            NodeList nodeList = document.getElementsByTagName(string3);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string5;
                Attr attr;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || (attr = ((Element)node).getAttributeNodeNS(NS_URI, string4)) == null || (string5 = attr.getNodeValue()) == null || string5.length() <= 0 || string5.indexOf(46) != -1 && string5.charAt(0) != '.') continue;
                string5 = string5.charAt(0) == '.' ? string + string5 : string + '.' + string5;
                attr.setNodeValue(string5);
            }
        }
    }

    private void extractFqcns(Document document) {
        String string = null;
        Element element = this.findFirstElement(document, "/manifest");
        if (element != null) {
            string = element.getAttribute("package");
        }
        if (string == null || string.length() == 0) {
            return;
        }
        int n = string.length();
        for (String string2 : sClassAttributes) {
            String[] stringArray = string2.split("/");
            if (stringArray.length != 2) continue;
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            NodeList nodeList = document.getElementsByTagName(string3);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string5;
                Attr attr;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || (attr = ((Element)node).getAttributeNodeNS(NS_URI, string4)) == null || (string5 = attr.getNodeValue()) == null || string5.length() <= n || !string5.startsWith(string) || string5.charAt(n) != '.') continue;
                string5 = string5.substring(n);
                attr.setNodeValue(string5);
            }
        }
    }

    private boolean checkApplication(Document document) {
        Element element = this.findFirstElement(this.mMainDoc, "/manifest/application");
        Element element2 = this.findFirstElement(document, "/manifest/application");
        if (element2 == null) {
            return true;
        }
        if (this.hasOverrideOrRemoveTag(element)) {
            return true;
        }
        for (String string : new String[]{"name", "backupAgent"}) {
            String string2;
            String string3 = this.getAttributeValue(element2, string);
            if (string3 == null || string3.length() == 0) continue;
            String string4 = string2 = element == null ? "" : this.getAttributeValue(element, string);
            if (string3.equals(string2)) continue;
            assert (element != null);
            this.mLog.conflict(IMergerLog.Severity.WARNING, this.xmlFileAndLine(element), this.xmlFileAndLine(element2), element == null ? "Library has <application android:%1$s='%3$s'> but main manifest has no application element." : "Main manifest has <application android:%1$s='%2$s'> but library uses %1$s='%3$s'.", string, string2, string3);
        }
        return true;
    }

    private boolean doNotMergeCheckEqual(String string, Document document) {
        for (Element element : this.findElements(document, string)) {
            boolean bl = false;
            for (Element element2 : this.findElements(this.mMainDoc, string)) {
                if (this.hasOverrideOrRemoveTag(element2) || !this.compareElements(element2, element, false, null, null)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.mLog.conflict(IMergerLog.Severity.WARNING, this.xmlFileAndLine(this.mMainDoc), this.xmlFileAndLine(element), "%1$s defined in library, missing from main manifest:\n%2$s", string, MergerXmlUtils.dump(element, false));
        }
        return true;
    }

    private boolean mergeNewOrEqual(String string, String string2, Document document, boolean bl) {
        int n = string.lastIndexOf(47);
        assert (n > 1);
        String string3 = string.substring(0, n);
        Element element = this.findFirstElement(this.mMainDoc, string3);
        assert (element != null);
        if (element == null) {
            this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(this.mMainDoc), "Could not find element %1$s.", string3);
            return false;
        }
        boolean bl2 = true;
        block0: for (Element element2 : this.findElements(document, string)) {
            String string4 = this.getAttributeValue(element2, string2);
            if (string4.length() == 0) {
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(element2), "Undefined '%1$s' attribute in %2$s.", string2, string);
                bl2 = false;
                continue;
            }
            List<Element> list = this.findElements(this.mMainDoc, string, string2, string4);
            if (list.size() > 1) {
                this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(list.get(0)), "Manifest has more than one %1$s[@%2$s=%3$s] element.", string, string2, string4);
            }
            boolean bl3 = true;
            for (Element element3 : list) {
                if (this.hasOverrideOrRemoveTag(element3)) {
                    bl3 = false;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (this.compareElements(element3, element2, false, stringBuilder, string2)) {
                    if (!bl) continue block0;
                    this.mLog.conflict(IMergerLog.Severity.INFO, this.xmlFileAndLine(element3), this.xmlFileAndLine(element2), "Skipping identical %1$s[@%2$s=%3$s] element.", string, string2, string4);
                    continue block0;
                }
                this.mLog.conflict(IMergerLog.Severity.ERROR, this.xmlFileAndLine(element3), this.xmlFileAndLine(element2), "Trying to merge incompatible %1$s[@%2$s=%3$s] element:\n%4$s", string, string2, string4, stringBuilder.toString());
                bl2 = false;
                continue block0;
            }
            if (!bl3) continue;
            Node node = this.selectPreviousSiblings(element2);
            this.insertAtEndOf(element, node, element2);
        }
        return bl2;
    }

    private String getAttributeValue(Element element, String string) {
        Attr attr = element.getAttributeNodeNS(NS_URI, string);
        String string2 = attr == null ? "" : attr.getNodeValue();
        return string2;
    }

    private boolean mergeAdjustRequired(String string, String string2, String string3, Document document, @Nullable String string4) {
        int n = string.lastIndexOf(47);
        assert (n > 1);
        String string5 = string.substring(0, n);
        Element element = this.findFirstElement(this.mMainDoc, string5);
        assert (element != null);
        if (element == null) {
            this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(this.mMainDoc), "Could not find element %1$s.", string5);
            return false;
        }
        boolean bl = true;
        for (Element element2 : this.findElements(document, string)) {
            Object object;
            List<Element> list;
            String string6;
            Attr attr = element2.getAttributeNodeNS(NS_URI, string2);
            String string7 = string6 = attr == null ? "" : attr.getNodeValue().trim();
            if (string6.length() == 0) {
                if (string4 != null) {
                    attr = element2.getAttributeNodeNS(NS_URI, string4);
                    List<Element> list2 = list = attr == null ? "" : attr.getNodeValue().trim();
                    if (((String)((Object)list)).length() != 0) continue;
                }
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(element2), "Undefined '%1$s' attribute in %2$s.", string2, string);
                bl = false;
                continue;
            }
            list = this.findElements(this.mMainDoc, string, string2, string6);
            if (list.size() > 1) {
                this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine((Node)list.get(0)), "Manifest has more than one %1$s[@%2$s=%3$s] element.", string, string2, string6);
            }
            if (list.size() > 0) {
                attr = element2.getAttributeNodeNS(NS_URI, string3);
                Object object2 = object = attr == null ? "true" : attr.getNodeValue();
                if (object == null || !((String)object).equals("true") && !((String)object).equals("false")) {
                    this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(element2), "Invalid attribute '%1$s' in %2$s[@%3$s=%4$s] element:\nExpected 'true' or 'false' but found '%5$s'.", string3, string, string2, string6, object);
                    continue;
                }
                boolean bl2 = Boolean.parseBoolean((String)object);
                for (Element element3 : list) {
                    if (this.hasOverrideOrRemoveTag(element3)) continue;
                    attr = element3.getAttributeNodeNS(NS_URI, string3);
                    Object object3 = object = attr == null ? "true" : attr.getNodeValue();
                    if (object == null || !((String)object).equals("true") && !((String)object).equals("false")) {
                        this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(element3), "Invalid attribute '%1$s' in %2$s[@%3$s=%4$s] element:\nExpected 'true' or 'false' but found '%5$s'.", string3, string, string2, string6, object);
                        continue;
                    }
                    boolean bl3 = Boolean.parseBoolean((String)object);
                    if (bl3 || !bl2 || attr == null) continue;
                    attr.setNodeValue("true");
                }
                continue;
            }
            object = this.selectPreviousSiblings(element2);
            Node node = this.insertAtEndOf(element, (Node)object, element2);
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap == null) continue;
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (node2.getNodeType() != 2) continue;
                boolean bl4 = NS_URI.equals(node2.getNamespaceURI());
                if (bl4) {
                    string6 = node2.getLocalName();
                    boolean bl5 = bl4 = string2.equals(string6) || string3.equals(string6);
                }
                if (bl4) continue;
                namedNodeMap.removeNamedItemNS(NS_URI, string6);
                i = -1;
            }
        }
        return bl;
    }

    private boolean checkGlEsVersion(Document document) {
        Node node;
        String string = "/manifest";
        Element element = this.findFirstElement(this.mMainDoc, string);
        assert (element != null);
        if (element == null) {
            this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(this.mMainDoc), "Could not find element %1$s.", string);
            return false;
        }
        String string2 = "/manifest/uses-feature";
        String string3 = "glEsVersion";
        long l = 65536L;
        Element element2 = null;
        boolean bl = true;
        for (Element element3 : this.findElements(this.mMainDoc, string2)) {
            node = element3.getAttributeNodeNS(NS_URI, string3);
            String string4 = node == null ? "" : node.getNodeValue().trim();
            if (string4.length() == 0) continue;
            try {
                long l2 = Long.decode(string4);
                if (l2 >= l) {
                    l = l2;
                    element2 = element3;
                    continue;
                }
                if (l2 >= 65536L) continue;
                this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(element3), "Ignoring <uses-feature android:glEsVersion='%1$s'> because it's smaller than 1.0.", string4);
            }
            catch (NumberFormatException numberFormatException) {
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(element3), "Failed to parse <uses-feature android:glEsVersion='%1$s'>: must be an integer in the form 0x00020001.", string4);
                bl = false;
            }
        }
        if (!bl && element2 == null) {
            return false;
        }
        long l3 = 65536L;
        node = null;
        bl = true;
        for (Element element4 : this.findElements(document, string2)) {
            Attr attr = element4.getAttributeNodeNS(NS_URI, string3);
            String string5 = attr == null ? "" : attr.getNodeValue().trim();
            if (string5.length() == 0) continue;
            try {
                long l4 = Long.decode(string5);
                if (l4 >= l3) {
                    l3 = l4;
                    node = element4;
                    continue;
                }
                if (l4 >= 65536L) continue;
                this.mLog.error(IMergerLog.Severity.WARNING, this.xmlFileAndLine(element4), "Ignoring <uses-feature android:glEsVersion='%1$s'> because it's smaller than 1.0.", string5);
            }
            catch (NumberFormatException numberFormatException) {
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(element4), "Failed to parse <uses-feature android:glEsVersion='%1$s'>: must be an integer in the form 0x00020001.", string5);
                bl = false;
            }
        }
        if (node != null && l < l3) {
            this.mLog.conflict(IMergerLog.Severity.WARNING, this.xmlFileAndLine(element2 == null ? this.mMainDoc : element2), this.xmlFileAndLine(node), "Main manifest has <uses-feature android:glEsVersion='0x%1$08x'> but library uses glEsVersion='0x%2$08x'%3$s", l, l3, element2 != null ? "" : "\nNote: main manifest lacks a <uses-feature android:glEsVersion> declaration, and thus defaults to glEsVersion=0x00010000.");
            bl = false;
        }
        return bl;
    }

    private boolean checkSdkVersion(Document document) {
        boolean bl = true;
        Element element = this.findFirstElement(this.mMainDoc, "/manifest/uses-sdk");
        if (this.hasOverrideOrRemoveTag(element)) {
            return true;
        }
        Element element2 = this.findFirstElement(document, "/manifest/uses-sdk");
        AtomicInteger atomicInteger = new AtomicInteger(1);
        AtomicInteger atomicInteger2 = new AtomicInteger(1);
        AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        AtomicBoolean atomicBoolean2 = new AtomicBoolean(true);
        int n = 1;
        bl = this.extractSdkVersionAttribute(document, element, element2, "min", atomicInteger, atomicInteger2, atomicBoolean, atomicBoolean2);
        if (bl && (n = atomicInteger.get()) < atomicInteger2.get()) {
            this.mLog.conflict(IMergerLog.Severity.ERROR, this.xmlFileAndLine(element == null ? this.mMainDoc : element), this.xmlFileAndLine(element2 == null ? document : element2), "Main manifest has <uses-sdk android:minSdkVersion='%1$d'> but library uses minSdkVersion='%2$d'%3$s", n, atomicInteger2.get(), !atomicBoolean.get() ? "" : "\nNote: main manifest lacks a <uses-sdk android:minSdkVersion> declaration, which defaults to value 1.");
            bl = false;
        }
        atomicBoolean.set(true);
        atomicBoolean2.set(true);
        boolean bl2 = this.extractSdkVersionAttribute(document, element, element2, "target", atomicInteger, atomicInteger2, atomicBoolean, atomicBoolean2);
        bl &= bl2;
        if (bl2) {
            int n2;
            int n3 = n2 = atomicBoolean.get() ? n : atomicInteger.get();
            if (n2 < atomicInteger2.get()) {
                this.mLog.conflict(IMergerLog.Severity.WARNING, this.xmlFileAndLine(element == null ? this.mMainDoc : element), this.xmlFileAndLine(element2 == null ? document : element2), "Main manifest has <uses-sdk android:targetSdkVersion='%1$d'> but library uses targetSdkVersion='%2$d'%3$s", n2, atomicInteger2.get(), !atomicBoolean.get() ? "" : "\nNote: main manifest lacks a <uses-sdk android:targetSdkVersion> declaration, which defaults to value minSdkVersion or 1.");
                bl = false;
            }
        }
        return bl;
    }

    private boolean extractSdkVersionAttribute(Document document, Element element, Element element2, String string, AtomicInteger atomicInteger, AtomicInteger atomicInteger2, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) {
        boolean bl;
        block11: {
            int n;
            boolean bl2;
            String string2;
            block10: {
                string2 = element == null ? "" : element.getAttributeNS(NS_URI, string + "SdkVersion");
                bl = true;
                assert (string2 != null);
                string2 = string2.trim();
                try {
                    if (string2.length() > 0) {
                        atomicInteger.set(Integer.parseInt(string2));
                        atomicBoolean.set(false);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = true;
                    if (this.mCallback != null && (n = this.mCallback.queryCodenameApiLevel(string2)) > 0) {
                        atomicInteger.set(n);
                        atomicBoolean.set(false);
                        bl2 = false;
                    }
                    if (!bl2) break block10;
                    this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(element == null ? this.mMainDoc : element), "Failed to parse <uses-sdk %1$sSdkVersion='%2$s'>: must be an integer number or codename.", string, string2);
                    bl = false;
                }
            }
            String string3 = string2 = element2 == null ? "" : element2.getAttributeNS(NS_URI, string + "SdkVersion");
            assert (string2 != null);
            string2 = string2.trim();
            try {
                if (string2.length() > 0) {
                    atomicInteger2.set(Integer.parseInt(string2));
                    atomicBoolean2.set(false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = true;
                if (this.mCallback != null && (n = this.mCallback.queryCodenameApiLevel(string2)) > 0) {
                    atomicInteger2.set(n);
                    atomicBoolean2.set(false);
                    bl2 = false;
                }
                if (!bl2) break block11;
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(element2 == null ? document : element2), "Failed to parse <uses-sdk %1$sSdkVersion='%2$s'>: must be an integer number or codename.", string, string2);
                bl = false;
            }
        }
        return bl;
    }

    @NonNull
    private Node selectPreviousSiblings(Node node) {
        String string;
        short s;
        Node node2 = node;
        Node node3 = node2.getPreviousSibling();
        while (node3 != null && !((s = node3.getNodeType()) != 3 ? s != 8 : (string = node3.getNodeValue()) == null || string.trim().length() != 0)) {
            node2 = node3;
            node3 = node2.getPreviousSibling();
        }
        return node2;
    }

    private Node insertAtEndOf(Element element, Node node, Node node2) {
        Object object;
        Node node3;
        String string = XmlUtils.lookupNamespacePrefix((Node)this.mMainDoc, (String)NS_URI);
        String string2 = XmlUtils.lookupNamespacePrefix((Node)node.getOwnerDocument(), (String)NS_URI);
        boolean bl = string != null && !string.equals(string2);
        for (node3 = element.getLastChild(); node3 != null && node3.getNodeType() == 3 && (object = node3.getNodeValue()) != null && ((String)object).trim().length() == 0; node3 = node3.getPreviousSibling()) {
        }
        if (node3 != null) {
            node3 = node3.getNextSibling();
        }
        assert (element.getOwnerDocument() == this.mMainDoc);
        assert (element.getOwnerDocument() != node.getOwnerDocument());
        assert (node.getOwnerDocument() == node2.getOwnerDocument());
        while (node != null) {
            object = this.mMainDoc.importNode(node, true);
            if (bl) {
                this.changePrefix((Node)object, string2, string);
            }
            element.insertBefore((Node)object, node3);
            if (node == node2) {
                return object;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    private void changePrefix(Node node, String string, String string2) {
        while (node != null) {
            Node node2;
            if (string.equals(node.getPrefix())) {
                node.setPrefix(string2);
            }
            if ((node2 = node.getFirstChild()) != null) {
                this.changePrefix(node2, string, string2);
            }
            node = node.getNextSibling();
        }
    }

    private boolean compareElements(@NonNull Node node, @NonNull Node node2, boolean bl, @Nullable StringBuilder stringBuilder, @Nullable String string) {
        String string2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String string3 = MergerXmlUtils.printElement(node, hashMap, "");
        if (string3.equals(string2 = MergerXmlUtils.printElement(node2, hashMap2, ""))) {
            return true;
        }
        if (stringBuilder != null) {
            MergerXmlUtils.printXmlDiff(stringBuilder, string3, string2, hashMap, hashMap2, "http://schemas.android.com/apk/res/android:" + string);
        }
        return false;
    }

    @Nullable
    private Element findFirstElement(@NonNull Document document, @NonNull String string) {
        try {
            Node node = (Node)this.mXPath.evaluate(string, document, XPathConstants.NODE);
            if (node instanceof Element) {
                return (Element)node;
            }
            if (node != null) {
                this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(document), "Unexpected Node type %s when evaluating %s", node.getClass().getName(), string);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(document), "XPath error on expr %s: %s", string, xPathExpressionException.toString());
        }
        return null;
    }

    private List<Element> findElements(@NonNull Document document, @NonNull String string) {
        return this.findElements(document, string, null, null);
    }

    private List<Element> findElements(@NonNull Document document, @NonNull String string, @Nullable String string2, @Nullable String string3) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (string2 != null) {
            assert (string3 != null);
            string = String.format("%1$s[@%2$s:%3$s='%4$s']", string, NS_PREFIX, string2, string3);
        }
        try {
            NodeList nodeList = (NodeList)this.mXPath.evaluate(string, document, XPathConstants.NODESET);
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    assert (node instanceof Element);
                    if (node instanceof Element) {
                        arrayList.add((Element)node);
                        continue;
                    }
                    this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(document), "Unexpected Node type %s when evaluating %s", node.getClass().getName(), string);
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            this.mLog.error(IMergerLog.Severity.ERROR, this.xmlFileAndLine(document), "XPath error on expr %s: %s", string, xPathExpressionException.toString());
        }
        return arrayList;
    }

    @NonNull
    private IMergerLog.FileAndLine xmlFileAndLine(@NonNull Node node) {
        return MergerXmlUtils.xmlFileAndLine(node);
    }

    private boolean hasOverrideOrRemoveTag(@Nullable Node node) {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItemNS(TOOLS_URI, MERGE_ATTR);
        String string = node2 == null ? null : node2.getNodeValue();
        return MERGE_OVERRIDE.equals(string) || MERGE_REMOVE.equals(string);
    }

    private void cleanupToolsAttributes(@Nullable Node node) {
        Node node2;
        if (node == null) {
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                node2 = namedNodeMap.item(i);
                if ("http://www.w3.org/2000/xmlns/".equals(node2.getNamespaceURI()) && TOOLS_URI.equals(node2.getNodeValue())) {
                    namedNodeMap.removeNamedItem(node2.getNodeName());
                    continue;
                }
                if (!TOOLS_URI.equals(node2.getNamespaceURI()) || !MERGE_ATTR.equals(node2.getLocalName())) continue;
                namedNodeMap.removeNamedItem(node2.getNodeName());
            }
            assert (namedNodeMap.getNamedItemNS(TOOLS_URI, MERGE_ATTR) == null);
        }
        Node node3 = node.getFirstChild();
        while (node3 != null) {
            if (node3.getNodeType() != 1) {
                node3 = node3.getNextSibling();
                continue;
            }
            namedNodeMap = node3.getAttributes();
            node2 = namedNodeMap == null ? null : namedNodeMap.getNamedItemNS(TOOLS_URI, MERGE_ATTR);
            String string = node2 == null ? null : node2.getNodeValue();
            Node node4 = node3.getNextSibling();
            if (MERGE_REMOVE.equals(string)) {
                Node node5 = node3.getPreviousSibling();
                node.removeChild(node3);
                while (node5 != null && node5.getNodeType() == 3 && node5.getNodeValue().trim().length() == 0) {
                    Node node6 = node5.getPreviousSibling();
                    node.removeChild(node5);
                    node5 = node6;
                }
            } else {
                this.cleanupToolsAttributes(node3);
            }
            node3 = node4;
        }
    }

    private Document cleanupToolsAttributes(@NonNull Document document) {
        this.cleanupToolsAttributes(document.getFirstChild());
        return document;
    }
}

