/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.systrace;

import com.android.ide.eclipse.ddms.systrace.ISystraceOptions;
import com.android.ide.eclipse.ddms.systrace.ISystraceOptionsDialog;
import java.io.File;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystraceOptionsDialogV1
extends TitleAreaDialog
implements ISystraceOptionsDialog {
    private static final String TITLE = "Android System Trace";
    private static final String DEFAULT_MESSAGE = "Settings to use while capturing system level trace";
    private static final String DEFAULT_TRACE_FNAME = "trace.html";
    private Text mDestinationText;
    private String mDestinationPath;
    private Text mTraceDurationText;
    private Text mTraceBufferSizeText;
    private static String sSaveToFolder = System.getProperty("user.home");
    private static String sTraceDuration = "";
    private static String sTraceBufferSize = "";
    private Button mTraceCpuFreqBtn;
    private Button mTraceCpuIdleBtn;
    private Button mTraceCpuLoadBtn;
    private Button mTraceDiskIoBtn;
    private Button mTraceKernelWorkqueuesBtn;
    private Button mTraceCpuSchedulerBtn;
    private static boolean sTraceCpuFreq;
    private static boolean sTraceCpuIdle;
    private static boolean sTraceCpuLoad;
    private static boolean sTraceDiskIo;
    private static boolean sTraceKernelWorkqueues;
    private static boolean sTraceCpuScheduler;
    private Button mGfxTagBtn;
    private Button mInputTagBtn;
    private Button mViewTagBtn;
    private Button mWebViewTagBtn;
    private Button mWmTagBtn;
    private Button mAmTagBtn;
    private Button mSyncTagBtn;
    private Button mAudioTagBtn;
    private Button mVideoTagBtn;
    private Button mCameraTagBtn;
    private static boolean sGfxTag;
    private static boolean sInputTag;
    private static boolean sViewTag;
    private static boolean sWebViewTag;
    private static boolean sWmTag;
    private static boolean sAmTag;
    private static boolean sSyncTag;
    private static boolean sAudioTag;
    private static boolean sVideoTag;
    private static boolean sCameraTag;
    private final SystraceOptions mOptions = new SystraceOptions();

    public SystraceOptionsDialogV1(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite composite) {
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText("Destination File: ");
        this.mDestinationText = new Text(composite2, 2048);
        this.mDestinationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mDestinationText.setText(String.valueOf(sSaveToFolder) + File.separator + DEFAULT_TRACE_FNAME);
        final Button button = new Button(composite2, 0);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = SystraceOptionsDialogV1.this.openBrowseDialog(button.getShell());
                if (string != null) {
                    SystraceOptionsDialogV1.this.mDestinationText.setText(string);
                }
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label2.setText("Trace duration (seconds): ");
        this.mTraceDurationText = new Text(composite2, 2048);
        this.mTraceDurationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mTraceDurationText.setText(sTraceDuration);
        Label label3 = new Label(composite2, 0);
        label3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label3.setText("Trace Buffer Size (kb): ");
        this.mTraceBufferSizeText = new Text(composite2, 2048);
        this.mTraceBufferSizeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mTraceBufferSizeText.setText(sTraceBufferSize);
        Label label4 = new Label(composite2, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label4.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 2048);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        group.setText("Trace Events");
        this.mTraceCpuFreqBtn = new Button((Composite)group, 32);
        this.mTraceCpuFreqBtn.setText("CPU Frequency Changes");
        this.mTraceCpuFreqBtn.setSelection(sTraceCpuFreq);
        this.mTraceCpuIdleBtn = new Button((Composite)group, 32);
        this.mTraceCpuIdleBtn.setText("CPU Idle Events");
        this.mTraceCpuIdleBtn.setSelection(sTraceCpuIdle);
        this.mTraceCpuLoadBtn = new Button((Composite)group, 32);
        this.mTraceCpuLoadBtn.setText("CPU Load");
        this.mTraceCpuLoadBtn.setSelection(sTraceCpuLoad);
        this.mTraceCpuSchedulerBtn = new Button((Composite)group, 32);
        this.mTraceCpuSchedulerBtn.setText("CPU Scheduler");
        this.mTraceCpuSchedulerBtn.setSelection(sTraceCpuScheduler);
        Group group2 = new Group(composite2, 2048);
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        group2.setText("Trace Events that require root privileges on device");
        this.mTraceDiskIoBtn = new Button((Composite)group2, 32);
        this.mTraceDiskIoBtn.setText("Disk I/O");
        this.mTraceDiskIoBtn.setSelection(sTraceDiskIo);
        this.mTraceKernelWorkqueuesBtn = new Button((Composite)group2, 32);
        this.mTraceKernelWorkqueuesBtn.setText("Kernel Workqueues (requires root)");
        this.mTraceKernelWorkqueuesBtn.setSelection(sTraceKernelWorkqueues);
        Group group3 = new Group(composite2, 2048);
        group3.setLayout((Layout)new GridLayout(5, false));
        group3.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        group3.setText("Trace Tags");
        this.mGfxTagBtn = new Button((Composite)group3, 32);
        this.mGfxTagBtn.setText("gfx");
        this.mGfxTagBtn.setSelection(sGfxTag);
        this.mInputTagBtn = new Button((Composite)group3, 32);
        this.mInputTagBtn.setText("input");
        this.mInputTagBtn.setSelection(sInputTag);
        this.mViewTagBtn = new Button((Composite)group3, 32);
        this.mViewTagBtn.setText("view");
        this.mViewTagBtn.setSelection(sViewTag);
        this.mWebViewTagBtn = new Button((Composite)group3, 32);
        this.mWebViewTagBtn.setText("webview");
        this.mWebViewTagBtn.setSelection(sWebViewTag);
        this.mWmTagBtn = new Button((Composite)group3, 32);
        this.mWmTagBtn.setText("wm");
        this.mWmTagBtn.setSelection(sWmTag);
        this.mAmTagBtn = new Button((Composite)group3, 32);
        this.mAmTagBtn.setText("am");
        this.mAmTagBtn.setSelection(sAmTag);
        this.mSyncTagBtn = new Button((Composite)group3, 32);
        this.mSyncTagBtn.setText("sync");
        this.mSyncTagBtn.setSelection(sSyncTag);
        this.mAudioTagBtn = new Button((Composite)group3, 32);
        this.mAudioTagBtn.setText("audio");
        this.mAudioTagBtn.setSelection(sAudioTag);
        this.mVideoTagBtn = new Button((Composite)group3, 32);
        this.mVideoTagBtn.setText("video");
        this.mVideoTagBtn.setSelection(sVideoTag);
        this.mCameraTagBtn = new Button((Composite)group3, 32);
        this.mCameraTagBtn.setText("camera");
        this.mCameraTagBtn.setSelection(sCameraTag);
        Label label5 = new Label((Composite)group3, 0);
        label5.setText("Changes to trace tags will likely need a restart of the Android framework to take effect:\n    $ adb shell stop\n    $ adb shell start");
        label5.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 5, 1));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SystraceOptionsDialogV1.this.validateFields();
            }
        };
        this.mDestinationText.addModifyListener(modifyListener);
        this.mTraceBufferSizeText.addModifyListener(modifyListener);
        this.mTraceDurationText.addModifyListener(modifyListener);
        return composite2;
    }

    private void validateFields() {
        String string = this.validatePath(this.mDestinationText.getText());
        if (string != null) {
            this.setErrorMessage(string);
            this.getButton(0).setEnabled(false);
            return;
        }
        if (!this.validateInteger(this.mTraceDurationText.getText())) {
            this.setErrorMessage("Trace Duration should be a valid integer (seconds)");
            this.getButton(0).setEnabled(false);
            return;
        }
        if (!this.validateInteger(this.mTraceBufferSizeText.getText())) {
            this.setErrorMessage("Trace Buffer Size should be a valid integer (kilobytes)");
            this.getButton(0).setEnabled(false);
            return;
        }
        this.getButton(0).setEnabled(true);
        this.setErrorMessage(null);
    }

    private boolean validateInteger(String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private String validatePath(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            return String.format("The path '%s' points to a folder", string);
        }
        if (!file.exists() && !file.getParentFile().isDirectory()) {
            return String.format("That path '%s' is not a valid folder.", file.getParent());
        }
        return null;
    }

    private String openBrowseDialog(Shell shell) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setText("Save To");
        fileDialog.setFileName(DEFAULT_TRACE_FNAME);
        fileDialog.setFilterPath(sSaveToFolder);
        fileDialog.setFilterExtensions(new String[]{"*.html"});
        String string = fileDialog.open();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        sSaveToFolder = fileDialog.getFilterPath();
        return string;
    }

    protected void okPressed() {
        this.mDestinationPath = this.mDestinationText.getText().trim();
        sTraceDuration = this.mTraceDurationText.getText();
        if (!sTraceDuration.isEmpty()) {
            this.mOptions.mTraceDuration = Integer.parseInt(SystraceOptionsDialogV1.sTraceDuration);
        }
        if (!(sTraceBufferSize = this.mTraceBufferSizeText.getText()).isEmpty()) {
            this.mOptions.mTraceBufferSize = Integer.parseInt(SystraceOptionsDialogV1.sTraceBufferSize);
        }
        this.mOptions.mTraceCpuFreq = this.mTraceCpuFreqBtn.getSelection();
        this.mOptions.mTraceCpuIdle = this.mTraceCpuIdleBtn.getSelection();
        this.mOptions.mTraceCpuLoad = this.mTraceCpuLoadBtn.getSelection();
        this.mOptions.mTraceDiskIo = this.mTraceDiskIoBtn.getSelection();
        this.mOptions.mTraceKernelWorkqueues = this.mTraceKernelWorkqueuesBtn.getSelection();
        this.mOptions.mTraceCpuScheduler = this.mTraceCpuSchedulerBtn.getSelection();
        if (this.mGfxTagBtn.getSelection()) {
            this.mOptions.enableTag(2);
        }
        if (this.mInputTagBtn.getSelection()) {
            this.mOptions.enableTag(4);
        }
        if (this.mViewTagBtn.getSelection()) {
            this.mOptions.enableTag(8);
        }
        if (this.mWebViewTagBtn.getSelection()) {
            this.mOptions.enableTag(16);
        }
        if (this.mWmTagBtn.getSelection()) {
            this.mOptions.enableTag(32);
        }
        if (this.mAmTagBtn.getSelection()) {
            this.mOptions.enableTag(64);
        }
        if (this.mSyncTagBtn.getSelection()) {
            this.mOptions.enableTag(128);
        }
        if (this.mAudioTagBtn.getSelection()) {
            this.mOptions.enableTag(256);
        }
        if (this.mViewTagBtn.getSelection()) {
            this.mOptions.enableTag(512);
        }
        if (this.mCameraTagBtn.getSelection()) {
            this.mOptions.enableTag(1024);
        }
        sTraceCpuFreq = this.mTraceCpuFreqBtn.getSelection();
        sTraceCpuIdle = this.mTraceCpuIdleBtn.getSelection();
        sTraceCpuLoad = this.mTraceCpuLoadBtn.getSelection();
        sTraceDiskIo = this.mTraceDiskIoBtn.getSelection();
        sTraceKernelWorkqueues = this.mTraceKernelWorkqueuesBtn.getSelection();
        sTraceCpuScheduler = this.mTraceCpuSchedulerBtn.getSelection();
        sGfxTag = this.mGfxTagBtn.getSelection();
        sInputTag = this.mInputTagBtn.getSelection();
        sViewTag = this.mViewTagBtn.getSelection();
        sWebViewTag = this.mWebViewTagBtn.getSelection();
        sWmTag = this.mWmTagBtn.getSelection();
        sAmTag = this.mAmTagBtn.getSelection();
        sSyncTag = this.mSyncTagBtn.getSelection();
        sAudioTag = this.mAudioTagBtn.getSelection();
        sViewTag = this.mViewTagBtn.getSelection();
        sCameraTag = this.mCameraTagBtn.getSelection();
        super.okPressed();
    }

    @Override
    public SystraceOptions getSystraceOptions() {
        return this.mOptions;
    }

    @Override
    public String getTraceFilePath() {
        return this.mDestinationPath;
    }

    private class SystraceOptions
    implements ISystraceOptions {
        private static final int TAG_GFX = 2;
        private static final int TAG_INPUT = 4;
        private static final int TAG_VIEW = 8;
        private static final int TAG_WEBVIEW = 16;
        private static final int TAG_WM = 32;
        private static final int TAG_AM = 64;
        private static final int TAG_SYNC = 128;
        private static final int TAG_AUDIO = 256;
        private static final int TAG_VIDEO = 512;
        private static final int TAG_CAMERA = 1024;
        private int mTraceBufferSize;
        private int mTraceDuration;
        private boolean mTraceCpuFreq;
        private boolean mTraceCpuIdle;
        private boolean mTraceCpuLoad;
        private boolean mTraceDiskIo;
        private boolean mTraceKernelWorkqueues;
        private boolean mTraceCpuScheduler;
        private int mTag;

        private SystraceOptions() {
        }

        private void enableTag(int n) {
            this.mTag |= n;
        }

        @Override
        public String getTags() {
            return this.mTag == 0 ? null : Integer.toHexString(this.mTag);
        }

        @Override
        public String getOptions() {
            StringBuilder stringBuilder = new StringBuilder(20);
            if (this.mTraceCpuFreq) {
                stringBuilder.append("-f ");
            }
            if (this.mTraceCpuIdle) {
                stringBuilder.append("-i ");
            }
            if (this.mTraceCpuLoad) {
                stringBuilder.append("-l ");
            }
            if (this.mTraceDiskIo) {
                stringBuilder.append("-d ");
            }
            if (this.mTraceKernelWorkqueues) {
                stringBuilder.append("-w ");
            }
            if (this.mTraceCpuScheduler) {
                stringBuilder.append("-s ");
            }
            if (this.mTraceDuration > 0) {
                stringBuilder.append("-t");
                stringBuilder.append(this.mTraceDuration);
                stringBuilder.append(' ');
            }
            if (this.mTraceBufferSize > 0) {
                stringBuilder.append("-b ");
                stringBuilder.append(this.mTraceBufferSize);
                stringBuilder.append(' ');
            }
            return stringBuilder.toString().trim();
        }
    }
}

