/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.views;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.explorer.DeviceExplorer;
import com.android.ide.eclipse.ddms.CommonAction;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.ide.eclipse.ddms.i18n.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class FileExplorerView
extends ViewPart
implements DdmsPlugin.ISelectionListener {
    public static final String ID = "com.android.ide.eclipse.ddms.views.FileExplorerView";
    private static final String COLUMN_NAME = "com.android.ide.eclipse.ddms.explorer.name";
    private static final String COLUMN_SIZE = "com.android.ide.eclipse.ddms.explorer.size";
    private static final String COLUMN_DATE = "com.android.ide.eclipse.ddms.explorer.data";
    private static final String COLUMN_TIME = "com.android.ide.eclipse.ddms.explorer.time";
    private static final String COLUMN_PERMISSIONS = "com.android.ide.eclipse.ddms.explorer.permissions";
    private static final String COLUMN_INFO = "com.android.ide.eclipse.ddms.explorer.info";
    private DeviceExplorer mExplorer;

    public void createPartControl(Composite composite) {
        ImageLoader imageLoader = ImageLoader.getDdmUiLibLoader();
        DeviceExplorer.COLUMN_NAME = COLUMN_NAME;
        DeviceExplorer.COLUMN_SIZE = COLUMN_SIZE;
        DeviceExplorer.COLUMN_DATE = COLUMN_DATE;
        DeviceExplorer.COLUMN_TIME = COLUMN_TIME;
        DeviceExplorer.COLUMN_PERMISSIONS = COLUMN_PERMISSIONS;
        DeviceExplorer.COLUMN_INFO = COLUMN_INFO;
        this.mExplorer = new DeviceExplorer();
        this.mExplorer.setCustomImages(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"), null, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS"));
        CommonAction commonAction = new CommonAction(Messages.FileExplorerView_Push_File){

            @Override
            public void run() {
                FileExplorerView.this.mExplorer.pushIntoSelection();
            }
        };
        commonAction.setToolTipText(Messages.FileExplorerView_Push_File_Onto_Device);
        commonAction.setImageDescriptor(imageLoader.loadDescriptor("push.png"));
        commonAction.setEnabled(false);
        CommonAction commonAction2 = new CommonAction(Messages.FileExplorerView_Pull_File){

            @Override
            public void run() {
                FileExplorerView.this.mExplorer.pullSelection();
            }
        };
        commonAction2.setToolTipText(Messages.FileExplorerView_Pull_File_From_File);
        commonAction2.setImageDescriptor(imageLoader.loadDescriptor("pull.png"));
        commonAction2.setEnabled(false);
        CommonAction commonAction3 = new CommonAction(Messages.FileExplorerView_Delete){

            @Override
            public void run() {
                FileExplorerView.this.mExplorer.deleteSelection();
            }
        };
        commonAction3.setToolTipText(Messages.FileExplorerView_Delete_The_Selection);
        commonAction3.setImageDescriptor(imageLoader.loadDescriptor("delete.png"));
        commonAction3.setEnabled(false);
        CommonAction commonAction4 = new CommonAction("New Folder"){

            @Override
            public void run() {
                FileExplorerView.this.mExplorer.createNewFolderInSelection();
            }
        };
        commonAction4.setToolTipText("New Folder");
        commonAction4.setImageDescriptor(imageLoader.loadDescriptor("add.png"));
        commonAction4.setEnabled(false);
        this.mExplorer.setActions((ICommonAction)commonAction, (ICommonAction)commonAction2, (ICommonAction)commonAction3, (ICommonAction)commonAction4);
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iMenuManager.add((IAction)commonAction2);
        iMenuManager.add((IAction)commonAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)commonAction3);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)commonAction4);
        iToolBarManager.add((IAction)commonAction2);
        iToolBarManager.add((IAction)commonAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)commonAction3);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)commonAction4);
        this.mExplorer.createPanel(composite);
        DdmsPlugin.getDefault().addSelectionListener(this);
    }

    public void setFocus() {
        this.mExplorer.setFocus();
    }

    @Override
    public void selectionChanged(Client client) {
    }

    @Override
    public void selectionChanged(IDevice iDevice) {
        this.mExplorer.switchDevice(iDevice);
    }

    public void selectionRemoved() {
    }
}

