/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.FileUtils;
import com.android.ide.eclipse.gltrace.GLEnum;
import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.state.GLState;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.BufferSubDataTransform;
import com.android.ide.eclipse.gltrace.state.transforms.CurrentProgramPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.CurrentVboPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.GLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IStateTransform;
import com.android.ide.eclipse.gltrace.state.transforms.ListElementAddTransform;
import com.android.ide.eclipse.gltrace.state.transforms.Predicates;
import com.android.ide.eclipse.gltrace.state.transforms.PropertyChangeTransform;
import com.android.ide.eclipse.gltrace.state.transforms.SparseArrayElementAddTransform;
import com.android.ide.eclipse.gltrace.state.transforms.SparseArrayElementRemoveTransform;
import com.android.ide.eclipse.gltrace.state.transforms.TexImageTransform;
import com.android.ide.eclipse.gltrace.state.transforms.TexturePropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.TextureUnitPropertyAccessor;
import com.google.common.io.Files;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class StateTransformFactory {
    private static final String TEXTURE_DATA_FILE_PREFIX = "tex";
    private static final String TEXTURE_DATA_FILE_SUFFIX = ".dat";

    public static List<IStateTransform> getTransformsFor(GLProtoBuf.GLMessage gLMessage) {
        switch (gLMessage.getFunction()) {
            case eglCreateContext: {
                return StateTransformFactory.transformsForEglCreateContext(gLMessage);
            }
            case glBindFramebuffer: {
                return StateTransformFactory.transformsForGlBindFramebuffer(gLMessage);
            }
            case glVertexAttribPointer: {
                return StateTransformFactory.transformsForGlVertexAttribPointer(gLMessage);
            }
            case glVertexAttrib1f: 
            case glVertexAttrib2f: 
            case glVertexAttrib3f: 
            case glVertexAttrib4f: {
                return StateTransformFactory.transformsForGlVertexAttribxf(gLMessage);
            }
            case glVertexAttrib1fv: 
            case glVertexAttrib2fv: 
            case glVertexAttrib3fv: 
            case glVertexAttrib4fv: {
                return StateTransformFactory.transformsForGlVertexAttribxfv(gLMessage);
            }
            case glEnableVertexAttribArray: {
                return StateTransformFactory.transformsForGlEnableVertexAttribArray(gLMessage);
            }
            case glDisableVertexAttribArray: {
                return StateTransformFactory.transformsForGlDisableVertexAttribArray(gLMessage);
            }
            case glBindBuffer: {
                return StateTransformFactory.transformsForGlBindBuffer(gLMessage);
            }
            case glGenBuffers: {
                return StateTransformFactory.transformsForGlGenBuffers(gLMessage);
            }
            case glDeleteBuffers: {
                return StateTransformFactory.transformsForGlDeleteBuffers(gLMessage);
            }
            case glBufferData: {
                return StateTransformFactory.transformsForGlBufferData(gLMessage);
            }
            case glBufferSubData: {
                return StateTransformFactory.transformsForGlBufferSubData(gLMessage);
            }
            case glViewport: {
                return StateTransformFactory.transformsForGlViewport(gLMessage);
            }
            case glDepthRangef: {
                return StateTransformFactory.transformsForGlDepthRangef(gLMessage);
            }
            case glLineWidth: {
                return StateTransformFactory.transformsForGlLineWidth(gLMessage);
            }
            case glCullFace: {
                return StateTransformFactory.transformsForGlCullFace(gLMessage);
            }
            case glFrontFace: {
                return StateTransformFactory.transformsForGlFrontFace(gLMessage);
            }
            case glPolygonOffset: {
                return StateTransformFactory.transformsForGlPolygonOffset(gLMessage);
            }
            case glScissor: {
                return StateTransformFactory.transformsForGlScissor(gLMessage);
            }
            case glStencilFunc: {
                return StateTransformFactory.transformsForGlStencilFunc(gLMessage);
            }
            case glStencilFuncSeparate: {
                return StateTransformFactory.transformsForGlStencilFuncSeparate(gLMessage);
            }
            case glStencilOp: {
                return StateTransformFactory.transformsForGlStencilOp(gLMessage);
            }
            case glStencilOpSeparate: {
                return StateTransformFactory.transformsForGlStencilOpSeparate(gLMessage);
            }
            case glDepthFunc: {
                return StateTransformFactory.transformsForGlDepthFunc(gLMessage);
            }
            case glBlendEquation: {
                return StateTransformFactory.transformsForGlBlendEquation(gLMessage);
            }
            case glBlendEquationSeparate: {
                return StateTransformFactory.transformsForGlBlendEquationSeparate(gLMessage);
            }
            case glBlendFunc: {
                return StateTransformFactory.transformsForGlBlendFunc(gLMessage);
            }
            case glBlendFuncSeparate: {
                return StateTransformFactory.transformsForGlBlendFuncSeparate(gLMessage);
            }
            case glPixelStorei: {
                return StateTransformFactory.transformsForGlPixelStorei(gLMessage);
            }
            case glGenTextures: {
                return StateTransformFactory.transformsForGlGenTextures(gLMessage);
            }
            case glDeleteTextures: {
                return StateTransformFactory.transformsForGlDeleteTextures(gLMessage);
            }
            case glActiveTexture: {
                return StateTransformFactory.transformsForGlActiveTexture(gLMessage);
            }
            case glBindTexture: {
                return StateTransformFactory.transformsForGlBindTexture(gLMessage);
            }
            case glTexImage2D: {
                return StateTransformFactory.transformsForGlTexImage2D(gLMessage);
            }
            case glTexSubImage2D: {
                return StateTransformFactory.transformsForGlTexSubImage2D(gLMessage);
            }
            case glTexParameteri: {
                return StateTransformFactory.transformsForGlTexParameter(gLMessage);
            }
            case glCreateProgram: {
                return StateTransformFactory.transformsForGlCreateProgram(gLMessage);
            }
            case glUseProgram: {
                return StateTransformFactory.transformsForGlUseProgram(gLMessage);
            }
            case glAttachShader: {
                return StateTransformFactory.transformsForGlAttachShader(gLMessage);
            }
            case glDetachShader: {
                return StateTransformFactory.transformsForGlDetachShader(gLMessage);
            }
            case glGetActiveAttrib: {
                return StateTransformFactory.transformsForGlGetActiveAttrib(gLMessage);
            }
            case glGetActiveUniform: {
                return StateTransformFactory.transformsForGlGetActiveUniform(gLMessage);
            }
            case glUniform1i: 
            case glUniform2i: 
            case glUniform3i: 
            case glUniform4i: {
                return StateTransformFactory.transformsForGlUniform(gLMessage, false);
            }
            case glUniform1f: 
            case glUniform2f: 
            case glUniform3f: 
            case glUniform4f: {
                return StateTransformFactory.transformsForGlUniform(gLMessage, true);
            }
            case glUniform1iv: 
            case glUniform2iv: 
            case glUniform3iv: 
            case glUniform4iv: {
                return StateTransformFactory.transformsForGlUniformv(gLMessage, false);
            }
            case glUniform1fv: 
            case glUniform2fv: 
            case glUniform3fv: 
            case glUniform4fv: {
                return StateTransformFactory.transformsForGlUniformv(gLMessage, true);
            }
            case glUniformMatrix2fv: 
            case glUniformMatrix3fv: 
            case glUniformMatrix4fv: {
                return StateTransformFactory.transformsForGlUniformMatrix(gLMessage);
            }
            case glCreateShader: {
                return StateTransformFactory.transformsForGlCreateShader(gLMessage);
            }
            case glDeleteShader: {
                return StateTransformFactory.transformsForGlDeleteShader(gLMessage);
            }
            case glShaderSource: {
                return StateTransformFactory.transformsForGlShaderSource(gLMessage);
            }
        }
        return Collections.emptyList();
    }

    private static List<IStateTransform> transformsForGlVertexAttribPointer(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        int n2 = gLMessage.getArgs(1).getIntValue(0);
        int n3 = gLMessage.getArgs(2).getIntValue(0);
        boolean bl = gLMessage.getArgs(3).getBoolValue(0);
        int n4 = gLMessage.getArgs(4).getIntValue(0);
        int n5 = gLMessage.getArgs(5).getIntValue(0);
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, n, GLStateType.VERTEX_ATTRIB_ARRAY_SIZE}), n2));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, n, GLStateType.VERTEX_ATTRIB_ARRAY_TYPE}), (Object)GLEnum.valueOf(n3)));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, n, GLStateType.VERTEX_ATTRIB_ARRAY_NORMALIZED}), bl));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, n, GLStateType.VERTEX_ATTRIB_ARRAY_STRIDE}), n4));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, n, GLStateType.VERTEX_ATTRIB_ARRAY_POINTER}), n5));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlVertexAttrib(int n, int n2, float f, float f2, float f3, float f4) {
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>(4);
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.GENERIC_VERTEX_ATTRIBUTES, n2, GLStateType.GENERIC_VERTEX_ATTRIB_V0}), Float.valueOf(f)));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.GENERIC_VERTEX_ATTRIBUTES, n2, GLStateType.GENERIC_VERTEX_ATTRIB_V1}), Float.valueOf(f2)));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.GENERIC_VERTEX_ATTRIBUTES, n2, GLStateType.GENERIC_VERTEX_ATTRIB_V2}), Float.valueOf(f3)));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.GENERIC_VERTEX_ATTRIBUTES, n2, GLStateType.GENERIC_VERTEX_ATTRIB_V3}), Float.valueOf(f4)));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlVertexAttribxf(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        float f = gLMessage.getArgs(1).getFloatValue(0);
        float f2 = gLMessage.getArgsCount() > 2 ? gLMessage.getArgs(2).getFloatValue(0) : 0.0f;
        float f3 = gLMessage.getArgsCount() > 3 ? gLMessage.getArgs(3).getFloatValue(0) : 0.0f;
        float f4 = gLMessage.getArgsCount() > 4 ? gLMessage.getArgs(4).getFloatValue(0) : 0.0f;
        return StateTransformFactory.transformsForGlVertexAttrib(gLMessage.getContextId(), n, f, f2, f3, f4);
    }

    private static List<IStateTransform> transformsForGlVertexAttribxfv(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        float[] fArray = new float[4];
        int n2 = 0;
        while (n2 < gLMessage.getArgs(1).getFloatValueList().size()) {
            fArray[n2] = gLMessage.getArgs(1).getFloatValue(n2);
            ++n2;
        }
        return StateTransformFactory.transformsForGlVertexAttrib(gLMessage.getContextId(), n, fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    private static List<IStateTransform> transformsForGlEnableVertexAttribArray(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, n, GLStateType.VERTEX_ATTRIB_ARRAY_ENABLED}), Boolean.TRUE);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlDisableVertexAttribArray(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, n, GLStateType.VERTEX_ATTRIB_ARRAY_ENABLED}), Boolean.FALSE);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlBindBuffer(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        int n = gLMessage.getArgs(1).getIntValue(0);
        GLStateType gLStateType = gLEnum == GLEnum.GL_ARRAY_BUFFER ? GLStateType.ARRAY_BUFFER_BINDING : GLStateType.ELEMENT_ARRAY_BUFFER_BINDING;
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.BUFFER_BINDINGS, gLStateType}), n);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlGenBuffers(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VBO}), gLMessage.getArgs(1).getIntValue(n2)));
            ++n2;
        }
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlDeleteBuffers(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(new SparseArrayElementRemoveTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VBO}), gLMessage.getArgs(1).getIntValue(n2)));
            ++n2;
        }
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlBufferData(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        int n = gLMessage.getArgs(1).getIntValue(0);
        byte[] byArray = null;
        GLEnum gLEnum2 = GLEnum.valueOf(gLMessage.getArgs(3).getIntValue(0));
        byArray = gLMessage.getArgs(2).getRawBytesList().size() > 0 ? gLMessage.getArgs(2).getRawBytesList().get(0).toByteArray() : new byte[n];
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(new PropertyChangeTransform(new CurrentVboPropertyAccessor(gLMessage.getContextId(), gLEnum, GLStateType.BUFFER_SIZE), n));
        arrayList.add(new PropertyChangeTransform(new CurrentVboPropertyAccessor(gLMessage.getContextId(), gLEnum, GLStateType.BUFFER_DATA), byArray));
        arrayList.add(new PropertyChangeTransform(new CurrentVboPropertyAccessor(gLMessage.getContextId(), gLEnum, GLStateType.BUFFER_USAGE), (Object)gLEnum2));
        arrayList.add(new PropertyChangeTransform(new CurrentVboPropertyAccessor(gLMessage.getContextId(), gLEnum, GLStateType.BUFFER_TYPE), (Object)gLEnum));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlBufferSubData(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        int n = gLMessage.getArgs(1).getIntValue(0);
        byte[] byArray = gLMessage.getArgs(3).getRawBytesList().get(0).toByteArray();
        BufferSubDataTransform bufferSubDataTransform = new BufferSubDataTransform(new CurrentVboPropertyAccessor(gLMessage.getContextId(), gLEnum, GLStateType.BUFFER_DATA), n, byArray);
        return Collections.singletonList(bufferSubDataTransform);
    }

    private static List<IStateTransform> transformsForGlBindFramebuffer(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(1).getIntValue(0);
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.FRAMEBUFFER_STATE, GLStateType.FRAMEBUFFER_BINDING}), n);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlLineWidth(GLProtoBuf.GLMessage gLMessage) {
        float f = gLMessage.getArgs(0).getFloatValue(0);
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.RASTERIZATION_STATE, GLStateType.LINE_WIDTH}), Float.valueOf(f));
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlCullFace(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.RASTERIZATION_STATE, GLStateType.CULL_FACE_MODE}), (Object)GLEnum.valueOf(n));
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlFrontFace(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.RASTERIZATION_STATE, GLStateType.FRONT_FACE}), (Object)GLEnum.valueOf(n));
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlPolygonOffset(GLProtoBuf.GLMessage gLMessage) {
        float f = gLMessage.getArgs(0).getFloatValue(0);
        float f2 = gLMessage.getArgs(1).getFloatValue(0);
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.RASTERIZATION_STATE, GLStateType.POLYGON_OFFSET_FACTOR}), Float.valueOf(f)));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.RASTERIZATION_STATE, GLStateType.POLYGON_OFFSET_UNITS}), Float.valueOf(f2)));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlScissor(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        int n2 = gLMessage.getArgs(1).getIntValue(0);
        int n3 = gLMessage.getArgs(2).getIntValue(0);
        int n4 = gLMessage.getArgs(3).getIntValue(0);
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.SCISSOR_BOX, GLStateType.SCISSOR_BOX_X}), n));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.SCISSOR_BOX, GLStateType.SCISSOR_BOX_Y}), n2));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.SCISSOR_BOX, GLStateType.SCISSOR_BOX_WIDTH}), n3));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.SCISSOR_BOX, GLStateType.SCISSOR_BOX_HEIGHT}), n4));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlStencilFuncFront(int n, GLEnum gLEnum, int n2, int n3) {
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_FUNC}), (Object)gLEnum));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_REF}), n2));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_VALUE_MASK}), n3));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlStencilFuncBack(int n, GLEnum gLEnum, int n2, int n3) {
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_FUNC}), (Object)gLEnum));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_REF}), n2));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_VALUE_MASK}), n3));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlStencilFunc(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        int n = gLMessage.getArgs(1).getIntValue(0);
        int n2 = gLMessage.getArgs(2).getIntValue(0);
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.addAll(StateTransformFactory.transformsForGlStencilFuncFront(gLMessage.getContextId(), gLEnum, n, n2));
        arrayList.addAll(StateTransformFactory.transformsForGlStencilFuncBack(gLMessage.getContextId(), gLEnum, n, n2));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlStencilFuncSeparate(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        GLEnum gLEnum2 = GLEnum.valueOf(gLMessage.getArgs(1).getIntValue(0));
        int n = gLMessage.getArgs(2).getIntValue(0);
        int n2 = gLMessage.getArgs(3).getIntValue(0);
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        if (gLEnum == GLEnum.GL_FRONT || gLEnum == GLEnum.GL_FRONT_AND_BACK) {
            arrayList.addAll(StateTransformFactory.transformsForGlStencilFuncFront(gLMessage.getContextId(), gLEnum2, n, n2));
        }
        if (gLEnum == GLEnum.GL_BACK || gLEnum == GLEnum.GL_FRONT_AND_BACK) {
            arrayList.addAll(StateTransformFactory.transformsForGlStencilFuncBack(gLMessage.getContextId(), gLEnum2, n, n2));
        }
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlStencilOpFront(int n, GLEnum gLEnum, GLEnum gLEnum2, GLEnum gLEnum3) {
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_FAIL}), (Object)gLEnum));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_PASS_DEPTH_FAIL}), (Object)gLEnum2));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_PASS_DEPTH_PASS}), (Object)gLEnum3));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlStencilOpBack(int n, GLEnum gLEnum, GLEnum gLEnum2, GLEnum gLEnum3) {
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_FAIL}), (Object)gLEnum));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_PASS_DEPTH_FAIL}), (Object)gLEnum2));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_PASS_DEPTH_PASS}), (Object)gLEnum3));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlStencilOp(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        GLEnum gLEnum2 = GLEnum.valueOf(gLMessage.getArgs(1).getIntValue(0));
        GLEnum gLEnum3 = GLEnum.valueOf(gLMessage.getArgs(2).getIntValue(0));
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.addAll(StateTransformFactory.transformsForGlStencilOpFront(gLMessage.getContextId(), gLEnum, gLEnum2, gLEnum3));
        arrayList.addAll(StateTransformFactory.transformsForGlStencilOpBack(gLMessage.getContextId(), gLEnum, gLEnum2, gLEnum3));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlStencilOpSeparate(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        GLEnum gLEnum2 = GLEnum.valueOf(gLMessage.getArgs(1).getIntValue(0));
        GLEnum gLEnum3 = GLEnum.valueOf(gLMessage.getArgs(2).getIntValue(0));
        GLEnum gLEnum4 = GLEnum.valueOf(gLMessage.getArgs(3).getIntValue(0));
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        if (gLEnum == GLEnum.GL_FRONT || gLEnum == GLEnum.GL_FRONT_AND_BACK) {
            arrayList.addAll(StateTransformFactory.transformsForGlStencilOpFront(gLMessage.getContextId(), gLEnum2, gLEnum3, gLEnum4));
        }
        if (gLEnum == GLEnum.GL_BACK || gLEnum == GLEnum.GL_FRONT_AND_BACK) {
            arrayList.addAll(StateTransformFactory.transformsForGlStencilOpBack(gLMessage.getContextId(), gLEnum2, gLEnum3, gLEnum4));
        }
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlDepthFunc(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.DEPTH_FUNC}), (Object)gLEnum);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static IStateTransform transformForGlEquationRGB(int n, GLEnum gLEnum) {
        return new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.BLEND, GLStateType.BLEND_EQUATION_RGB}), (Object)gLEnum);
    }

    private static IStateTransform transformForGlEquationAlpha(int n, GLEnum gLEnum) {
        return new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.BLEND, GLStateType.BLEND_EQUATION_ALPHA}), (Object)gLEnum);
    }

    private static List<IStateTransform> transformsForGlBlendEquationSeparate(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        GLEnum gLEnum2 = GLEnum.valueOf(gLMessage.getArgs(1).getIntValue(0));
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(StateTransformFactory.transformForGlEquationRGB(gLMessage.getContextId(), gLEnum));
        arrayList.add(StateTransformFactory.transformForGlEquationAlpha(gLMessage.getContextId(), gLEnum2));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlBlendEquation(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(StateTransformFactory.transformForGlEquationRGB(gLMessage.getContextId(), gLEnum));
        arrayList.add(StateTransformFactory.transformForGlEquationAlpha(gLMessage.getContextId(), gLEnum));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlBlendFuncSrcDst(boolean bl, int n, GLEnum gLEnum, GLEnum gLEnum2) {
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        GLStateType gLStateType = GLStateType.BLEND_DST_RGB;
        GLStateType gLStateType2 = GLStateType.BLEND_DST_ALPHA;
        if (bl) {
            gLStateType = GLStateType.BLEND_SRC_RGB;
            gLStateType2 = GLStateType.BLEND_SRC_ALPHA;
        }
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.BLEND, gLStateType}), (Object)gLEnum));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.BLEND, gLStateType2}), (Object)gLEnum2));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlBlendFuncSeparate(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        GLEnum gLEnum2 = GLEnum.valueOf(gLMessage.getArgs(1).getIntValue(0));
        GLEnum gLEnum3 = GLEnum.valueOf(gLMessage.getArgs(2).getIntValue(0));
        GLEnum gLEnum4 = GLEnum.valueOf(gLMessage.getArgs(3).getIntValue(0));
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.addAll(StateTransformFactory.transformsForGlBlendFuncSrcDst(true, gLMessage.getContextId(), gLEnum, gLEnum3));
        arrayList.addAll(StateTransformFactory.transformsForGlBlendFuncSrcDst(false, gLMessage.getContextId(), gLEnum2, gLEnum4));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlBlendFunc(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        GLEnum gLEnum2 = GLEnum.valueOf(gLMessage.getArgs(1).getIntValue(0));
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.addAll(StateTransformFactory.transformsForGlBlendFuncSrcDst(true, gLMessage.getContextId(), gLEnum, gLEnum));
        arrayList.addAll(StateTransformFactory.transformsForGlBlendFuncSrcDst(false, gLMessage.getContextId(), gLEnum2, gLEnum2));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlPixelStorei(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        Integer n = gLMessage.getArgs(1).getIntValue(0);
        PropertyChangeTransform propertyChangeTransform = gLEnum == GLEnum.GL_PACK_ALIGNMENT ? new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PIXEL_PACKING, GLStateType.PACK_ALIGNMENT}), n) : new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PIXEL_PACKING, GLStateType.UNPACK_ALIGNMENT}), n);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlViewport(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        int n2 = gLMessage.getArgs(1).getIntValue(0);
        int n3 = gLMessage.getArgs(2).getIntValue(0);
        int n4 = gLMessage.getArgs(3).getIntValue(0);
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.VIEWPORT, GLStateType.VIEWPORT_X}), n));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.VIEWPORT, GLStateType.VIEWPORT_Y}), n2));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.VIEWPORT, GLStateType.VIEWPORT_WIDTH}), n3));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.VIEWPORT, GLStateType.VIEWPORT_HEIGHT}), n4));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlDepthRangef(GLProtoBuf.GLMessage gLMessage) {
        float f = gLMessage.getArgs(0).getFloatValue(0);
        float f2 = gLMessage.getArgs(1).getFloatValue(0);
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.DEPTH_RANGE, GLStateType.DEPTH_RANGE_NEAR}), Float.valueOf(f)));
        arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.DEPTH_RANGE, GLStateType.DEPTH_RANGE_FAR}), Float.valueOf(f2)));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlGenTextures(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        int n2 = 0;
        while (n2 < n) {
            int n3 = gLMessage.getArgs(1).getIntValue(n2);
            arrayList.add(new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURES}), n3));
            ++n2;
        }
        return arrayList;
    }

    private static List<IStateTransform> transformsToResetBoundTextureUnits(int n, int n2) {
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>(16);
        int n3 = 0;
        while (n3 < 16) {
            arrayList.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(n, new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURE_UNITS, n3, GLStateType.TEXTURE_BINDING_2D}), 0, Predicates.matchesInteger(n2)));
            ++n3;
        }
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlDeleteTextures(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = gLMessage.getArgs(1).getIntValue(n2);
            arrayList.add(new SparseArrayElementRemoveTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURES}), n3));
            arrayList.addAll(StateTransformFactory.transformsToResetBoundTextureUnits(gLMessage.getContextId(), n3));
            ++n2;
        }
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlActiveTexture(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        Integer n = gLEnum.value - GLEnum.GL_TEXTURE0.value;
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.TEXTURE_STATE, GLStateType.ACTIVE_TEXTURE_UNIT}), n);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static GLStateType getTextureUnitTargetName(GLEnum gLEnum) {
        if (gLEnum == GLEnum.GL_TEXTURE_CUBE_MAP) {
            return GLStateType.TEXTURE_BINDING_CUBE_MAP;
        }
        if (gLEnum == GLEnum.GL_TEXTURE_EXTERNAL) {
            return GLStateType.TEXTURE_BINDING_EXTERNAL;
        }
        return GLStateType.TEXTURE_BINDING_2D;
    }

    private static GLStateType getTextureTargetName(GLEnum gLEnum) {
        switch (gLEnum) {
            case GL_TEXTURE_MIN_FILTER: {
                return GLStateType.TEXTURE_MIN_FILTER;
            }
            case GL_TEXTURE_MAG_FILTER: {
                return GLStateType.TEXTURE_MAG_FILTER;
            }
            case GL_TEXTURE_WRAP_S: {
                return GLStateType.TEXTURE_WRAP_S;
            }
            case GL_TEXTURE_WRAP_T: {
                return GLStateType.TEXTURE_WRAP_T;
            }
        }
        assert (false) : "glTexParameter's pname argument does not support provided value.";
        return GLStateType.TEXTURE_MIN_FILTER;
    }

    private static List<IStateTransform> transformsForGlBindTexture(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        Integer n = gLMessage.getArgs(1).getIntValue(0);
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(new TextureUnitPropertyAccessor(gLMessage.getContextId(), StateTransformFactory.getTextureUnitTargetName(gLEnum)), n);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlTexImage(GLProtoBuf.GLMessage gLMessage, int n, int n2, int n3, int n4) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        int n5 = gLMessage.getArgs(1).getIntValue(0);
        Integer n6 = gLMessage.getArgs(n).getIntValue(0);
        Integer n7 = gLMessage.getArgs(n2).getIntValue(0);
        GLEnum gLEnum2 = GLEnum.valueOf(gLMessage.getArgs(6).getIntValue(0));
        GLEnum gLEnum3 = GLEnum.valueOf(gLMessage.getArgs(7).getIntValue(0));
        ArrayList<IStateTransform> arrayList = new ArrayList<IStateTransform>();
        arrayList.add(new PropertyChangeTransform(new TexturePropertyAccessor(gLMessage.getContextId(), StateTransformFactory.getTextureUnitTargetName(gLEnum), n5, GLStateType.TEXTURE_WIDTH), n6));
        arrayList.add(new PropertyChangeTransform(new TexturePropertyAccessor(gLMessage.getContextId(), StateTransformFactory.getTextureUnitTargetName(gLEnum), n5, GLStateType.TEXTURE_HEIGHT), n7));
        arrayList.add(new PropertyChangeTransform(new TexturePropertyAccessor(gLMessage.getContextId(), StateTransformFactory.getTextureUnitTargetName(gLEnum), n5, GLStateType.TEXTURE_FORMAT), (Object)gLEnum2));
        arrayList.add(new PropertyChangeTransform(new TexturePropertyAccessor(gLMessage.getContextId(), StateTransformFactory.getTextureUnitTargetName(gLEnum), n5, GLStateType.TEXTURE_IMAGE_TYPE), (Object)gLEnum3));
        File file = null;
        if (gLMessage.getArgs(8).getIsArray()) {
            ByteString byteString = gLMessage.getArgs(8).getRawBytes(0);
            file = FileUtils.createTempFile(TEXTURE_DATA_FILE_PREFIX, TEXTURE_DATA_FILE_SUFFIX);
            try {
                Files.write((byte[])byteString.toByteArray(), (File)file);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        int n8 = 0;
        int n9 = 0;
        if (n3 >= 0) {
            n8 = gLMessage.getArgs(n3).getIntValue(0);
        }
        if (n4 >= 0) {
            n9 = gLMessage.getArgs(n4).getIntValue(0);
        }
        arrayList.add(new TexImageTransform(new TexturePropertyAccessor(gLMessage.getContextId(), StateTransformFactory.getTextureUnitTargetName(gLEnum), n5, GLStateType.TEXTURE_IMAGE), file, gLEnum2, gLEnum3, n8, n9, n6, n7));
        return arrayList;
    }

    private static List<IStateTransform> transformsForGlTexImage2D(GLProtoBuf.GLMessage gLMessage) {
        return StateTransformFactory.transformsForGlTexImage(gLMessage, 3, 4, -1, -1);
    }

    private static List<IStateTransform> transformsForGlTexSubImage2D(GLProtoBuf.GLMessage gLMessage) {
        return StateTransformFactory.transformsForGlTexImage(gLMessage, 4, 5, 2, 3);
    }

    private static List<IStateTransform> transformsForGlTexParameter(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        GLEnum gLEnum2 = GLEnum.valueOf(gLMessage.getArgs(1).getIntValue(0));
        GLEnum gLEnum3 = GLEnum.valueOf(gLMessage.getArgs(2).getIntValue(0));
        if (gLEnum2 != GLEnum.GL_TEXTURE_MIN_FILTER && gLEnum2 != GLEnum.GL_TEXTURE_MAG_FILTER && gLEnum2 != GLEnum.GL_TEXTURE_WRAP_S && gLEnum2 != GLEnum.GL_TEXTURE_WRAP_T) {
            throw new IllegalArgumentException(String.format("Unsupported parameter (%s) for glTexParameter()", new Object[]{gLEnum2}));
        }
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(new TexturePropertyAccessor(gLMessage.getContextId(), StateTransformFactory.getTextureUnitTargetName(gLEnum), StateTransformFactory.getTextureTargetName(gLEnum2)), (Object)gLEnum3);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlCreateProgram(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getReturnValue().getIntValue(0);
        SparseArrayElementAddTransform sparseArrayElementAddTransform = new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS}), n);
        return Collections.singletonList(sparseArrayElementAddTransform);
    }

    private static List<IStateTransform> transformsForGlUseProgram(GLProtoBuf.GLMessage gLMessage) {
        Integer n = gLMessage.getArgs(0).getIntValue(0);
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.CURRENT_PROGRAM}), n);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlAttachShader(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        int n2 = gLMessage.getArgs(1).getIntValue(0);
        SparseArrayElementAddTransform sparseArrayElementAddTransform = new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, n, GLStateType.ATTACHED_SHADERS}), n2);
        return Collections.singletonList(sparseArrayElementAddTransform);
    }

    private static List<IStateTransform> transformsForGlDetachShader(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        int n2 = gLMessage.getArgs(1).getIntValue(0);
        SparseArrayElementRemoveTransform sparseArrayElementRemoveTransform = new SparseArrayElementRemoveTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, n, GLStateType.ATTACHED_SHADERS}), n2);
        return Collections.singletonList(sparseArrayElementRemoveTransform);
    }

    private static List<IStateTransform> transformsForGlGetActiveAttribOrUniform(GLProtoBuf.GLMessage gLMessage, boolean bl) {
        GLStateType gLStateType;
        GLStateType gLStateType2;
        GLStateType gLStateType3;
        GLStateType gLStateType4;
        int n = gLMessage.getArgs(0).getIntValue(0);
        int n2 = gLMessage.getArgs(4).getIntValue(0);
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(5).getIntValue(0));
        String string = gLMessage.getArgs(6).getCharValue(0).toStringUtf8();
        int n3 = gLMessage.getArgs(7).getIntValue(0);
        if (bl) {
            gLStateType4 = GLStateType.ACTIVE_ATTRIBUTES;
            gLStateType3 = GLStateType.ATTRIBUTE_NAME;
            gLStateType2 = GLStateType.ATTRIBUTE_TYPE;
            gLStateType = GLStateType.ATTRIBUTE_SIZE;
        } else {
            gLStateType4 = GLStateType.ACTIVE_UNIFORMS;
            gLStateType3 = GLStateType.UNIFORM_NAME;
            gLStateType2 = GLStateType.UNIFORM_TYPE;
            gLStateType = GLStateType.UNIFORM_SIZE;
        }
        SparseArrayElementAddTransform sparseArrayElementAddTransform = new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, n, gLStateType4}), n3);
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, n, gLStateType4, n3, gLStateType3}), string);
        PropertyChangeTransform propertyChangeTransform2 = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, n, gLStateType4, n3, gLStateType2}), (Object)gLEnum);
        PropertyChangeTransform propertyChangeTransform3 = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, n, gLStateType4, n3, gLStateType}), n2);
        return Arrays.asList(sparseArrayElementAddTransform, propertyChangeTransform, propertyChangeTransform2, propertyChangeTransform3);
    }

    private static List<IStateTransform> transformsForGlGetActiveAttrib(GLProtoBuf.GLMessage gLMessage) {
        return StateTransformFactory.transformsForGlGetActiveAttribOrUniform(gLMessage, true);
    }

    private static List<IStateTransform> transformsForGlGetActiveUniform(GLProtoBuf.GLMessage gLMessage) {
        return StateTransformFactory.transformsForGlGetActiveAttribOrUniform(gLMessage, false);
    }

    private static List<IStateTransform> transformsForGlUniformMatrix(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        List<Float> list = gLMessage.getArgs(3).getFloatValueList();
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(new CurrentProgramPropertyAccessor(gLMessage.getContextId(), GLStateType.ACTIVE_UNIFORMS, n, GLStateType.UNIFORM_VALUE), list);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlUniformv(GLProtoBuf.GLMessage gLMessage, boolean bl) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        List<Number> list = bl ? gLMessage.getArgs(2).getFloatValueList() : gLMessage.getArgs(2).getIntValueList();
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(new CurrentProgramPropertyAccessor(gLMessage.getContextId(), GLStateType.ACTIVE_UNIFORMS, n, GLStateType.UNIFORM_VALUE), list);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlUniform(GLProtoBuf.GLMessage gLMessage, boolean bl) {
        ArrayList<Number> arrayList;
        Object object;
        int n = gLMessage.getArgs(0).getIntValue(0);
        if (n < 0) {
            throw new IllegalArgumentException("Argument location cannot be less than 0.");
        }
        if (bl) {
            object = new ArrayList<Number>(gLMessage.getArgsCount() - 1);
            int n2 = 1;
            while (n2 < gLMessage.getArgsCount()) {
                object.add(Float.valueOf(gLMessage.getArgs(1).getFloatValue(0)));
                ++n2;
            }
            arrayList = object;
        } else {
            object = new ArrayList(gLMessage.getArgsCount() - 1);
            int n3 = 1;
            while (n3 < gLMessage.getArgsCount()) {
                object.add(gLMessage.getArgs(1).getIntValue(0));
                ++n3;
            }
            arrayList = object;
        }
        object = new PropertyChangeTransform(new CurrentProgramPropertyAccessor(gLMessage.getContextId(), GLStateType.ACTIVE_UNIFORMS, n, GLStateType.UNIFORM_VALUE), arrayList);
        return Collections.singletonList(object);
    }

    private static List<IStateTransform> transformsForGlCreateShader(GLProtoBuf.GLMessage gLMessage) {
        GLEnum gLEnum = GLEnum.valueOf(gLMessage.getArgs(0).getIntValue(0));
        int n = gLMessage.getReturnValue().getIntValue(0);
        SparseArrayElementAddTransform sparseArrayElementAddTransform = new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.SHADERS}), n);
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.SHADERS, n, GLStateType.SHADER_TYPE}), (Object)gLEnum);
        return Arrays.asList(sparseArrayElementAddTransform, propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForGlDeleteShader(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        SparseArrayElementRemoveTransform sparseArrayElementRemoveTransform = new SparseArrayElementRemoveTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.SHADERS}), n);
        return Collections.singletonList(sparseArrayElementRemoveTransform);
    }

    private static List<IStateTransform> transformsForGlShaderSource(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        String string = gLMessage.getArgs(2).getCharValue(0).toStringUtf8();
        PropertyChangeTransform propertyChangeTransform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(gLMessage.getContextId(), new Object[]{GLStateType.SHADERS, n, GLStateType.SHADER_SOURCE}), string);
        return Collections.singletonList(propertyChangeTransform);
    }

    private static List<IStateTransform> transformsForEglCreateContext(GLProtoBuf.GLMessage gLMessage) {
        int n = gLMessage.getArgs(0).getIntValue(0);
        IGLProperty iGLProperty = null;
        iGLProperty = n == 0 ? GLState.createDefaultES1State() : GLState.createDefaultES2State();
        ListElementAddTransform listElementAddTransform = new ListElementAddTransform(null, iGLProperty);
        return Collections.singletonList(listElementAddTransform);
    }
}

