/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner;

import com.android.chimpchat.core.IChimpView;
import com.android.monkeyrunner.JythonUtils;
import com.android.monkeyrunner.MonkeyRect;
import com.android.monkeyrunner.doc.MonkeyRunnerExported;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.logging.Logger;
import org.python.core.ArgParser;
import org.python.core.ClassDictInit;
import org.python.core.PyBoolean;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

@MonkeyRunnerExported(doc="Represents a view object.")
public class MonkeyView
extends PyObject
implements ClassDictInit {
    private static final Logger LOG = Logger.getLogger(MonkeyView.class.getName());
    private IChimpView impl;

    public static void classDictInit(PyObject pyObject) {
        JythonUtils.convertDocAnnotationsForClass(MonkeyView.class, pyObject);
    }

    public MonkeyView(IChimpView iChimpView) {
        this.impl = iChimpView;
    }

    @MonkeyRunnerExported(doc="Get the checked status of the view", returns="A boolean value for whether the item is checked or not")
    public PyBoolean getChecked(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        return new PyBoolean(this.impl.getChecked());
    }

    @MonkeyRunnerExported(doc="Returns the class name of the view", returns="The class name of the view as a string")
    public PyString getViewClass(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        return new PyString(this.impl.getViewClass());
    }

    @MonkeyRunnerExported(doc="Returns the text contained by the view", returns="The text contained in the view")
    public PyString getText(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        return new PyString(this.impl.getText());
    }

    @MonkeyRunnerExported(doc="Returns the location of the view in the form of a MonkeyRect", returns="The location of the view as a MonkeyRect object")
    public MonkeyRect getLocation(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        return new MonkeyRect(this.impl.getLocation());
    }

    @MonkeyRunnerExported(doc="Returns the enabled status of the view", returns="The enabled status of the view as a boolean")
    public PyBoolean getEnabled(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        return new PyBoolean(this.impl.getEnabled());
    }

    @MonkeyRunnerExported(doc="Returns the selected status of the view", returns="The selected status of the view as a boolean")
    public PyBoolean getSelected(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        return new PyBoolean(this.impl.getSelected());
    }

    @MonkeyRunnerExported(doc="Sets the selected status of the view", args={"selected"}, argDocs={"The boolean value to set selected to"})
    public void setSelected(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        PyBoolean pyBoolean = (PyBoolean)argParser.getPyObject(0, (PyObject)new PyBoolean(false));
        boolean bl = (Boolean)pyBoolean.__tojava__(Boolean.class);
        this.impl.setSelected(bl);
    }

    @MonkeyRunnerExported(doc="Returns the focused status of the view", returns="The focused status of the view as a boolean")
    public PyBoolean getFocused(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        return new PyBoolean(this.impl.getFocused());
    }

    @MonkeyRunnerExported(doc="Sets the focused status of the view", args={"focused"}, argDocs={"The boolean value to set focused to"})
    public void setFocused(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        PyBoolean pyBoolean = (PyBoolean)argParser.getPyObject(0, (PyObject)new PyBoolean(false));
        boolean bl = (Boolean)pyBoolean.__tojava__(Boolean.class);
        this.impl.setFocused(bl);
    }

    @MonkeyRunnerExported(doc="Returns the parent of the current view", returns="The parent of the view as a MonkeyView object")
    public MonkeyView getParent(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        MonkeyView monkeyView = new MonkeyView(this.impl.getParent());
        return monkeyView;
    }

    @MonkeyRunnerExported(doc="Returns the children of the current view", returns="The children of the view as a list of MonkeyView objects")
    public PyList getChildren(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        List list = this.impl.getChildren();
        PyList pyList = new PyList();
        for (IChimpView iChimpView : list) {
            pyList.append((PyObject)new MonkeyView(iChimpView));
        }
        return pyList;
    }

    @MonkeyRunnerExported(doc="Returns the accessibility ids of the current view", returns="The accessibility ids of the view as a list of ints")
    public PyList getAccessibilityIds(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        int[] nArray = this.impl.getAccessibilityIds();
        PyList pyList = new PyList();
        for (int i = 0; i < nArray.length; ++i) {
            pyList.append((PyObject)new PyInteger(nArray[i]));
        }
        return pyList;
    }
}

