/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner;

import com.android.monkeyrunner.MonkeyRunnerOptions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.JLineConsole;
import org.python.util.PythonInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptRunner {
    private static final Logger LOG = Logger.getLogger(MonkeyRunnerOptions.class.getName());
    private final Object scope;
    private final String variable;

    private ScriptRunner(Object object, String string) {
        this.scope = object;
        this.variable = string;
    }

    public static ScriptRunner newInstance(Object object, String string) {
        return new ScriptRunner(object, string);
    }

    public static int run(String string, String string2, Collection<String> collection, Map<String, Predicate<PythonInterpreter>> map) {
        File file = new File(string2);
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{file.getParent()});
        arrayList.addAll(map.keySet());
        String[] stringArray = new String[collection.size() + 1];
        stringArray[0] = file.getAbsolutePath();
        int n = 1;
        for (String object : collection) {
            stringArray[n++] = object;
        }
        ScriptRunner.initPython(string, arrayList, stringArray);
        PythonInterpreter pythonInterpreter = new PythonInterpreter();
        for (Map.Entry<String, Predicate<PythonInterpreter>> entry : map.entrySet()) {
            boolean bl;
            try {
                bl = entry.getValue().apply((Object)pythonInterpreter);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Plugin Main through an exception.", exception);
                continue;
            }
            if (bl) continue;
            LOG.severe("Plugin Main returned error for: " + entry.getKey());
        }
        pythonInterpreter.set("__name__", (Object)"__main__");
        pythonInterpreter.set("__file__", (Object)string2);
        try {
            pythonInterpreter.execfile(string2);
        }
        catch (PyException pyException) {
            if (Py.SystemExit.equals((Object)pyException.type)) {
                return (Integer)pyException.value.__tojava__(Integer.class);
            }
            LOG.log(Level.SEVERE, "Script terminated due to an exception", pyException);
            return 1;
        }
        return 0;
    }

    public static void runString(String string, String string2) {
        ScriptRunner.initPython(string);
        PythonInterpreter pythonInterpreter = new PythonInterpreter();
        pythonInterpreter.exec(string2);
    }

    public static Map<String, PyObject> runStringAndGet(String string, String string2, String ... stringArray) {
        return ScriptRunner.runStringAndGet(string, string2, Arrays.asList(stringArray));
    }

    public static Map<String, PyObject> runStringAndGet(String string, String string2, Collection<String> collection) {
        ScriptRunner.initPython(string);
        PythonInterpreter pythonInterpreter = new PythonInterpreter();
        pythonInterpreter.exec(string2);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String string3 : collection) {
            builder.put((Object)string3, (Object)pythonInterpreter.get(string3));
        }
        return builder.build();
    }

    private static void initPython(String string) {
        List<String> list = Collections.emptyList();
        ScriptRunner.initPython(string, list, new String[]{""});
    }

    private static void initPython(String string, Collection<String> collection, String[] stringArray) {
        Properties properties = new Properties();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("java.class.path"));
        for (String object2 : collection) {
            stringBuilder.append(":").append(object2);
        }
        properties.setProperty("python.path", stringBuilder.toString());
        properties.setProperty("python.verbose", "error");
        properties.setProperty("python.executable", string);
        PythonInterpreter.initialize((Properties)System.getProperties(), (Properties)properties, (String[])stringArray);
        String string2 = System.getProperty("java.ext.dirs");
        File file = new File(string2, "monkeyrunner.jar");
        if (file.canRead()) {
            PySystemState.packageManager.addJar(file.getAbsolutePath(), false);
        }
    }

    public static void console(String string) {
        ScriptRunner.initPython(string);
        JLineConsole jLineConsole = new JLineConsole();
        jLineConsole.interact();
    }
}

