/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner.easy;

import com.android.chimpchat.core.TouchPressType;
import com.android.chimpchat.hierarchyviewer.HierarchyViewer;
import com.android.hierarchyviewerlib.device.ViewNode;
import com.android.monkeyrunner.JythonUtils;
import com.android.monkeyrunner.MonkeyDevice;
import com.android.monkeyrunner.doc.MonkeyRunnerExported;
import com.android.monkeyrunner.easy.By;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import org.python.core.ArgParser;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyTuple;

@MonkeyRunnerExported(doc="MonkeyDevice with easier methods to refer to objects.")
public class EasyMonkeyDevice
extends PyObject
implements ClassDictInit {
    private MonkeyDevice mDevice;
    private HierarchyViewer mHierarchyViewer;
    private static final Set<String> EXPORTED_METHODS = JythonUtils.getMethodNames(EasyMonkeyDevice.class);

    public static void classDictInit(PyObject pyObject) {
        JythonUtils.convertDocAnnotationsForClass(EasyMonkeyDevice.class, pyObject);
    }

    @MonkeyRunnerExported(doc="Creates EasyMonkeyDevice with an underlying MonkeyDevice.", args={"device"}, argDocs={"MonkeyDevice to extend."})
    public EasyMonkeyDevice(MonkeyDevice monkeyDevice) {
        this.mDevice = monkeyDevice;
        this.mHierarchyViewer = monkeyDevice.getImpl().getHierarchyViewer();
    }

    @MonkeyRunnerExported(doc="Sends a touch event to the selected object.", args={"selector", "type"}, argDocs={"The selector identifying the object.", "The event type as returned by TouchPressType()."})
    public void touch(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        By by = this.getSelector(argParser, 0);
        String string = argParser.getString(1);
        TouchPressType touchPressType = TouchPressType.fromIdentifier((String)string);
        Preconditions.checkNotNull((Object)touchPressType, (Object)("Invalid touch type: " + string));
        this.touch(by, touchPressType);
    }

    public void touch(By by, TouchPressType touchPressType) {
        Point point = this.getElementCenter(by);
        this.mDevice.getImpl().touch(point.x, point.y, touchPressType);
    }

    @MonkeyRunnerExported(doc="Types a string into the specified object.", args={"selector", "text"}, argDocs={"The selector identifying the object.", "The text to type into the object."})
    public void type(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        By by = this.getSelector(argParser, 0);
        String string = argParser.getString(1);
        this.type(by, string);
    }

    public void type(By by, String string) {
        Point point = this.getElementCenter(by);
        this.mDevice.getImpl().touch(point.x, point.y, TouchPressType.DOWN_AND_UP);
        this.mDevice.getImpl().type(string);
    }

    @MonkeyRunnerExported(doc="Locates the coordinates of the selected object.", args={"selector"}, argDocs={"The selector identifying the object."}, returns="Tuple containing (x,y,w,h) location and size.")
    public PyTuple locate(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        By by = this.getSelector(argParser, 0);
        ViewNode viewNode = by.findView(this.mHierarchyViewer);
        Point point = HierarchyViewer.getAbsolutePositionOfView((ViewNode)viewNode);
        PyTuple pyTuple = new PyTuple(new PyObject[]{new PyInteger(point.x), new PyInteger(point.y), new PyInteger(viewNode.width), new PyInteger(viewNode.height)});
        return pyTuple;
    }

    @MonkeyRunnerExported(doc="Checks if the specified object exists.", args={"selector"}, returns="True if the object exists.", argDocs={"The selector identifying the object."})
    public boolean exists(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        By by = this.getSelector(argParser, 0);
        return this.exists(by);
    }

    public boolean exists(By by) {
        ViewNode viewNode = by.findView(this.mHierarchyViewer);
        return viewNode != null;
    }

    @MonkeyRunnerExported(doc="Checks if the specified object is visible.", args={"selector"}, returns="True if the object is visible.", argDocs={"The selector identifying the object."})
    public boolean visible(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        By by = this.getSelector(argParser, 0);
        return this.visible(by);
    }

    public boolean visible(By by) {
        ViewNode viewNode = by.findView(this.mHierarchyViewer);
        return this.mHierarchyViewer.visible(viewNode);
    }

    @MonkeyRunnerExported(doc="Obtain the text in the selected input box.", args={"selector"}, argDocs={"The selector identifying the object."}, returns="Text in the selected input box.")
    public String getText(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = JythonUtils.createArgParser(pyObjectArray, stringArray);
        Preconditions.checkNotNull((Object)argParser);
        By by = this.getSelector(argParser, 0);
        return this.getText(by);
    }

    public String getText(By by) {
        ViewNode viewNode = by.findView(this.mHierarchyViewer);
        return this.mHierarchyViewer.getText(viewNode);
    }

    @MonkeyRunnerExported(doc="Gets the id of the focused window.", returns="The symbolic id of the focused window or None.")
    public String getFocusedWindowId(PyObject[] pyObjectArray, String[] stringArray) {
        return this.getFocusedWindowId();
    }

    public String getFocusedWindowId() {
        return this.mHierarchyViewer.getFocusedWindowName();
    }

    public PyObject __findattr_ex__(String string) {
        if (!EXPORTED_METHODS.contains(string)) {
            return this.mDevice.__findattr_ex__(string);
        }
        return super.__findattr_ex__(string);
    }

    private By getSelector(ArgParser argParser, int n) {
        return (By)((Object)argParser.getPyObject(n).__tojava__(By.class));
    }

    private Point getElementCenter(By by) {
        ViewNode viewNode = by.findView(this.mHierarchyViewer);
        if (viewNode == null) {
            throw new PyException(Py.ValueError, String.format("View not found: %s", new Object[]{by}));
        }
        Point point = HierarchyViewer.getAbsoluteCenterOfView((ViewNode)viewNode);
        return point;
    }
}

