/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

public class Storage {
    private long mNoBytes;

    public Storage(long l, Unit unit) {
        this.mNoBytes = l * unit.getNumberOfBytes();
    }

    public Storage(long l) {
        this(l, Unit.B);
    }

    public long getSize() {
        return this.getSizeAsUnit(Unit.B);
    }

    public Storage deepCopy() {
        return new Storage(this.mNoBytes);
    }

    public long getSizeAsUnit(Unit unit) {
        return this.mNoBytes / unit.getNumberOfBytes();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Storage)) {
            return false;
        }
        Storage storage = (Storage)object;
        return storage.getSize() == this.getSize();
    }

    public int hashCode() {
        int n = 17;
        return 31 * n + (int)(this.mNoBytes ^ this.mNoBytes >>> 32);
    }

    public Unit getApproriateUnits() {
        Unit unit = Unit.B;
        for (Unit unit2 : Unit.values()) {
            if (this.mNoBytes % unit2.getNumberOfBytes() != 0L) break;
            unit = unit2;
        }
        return unit;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Unit {
        B("B", 1L),
        KiB("KiB", 1024L),
        MiB("MiB", 0x100000L),
        GiB("GiB", 0x40000000L),
        TiB("TiB", 0x10000000000L);

        private String mValue;
        private long mNoBytes;

        private Unit(String string2, long l) {
            this.mValue = string2;
            this.mNoBytes = l;
        }

        public static Unit getEnum(String string) {
            for (Unit unit : Unit.values()) {
                if (!unit.mValue.equals(string)) continue;
                return unit;
            }
            return null;
        }

        public long getNumberOfBytes() {
            return this.mNoBytes;
        }

        public String toString() {
            return this.mValue;
        }
    }
}

