/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.build;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.build.KeystoreHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class DebugKeyProvider {
    private static final String PASSWORD_STRING = "android";
    private static final char[] PASSWORD_CHAR = "android".toCharArray();
    private static final String DEBUG_ALIAS = "AndroidDebugKey";
    private static final String CERTIFICATE_DESC = "CN=Android Debug,O=Android,C=US";
    private KeyStore.PrivateKeyEntry mEntry;

    public DebugKeyProvider(String string, String string2, IKeyGenOutput iKeyGenOutput) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException, IOException, KeytoolException, AndroidLocation.AndroidLocationException {
        if (string == null) {
            string = DebugKeyProvider.getDefaultKeyStoreOsPath();
        }
        if (!this.loadKeyEntry(string, string2)) {
            this.createNewStore(string, string2, iKeyGenOutput);
        }
    }

    public static String getDefaultKeyStoreOsPath() throws KeytoolException, AndroidLocation.AndroidLocationException {
        String string = AndroidLocation.getFolder();
        if (string == null) {
            throw new KeytoolException("Failed to get HOME directory!\n");
        }
        String string2 = string + "debug.keystore";
        return string2;
    }

    public PrivateKey getDebugKey() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, UnrecoverableEntryException {
        if (this.mEntry != null) {
            return this.mEntry.getPrivateKey();
        }
        return null;
    }

    public Certificate getCertificate() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, UnrecoverableEntryException {
        if (this.mEntry != null) {
            return this.mEntry.getCertificate();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadKeyEntry(String string, String string2) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        FileInputStream fileInputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(string2 != null ? string2 : KeyStore.getDefaultType());
            fileInputStream = new FileInputStream(string);
            keyStore.load(fileInputStream, PASSWORD_CHAR);
            this.mEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(DEBUG_ALIAS, new KeyStore.PasswordProtection(PASSWORD_CHAR));
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private void createNewStore(String string, String string2, IKeyGenOutput iKeyGenOutput) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException, IOException, KeytoolException {
        if (KeystoreHelper.createNewStore(string, string2, PASSWORD_STRING, DEBUG_ALIAS, PASSWORD_STRING, CERTIFICATE_DESC, 30, iKeyGenOutput)) {
            this.loadKeyEntry(string, string2);
        }
    }

    public static class KeytoolException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String mJavaHome = null;
        private String mCommandLine = null;

        KeytoolException(String string) {
            super(string);
        }

        KeytoolException(String string, String string2, String string3) {
            super(string);
            this.mJavaHome = string2;
            this.mCommandLine = string3;
        }

        public String getJavaHome() {
            return this.mJavaHome;
        }

        public String getCommandLine() {
            return this.mCommandLine;
        }
    }

    public static interface IKeyGenOutput {
        public void out(String var1);

        public void err(String var1);
    }
}

