/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.annotations.NonNull;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.android.sdklib.internal.project.ProjectProperties;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectPropertiesWorkingCopy
extends ProjectProperties {
    private static final Map<String, String> COMMENT_MAP = new HashMap<String, String>();

    public synchronized void setProperty(String string, String string2) {
        this.mProperties.put(string, string2);
    }

    public synchronized String removeProperty(String string) {
        return (String)this.mProperties.remove(string);
    }

    public synchronized ProjectPropertiesWorkingCopy merge(ProjectProperties.PropertyType propertyType) {
        Map<String, String> map;
        IAbstractFile iAbstractFile;
        if (this.mProjectFolder.exists() && this.mType != propertyType && (iAbstractFile = this.mProjectFolder.getFile(propertyType.getFilename())).exists() && (map = ProjectPropertiesWorkingCopy.parsePropertyFile(iAbstractFile, null)) != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                if (this.mProperties.containsKey(string) || string2 == null) continue;
                this.mProperties.put(string, string2);
            }
        }
        return this;
    }

    public synchronized void save() throws IOException, StreamException {
        Object object;
        IAbstractFile iAbstractFile = this.mProjectFolder.getFile(this.mType.getFilename());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        if (iAbstractFile.exists()) {
            String string;
            object = new BufferedReader(new InputStreamReader(iAbstractFile.getContents(), "UTF-8"));
            HashSet<Object> hashSet = new HashSet<Object>();
            String string2 = null;
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                if (string2.length() > 0 && string2.charAt(0) != '#') {
                    Matcher matcher = PATTERN_PROP.matcher(string2);
                    if (!matcher.matches()) continue;
                    Map.Entry entry = matcher.group(1);
                    string = matcher.group(2);
                    hashSet.add(entry);
                    if (this.mType.isRemovedProperty((String)((Object)entry))) {
                        string = null;
                    } else if (this.mProperties.containsKey(entry)) {
                        string = (String)this.mProperties.get(entry);
                    } else if (this.mType.isKnownProperty((String)((Object)entry))) {
                        string = null;
                    }
                    if (string == null) continue;
                    this.writeValue(outputStreamWriter, (String)((Object)entry), string, false);
                    continue;
                }
                outputStreamWriter.append(string2).append('\n');
            }
            for (Map.Entry entry : this.mProperties.entrySet()) {
                if (hashSet.contains(entry.getKey()) || (string = (String)entry.getValue()) == null) continue;
                this.writeValue(outputStreamWriter, (String)entry.getKey(), string, true);
            }
            Closeables.closeQuietly((Closeable)object);
        } else {
            if (this.mType.getHeader() != null) {
                outputStreamWriter.write(this.mType.getHeader());
            }
            for (Map.Entry entry : this.mProperties.entrySet()) {
                String string = (String)entry.getValue();
                if (string == null) continue;
                this.writeValue(outputStreamWriter, (String)entry.getKey(), string, true);
            }
        }
        outputStreamWriter.flush();
        object = iAbstractFile.getOutputStream();
        ((OutputStream)object).write(byteArrayOutputStream.toByteArray());
        ((OutputStream)object).flush();
        ((OutputStream)object).close();
    }

    private void writeValue(OutputStreamWriter outputStreamWriter, String string, String string2, boolean bl) throws IOException {
        String string3;
        if (bl && (string3 = COMMENT_MAP.get(string)) != null) {
            outputStreamWriter.write(string3);
        }
        outputStreamWriter.write(String.format("%s=%s\n", string, ProjectPropertiesWorkingCopy.escape(string2)));
    }

    ProjectPropertiesWorkingCopy(IAbstractFolder iAbstractFolder, Map<String, String> map, ProjectProperties.PropertyType propertyType) {
        super(iAbstractFolder, map, propertyType);
    }

    @NonNull
    public ProjectProperties makeReadOnlyCopy() {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.mProperties);
        return new ProjectProperties(this.mProjectFolder, hashMap, this.mType);
    }

    static {
        COMMENT_MAP.put("target", "# Project target.\n");
        COMMENT_MAP.put("split.density", "# Indicates whether an apk should be generated for each density.\n");
        COMMENT_MAP.put("sdk.dir", "# location of the SDK. This is only used by Ant\n# For customization when using a Version Control System, please read the\n# header note.\n");
        COMMENT_MAP.put("package", "# Package of the application being exported\n");
        COMMENT_MAP.put("versionCode", "# Major version code\n");
        COMMENT_MAP.put("projects", "# List of the Android projects being used for the export.\n# The list is made of paths that are relative to this project,\n# using forward-slash (/) as separator, and are separated by colons (:).\n");
    }
}

