/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.repository.CanceledByUserException;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.UrlOpener;
import com.android.utils.Pair;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadCache {
    private static final boolean DEBUG = System.getenv("SDKMAN_DEBUG_CACHE") != null;
    private static final String KEY_STATUS_CODE = "Status-Code";
    private static final String KEY_URL = "URL";
    private static final String BIN_FILE_PREFIX = "sdkbin";
    private static final String INFO_FILE_PREFIX = "sdkinf";
    private static final String REV_FILE_PREFIX = "-1_";
    private static final long MIN_TIME_EXPIRED_MS = 600000L;
    private static final long MAX_TIME_EXPIRED_MS = 14400000L;
    private static final int MAX_SMALL_FILE_SIZE = 655360;
    private static final String[] INFO_HTTP_HEADERS = new String[]{"Last-Modified", "ETag", "Content-Length", "Date"};
    private final Strategy mStrategy;
    private final File mCacheRoot = this.initCacheRoot();

    public DownloadCache(Strategy strategy) {
        if (System.getenv("SDKMAN_DISABLE_CACHE") != null) {
            strategy = Strategy.DIRECT;
        }
        this.mStrategy = this.mCacheRoot == null ? Strategy.DIRECT : strategy;
    }

    public Strategy getStrategy() {
        return this.mStrategy;
    }

    public File getCacheRoot() {
        return this.mCacheRoot;
    }

    public long getCurrentSize() {
        File[] fileArray;
        long l = 0L;
        if (this.mCacheRoot != null && (fileArray = this.mCacheRoot.listFiles()) != null) {
            for (File file : fileArray) {
                String string;
                if (!file.isFile() || !(string = file.getName()).startsWith(BIN_FILE_PREFIX) && !string.startsWith(INFO_FILE_PREFIX)) continue;
                l += file.length();
            }
        }
        return l;
    }

    public void clearCache() {
        File[] fileArray;
        if (this.mCacheRoot != null && (fileArray = this.mCacheRoot.listFiles()) != null) {
            for (File file : fileArray) {
                String string;
                if (!file.isFile() || !(string = file.getName()).startsWith(BIN_FILE_PREFIX) && !string.startsWith(INFO_FILE_PREFIX)) continue;
                file.delete();
            }
        }
    }

    public void clearOldCache() {
        File[] fileArray;
        String string = "sdkbin-1_";
        String string2 = "sdkinf-1_";
        if (this.mCacheRoot != null && (fileArray = this.mCacheRoot.listFiles()) != null) {
            for (File file : fileArray) {
                String string3;
                if (!file.isFile() || !(string3 = file.getName()).startsWith(BIN_FILE_PREFIX) && !string3.startsWith(INFO_FILE_PREFIX) || string3.startsWith(string) || string3.startsWith(string2)) continue;
                file.delete();
            }
        }
    }

    protected File initCacheRoot() {
        try {
            File file = new File(AndroidLocation.getFolder());
            file = new File(file, "cache");
            if (!file.exists()) {
                file.mkdirs();
            }
            return file;
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            return null;
        }
    }

    public Pair<InputStream, HttpResponse> openDirectUrl(@NonNull String string, @Nullable Header[] headerArray, @NonNull ITaskMonitor iTaskMonitor) throws IOException, CanceledByUserException {
        if (DEBUG) {
            System.out.println(String.format("%s : Direct download", string));
        }
        return UrlOpener.openUrl(string, false, iTaskMonitor, headerArray);
    }

    public Pair<InputStream, Integer> openDirectUrl(@NonNull String string, @NonNull ITaskMonitor iTaskMonitor) throws IOException, CanceledByUserException {
        if (DEBUG) {
            System.out.println(String.format("%s : Direct download", string));
        }
        Pair<InputStream, HttpResponse> pair = UrlOpener.openUrl(string, false, iTaskMonitor, null);
        return Pair.of((Object)pair.getFirst(), (Object)((HttpResponse)pair.getSecond()).getStatusLine().getStatusCode());
    }

    public InputStream openCachedUrl(String string, ITaskMonitor iTaskMonitor) throws IOException, CanceledByUserException {
        if (this.mStrategy == Strategy.DIRECT) {
            Pair<InputStream, HttpResponse> pair = UrlOpener.openUrl(string, true, iTaskMonitor, null);
            return (InputStream)pair.getFirst();
        }
        File file = new File(this.mCacheRoot, this.getCacheFilename(string));
        File file2 = new File(this.mCacheRoot, this.getInfoFilename(file.getName()));
        boolean bl = file.exists();
        if (bl && this.mStrategy == Strategy.FRESH_CACHE) {
            long l = file.lastModified();
            boolean bl2 = true;
            Properties properties = this.readInfo(file2);
            if (properties == null) {
                bl = false;
            } else {
                long l2 = System.currentTimeMillis() - 600000L;
                boolean bl3 = bl2 = l < l2;
                if (!bl2 && DEBUG) {
                    System.out.println(String.format("%s : Too fresh [%,d ms], not checking yet.", string, l - l2));
                }
            }
            if (bl && bl2) {
                assert (properties != null);
                String string2 = properties.getProperty(KEY_STATUS_CODE, "");
                bl = Integer.toString(200).equals(string2);
                if (!bl && DEBUG) {
                    System.out.println(String.format("%s : cache disabled by code %s", string, string2));
                }
                if (bl) {
                    try {
                        long l3 = Long.parseLong(properties.getProperty("Content-Length", "-1"));
                        if (l3 >= 0L) {
                            boolean bl4 = bl = l3 == file.length();
                            if (!bl && DEBUG) {
                                System.out.println(String.format("%s : cache disabled by length mismatch %d, expected %d", string, l3, file.length()));
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (bl) {
                    String string3 = properties.getProperty("ETag");
                    String string4 = properties.getProperty("Last-Modified");
                    if (string3 != null || string4 != null) {
                        AtomicInteger atomicInteger = new AtomicInteger(0);
                        InputStream inputStream = null;
                        ArrayList<BasicHeader> arrayList = new ArrayList<BasicHeader>(2);
                        if (string3 != null) {
                            arrayList.add(new BasicHeader("If-None-Match", string3));
                        }
                        if (string4 != null) {
                            arrayList.add(new BasicHeader("If-Modified-Since", string4));
                        }
                        if (!arrayList.isEmpty()) {
                            inputStream = this.downloadAndCache(string, iTaskMonitor, file, file2, arrayList.toArray(new Header[arrayList.size()]), atomicInteger);
                        }
                        if (inputStream != null && atomicInteger.get() == 200) {
                            return inputStream;
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            inputStream = null;
                        }
                        if (atomicInteger.get() == 304) {
                            file.setLastModified(System.currentTimeMillis());
                        } else {
                            bl = false;
                            if (atomicInteger.get() == 404) {
                                return null;
                            }
                        }
                    } else {
                        long l4 = System.currentTimeMillis() - 14400000L;
                        boolean bl5 = bl = l >= l4;
                        if (!bl && DEBUG) {
                            System.out.println(String.format("[%1$s] cache disabled by timestamp %2$tD %2$tT < %3$tD %3$tT", string, l, l4));
                        }
                    }
                }
            }
        }
        if (bl) {
            try {
                InputStream inputStream = this.readCachedFile(file);
                if (inputStream != null) {
                    if (DEBUG) {
                        System.out.println(String.format("%s : Use cached file", string));
                    }
                    return inputStream;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!bl && this.mStrategy == Strategy.ONLY_CACHE) {
            if (DEBUG) {
                System.out.println(String.format("%s : file not in cache", string));
            }
            return null;
        }
        try {
            file.delete();
            file2.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return this.downloadAndCache(string, iTaskMonitor, file, file2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream readCachedFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        int n = 65536;
        int n2 = 0;
        long l = file.length();
        assert (l < Integer.MAX_VALUE);
        if (l >= 655360L) {
            return null;
        }
        Object object = new byte[(int)(l > 0L ? l : (long)n)];
        try {
            Object object2;
            int n3;
            fileInputStream = new FileInputStream(file);
            while ((n3 = ((InputStream)fileInputStream).read((byte[])object, n2, ((byte[])object).length - n2)) != -1) {
                if ((n2 += n3) != ((byte[])object).length) continue;
                object2 = new byte[n2 + n];
                System.arraycopy(object, 0, object2, 0, n2);
                object = object2;
            }
            object2 = new ByteArrayInputStream((byte[])object, 0, n2);
            return object2;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream downloadAndCache(String string, ITaskMonitor iTaskMonitor, File file, File file2, @Nullable Header[] headerArray, @Nullable AtomicInteger atomicInteger) throws FileNotFoundException, IOException, CanceledByUserException {
        Object object;
        int n;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        int n2 = 65536;
        int n3 = 0;
        Object object2 = new byte[n2];
        Pair<InputStream, HttpResponse> pair = UrlOpener.openUrl(string, true, iTaskMonitor, headerArray);
        inputStream = (InputStream)pair.getFirst();
        HttpResponse httpResponse = (HttpResponse)pair.getSecond();
        if (DEBUG) {
            System.out.println(String.format("%s : fetch: %s => %s", string, headerArray == null ? "" : Arrays.toString(headerArray), httpResponse.getStatusLine()));
        }
        int n4 = httpResponse.getStatusLine().getStatusCode();
        if (atomicInteger != null) {
            atomicInteger.set(n4);
        }
        if (n4 != 200) {
            InputStream inputStream2 = null;
            return inputStream2;
        }
        outputStream = new FileOutputStream(file);
        while ((n = inputStream.read((byte[])object2, n3, ((byte[])object2).length - n3)) != -1) {
            if (outputStream != null && n > 0) {
                outputStream.write((byte[])object2, n3, n);
            }
            if (outputStream != null && (n3 += n) > 655360) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    file.delete();
                    file2.delete();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                outputStream = null;
            }
            if (n3 != ((byte[])object2).length) continue;
            object = new byte[n3 + n2];
            System.arraycopy(object2, 0, object, 0, n3);
            object2 = object;
        }
        if (outputStream != null) {
            try {
                outputStream.close();
                outputStream = null;
                this.saveInfo(string, httpResponse, file2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = new ByteArrayInputStream((byte[])object2, 0, n3);
        return object;
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    file.delete();
                    file2.delete();
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInfo(String string, HttpResponse httpResponse, File file) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(KEY_URL, string);
        properties.setProperty(KEY_STATUS_CODE, Integer.toString(httpResponse.getStatusLine().getStatusCode()));
        for (String string2 : INFO_HTTP_HEADERS) {
            Header header = httpResponse.getFirstHeader(string2);
            if (header == null) continue;
            properties.setProperty(string2, header.getValue());
        }
        Object object = null;
        try {
            object = new FileOutputStream(file);
            properties.store((OutputStream)object, "## Meta data for SDK Manager cache. Do not modify.");
        }
        finally {
            if (object != null) {
                ((FileOutputStream)object).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readInfo(File file) {
        if (file.exists()) {
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                Properties properties2 = properties;
                return properties2;
            }
            catch (IOException iOException) {
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    private String getCacheFilename(String string) {
        String string2 = String.format("%08x", string.hashCode());
        String string3 = string.toLowerCase(Locale.US);
        if (string3.length() >= 2) {
            int n = string.lastIndexOf(47, string3.length() - 2);
            string3 = string.substring(n + 1);
        }
        string3 = string3.replaceAll("[^a-z0-9_-]+", "_");
        string3 = string3.replaceAll("__+", "_");
        string3 = string2 + '-' + string3;
        String string4 = "sdkbin-1_";
        int n = 64 - string4.length();
        if (string3.length() > n) {
            string3 = string3.substring(0, n);
        }
        return string4 + string3;
    }

    private String getInfoFilename(String string) {
        return string.replaceFirst(BIN_FILE_PREFIX, INFO_FILE_PREFIX);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        ONLY_CACHE,
        SERVE_CACHE,
        FRESH_CACHE,
        DIRECT;

    }
}

