/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.FullRevision;
import com.android.sdklib.internal.repository.packages.MajorRevision;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MajorRevisionPackage
extends Package {
    private final MajorRevision mRevision;

    MajorRevisionPackage(SdkSource sdkSource, Node node, String string, Map<String, String> map) {
        super(sdkSource, node, string, map);
        this.mRevision = new MajorRevision(PackageParserUtils.getXmlInt(node, "revision", 0));
    }

    public MajorRevisionPackage(SdkSource sdkSource, Properties properties, int n, String string, String string2, String string3, Archive.Os os, Archive.Arch arch, String string4) {
        super(sdkSource, properties, n, string, string2, string3, os, arch, string4);
        String string5 = MajorRevisionPackage.getProperty(properties, "Pkg.Revision", null);
        MajorRevision majorRevision = null;
        if (string5 != null) {
            try {
                majorRevision = MajorRevision.parseRevision(string5);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (majorRevision == null) {
            majorRevision = new MajorRevision(n);
        }
        this.mRevision = majorRevision;
    }

    @Override
    public FullRevision getRevision() {
        return this.mRevision;
    }

    @Override
    public void saveProperties(Properties properties) {
        super.saveProperties(properties);
        properties.setProperty("Pkg.Revision", this.mRevision.toString());
    }

    @Override
    public Package.UpdateInfo canBeUpdatedBy(Package package_) {
        if (package_ == null) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        if (!this.sameItemAs(package_)) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        if (package_.getRevision().compareTo(this.getRevision()) > 0) {
            return Package.UpdateInfo.UPDATE;
        }
        return Package.UpdateInfo.NOT_UPDATE;
    }
}

