/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.sources;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.prefs.AndroidLocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;

public class SdkSourceProperties {
    private static final String KEY_VERSION = "@version@";
    public static final String KEY_NAME = "@name@";
    public static final String KEY_DISABLED = "@disabled@";
    private static final Properties sSourcesProperties = new Properties();
    private static final String SRC_FILENAME = "sites-settings.cfg";
    private static boolean sModified = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Properties properties = sSourcesProperties;
        synchronized (properties) {
            if (sModified && !sSourcesProperties.isEmpty()) {
                this.saveLocked();
                sModified = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getProperty(@NonNull String string, @NonNull String string2, @Nullable String string3) {
        String string4 = string3;
        Properties properties = sSourcesProperties;
        synchronized (properties) {
            if (sSourcesProperties.isEmpty()) {
                this.loadLocked();
            }
            string4 = sSourcesProperties.getProperty(string + string2, string3);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String string, String string2, String string3) {
        Properties properties = sSourcesProperties;
        synchronized (properties) {
            if (sSourcesProperties.isEmpty()) {
                this.loadLocked();
            }
            string = string + string2;
            String string4 = sSourcesProperties.getProperty(string);
            if (string3 == null) {
                if (string4 != null) {
                    sSourcesProperties.remove(string);
                    sModified = true;
                }
            } else if (string4 == null || !string4.equals(string3)) {
                sSourcesProperties.setProperty(string, string3);
                sModified = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<SdkSourceProperties");
        Properties properties = sSourcesProperties;
        synchronized (properties) {
            ArrayList<Object> arrayList = Collections.list(sSourcesProperties.keys());
            Collections.sort(arrayList, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    return object.toString().compareTo(object2.toString());
                }
            });
            for (Object e : arrayList) {
                stringBuilder.append('\n').append(e).append(" = ").append(sSourcesProperties.get(e));
            }
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    private void loadLocked() {
        if (this.loadProperties()) {
            if (sSourcesProperties.getProperty(KEY_VERSION) == null) {
                sSourcesProperties.clear();
            }
            sModified = false;
        }
        if (sSourcesProperties.isEmpty()) {
            sSourcesProperties.setProperty(KEY_VERSION, "1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadProperties() {
        block14: {
            try {
                String string = AndroidLocation.getFolder();
                File file = new File(string, SRC_FILENAME);
                if (!file.exists()) break block14;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    sSourcesProperties.load(fileInputStream);
                }
                catch (IOException iOException) {
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return true;
            }
            catch (AndroidLocation.AndroidLocationException androidLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveLocked() {
        FileOutputStream fileOutputStream = null;
        try {
            String string = AndroidLocation.getFolder();
            File file = new File(string, SRC_FILENAME);
            fileOutputStream = new FileOutputStream(file);
            sSourcesProperties.store(fileOutputStream, "## Sites Settings for Android SDK Manager");
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Properties properties = sSourcesProperties;
        synchronized (properties) {
            sSourcesProperties.clear();
            sModified = false;
        }
    }
}

