/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.util;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.util.LineUtil;
import com.android.utils.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandLineParser {
    public static final String GLOBAL_FLAG_VERB = "@@internal@@";
    public static final String NO_VERB_OBJECT = "";
    public static final String KEY_HELP = "help";
    public static final String KEY_VERBOSE = "verbose";
    public static final String KEY_SILENT = "silent";
    private String mVerbRequested;
    private String mDirectObjectRequested;
    private final String[][] mActions;
    private static final int ACTION_VERB_INDEX = 0;
    private static final int ACTION_OBJECT_INDEX = 1;
    private static final int ACTION_DESC_INDEX = 2;
    private static final int ACTION_ALT_OBJECT_INDEX = 3;
    private final HashMap<String, Arg> mArguments = new HashMap();
    private final ILogger mLog;

    public CommandLineParser(ILogger iLogger, String[][] stringArray) {
        this.mLog = iLogger;
        this.mActions = stringArray;
        this.define(Mode.BOOLEAN, false, GLOBAL_FLAG_VERB, NO_VERB_OBJECT, "v", KEY_VERBOSE, "Verbose mode, shows errors, warnings and all messages.", false);
        this.define(Mode.BOOLEAN, false, GLOBAL_FLAG_VERB, NO_VERB_OBJECT, "s", KEY_SILENT, "Silent mode, shows errors only.", false);
        this.define(Mode.BOOLEAN, false, GLOBAL_FLAG_VERB, NO_VERB_OBJECT, "h", KEY_HELP, "Help on a specific command.", false);
    }

    public boolean acceptLackOfVerb() {
        return false;
    }

    public boolean isVerbose() {
        return (Boolean)this.getValue(GLOBAL_FLAG_VERB, NO_VERB_OBJECT, KEY_VERBOSE);
    }

    public boolean isSilent() {
        return (Boolean)this.getValue(GLOBAL_FLAG_VERB, NO_VERB_OBJECT, KEY_SILENT);
    }

    public boolean isHelpRequested() {
        return (Boolean)this.getValue(GLOBAL_FLAG_VERB, NO_VERB_OBJECT, KEY_HELP);
    }

    public String getVerb() {
        return this.mVerbRequested;
    }

    public String getDirectObject() {
        return this.mDirectObjectRequested;
    }

    public Object getValue(String string, String string2, String string3) {
        if (string != null && string2 != null) {
            String string4 = string + '/' + string2 + '/' + string3;
            Arg arg = this.mArguments.get(string4);
            return arg.getCurrentValue();
        }
        Object object = null;
        for (Arg arg : this.mArguments.values()) {
            if (!arg.getLongArg().equals(string3) || string != null && !arg.getVerb().equals(string) || string2 != null && !arg.getDirectObject().equals(string2)) continue;
            if (arg.isInCommandLine()) {
                return arg.getCurrentValue();
            }
            if (arg.getCurrentValue() == null) continue;
            object = arg.getCurrentValue();
        }
        return object;
    }

    protected void setValue(String string, String string2, String string3, Object object) {
        String string4 = string + '/' + string2 + '/' + string3;
        Arg arg = this.mArguments.get(string4);
        arg.setCurrentValue(object);
    }

    /*
     * Exception decompiling
     */
    public void parseArgs(String[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Arg findLongArg(String string, String string2, String string3) {
        if (string == null) {
            string = GLOBAL_FLAG_VERB;
        }
        if (string2 == null) {
            string2 = NO_VERB_OBJECT;
        }
        String string4 = string + '/' + string2 + '/' + string3;
        return this.mArguments.get(string4);
    }

    protected Arg findShortArg(String string, String string2, String string3) {
        if (string == null) {
            string = GLOBAL_FLAG_VERB;
        }
        if (string2 == null) {
            string2 = NO_VERB_OBJECT;
        }
        for (Map.Entry<String, Arg> entry : this.mArguments.entrySet()) {
            Arg arg = entry.getValue();
            if (!arg.getVerb().equals(string) || !arg.getDirectObject().equals(string2) || !string3.equals(arg.getShortArg())) continue;
            return arg;
        }
        return null;
    }

    public void printHelpAndExit(String string, Object ... objectArray) {
        this.printHelpAndExitForAction(null, null, string, objectArray);
    }

    public void printHelpAndExitForAction(String string, String string2, String string3, Object ... objectArray) {
        if (string3 != null && string3.length() > 0) {
            this.stderr(string3, objectArray);
        }
        this.stdout("\nUsage:\n  android [global options] %s [action options]\n\nGlobal options:", string == null ? "action" : string + (string2 == null ? NO_VERB_OBJECT : " " + string2));
        this.listOptions(GLOBAL_FLAG_VERB, NO_VERB_OBJECT);
        if (string == null || string2 == null) {
            this.stdout("\nValid actions are composed of a verb and an optional direct object:", new Object[0]);
            for (String[] stringArray : this.mActions) {
                if (string != null && !string.equals(stringArray[0])) continue;
                this.stdout("- %1$6s %2$-13s: %3$s", stringArray[0], stringArray[1], stringArray[2]);
            }
        }
        if (string != null) {
            for (String[] stringArray : this.mActions) {
                if (string != null && !string.equals(stringArray[0]) || string2 != null && !string2.equals(stringArray[1])) continue;
                this.stdout("\nAction \"%1$s %2$s\":", stringArray[0], stringArray[1]);
                this.stdout("  %1$s", stringArray[2]);
                this.stdout("Options:", new Object[0]);
                this.listOptions(stringArray[0], stringArray[1]);
            }
        }
        this.exit();
    }

    protected void listOptions(String string, String string2) {
        Arg arg;
        int n = 0;
        int n2 = 8;
        for (Map.Entry<String, Arg> entry : this.mArguments.entrySet()) {
            int n3;
            arg = entry.getValue();
            if (!arg.getVerb().equals(string) || !arg.getDirectObject().equals(string2) || (n3 = arg.getLongArg().length()) <= n2) continue;
            n2 = n3;
        }
        for (Map.Entry<String, Arg> entry : this.mArguments.entrySet()) {
            Object object;
            arg = entry.getValue();
            if (!arg.getVerb().equals(string) || !arg.getDirectObject().equals(string2)) continue;
            String string3 = NO_VERB_OBJECT;
            String string4 = NO_VERB_OBJECT;
            if (arg.isMandatory()) {
                string4 = " [required]";
            } else {
                if (arg.getDefaultValue() instanceof String[]) {
                    for (String string5 : (String[])arg.getDefaultValue()) {
                        if (string3.length() > 0) {
                            string3 = string3 + ", ";
                        }
                        string3 = string3 + (String)string5;
                    }
                } else if (arg.getDefaultValue() != null) {
                    object = arg.getDefaultValue();
                    if (arg.getMode() != Mode.BOOLEAN || object.equals(Boolean.TRUE)) {
                        string3 = object.toString();
                    }
                }
                if (string3.length() > 0) {
                    string3 = " [Default: " + string3 + "]";
                }
            }
            object = Integer.toString(n2 + 2);
            String string6 = String.format("  %1$-2s %2$-" + (String)object + "s: %3$s%4$s%5$s", arg.getShortArg().length() > 0 ? "-" + arg.getShortArg() : NO_VERB_OBJECT, arg.getLongArg().length() > 0 ? "--" + arg.getLongArg() : NO_VERB_OBJECT, arg.getDescription(), string3, string4);
            this.stdout(string6, new Object[0]);
            ++n;
        }
        if (n == 0) {
            this.stdout("  No options", new Object[0]);
        }
    }

    protected void define(Mode mode, boolean bl, @NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull String string5, @Nullable Object object) {
        assert (string != null);
        assert (!bl || mode != Mode.BOOLEAN);
        assert (string3 != null);
        assert (string4 != null);
        assert (string3.length() > 0 || string4.length() > 0);
        if (string2 == null) {
            string2 = NO_VERB_OBJECT;
        }
        String string6 = string + '/' + string2 + '/' + string4;
        this.mArguments.put(string6, new Arg(mode, bl, string, string2, string3, string4, string5, object));
    }

    protected void exit() {
        System.exit(1);
    }

    protected void stdout(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        string2 = LineUtil.reflowLine(string2);
        this.mLog.info("%s\n", new Object[]{string2});
    }

    protected void stderr(String string, Object ... objectArray) {
        this.mLog.error(null, string, objectArray);
    }

    static class Arg {
        private final String mVerb;
        private final String mDirectObject;
        private final String mShortName;
        private final String mLongName;
        private final String mDescription;
        private final Object mDefaultValue;
        private final Mode mMode;
        private final boolean mMandatory;
        private Object mCurrentValue;
        private boolean mInCommandLine;

        public Arg(Mode mode, boolean bl, @NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull String string5, @Nullable Object object) {
            this.mMode = mode;
            this.mMandatory = bl;
            this.mVerb = string;
            this.mDirectObject = string2;
            this.mShortName = string3;
            this.mLongName = string4;
            this.mDescription = string5;
            this.mDefaultValue = object;
            this.mInCommandLine = false;
            this.mCurrentValue = object instanceof String[] ? ((String[])object)[0] : this.mDefaultValue;
        }

        public boolean isMandatory() {
            return this.mMandatory;
        }

        public String getShortArg() {
            return this.mShortName;
        }

        public String getLongArg() {
            return this.mLongName;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String getVerb() {
            return this.mVerb;
        }

        public String getDirectObject() {
            return this.mDirectObject;
        }

        public Object getDefaultValue() {
            return this.mDefaultValue;
        }

        public Object getCurrentValue() {
            return this.mCurrentValue;
        }

        public void setCurrentValue(Object object) {
            this.mCurrentValue = object;
        }

        public Mode getMode() {
            return this.mMode;
        }

        public boolean isInCommandLine() {
            return this.mInCommandLine;
        }

        public void setInCommandLine(boolean bl) {
            this.mInCommandLine = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        BOOLEAN{

            public boolean needsExtra() {
                return false;
            }

            public Object process(Arg arg, String string) {
                arg.setCurrentValue((Boolean)arg.getCurrentValue() == false);
                return Accept.ACCEPT_AND_STOP;
            }
        }
        ,
        INTEGER{

            public boolean needsExtra() {
                return true;
            }

            public Object process(Arg arg, String string) {
                try {
                    arg.setCurrentValue(Integer.parseInt(string));
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return String.format("Failed to parse '%1$s' as an integer: %2$s", string, numberFormatException.getMessage());
                }
            }
        }
        ,
        ENUM{

            public boolean needsExtra() {
                return true;
            }

            public Object process(Arg arg, String string) {
                String[] stringArray;
                StringBuilder stringBuilder = new StringBuilder();
                for (String string2 : stringArray = (String[])arg.getDefaultValue()) {
                    if (string2.equals(string)) {
                        arg.setCurrentValue(string);
                        return Accept.ACCEPT_AND_STOP;
                    }
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string2);
                }
                return String.format("'%1$s' is not one of %2$s", string, stringBuilder.toString());
            }
        }
        ,
        STRING{

            public boolean needsExtra() {
                return true;
            }

            public Object process(Arg arg, String string) {
                arg.setCurrentValue(string);
                return Accept.ACCEPT_AND_STOP;
            }
        }
        ,
        STRING_ARRAY{

            public boolean needsExtra() {
                return true;
            }

            public Object process(Arg arg, String string) {
                if (string != null) {
                    List<String> list;
                    List<String> list2 = arg.getCurrentValue();
                    if (list2 == null) {
                        list = new ArrayList();
                        arg.setCurrentValue(list);
                        list2 = list;
                    }
                    if (list2 instanceof List) {
                        list = list2;
                        if (string.equals("--") || !string.startsWith("-") || string.startsWith("-") && list.contains("--")) {
                            list.add(string);
                            return Accept.CONTINUE;
                        }
                        if (list.isEmpty()) {
                            return "No values provided";
                        }
                    }
                }
                return Accept.REJECT_AND_STOP;
            }
        };


        public abstract boolean needsExtra();

        public abstract Object process(Arg var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Accept {
        CONTINUE,
        ACCEPT_AND_STOP,
        REJECT_AND_STOP;

    }
}

