/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkmanager;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.internal.project.ProjectCreator;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.android.sdklib.internal.repository.DownloadCache;
import com.android.sdklib.repository.SdkAddonConstants;
import com.android.sdklib.repository.SdkRepoConstants;
import com.android.sdkmanager.SdkCommandLine;
import com.android.sdkuilib.internal.repository.SdkUpdaterNoWindow;
import com.android.sdkuilib.internal.widgets.MessageBoxLog;
import com.android.sdkuilib.repository.AvdManagerWindow;
import com.android.sdkuilib.repository.SdkUpdaterWindow;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.xml.AndroidXPathFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.swt.widgets.Display;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    public static final String TOOLSDIR = "com.android.sdkmanager.toolsdir";
    private static final String WORKDIR = "com.android.sdkmanager.workdir";
    private static final int INVALID_TARGET_ID = 0;
    private static final String[] BOOLEAN_YES_REPLIES = new String[]{"yes", "y"};
    private static final String[] BOOLEAN_NO_REPLIES = new String[]{"no", "n"};
    private String mOsSdkFolder;
    private ILogger mSdkLog;
    private SdkManager mSdkManager;
    private SdkCommandLine mSdkCommandLine;
    private File mWorkDir;

    public static void main(String[] stringArray) {
        new Main().run(stringArray);
    }

    void setSdkManager(SdkManager sdkManager) {
        this.mSdkManager = sdkManager;
    }

    private void run(String[] stringArray) {
        this.createLogger();
        this.init();
        this.mSdkCommandLine.parseArgs(stringArray);
        this.parseSdk();
        this.doAction();
    }

    private void createLogger() {
        this.mSdkLog = new ILogger(){

            public void error(Throwable throwable, String string, Object ... objectArray) {
                if (string != null) {
                    System.err.printf("Error: " + string, objectArray);
                    if (!string.endsWith("\n")) {
                        System.err.printf("\n", new Object[0]);
                    }
                }
                if (throwable != null) {
                    System.err.printf("Error: %s\n", throwable.getMessage());
                }
            }

            public void warning(@NonNull String string, Object ... objectArray) {
                if (Main.this.mSdkCommandLine.isVerbose()) {
                    System.out.printf("Warning: " + string, objectArray);
                    if (!string.endsWith("\n")) {
                        System.out.printf("\n", new Object[0]);
                    }
                }
            }

            public void info(@NonNull String string, Object ... objectArray) {
                System.out.printf(string, objectArray);
            }

            public void verbose(@NonNull String string, Object ... objectArray) {
                System.out.printf(string, objectArray);
            }
        };
    }

    public void setLogger(ILogger iLogger) {
        this.mSdkLog = iLogger;
    }

    private void init() {
        Object object;
        this.mSdkCommandLine = new SdkCommandLine(this.mSdkLog);
        String string = System.getProperty(TOOLSDIR);
        if (string == null) {
            string = System.getenv(TOOLSDIR);
        }
        if (string != null) {
            if (string.length() > 0) {
                object = new File(string);
                this.mOsSdkFolder = ((File)object).getParent();
            } else {
                try {
                    object = new File(".").getCanonicalFile();
                    this.mOsSdkFolder = ((File)object).getParent();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (this.mOsSdkFolder == null) {
            this.errorAndExit("The tools directory property is not set, please make sure you are executing %1$s", SdkConstants.androidCmdName());
        }
        if ((object = System.getProperty(WORKDIR)) == null) {
            object = System.getenv(WORKDIR);
        }
        if (object != null) {
            this.mWorkDir = new File((String)object);
            try {
                this.mWorkDir = this.mWorkDir.getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException iOException) {
                this.mWorkDir = null;
            }
            if (this.mWorkDir == null || !this.mWorkDir.isDirectory()) {
                this.errorAndExit("The working directory does not seem to be valid: '%1$s", object);
            }
        }
    }

    private void parseSdk() {
        this.mSdkManager = SdkManager.createManager((String)this.mOsSdkFolder, (ILogger)this.mSdkLog);
        if (this.mSdkManager == null) {
            this.errorAndExit("Unable to parse SDK content.", new Object[0]);
        }
    }

    private void doAction() {
        String string;
        if (this.mSdkCommandLine.hasClearCache()) {
            string = new DownloadCache(DownloadCache.Strategy.SERVE_CACHE);
            string.clearCache();
            this.mSdkLog.info("SDK Manager repository: manifest cache cleared.\n", new Object[0]);
        }
        string = this.mSdkCommandLine.getVerb();
        String string2 = this.mSdkCommandLine.getDirectObject();
        if ("list".equals(string)) {
            if ("target".equals(string2)) {
                this.displayTargetList();
            } else if ("avd".equals(string2)) {
                this.displayAvdList();
            } else if ("sdk".equals(string2)) {
                this.displayRemoteSdkListNoUI();
            } else {
                this.displayTargetList();
                this.displayAvdList();
            }
        } else if ("create".equals(string)) {
            if ("avd".equals(string2)) {
                this.createAvd();
            } else if ("project".equals(string2)) {
                this.createProject(false);
            } else if ("test-project".equals(string2)) {
                this.createTestProject();
            } else if ("lib-project".equals(string2)) {
                this.createProject(true);
            } else if ("uitest-project".equals(string2)) {
                this.createUiTestProject();
            }
        } else if ("update".equals(string)) {
            if ("avd".equals(string2)) {
                this.updateAvd();
            } else if ("project".equals(string2)) {
                this.updateProject(false);
            } else if ("test-project".equals(string2)) {
                this.updateTestProject();
            } else if ("lib-project".equals(string2)) {
                this.updateProject(true);
            } else if ("sdk".equals(string2)) {
                if (this.mSdkCommandLine.getFlagNoUI(string)) {
                    this.updateSdkNoUI();
                } else {
                    this.showSdkManagerWindow();
                }
            } else if ("adb".equals(string2)) {
                this.updateAdb();
            }
        } else if ("sdk".equals(string)) {
            this.showSdkManagerWindow();
        } else if ("avd".equals(string)) {
            this.showAvdManagerWindow();
        } else if ("delete".equals(string) && "avd".equals(string2)) {
            this.deleteAvd();
        } else if ("move".equals(string) && "avd".equals(string2)) {
            this.moveAvd();
        } else if (string == null && string2 == null) {
            this.showSdkManagerWindow();
        } else {
            this.mSdkCommandLine.printHelpAndExit(null, new Object[0]);
        }
    }

    private void showSdkManagerWindow() {
        try {
            MessageBoxLog messageBoxLog = new MessageBoxLog("SDK Manager", Display.getCurrent(), true);
            SdkUpdaterWindow sdkUpdaterWindow = new SdkUpdaterWindow(null, (ILogger)messageBoxLog, this.mOsSdkFolder, SdkUpdaterWindow.SdkInvocationContext.STANDALONE);
            sdkUpdaterWindow.open();
            messageBoxLog.displayResult(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void showAvdManagerWindow() {
        try {
            MessageBoxLog messageBoxLog = new MessageBoxLog("AVD Manager", Display.getCurrent(), true);
            AvdManagerWindow avdManagerWindow = new AvdManagerWindow(null, (ILogger)messageBoxLog, this.mOsSdkFolder, AvdManagerWindow.AvdInvocationContext.STANDALONE);
            avdManagerWindow.open();
            messageBoxLog.displayResult(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void displayRemoteSdkListNoUI() {
        boolean bl = this.mSdkCommandLine.getFlagForce();
        boolean bl2 = this.mSdkCommandLine.getFlagNoHttps();
        boolean bl3 = this.mSdkCommandLine.getFlagAll();
        boolean bl4 = this.mSdkCommandLine.getFlagExtended();
        String string = this.mSdkCommandLine.getParamProxyHost();
        String string2 = this.mSdkCommandLine.getParamProxyPort();
        boolean bl5 = this.mSdkCommandLine.getFlagObsolete();
        SdkUpdaterNoWindow sdkUpdaterNoWindow = new SdkUpdaterNoWindow(this.mOsSdkFolder, this.mSdkManager, this.mSdkLog, bl, bl2, string, string2);
        sdkUpdaterNoWindow.listRemotePackages(bl3 |= bl5, bl4);
        if (bl5) {
            this.mSdkLog.info("Note: Flag --obsolete is deprecated and will be removed in the next version.\n      Please use --all instead.\n", new Object[0]);
        }
    }

    private void updateSdkNoUI() {
        boolean bl = this.mSdkCommandLine.getFlagForce();
        boolean bl2 = this.mSdkCommandLine.getFlagNoHttps();
        boolean bl3 = this.mSdkCommandLine.getFlagDryMode();
        boolean bl4 = this.mSdkCommandLine.getFlagAll();
        String string = this.mSdkCommandLine.getParamProxyHost();
        String string2 = this.mSdkCommandLine.getParamProxyPort();
        boolean bl5 = this.mSdkCommandLine.getFlagObsolete();
        bl4 |= bl5;
        Pair<String, ArrayList<String>> pair = this.checkFilterValues(this.mSdkCommandLine.getParamFilter());
        if (pair.getFirst() != null) {
            this.errorAndExit((String)pair.getFirst(), new Object[0]);
        }
        SdkUpdaterNoWindow sdkUpdaterNoWindow = new SdkUpdaterNoWindow(this.mOsSdkFolder, this.mSdkManager, this.mSdkLog, bl, bl2, string, string2);
        sdkUpdaterNoWindow.updateAll((ArrayList)pair.getSecond(), bl4, bl3);
        if (bl5) {
            this.mSdkLog.info("Note: Flag --obsolete is deprecated and will be removed in the next version.\n      Please use --all instead.\n", new Object[0]);
        }
    }

    Pair<String, ArrayList<String>> checkFilterValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() > 0) {
            TreeSet<String> treeSet = new TreeSet<String>();
            treeSet.addAll(Arrays.asList(SdkRepoConstants.NODES));
            treeSet.addAll(Arrays.asList(SdkAddonConstants.NODES));
            for (String string2 : string.split(",")) {
                if (string2 == null || (string2 = string2.trim()).length() <= 0) continue;
                if (string2.indexOf(45) > 0 || string2.equals("tools") || string2.equals("platform-tools")) {
                    arrayList.add(string2);
                    continue;
                }
                if (string2.replaceAll("[0-9]+", "").length() == 0) {
                    arrayList.add(string2);
                    continue;
                }
                if (treeSet.contains(string2)) {
                    arrayList.add(string2);
                    continue;
                }
                return Pair.of((Object)String.format("Unknown package filter type '%1$s'.\nAccepted values are: %2$s", string2, Arrays.toString(treeSet.toArray())), null);
            }
        }
        return Pair.of(null, arrayList);
    }

    private ProjectCreator getProjectCreator() {
        ProjectCreator projectCreator = new ProjectCreator(this.mSdkManager, this.mOsSdkFolder, this.mSdkCommandLine.isVerbose() ? ProjectCreator.OutputLevel.VERBOSE : (this.mSdkCommandLine.isSilent() ? ProjectCreator.OutputLevel.SILENT : ProjectCreator.OutputLevel.NORMAL), this.mSdkLog);
        return projectCreator;
    }

    private void createProject(boolean bl) {
        String string = bl ? "lib-project" : "project";
        int n = this.resolveTargetName(this.mSdkCommandLine.getParamTargetId());
        IAndroidTarget[] iAndroidTargetArray = this.mSdkManager.getTargets();
        if (n == 0 || n > iAndroidTargetArray.length) {
            this.errorAndExit("Target id is not valid. Use '%s list targets' to get the target ids.", SdkConstants.androidCmdName());
        }
        IAndroidTarget iAndroidTarget = iAndroidTargetArray[n - 1];
        ProjectCreator projectCreator = this.getProjectCreator();
        String string2 = this.getProjectLocation(this.mSdkCommandLine.getParamLocationPath());
        String string3 = this.mSdkCommandLine.getParamName();
        String string4 = this.mSdkCommandLine.getParamProjectPackage(string);
        String string5 = null;
        if (!bl) {
            string5 = this.mSdkCommandLine.getParamProjectActivity();
        }
        if (string3 != null && !ProjectCreator.RE_PROJECT_NAME.matcher(string3).matches()) {
            this.errorAndExit("Project name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", string3, "a-z A-Z 0-9 _");
            return;
        }
        if (string5 != null && !ProjectCreator.RE_ACTIVITY_NAME.matcher(string5).matches()) {
            this.errorAndExit("Activity name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", string5, "a-z A-Z 0-9 _");
            return;
        }
        if (string4 != null && !ProjectCreator.RE_PACKAGE_NAME.matcher(string4).matches()) {
            this.errorAndExit("Package name '%1$s' contains invalid characters.\nA package name must be constitued of two Java identifiers.\nEach identifier allowed characters are: %2$s", string4, "a-z A-Z 0-9 _");
            return;
        }
        projectCreator.createProject(string2, string3, string4, string5, iAndroidTarget, bl, null);
    }

    private void createTestProject() {
        String string;
        String string2;
        String string3 = this.getProjectLocation(this.mSdkCommandLine.getParamLocationPath());
        String string4 = this.mSdkCommandLine.getParamTestProjectMain();
        File file = new File(string4);
        if (!file.isAbsolute()) {
            try {
                file = new File(string3, string4).getCanonicalFile();
            }
            catch (IOException iOException) {
                this.errorAndExit("Unable to resolve Main project's directory: %1$s", string4);
                return;
            }
        }
        if (!file.isDirectory()) {
            this.errorAndExit("Main project's directory does not exist: %1$s", string4);
            return;
        }
        File file2 = new File(file, "AndroidManifest.xml");
        if (!file2.isFile()) {
            this.errorAndExit("No AndroidManifest.xml file found in the main project directory: %1$s", file.getAbsolutePath());
            return;
        }
        XPath xPath = AndroidXPathFactory.newXPath();
        try {
            string2 = xPath.evaluate("/manifest/@package", new InputSource(new FileInputStream(file2)));
            this.mSdkLog.info("Found main project package: %1$s\n", new Object[]{string2});
            string = xPath.evaluate("/manifest/application/activity[1]/@android:name", new InputSource(new FileInputStream(file2)));
            if (string == null || string.length() == 0) {
                string = null;
            } else {
                this.mSdkLog.info("Found main project activity: %1$s\n", new Object[]{string});
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorAndExit("No AndroidManifest.xml file found in main project.", new Object[0]);
            return;
        }
        catch (XPathExpressionException xPathExpressionException) {
            this.errorAndExit("Unable to parse main project manifest to get information.", new Object[0]);
            return;
        }
        ProjectProperties projectProperties = ProjectProperties.load((String)file.getAbsolutePath(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
        if (projectProperties == null) {
            this.errorAndExit("Unable to load the main project's %1$s", ProjectProperties.PropertyType.PROJECT.getFilename());
            return;
        }
        String string5 = projectProperties.getProperty("target");
        if (string5 == null) {
            this.errorAndExit("Couldn't find the main project target", new Object[0]);
            return;
        }
        IAndroidTarget iAndroidTarget = this.mSdkManager.getTargetFromHashString(string5);
        if (iAndroidTarget == null) {
            this.errorAndExit("Unable to resolve main project target '%1$s'. You may want to install the platform in your SDK.", string5);
            return;
        }
        this.mSdkLog.info("Found main project target: %1$s\n", new Object[]{iAndroidTarget.getFullName()});
        ProjectCreator projectCreator = this.getProjectCreator();
        String string6 = this.mSdkCommandLine.getParamName();
        if (string6 != null && !ProjectCreator.RE_PROJECT_NAME.matcher(string6).matches()) {
            this.errorAndExit("Project name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", string6, "a-z A-Z 0-9 _");
            return;
        }
        projectCreator.createProject(string3, string6, string2, string, iAndroidTarget, false, string4);
    }

    private void createUiTestProject() {
        File file;
        String string;
        IAndroidTarget iAndroidTarget;
        String string2 = this.getProjectLocation(this.mSdkCommandLine.getParamLocationPath());
        int n = this.resolveTargetName(this.mSdkCommandLine.getParamTargetId());
        IAndroidTarget[] iAndroidTargetArray = this.mSdkManager.getTargets();
        if (n == 0 || n > iAndroidTargetArray.length) {
            this.errorAndExit("Target id is not valid. Use '%s list targets' to get the target ids.", SdkConstants.androidCmdName());
        }
        if ((iAndroidTarget = iAndroidTargetArray[n - 1]).getVersion().getApiLevel() < 16) {
            this.errorAndExit("UI test projects can only target API 16 and above", new Object[0]);
        }
        if ((string = this.mSdkCommandLine.getParamName()) == null) {
            file = new File(string2);
            string = file.getName();
        }
        try {
            file = new File(string2, "src");
            file.mkdir();
            ProjectPropertiesWorkingCopy projectPropertiesWorkingCopy = ProjectProperties.create((String)string2, (ProjectProperties.PropertyType)ProjectProperties.PropertyType.LOCAL);
            projectPropertiesWorkingCopy.setProperty("sdk.dir", this.mOsSdkFolder);
            projectPropertiesWorkingCopy.save();
            ProjectPropertiesWorkingCopy projectPropertiesWorkingCopy2 = ProjectProperties.create((String)string2, (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
            projectPropertiesWorkingCopy2.setProperty("target", iAndroidTarget.hashString());
            projectPropertiesWorkingCopy2.save();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("PROJECT_NAME", string);
            ProjectCreator projectCreator = this.getProjectCreator();
            projectCreator.installTemplate("uibuild.template", new File(string2, "build.xml"), hashMap);
        }
        catch (Exception exception) {
            this.mSdkLog.error((Throwable)exception, null, new Object[0]);
        }
    }

    private void updateProject(boolean bl) {
        IAndroidTarget[] iAndroidTargetArray;
        IAndroidTarget iAndroidTarget = null;
        String string = this.mSdkCommandLine.getParamTargetId();
        if (string != null) {
            iAndroidTargetArray = this.mSdkManager.getTargets();
            int n = this.resolveTargetName(string);
            if (n == 0 || n > iAndroidTargetArray.length) {
                this.errorAndExit("Target id '%1$s' is not valid. Use '%2$s list targets' to get the target ids.", string, SdkConstants.androidCmdName());
            }
            iAndroidTarget = iAndroidTargetArray[n - 1];
        }
        iAndroidTargetArray = this.getProjectCreator();
        String string2 = this.getProjectLocation(this.mSdkCommandLine.getParamLocationPath());
        String string3 = bl ? null : this.mSdkCommandLine.getParamProjectLibrary("project");
        iAndroidTargetArray.updateProject(string2, iAndroidTarget, this.mSdkCommandLine.getParamName(), string3);
        if (!bl) {
            boolean bl2 = this.mSdkCommandLine.getParamSubProject();
            boolean bl3 = false;
            File[] fileArray = new File(string2).listFiles();
            if (fileArray != null) {
                for (File file : fileArray) {
                    if (!file.isDirectory() || !new File(file, "AndroidManifest.xml").isFile()) continue;
                    if (bl2) {
                        iAndroidTargetArray.updateProject(file.getPath(), iAndroidTarget, this.mSdkCommandLine.getParamName(), null);
                        continue;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                this.mSdkLog.info("It seems that there are sub-projects. If you want to update them\nplease use the --%1$s parameter.\n", new Object[]{"subprojects"});
            }
        }
    }

    private void updateTestProject() {
        ProjectCreator projectCreator = this.getProjectCreator();
        String string = this.getProjectLocation(this.mSdkCommandLine.getParamLocationPath());
        projectCreator.updateTestProject(string, this.mSdkCommandLine.getParamTestProjectMain(), this.mSdkManager);
    }

    private String getProjectLocation(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            return string;
        }
        if (this.mWorkDir == null) {
            return string;
        }
        try {
            file = new File(this.mWorkDir, string).getCanonicalFile();
            return file.getPath();
        }
        catch (IOException iOException) {
            this.errorAndExit("Failed to combine working directory '%1$s' with project location '%2$s': %3$s", this.mWorkDir.getPath(), string, iOException.getMessage());
            return null;
        }
    }

    void displayTargetList() {
        if (this.mSdkCommandLine != null && this.mSdkCommandLine.getFlagCompact()) {
            char c = this.mSdkCommandLine.getFlagEolNull() ? (char)'\u0000' : '\n';
            for (IAndroidTarget iAndroidTarget : this.mSdkManager.getTargets()) {
                this.mSdkLog.info("%1$s%2$c", new Object[]{iAndroidTarget.hashString(), Character.valueOf(c)});
            }
            return;
        }
        this.mSdkLog.info("Available Android targets:\n", new Object[0]);
        int n = 1;
        for (IAndroidTarget iAndroidTarget : this.mSdkManager.getTargets()) {
            this.mSdkLog.info("----------\n", new Object[0]);
            this.mSdkLog.info("id: %1$d or \"%2$s\"\n", new Object[]{n, iAndroidTarget.hashString()});
            this.mSdkLog.info("     Name: %s\n", new Object[]{iAndroidTarget.getName()});
            if (iAndroidTarget.isPlatform()) {
                this.mSdkLog.info("     Type: Platform\n", new Object[0]);
                this.mSdkLog.info("     API level: %s\n", new Object[]{iAndroidTarget.getVersion().getApiString()});
                this.mSdkLog.info("     Revision: %d\n", new Object[]{iAndroidTarget.getRevision()});
            } else {
                this.mSdkLog.info("     Type: Add-On\n", new Object[0]);
                this.mSdkLog.info("     Vendor: %s\n", new Object[]{iAndroidTarget.getVendor()});
                this.mSdkLog.info("     Revision: %d\n", new Object[]{iAndroidTarget.getRevision()});
                if (iAndroidTarget.getDescription() != null) {
                    this.mSdkLog.info("     Description: %s\n", new Object[]{iAndroidTarget.getDescription()});
                }
                this.mSdkLog.info("     Based on Android %s (API level %s)\n", new Object[]{iAndroidTarget.getVersionName(), iAndroidTarget.getVersion().getApiString()});
                IAndroidTarget.IOptionalLibrary[] iOptionalLibraryArray = iAndroidTarget.getOptionalLibraries();
                if (iOptionalLibraryArray != null) {
                    this.mSdkLog.info("     Libraries:\n", new Object[0]);
                    for (IAndroidTarget.IOptionalLibrary iOptionalLibrary : iOptionalLibraryArray) {
                        this.mSdkLog.info("      * %1$s (%2$s)\n", new Object[]{iOptionalLibrary.getName(), iOptionalLibrary.getJarName()});
                        this.mSdkLog.info("          %1$s\n", new Object[]{iOptionalLibrary.getDescription()});
                    }
                }
            }
            this.displaySkinList(iAndroidTarget, "     Skins: ");
            this.displayAbiList(iAndroidTarget, "     ABIs : ");
            if (iAndroidTarget.getUsbVendorId() != 0) {
                this.mSdkLog.info("     Adds USB support for devices (Vendor: 0x%04X)\n", new Object[]{iAndroidTarget.getUsbVendorId()});
            }
            ++n;
        }
    }

    void displaySkinList(IAndroidTarget iAndroidTarget, String string) {
        String[] stringArray = iAndroidTarget.getSkins();
        String string2 = iAndroidTarget.getDefaultSkin();
        this.mSdkLog.info(string, new Object[0]);
        if (stringArray != null) {
            boolean bl = true;
            for (String string3 : stringArray) {
                if (!bl) {
                    this.mSdkLog.info(", ", new Object[0]);
                } else {
                    bl = false;
                }
                this.mSdkLog.info(string3, new Object[0]);
                if (!string3.equals(string2)) continue;
                this.mSdkLog.info(" (default)", new Object[0]);
            }
            this.mSdkLog.info("\n", new Object[0]);
        } else {
            this.mSdkLog.info("no skins.\n", new Object[0]);
        }
    }

    void displayAbiList(IAndroidTarget iAndroidTarget, String string) {
        ISystemImage[] iSystemImageArray = iAndroidTarget.getSystemImages();
        this.mSdkLog.info(string, new Object[0]);
        if (iSystemImageArray.length > 0) {
            boolean bl = true;
            for (ISystemImage iSystemImage : iSystemImageArray) {
                if (!bl) {
                    this.mSdkLog.info(", ", new Object[0]);
                } else {
                    bl = false;
                }
                this.mSdkLog.info(iSystemImage.getAbiType(), new Object[0]);
            }
            this.mSdkLog.info("\n", new Object[0]);
        } else {
            this.mSdkLog.info("no ABIs.\n", new Object[0]);
        }
    }

    void displayAvdList(AvdManager avdManager) {
        String string;
        AvdInfo[] avdInfoArray = avdManager.getValidAvds();
        if (this.mSdkCommandLine != null && this.mSdkCommandLine.getFlagCompact()) {
            char c = this.mSdkCommandLine.getFlagEolNull() ? (char)'\u0000' : '\n';
            for (int i = 0; i < avdInfoArray.length; ++i) {
                AvdInfo avdInfo = avdInfoArray[i];
                this.mSdkLog.info("%1$s%2$c", new Object[]{avdInfo.getName(), Character.valueOf(c)});
            }
            return;
        }
        this.mSdkLog.info("Available Android Virtual Devices:\n", new Object[0]);
        for (int i = 0; i < avdInfoArray.length; ++i) {
            Object object;
            AvdInfo avdInfo = avdInfoArray[i];
            if (i > 0) {
                this.mSdkLog.info("---------\n", new Object[0]);
            }
            this.mSdkLog.info("    Name: %s\n", new Object[]{avdInfo.getName()});
            this.mSdkLog.info("    Path: %s\n", new Object[]{avdInfo.getDataFolderPath()});
            IAndroidTarget iAndroidTarget = avdInfo.getTarget();
            if (iAndroidTarget.isPlatform()) {
                this.mSdkLog.info("  Target: %s (API level %s)\n", new Object[]{iAndroidTarget.getName(), iAndroidTarget.getVersion().getApiString()});
            } else {
                this.mSdkLog.info("  Target: %s (%s)\n", new Object[]{iAndroidTarget.getName(), iAndroidTarget.getVendor()});
                this.mSdkLog.info("          Based on Android %s (API level %s)\n", new Object[]{iAndroidTarget.getVersionName(), iAndroidTarget.getVersion().getApiString()});
            }
            this.mSdkLog.info("     ABI: %s\n", new Object[]{avdInfo.getAbiType()});
            Map map = avdInfo.getProperties();
            if (map == null) continue;
            String string2 = (String)map.get("skin.name");
            if (string2 != null) {
                this.mSdkLog.info("    Skin: %s\n", new Object[]{string2});
            }
            if ((object = (String)map.get("sdcard.size")) == null) {
                object = (String)map.get("sdcard.path");
            }
            if (object != null) {
                this.mSdkLog.info("  Sdcard: %s\n", new Object[]{object});
            }
            if ((string = (String)map.get("snapshot.present")) == null) continue;
            this.mSdkLog.info("Snapshot: %s\n", new Object[]{string});
        }
        IAndroidTarget iAndroidTarget = avdManager.getBrokenAvds();
        if (((AvdInfo[])iAndroidTarget).length == 0) {
            return;
        }
        this.mSdkLog.info("\nThe following Android Virtual Devices could not be loaded:\n", new Object[0]);
        boolean bl = false;
        for (Object object : iAndroidTarget) {
            if (bl) {
                this.mSdkLog.info("---------\n", new Object[0]);
            }
            this.mSdkLog.info("    Name: %s\n", new Object[]{object.getName() == null ? "--" : object.getName()});
            this.mSdkLog.info("    Path: %s\n", new Object[]{object.getDataFolderPath() == null ? "--" : object.getDataFolderPath()});
            string = object.getErrorMessage();
            this.mSdkLog.info("   Error: %s\n", new Object[]{string == null ? "Uknown error" : string});
            bl = true;
        }
    }

    private void displayAvdList() {
        try {
            AvdManager avdManager = AvdManager.getInstance((SdkManager)this.mSdkManager, (ILogger)this.mSdkLog);
            this.displayAvdList(avdManager);
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            this.errorAndExit(androidLocationException.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createAvd() {
        int n = this.resolveTargetName(this.mSdkCommandLine.getParamTargetId());
        IAndroidTarget[] iAndroidTargetArray = this.mSdkManager.getTargets();
        if (n == 0 || n > iAndroidTargetArray.length) {
            this.errorAndExit("Target id is not valid. Use '%s list targets' to get the target ids.", SdkConstants.androidCmdName());
        }
        IAndroidTarget iAndroidTarget = iAndroidTargetArray[n - 1];
        try {
            void var13_20;
            boolean bl = this.mSdkCommandLine.getFlagForce();
            AvdManager avdManager = AvdManager.getInstance((SdkManager)this.mSdkManager, (ILogger)this.mSdkLog);
            String string = this.mSdkCommandLine.getParamName();
            if (!AvdManager.RE_AVD_NAME.matcher(string).matches()) {
                this.errorAndExit("AVD name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", string, "a-z A-Z 0-9 . _ -");
                return;
            }
            AvdInfo avdInfo = avdManager.getAvd(string, false);
            if (avdInfo != null) {
                if (bl) {
                    this.mSdkLog.warning("Android Virtual Device '%s' already exists and will be replaced.", new Object[]{string});
                } else {
                    this.errorAndExit("Android Virtual Device '%s' already exists.\nUse --force if you want to replace it.", string);
                    return;
                }
            }
            String string2 = this.mSdkCommandLine.getParamLocationPath();
            File file = null;
            file = string2 != null ? new File(string2) : AvdInfo.getDefaultAvdFolder((AvdManager)avdManager, (String)string);
            Map map = null;
            String string3 = this.mSdkCommandLine.getParamSkin();
            if (string3 != null && string3.length() == 0) {
                string3 = null;
            }
            if (string3 != null && iAndroidTarget != null) {
                boolean bl2 = false;
                for (String string4 : iAndroidTarget.getSkins()) {
                    if (!string3.equalsIgnoreCase(string4)) continue;
                    string3 = string4;
                    bl2 = true;
                    File file2 = avdManager.getSkinPath(string3, iAndroidTarget);
                    FileWrapper fileWrapper = new FileWrapper(file2, "hardware.ini");
                    if (!fileWrapper.isFile()) break;
                    map = ProjectProperties.parsePropertyFile((IAbstractFile)fileWrapper, (ILogger)this.mSdkLog);
                    break;
                }
                if (!bl2) {
                    bl2 = AvdManager.NUMERIC_SKIN_SIZE.matcher(string3).matches();
                }
                if (!bl2) {
                    this.displaySkinList(iAndroidTarget, "Valid skins: ");
                    this.errorAndExit("'%s' is not a valid skin name or size (NNNxMMM)", string3);
                    return;
                }
            }
            String string5 = this.mSdkCommandLine.getParamAbi();
            if (iAndroidTarget != null && (string5 == null || string5.length() == 0)) {
                ISystemImage[] iSystemImageArray = iAndroidTarget.getSystemImages();
                if (iSystemImageArray != null && iSystemImageArray.length == 1) {
                    string5 = iSystemImageArray[0].getAbiType();
                    this.mSdkLog.info("Auto-selecting single ABI %1$s\n", new Object[]{string5});
                } else {
                    this.displayAbiList(iAndroidTarget, "Valid ABIs: ");
                    this.errorAndExit("This platform has more than one ABI. Please specify one using --%1$s.", "abi");
                }
            }
            Object var13_18 = null;
            if (iAndroidTarget != null && iAndroidTarget.isPlatform()) {
                try {
                    Map<String, String> map2 = this.promptForHardware(iAndroidTarget, map);
                }
                catch (IOException iOException) {
                    this.errorAndExit(iOException.getMessage(), new Object[0]);
                }
            }
            AvdInfo avdInfo2 = null;
            if (bl) {
                avdInfo2 = avdManager.getAvd(string, false);
            }
            AvdInfo avdInfo3 = avdManager.createAvd(file, string, iAndroidTarget, string5, string3, this.mSdkCommandLine.getParamSdCard(), (Map)var13_20, this.mSdkCommandLine.getFlagSnapshot(), bl, false, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            this.errorAndExit(androidLocationException.getMessage(), new Object[0]);
        }
    }

    private void deleteAvd() {
        try {
            String string = this.mSdkCommandLine.getParamName();
            AvdManager avdManager = AvdManager.getInstance((SdkManager)this.mSdkManager, (ILogger)this.mSdkLog);
            AvdInfo avdInfo = avdManager.getAvd(string, false);
            if (avdInfo == null) {
                this.errorAndExit("There is no Android Virtual Device named '%s'.", string);
                return;
            }
            avdManager.deleteAvd(avdInfo, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            this.errorAndExit(androidLocationException.getMessage(), new Object[0]);
        }
    }

    private void moveAvd() {
        try {
            File file;
            File file2;
            String string;
            String string2 = this.mSdkCommandLine.getParamName();
            AvdManager avdManager = AvdManager.getInstance((SdkManager)this.mSdkManager, (ILogger)this.mSdkLog);
            AvdInfo avdInfo = avdManager.getAvd(string2, true);
            if (avdInfo == null) {
                this.errorAndExit("There is no valid Android Virtual Device named '%s'.", string2);
                return;
            }
            String string3 = this.mSdkCommandLine.getParamMoveNewName();
            if (string3 != null && string3.equals(avdInfo.getName())) {
                string3 = null;
            }
            if ((string = this.mSdkCommandLine.getParamLocationPath()) != null) {
                try {
                    file2 = new File(string).getCanonicalFile();
                    file = new File(avdInfo.getDataFolderPath()).getCanonicalFile();
                    if (file2.equals(file)) {
                        string = null;
                    }
                }
                catch (IOException iOException) {
                    this.errorAndExit(iOException.getMessage(), new Object[0]);
                    return;
                }
            }
            if (string3 == null && string == null) {
                this.mSdkLog.warning("Move operation aborted: same AVD name, same canonical data path", new Object[0]);
                return;
            }
            if (string3 != null && string == null) {
                file2 = new File(AndroidLocation.getFolder() + "avd", avdInfo.getName() + ".avd");
                if (avdInfo.getDataFolderPath() != null && file2.equals(new File(avdInfo.getDataFolderPath()))) {
                    try {
                        file = new File(AndroidLocation.getFolder() + "avd", string3 + ".avd");
                        string = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        this.errorAndExit(iOException.getMessage(), new Object[0]);
                    }
                }
            }
            if (string3 != null) {
                if (avdManager.getAvd(string3, false) != null) {
                    this.errorAndExit("There is already an AVD named '%s'.", string3);
                    return;
                }
                file2 = avdInfo.getIniFile();
                if (file2.equals(AvdInfo.getDefaultIniFile((AvdManager)avdManager, (String)string3))) {
                    this.errorAndExit("The AVD file '%s' is in the way.", file2.getCanonicalPath());
                    return;
                }
            }
            if (string != null && new File(string).exists()) {
                this.errorAndExit("There is already a file or directory at '%s'.\nUse --path to specify a different data folder.", string);
            }
            avdManager.moveAvd(avdInfo, string3, string, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            this.errorAndExit(androidLocationException.getMessage(), new Object[0]);
        }
        catch (IOException iOException) {
            this.errorAndExit(iOException.getMessage(), new Object[0]);
        }
    }

    private void updateAvd() {
        try {
            String string = this.mSdkCommandLine.getParamName();
            AvdManager avdManager = AvdManager.getInstance((SdkManager)this.mSdkManager, (ILogger)this.mSdkLog);
            avdManager.updateAvd(string, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            this.errorAndExit(androidLocationException.getMessage(), new Object[0]);
        }
        catch (IOException iOException) {
            this.errorAndExit(iOException.getMessage(), new Object[0]);
        }
    }

    private void updateAdb() {
        try {
            this.mSdkManager.updateAdb();
            this.mSdkLog.info("adb has been updated. You must restart adb with the following commands\n\tadb kill-server\n\tadb start-server\n", new Object[0]);
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            this.errorAndExit(androidLocationException.getMessage(), new Object[0]);
        }
        catch (IOException iOException) {
            this.errorAndExit(iOException.getMessage(), new Object[0]);
        }
    }

    private Map<String, String> promptForHardware(IAndroidTarget iAndroidTarget, Map<String, String> map) throws IOException {
        byte[] byArray = new byte[256];
        String string = "no";
        this.mSdkLog.info("%s is a basic Android platform.\n", new Object[]{iAndroidTarget.getName()});
        this.mSdkLog.info("Do you wish to create a custom hardware profile [%s]", new Object[]{string});
        String string2 = this.readLine(byArray).trim();
        if (string2.length() == 0) {
            string2 = string;
        }
        if (!this.getBooleanReply(string2)) {
            return map;
        }
        this.mSdkLog.info("\n", new Object[0]);
        File file = new File(this.mOsSdkFolder + File.separator + SdkConstants.OS_SDK_TOOLS_LIB_FOLDER, "hardware-properties.ini");
        Map map2 = HardwareProperties.parseHardwareDefinitions((File)file, null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HardwareProperties.HardwareProperty[] hardwarePropertyArray = map2.values().toArray(new HardwareProperties.HardwareProperty[map2.size()]);
        int n = 0;
        while (n < hardwarePropertyArray.length) {
            String string3;
            HardwareProperties.HardwareProperty hardwareProperty = hardwarePropertyArray[n];
            String string4 = hardwareProperty.getDescription();
            if (string4 != null) {
                this.mSdkLog.info("%s: %s\n", new Object[]{hardwareProperty.getAbstract(), string4});
            } else {
                this.mSdkLog.info("%s\n", new Object[]{hardwareProperty.getAbstract()});
            }
            String string5 = hardwareProperty.getDefault();
            String string6 = string3 = map != null ? map.get(hardwareProperty.getName()) : null;
            if (string3 != null) {
                this.mSdkLog.info("%s [%s (from skin)]:", new Object[]{hardwareProperty.getName(), string3});
            } else if (string5 != null) {
                this.mSdkLog.info("%s [%s]:", new Object[]{hardwareProperty.getName(), string5});
            } else {
                this.mSdkLog.info("%s (%s):", new Object[]{hardwareProperty.getName(), hardwareProperty.getType()});
            }
            string2 = this.readLine(byArray);
            if (string2.length() == 0) {
                if (string3 == null && string5 == null) continue;
                if (string3 != null) {
                    hashMap.put(hardwareProperty.getName(), string3);
                }
                this.mSdkLog.info("\n", new Object[0]);
                ++n;
                continue;
            }
            switch (hardwareProperty.getType()) {
                case BOOLEAN: {
                    try {
                        if (this.getBooleanReply(string2)) {
                            hashMap.put(hardwareProperty.getName(), "yes");
                            ++n;
                            break;
                        }
                        hashMap.put(hardwareProperty.getName(), "no");
                        ++n;
                    }
                    catch (IOException iOException) {
                        this.mSdkLog.info("\n%s\n", new Object[]{iOException.getMessage()});
                    }
                    break;
                }
                case INTEGER: {
                    try {
                        Integer.parseInt(string2);
                        hashMap.put(hardwareProperty.getName(), string2);
                        ++n;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.mSdkLog.info("\n%s\n", new Object[]{numberFormatException.getMessage()});
                    }
                    break;
                }
                case DISKSIZE: {
                    hashMap.put(hardwareProperty.getName(), string2);
                    ++n;
                }
            }
            this.mSdkLog.info("\n", new Object[0]);
        }
        return hashMap;
    }

    private String readLine(byte[] byArray) throws IOException {
        int n = System.in.read(byArray);
        if (n == byArray.length && byArray[n - 1] != 10) {
            byte[] byArray2 = new byte[256];
            String string = this.readLine(byArray2);
            return new String(byArray, 0, n) + string;
        }
        while (n > 0 && (byArray[n - 1] == 13 || byArray[n - 1] == 10)) {
            --n;
        }
        return new String(byArray, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String promptPassword(String string) throws IOException {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (atomicBoolean.get()) {
                    System.err.print("\b ");
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "eraser");
        try {
            System.err.print(string);
            thread.start();
            byte[] byArray = new byte[256];
            String string2 = this.readLine(byArray);
            return string2;
        }
        finally {
            atomicBoolean.set(false);
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean getBooleanReply(String string) throws IOException {
        for (String string2 : BOOLEAN_YES_REPLIES) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        for (String string2 : BOOLEAN_NO_REPLIES) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return false;
        }
        throw new IOException(String.format("%s is not a valid reply", string));
    }

    private void errorAndExit(String string, Object ... objectArray) {
        this.mSdkLog.error(null, string, objectArray);
        System.exit(1);
    }

    private int resolveTargetName(String string) {
        if (string == null) {
            return 0;
        }
        if ((string = string.trim()).matches("[0-9]*")) {
            try {
                int n = Integer.parseInt(string);
                return n < 1 ? 0 : n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        IAndroidTarget[] iAndroidTargetArray = this.mSdkManager.getTargets();
        for (int i = 0; i < iAndroidTargetArray.length; ++i) {
            if (!string.equals(iAndroidTargetArray[i].hashString())) continue;
            return i + 1;
        }
        return 0;
    }
}

