/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkmanager;

import com.android.sdklib.repository.SdkRepoConstants;
import com.android.sdklib.util.CommandLineParser;
import com.android.utils.ILogger;
import java.util.Arrays;

class SdkCommandLine
extends CommandLineParser {
    public static final String VERB_LIST = "list";
    public static final String VERB_CREATE = "create";
    public static final String VERB_MOVE = "move";
    public static final String VERB_DELETE = "delete";
    public static final String VERB_UPDATE = "update";
    public static final String VERB_SDK = "sdk";
    public static final String VERB_AVD = "avd";
    public static final String OBJECT_SDK = "sdk";
    public static final String OBJECT_AVD = "avd";
    public static final String OBJECT_AVDS = "avds";
    public static final String OBJECT_TARGET = "target";
    public static final String OBJECT_TARGETS = "targets";
    public static final String OBJECT_PROJECT = "project";
    public static final String OBJECT_TEST_PROJECT = "test-project";
    public static final String OBJECT_UITEST_PROJECT = "uitest-project";
    public static final String OBJECT_LIB_PROJECT = "lib-project";
    public static final String OBJECT_ADB = "adb";
    public static final String ARG_ALIAS = "alias";
    public static final String ARG_ACTIVITY = "activity";
    public static final String KEY_ACTIVITY = "activity";
    public static final String KEY_PACKAGE = "package";
    public static final String KEY_MODE = "mode";
    public static final String KEY_TARGET_ID = "target";
    public static final String KEY_NAME = "name";
    public static final String KEY_LIBRARY = "library";
    public static final String KEY_PATH = "path";
    public static final String KEY_FILTER = "filter";
    public static final String KEY_SKIN = "skin";
    public static final String KEY_SDCARD = "sdcard";
    public static final String KEY_FORCE = "force";
    public static final String KEY_RENAME = "rename";
    public static final String KEY_SUBPROJECTS = "subprojects";
    public static final String KEY_MAIN_PROJECT = "main";
    public static final String KEY_NO_UI = "no-ui";
    public static final String KEY_NO_HTTPS = "no-https";
    public static final String KEY_PROXY_PORT = "proxy-port";
    public static final String KEY_PROXY_HOST = "proxy-host";
    public static final String KEY_DRY_MODE = "dry-mode";
    public static final String KEY_ALL = "all";
    public static final String KEY_EXTENDED = "extended";
    public static final String KEY_SNAPSHOT = "snapshot";
    public static final String KEY_COMPACT = "compact";
    public static final String KEY_EOL_NULL = "null";
    public static final String KEY_ABI = "abi";
    public static final String KEY_ACCOUNT = "account";
    public static final String KEY_KEYSTORE = "keystore";
    public static final String KEY_ALIAS = "alias";
    public static final String KEY_STOREPASS = "storepass";
    public static final String KEY_KEYPASS = "keypass";
    public static final String KEY_CLEAR_CACHE = "clear-cache";
    private static final String[][] ACTIONS = new String[][]{{"sdk", "", "Displays the SDK Manager window."}, {"avd", "", "Displays the AVD Manager window."}, {"list", "", "Lists existing targets or virtual devices."}, {"list", "avd", "Lists existing Android Virtual Devices.", "avds"}, {"list", "target", "Lists existing targets.", "targets"}, {"list", "sdk", "Lists remote SDK repository."}, {"create", "avd", "Creates a new Android Virtual Device."}, {"move", "avd", "Moves or renames an Android Virtual Device."}, {"delete", "avd", "Deletes an Android Virtual Device."}, {"update", "avd", "Updates an Android Virtual Device to match the folders of a new SDK."}, {"create", "project", "Creates a new Android project."}, {"update", "project", "Updates an Android project (must already have an AndroidManifest.xml)."}, {"create", "test-project", "Creates a new Android project for a test package."}, {"update", "test-project", "Updates the Android project for a test package (must already have an AndroidManifest.xml)."}, {"create", "lib-project", "Creates a new Android library project."}, {"update", "lib-project", "Updates an Android library project (must already have an AndroidManifest.xml)."}, {"create", "uitest-project", "Creates a new UI test project."}, {"update", "adb", "Updates adb to support the USB devices declared in the SDK add-ons."}, {"update", "sdk", "Updates the SDK by suggesting new platforms to install if available."}};

    public SdkCommandLine(ILogger iLogger) {
        super(iLogger, ACTIONS);
        this.define(CommandLineParser.Mode.BOOLEAN, false, "@@internal@@", "", "", KEY_CLEAR_CACHE, "Clear the SDK Manager repository manifest cache.", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "avd", "c", KEY_COMPACT, "Compact output (suitable for scripts)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "avd", "0", KEY_EOL_NULL, "Terminates lines with \\0 instead of \\n (e.g. for xargs -0). Only used by --compact.", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "target", "c", KEY_COMPACT, "Compact output (suitable for scripts)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "target", "0", KEY_EOL_NULL, "Terminates lines with \\0 instead of \\n (e.g. for xargs -0) Only used by --compact.", false);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, "avd", "p", KEY_PATH, "Directory where the new AVD will be created.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, "avd", "n", KEY_NAME, "Name of the new AVD.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, "avd", "t", "target", "Target ID of the new AVD.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, "avd", "s", KEY_SKIN, "Skin for the new AVD.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, "avd", "c", KEY_SDCARD, "Path to a shared SD card image, or size of a new sdcard for the new AVD.", null);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_CREATE, "avd", "f", KEY_FORCE, "Forces creation (overwrites an existing AVD)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_CREATE, "avd", "a", KEY_SNAPSHOT, "Place a snapshots file in the AVD, to enable persistence.", false);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, "avd", "b", KEY_ABI, "The ABI to use for the AVD. The default is to auto-select the ABI if the platform has only one ABI for its system images.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_DELETE, "avd", "n", KEY_NAME, "Name of the AVD to delete.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_MOVE, "avd", "n", KEY_NAME, "Name of the AVD to move or rename.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_MOVE, "avd", "r", KEY_RENAME, "New name of the AVD.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_MOVE, "avd", "p", KEY_PATH, "Path to the AVD's new directory.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_UPDATE, "avd", "n", KEY_NAME, "Name of the AVD to update", null);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "sdk", "u", KEY_NO_UI, "Displays list result on console (no GUI)", true);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "sdk", "s", KEY_NO_HTTPS, "Uses HTTP instead of HTTPS (the default) for downloads.", false);
        this.define(CommandLineParser.Mode.STRING, false, VERB_LIST, "sdk", "", KEY_PROXY_PORT, "HTTP/HTTPS proxy port (overrides settings if defined)", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_LIST, "sdk", "", KEY_PROXY_HOST, "HTTP/HTTPS proxy host (overrides settings if defined)", null);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "sdk", "a", KEY_ALL, "Lists all available packages (including obsolete and installed ones)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "sdk", "o", "obsolete", "Deprecated. Please use --all instead.", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "sdk", "e", KEY_EXTENDED, "Displays extended details on each package", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_UPDATE, "sdk", "u", KEY_NO_UI, "Updates from command-line (does not display the GUI)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_UPDATE, "sdk", "s", KEY_NO_HTTPS, "Uses HTTP instead of HTTPS (the default) for downloads.", false);
        this.define(CommandLineParser.Mode.STRING, false, VERB_UPDATE, "sdk", "", KEY_PROXY_PORT, "HTTP/HTTPS proxy port (overrides settings if defined)", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_UPDATE, "sdk", "", KEY_PROXY_HOST, "HTTP/HTTPS proxy host (overrides settings if defined)", null);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_UPDATE, "sdk", "f", KEY_FORCE, "Forces replacement of a package or its parts, even if something has been modified.", false);
        this.define(CommandLineParser.Mode.STRING, false, VERB_UPDATE, "sdk", "t", KEY_FILTER, "A filter that limits the update to the specified types of packages in the form of a comma-separated list of " + Arrays.toString(SdkRepoConstants.NODES) + ". This also accepts the identifiers returned by 'list sdk --extended'.", null);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_UPDATE, "sdk", "a", KEY_ALL, "Includes all packages (such as obsolete and non-dependent ones.)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_UPDATE, "sdk", "p", "obsolete", "Deprecated. Please use --all instead.", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_UPDATE, "sdk", "n", KEY_DRY_MODE, "Simulates the update but does not download or install anything.", false);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_PROJECT, "p", KEY_PATH, "The new project's directory.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_PROJECT, "t", "target", "Target ID of the new project.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_PROJECT, "k", KEY_PACKAGE, "Android package name for the application.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_PROJECT, "a", "activity", "Name of the default Activity that is created.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_PROJECT, "n", KEY_NAME, "Project name.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_TEST_PROJECT, "p", KEY_PATH, "The new project's directory.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_TEST_PROJECT, "n", KEY_NAME, "Project name.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_TEST_PROJECT, "m", KEY_MAIN_PROJECT, "Path to directory of the app under test, relative to the test project directory.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_UITEST_PROJECT, "p", KEY_PATH, "The new project's directory.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_UITEST_PROJECT, "n", KEY_NAME, "Project name.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_UITEST_PROJECT, "t", "target", "Target ID of the new project.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_LIB_PROJECT, "p", KEY_PATH, "The new project's directory.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_LIB_PROJECT, "t", "target", "Target ID of the new project.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_LIB_PROJECT, "n", KEY_NAME, "Project name.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_LIB_PROJECT, "k", KEY_PACKAGE, "Android package name for the library.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_UPDATE, OBJECT_PROJECT, "p", KEY_PATH, "The project's directory.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_UPDATE, OBJECT_PROJECT, "t", "target", "Target ID to set for the project.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_UPDATE, OBJECT_PROJECT, "n", KEY_NAME, "Project name.", null);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_UPDATE, OBJECT_PROJECT, "s", KEY_SUBPROJECTS, "Also updates any projects in sub-folders, such as test projects.", false);
        this.define(CommandLineParser.Mode.STRING, false, VERB_UPDATE, OBJECT_PROJECT, "l", KEY_LIBRARY, "Directory of an Android library to add, relative to this project's directory.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_UPDATE, OBJECT_TEST_PROJECT, "p", KEY_PATH, "The project's directory.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_UPDATE, OBJECT_TEST_PROJECT, "m", KEY_MAIN_PROJECT, "Directory of the app under test, relative to the test project directory.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_UPDATE, OBJECT_LIB_PROJECT, "p", KEY_PATH, "The project's directory.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_UPDATE, OBJECT_LIB_PROJECT, "t", "target", "Target ID to set for the project.", null);
    }

    public boolean acceptLackOfVerb() {
        return true;
    }

    public boolean hasClearCache() {
        return (Boolean)this.getValue("@@internal@@", "", KEY_CLEAR_CACHE);
    }

    public String getParamLocationPath() {
        return (String)this.getValue(null, null, KEY_PATH);
    }

    public String getParamTargetId() {
        return (String)this.getValue(null, null, "target");
    }

    public String getParamName() {
        return (String)this.getValue(null, null, KEY_NAME);
    }

    public String getParamSkin() {
        return (String)this.getValue(null, null, KEY_SKIN);
    }

    public String getParamSdCard() {
        return (String)this.getValue(null, null, KEY_SDCARD);
    }

    public boolean getFlagForce() {
        return (Boolean)this.getValue(null, null, KEY_FORCE);
    }

    public boolean getFlagSnapshot() {
        return (Boolean)this.getValue(null, null, KEY_SNAPSHOT);
    }

    public String getParamMoveNewName() {
        return (String)this.getValue(VERB_MOVE, null, KEY_RENAME);
    }

    public String getParamProjectPackage(String string) {
        return (String)this.getValue(null, string, KEY_PACKAGE);
    }

    public String getParamProjectActivity() {
        return (String)this.getValue(null, OBJECT_PROJECT, "activity");
    }

    public String getParamProjectLibrary(String string) {
        return (String)this.getValue(null, string, KEY_LIBRARY);
    }

    public boolean getParamSubProject() {
        return (Boolean)this.getValue(null, OBJECT_PROJECT, KEY_SUBPROJECTS);
    }

    public String getParamTestProjectMain() {
        return (String)this.getValue(null, null, KEY_MAIN_PROJECT);
    }

    public boolean getFlagNoUI(String string) {
        return (Boolean)this.getValue(string, null, KEY_NO_UI);
    }

    public boolean getFlagNoHttps() {
        return (Boolean)this.getValue(null, null, KEY_NO_HTTPS);
    }

    public boolean getFlagDryMode() {
        return (Boolean)this.getValue(null, null, KEY_DRY_MODE);
    }

    public boolean getFlagObsolete() {
        return (Boolean)this.getValue(null, null, "obsolete");
    }

    public boolean getFlagAll() {
        return (Boolean)this.getValue(null, null, KEY_ALL);
    }

    public boolean getFlagExtended() {
        return (Boolean)this.getValue(null, null, KEY_EXTENDED);
    }

    public String getParamFilter() {
        return (String)this.getValue(null, null, KEY_FILTER);
    }

    public String getParamAbi() {
        return (String)this.getValue(null, null, KEY_ABI);
    }

    public String getParamProxyHost() {
        return (String)this.getValue(null, null, KEY_PROXY_HOST);
    }

    public String getParamProxyPort() {
        return (String)this.getValue(null, null, KEY_PROXY_PORT);
    }

    public boolean getFlagCompact() {
        return (Boolean)this.getValue(null, null, KEY_COMPACT);
    }

    public boolean getFlagEolNull() {
        return (Boolean)this.getValue(null, null, KEY_EOL_NULL);
    }
}

