/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.SdkConstants;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import com.android.sdkuilib.ui.SwtBaseDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class UpdaterBaseDialog
extends SwtBaseDialog {
    private final UpdaterData mUpdaterData;

    protected UpdaterBaseDialog(Shell shell, UpdaterData updaterData, String string) {
        super(shell, 65536, String.format("%1$s - %2$s", "Android SDK Manager", string));
        this.mUpdaterData = updaterData;
    }

    public UpdaterData getUpdaterData() {
        return this.mUpdaterData;
    }

    protected void createContents() {
        Shell shell = this.getShell();
        this.setWindowImage(shell);
        GridLayoutBuilder.create((Composite)shell).columns(2);
    }

    protected void createCloseButton() {
        Button button = new Button((Composite)this.getShell(), 8);
        button.setText("Close");
        GridDataBuilder.create((Control)button).hFill().vBottom();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UpdaterBaseDialog.this.close();
            }
        });
    }

    protected void postCreate() {
    }

    protected void close() {
        super.close();
    }

    private void setWindowImage(Shell shell) {
        ImageFactory imageFactory;
        String string = "android_icon_16.png";
        if (SdkConstants.currentPlatform() == 3) {
            string = "android_icon_128.png";
        }
        if (this.mUpdaterData != null && (imageFactory = this.mUpdaterData.getImageFactory()) != null) {
            shell.setImage(imageFactory.getImageByName(string));
        }
    }
}

