/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.icons;

import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.sources.SdkSourceCategory;
import com.android.sdkuilib.internal.repository.core.PkgContentProvider;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageFactory {
    private final Display mDisplay;
    private final Map<String, Image> mImages = new HashMap<String, Image>();

    public ImageFactory(Display display) {
        this.mDisplay = display;
    }

    public Image getImageByName(String string) {
        Image image = this.mImages.get(string);
        if (image != null) {
            return image;
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream != null) {
            try {
                image = new Image((Device)this.mDisplay, inputStream);
            }
            catch (SWTException sWTException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.mImages.put(string, image);
        return image;
    }

    public Image getImageForObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Image) {
            return (Image)object;
        }
        String string = object.getClass().getSimpleName();
        if (string.endsWith(Package.class.getSimpleName())) {
            String string2 = string.replaceFirst(Package.class.getSimpleName(), "").replace("SystemImage", "sysimg").toLowerCase(Locale.US);
            string2 = string2 + "_pkg_16.png";
            return this.getImageByName(string2);
        }
        if (object instanceof SdkSourceCategory) {
            return this.getImageByName("source_cat_icon_16.png");
        }
        if (object instanceof SdkSource) {
            return this.getImageByName("source_icon_16.png");
        }
        if (object instanceof PkgContentProvider.RepoSourceError) {
            return this.getImageByName("error_icon_16.png");
        }
        if (object instanceof PkgContentProvider.RepoSourceNotification) {
            return this.getImageByName("nopkg_icon_16.png");
        }
        if (object instanceof Archive) {
            if (((Archive)object).isCompatible()) {
                return this.getImageByName("archive_icon16.png");
            }
            return this.getImageByName("incompat_icon16.png");
        }
        if (object instanceof String) {
            return this.getImageByName((String)object);
        }
        if (object != null) {
            // empty if block
        }
        return null;
    }

    public void dispose() {
        Iterator<Image> iterator = this.mImages.values().iterator();
        while (iterator.hasNext()) {
            Image image = iterator.next();
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            iterator.remove();
        }
    }
}

