/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.ui;

import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.core.PkgCategory;
import com.android.sdkuilib.internal.repository.core.PkgCategoryApi;
import com.android.sdkuilib.internal.repository.core.PkgContentProvider;
import com.android.sdkuilib.internal.repository.core.PkgItem;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.repository.ui.AddonSitesDialog;
import com.android.sdkuilib.internal.repository.ui.PackagesPageImpl;
import com.android.sdkuilib.repository.ISdkChangeListener;
import com.android.sdkuilib.repository.SdkUpdaterWindow;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackagesPage
extends Composite
implements ISdkChangeListener {
    private final Map<MenuAction, MenuItem> mMenuActions = new HashMap<MenuAction, MenuItem>();
    private final PackagesPageImpl mImpl;
    private final SdkUpdaterWindow.SdkInvocationContext mContext;
    private boolean mDisplayArchives = false;
    private boolean mOperationPending;
    private Composite mGroupPackages;
    private Text mTextSdkOsPath;
    private Button mCheckSortSource;
    private Button mCheckSortApi;
    private Button mCheckFilterObsolete;
    private Button mCheckFilterInstalled;
    private Button mCheckFilterNew;
    private Composite mGroupOptions;
    private Composite mGroupSdk;
    private Button mButtonDelete;
    private Button mButtonInstall;
    private Font mTreeFontItalic;
    private TreeColumn mTreeColumnName;
    private CheckboxTreeViewer mTreeViewer;

    public PackagesPage(Composite composite, int n, UpdaterData updaterData, SdkUpdaterWindow.SdkInvocationContext sdkInvocationContext) {
        super(composite, n);
        this.mImpl = new PackagesPageImpl(updaterData){

            protected boolean isUiDisposed() {
                return PackagesPage.this.mGroupPackages == null || PackagesPage.this.mGroupPackages.isDisposed();
            }

            protected void syncExec(Runnable runnable) {
                if (!this.isUiDisposed()) {
                    PackagesPage.this.mGroupPackages.getDisplay().syncExec(runnable);
                }
            }

            protected void syncViewerSelection() {
                PackagesPage.this.syncViewerSelection();
            }

            protected void refreshViewerInput() {
                PackagesPage.this.refreshViewerInput();
            }

            protected boolean isSortByApi() {
                return PackagesPage.this.isSortByApi();
            }

            protected Font getTreeFontItalic() {
                return PackagesPage.this.mTreeFontItalic;
            }

            protected void loadPackages(boolean bl, boolean bl2) {
                PackagesPage.this.loadPackages(bl, bl2);
            }
        };
        this.mContext = sdkInvocationContext;
        this.createContents(this);
        this.postCreate();
    }

    public void performFirstLoad() {
        this.mImpl.performFirstLoad();
    }

    private void createContents(Composite composite) {
        GridLayoutBuilder.create(composite).noMargins().columns(2);
        this.mGroupSdk = new Composite(composite, 0);
        GridDataBuilder.create((Control)this.mGroupSdk).hFill().vCenter().hGrab().hSpan(2);
        GridLayoutBuilder.create(this.mGroupSdk).columns(2);
        Label label = new Label(this.mGroupSdk, 0);
        label.setText("SDK Path:");
        this.mTextSdkOsPath = new Text(this.mGroupSdk, 0);
        GridDataBuilder.create((Control)this.mTextSdkOsPath).hFill().vCenter().hGrab();
        this.mTextSdkOsPath.setEnabled(false);
        Group group = new Group(composite, 0);
        this.mGroupPackages = group;
        GridDataBuilder.create((Control)this.mGroupPackages).fill().grab().hSpan(2);
        group.setText("Packages");
        GridLayoutBuilder.create((Composite)group).columns(1);
        this.mTreeViewer = new CheckboxTreeViewer((Composite)group, 2048);
        this.mImpl.setITreeViewer(new PackagesPageImpl.ICheckboxTreeViewer(){

            public Object getInput() {
                return PackagesPage.this.mTreeViewer.getInput();
            }

            @Override
            public void setInput(List<PkgCategory> list) {
                PackagesPage.this.mTreeViewer.setInput(list);
            }

            @Override
            public void setContentProvider(PkgContentProvider pkgContentProvider) {
                PackagesPage.this.mTreeViewer.setContentProvider((IContentProvider)pkgContentProvider);
            }

            @Override
            public void refresh() {
                PackagesPage.this.mTreeViewer.refresh();
            }

            @Override
            public Object[] getCheckedElements() {
                return PackagesPage.this.mTreeViewer.getCheckedElements();
            }
        });
        this.mTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                return PackagesPage.this.filterViewerItem(object2);
            }
        });
        this.mTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                PackagesPage.this.onTreeCheckStateChanged(checkStateChangedEvent);
            }
        });
        this.mTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                PackagesPage.this.onTreeDoubleClick(doubleClickEvent);
            }
        });
        Tree tree = this.mTreeViewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        GridDataBuilder.create((Control)tree).fill().grab();
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn((TreeViewer)this.mTreeViewer, 0);
        this.mTreeColumnName = treeViewerColumn.getColumn();
        this.mTreeColumnName.setText("Name");
        this.mTreeColumnName.setWidth(340);
        TreeViewerColumn treeViewerColumn2 = new TreeViewerColumn((TreeViewer)this.mTreeViewer, 0);
        TreeColumn treeColumn = treeViewerColumn2.getColumn();
        treeColumn.setText("API");
        treeColumn.setAlignment(0x1000000);
        treeColumn.setWidth(50);
        TreeViewerColumn treeViewerColumn3 = new TreeViewerColumn((TreeViewer)this.mTreeViewer, 0);
        TreeColumn treeColumn2 = treeViewerColumn3.getColumn();
        treeColumn2.setText("Rev.");
        treeColumn2.setToolTipText("Revision currently installed");
        treeColumn2.setAlignment(0x1000000);
        treeColumn2.setWidth(50);
        TreeViewerColumn treeViewerColumn4 = new TreeViewerColumn((TreeViewer)this.mTreeViewer, 0);
        TreeColumn treeColumn3 = treeViewerColumn4.getColumn();
        treeColumn3.setText("Status");
        treeColumn3.setAlignment(16384);
        treeColumn3.setWidth(190);
        this.mImpl.setIColumns(this.wrapColumn(treeViewerColumn), this.wrapColumn(treeViewerColumn2), this.wrapColumn(treeViewerColumn3), this.wrapColumn(treeViewerColumn4));
        this.mGroupOptions = new Composite((Composite)group, 0);
        GridDataBuilder.create((Control)this.mGroupOptions).hFill().vCenter().hGrab();
        GridLayoutBuilder.create(this.mGroupOptions).columns(7).noMargins();
        Label label2 = new Label(this.mGroupOptions, 0);
        label2.setText("Show:");
        this.mCheckFilterNew = new Button(this.mGroupOptions, 32);
        this.mCheckFilterNew.setText("Updates/New");
        this.mCheckFilterNew.setToolTipText("Show Updates and New");
        this.mCheckFilterNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PackagesPage.this.refreshViewerInput();
            }
        });
        this.mCheckFilterNew.setSelection(true);
        this.mCheckFilterInstalled = new Button(this.mGroupOptions, 32);
        this.mCheckFilterInstalled.setToolTipText("Show Installed");
        this.mCheckFilterInstalled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PackagesPage.this.refreshViewerInput();
            }
        });
        this.mCheckFilterInstalled.setSelection(true);
        this.mCheckFilterInstalled.setText("Installed");
        this.mCheckFilterObsolete = new Button(this.mGroupOptions, 32);
        this.mCheckFilterObsolete.setText("Obsolete");
        this.mCheckFilterObsolete.setToolTipText("Also show obsolete packages");
        this.mCheckFilterObsolete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PackagesPage.this.refreshViewerInput();
            }
        });
        this.mCheckFilterObsolete.setSelection(false);
        Link link = new Link(this.mGroupOptions, 0);
        link.setText(String.format("Select <a>%1$s</a> or <a>%2$s</a>", "New", "Updates"));
        link.setToolTipText("Selects all items that are either new or updates.");
        GridDataBuilder.create((Control)link).hFill();
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                boolean bl = selectionEvent.text == null || selectionEvent.text.equals("New");
                PackagesPage.this.onSelectNewUpdates(bl, !bl, false);
            }
        });
        Label label3 = new Label(this.mGroupOptions, 0);
        GridDataBuilder.create((Control)label3).hFill().hGrab();
        this.mButtonInstall = new Button(this.mGroupOptions, 0);
        this.mButtonInstall.setText("");
        this.mButtonInstall.setToolTipText("Install one or more packages");
        GridDataBuilder.create((Control)this.mButtonInstall).vCenter().wHint(150);
        this.mButtonInstall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PackagesPage.this.onButtonInstall();
            }
        });
        Label label4 = new Label(this.mGroupOptions, 0);
        label4.setText("Sort by:");
        this.mCheckSortApi = new Button(this.mGroupOptions, 16);
        this.mCheckSortApi.setToolTipText("Sort by API level");
        this.mCheckSortApi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PackagesPage.this.mCheckSortApi.getSelection()) {
                    PackagesPage.this.refreshViewerInput();
                    PackagesPage.this.copySelection(true);
                    PackagesPage.this.syncViewerSelection();
                }
            }
        });
        this.mCheckSortApi.setText("API level");
        this.mCheckSortApi.setSelection(true);
        this.mCheckSortSource = new Button(this.mGroupOptions, 16);
        this.mCheckSortSource.setText("Repository");
        this.mCheckSortSource.setToolTipText("Sort by Repository");
        this.mCheckSortSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PackagesPage.this.mCheckSortSource.getSelection()) {
                    PackagesPage.this.refreshViewerInput();
                    PackagesPage.this.copySelection(false);
                    PackagesPage.this.syncViewerSelection();
                }
            }
        });
        new Label(this.mGroupOptions, 0);
        Link link2 = new Link(this.mGroupOptions, 0);
        link2.setText("<a>Deselect All</a>");
        link2.setToolTipText("Deselects all the currently selected items");
        GridDataBuilder.create((Control)link2).hFill();
        link2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                PackagesPage.this.onDeselectAll();
            }
        });
        label3 = new Label(this.mGroupOptions, 0);
        GridDataBuilder.create((Control)label3).hFill().hGrab();
        this.mButtonDelete = new Button(this.mGroupOptions, 0);
        this.mButtonDelete.setText("");
        this.mButtonDelete.setToolTipText("Delete one ore more installed packages");
        GridDataBuilder.create((Control)this.mButtonDelete).vCenter().wHint(150);
        this.mButtonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PackagesPage.this.onButtonDelete();
            }
        });
    }

    private PackagesPageImpl.ITreeViewerColumn wrapColumn(final TreeViewerColumn treeViewerColumn) {
        return new PackagesPageImpl.ITreeViewerColumn(){

            public void setLabelProvider(ColumnLabelProvider columnLabelProvider) {
                treeViewerColumn.setLabelProvider((CellLabelProvider)columnLabelProvider);
            }
        };
    }

    private Image getImage(String string) {
        ImageFactory imageFactory;
        if (this.mImpl.mUpdaterData != null && (imageFactory = this.mImpl.mUpdaterData.getImageFactory()) != null) {
            return imageFactory.getImageByName(string);
        }
        return null;
    }

    public void registerMenuAction(final MenuAction menuAction, MenuItem menuItem) {
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = null;
                switch (menuAction) {
                    case RELOAD: {
                        PackagesPage.this.mImpl.fullReload();
                        break;
                    }
                    case SHOW_ADDON_SITES: {
                        AddonSitesDialog addonSitesDialog = new AddonSitesDialog(PackagesPage.this.getShell(), ((PackagesPage)PackagesPage.this).mImpl.mUpdaterData);
                        if (!addonSitesDialog.open()) break;
                        PackagesPage.this.mImpl.loadPackages();
                        break;
                    }
                    case TOGGLE_SHOW_ARCHIVES: {
                        PackagesPage.this.mDisplayArchives = !PackagesPage.this.mDisplayArchives;
                        ((PkgContentProvider)PackagesPage.this.mTreeViewer.getContentProvider()).setDisplayArchives(PackagesPage.this.mDisplayArchives);
                        PackagesPage.this.mTreeViewer.setInput(null);
                        PackagesPage.this.refreshViewerInput();
                        PackagesPage.this.syncViewerSelection();
                        break;
                    }
                    case TOGGLE_SHOW_INSTALLED_PKG: {
                        button = PackagesPage.this.mCheckFilterInstalled;
                        break;
                    }
                    case TOGGLE_SHOW_OBSOLETE_PKG: {
                        button = PackagesPage.this.mCheckFilterObsolete;
                        break;
                    }
                    case TOGGLE_SHOW_UPDATE_NEW_PKG: {
                        button = PackagesPage.this.mCheckFilterNew;
                        break;
                    }
                    case SORT_API_LEVEL: {
                        button = PackagesPage.this.mCheckSortApi;
                        break;
                    }
                    case SORT_SOURCE: {
                        button = PackagesPage.this.mCheckSortSource;
                    }
                }
                if (button != null && !button.isDisposed()) {
                    boolean bl = button.getSelection();
                    if (!bl && (button.getStyle() & 0x10) != 0) {
                        for (Control control : button.getParent().getChildren()) {
                            if (!(control instanceof Button) || control == button || (control.getStyle() & 0x10) == 0) continue;
                            ((Button)control).setSelection(bl);
                        }
                    }
                    button.setSelection(!bl);
                    button.notifyListeners(13, new Event());
                }
                PackagesPage.this.updateMenuCheckmarks();
            }
        });
        this.mMenuActions.put(menuAction, menuItem);
    }

    private void updateMenuCheckmarks() {
        for (Map.Entry<MenuAction, MenuItem> entry : this.mMenuActions.entrySet()) {
            MenuAction menuAction = entry.getKey();
            MenuItem menuItem = entry.getValue();
            if (menuAction.getMenuStyle() == 0) continue;
            boolean bl = false;
            Button button = null;
            switch (menuAction) {
                case TOGGLE_SHOW_ARCHIVES: {
                    bl = this.mDisplayArchives;
                    break;
                }
                case TOGGLE_SHOW_INSTALLED_PKG: {
                    button = this.mCheckFilterInstalled;
                    break;
                }
                case TOGGLE_SHOW_OBSOLETE_PKG: {
                    button = this.mCheckFilterObsolete;
                    break;
                }
                case TOGGLE_SHOW_UPDATE_NEW_PKG: {
                    button = this.mCheckFilterNew;
                    break;
                }
                case SORT_API_LEVEL: {
                    button = this.mCheckSortApi;
                    break;
                }
                case SORT_SOURCE: {
                    button = this.mCheckSortSource;
                    break;
                }
            }
            if (button != null && !button.isDisposed()) {
                bl = button.getSelection();
            }
            if (menuItem.isDisposed()) continue;
            menuItem.setSelection(bl);
        }
    }

    private void postCreate() {
        this.mImpl.postCreate();
        if (this.mImpl.mUpdaterData != null) {
            this.mTextSdkOsPath.setText(this.mImpl.mUpdaterData.getOsSdkRoot());
        }
        ((PkgContentProvider)this.mTreeViewer.getContentProvider()).setDisplayArchives(this.mDisplayArchives);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.mTreeViewer, (int)2);
        Tree tree = this.mTreeViewer.getTree();
        FontData fontData = tree.getFont().getFontData()[0];
        fontData.setStyle(2);
        this.mTreeFontItalic = new Font((Device)tree.getDisplay(), fontData);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                PackagesPage.this.mTreeFontItalic.dispose();
                PackagesPage.this.mTreeFontItalic = null;
            }
        });
    }

    private void loadPackages(boolean bl, boolean bl2) {
        if (this.mImpl.mUpdaterData == null) {
            return;
        }
        boolean bl3 = this.isSortByApi();
        if (this.mTreeColumnName.isDisposed()) {
            return;
        }
        this.mTreeColumnName.setImage(this.getImage(bl3 ? "platform_pkg_16.png" : "source_icon16.png"));
        this.mImpl.loadPackagesImpl(bl, bl2);
    }

    private void refreshViewerInput() {
        if (!this.mGroupPackages.isDisposed()) {
            try {
                this.mImpl.setViewerInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.expandInitial(this.mTreeViewer.getInput());
            this.updateButtonsState();
            this.updateMenuCheckmarks();
        }
    }

    private boolean isSortByApi() {
        return this.mCheckSortApi != null && !this.mCheckSortApi.isDisposed() && this.mCheckSortApi.getSelection();
    }

    private boolean filterViewerItem(Object object) {
        Object object2;
        if (object instanceof PkgCategory && !((PkgCategory)(object2 = (PkgCategory)object)).getItems().isEmpty()) {
            for (PkgItem pkgItem : ((PkgCategory)object2).getItems()) {
                if (!this.filterViewerItem(pkgItem)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof PkgItem) {
            object2 = (PkgItem)object;
            if (!this.mCheckFilterObsolete.getSelection() && ((PkgItem)object2).isObsolete()) {
                return false;
            }
            if (!this.mCheckFilterInstalled.getSelection() && ((PkgItem)object2).getState() == PkgItem.PkgState.INSTALLED) {
                return false;
            }
            if (!this.mCheckFilterNew.getSelection() && (((PkgItem)object2).getState() == PkgItem.PkgState.NEW || ((PkgItem)object2).hasUpdatePkg())) {
                return false;
            }
        }
        return true;
    }

    private void expandInitial(Object object) {
        if (object == null) {
            return;
        }
        if (this.mTreeViewer != null && !this.mTreeViewer.getTree().isDisposed()) {
            boolean bl = this.mImpl.mUpdaterData.getSettingsController().getSettings().getEnablePreviews();
            this.mTreeViewer.setExpandedState(object, true);
            block0: for (Object object2 : ((ITreeContentProvider)this.mTreeViewer.getContentProvider()).getChildren(object)) {
                if (!(object2 instanceof PkgCategory)) continue;
                PkgCategory pkgCategory = (PkgCategory)object2;
                if (pkgCategory.getKey().equals(PkgCategoryApi.KEY_TOOLS) || bl && pkgCategory.getKey().equals(PkgCategoryApi.KEY_TOOLS_PREVIEW)) {
                    this.expandInitial(object2);
                    continue;
                }
                for (PkgItem pkgItem : pkgCategory.getItems()) {
                    if (pkgItem.getState() != PkgItem.PkgState.INSTALLED) continue;
                    this.expandInitial(object2);
                    continue block0;
                }
            }
        }
    }

    private void onTreeCheckStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        boolean bl = checkStateChangedEvent.getChecked();
        Object object = checkStateChangedEvent.getElement();
        assert (checkStateChangedEvent.getSource() == this.mTreeViewer);
        this.checkAndExpandItem(object, bl, true, true);
        this.updateButtonsState();
    }

    private void onTreeDoubleClick(DoubleClickEvent doubleClickEvent) {
        assert (doubleClickEvent.getSource() == this.mTreeViewer);
        ISelection iSelection = doubleClickEvent.getSelection();
        if (iSelection.isEmpty() || !(iSelection instanceof ITreeSelection)) {
            return;
        }
        ITreeSelection iTreeSelection = (ITreeSelection)iSelection;
        Object object = iTreeSelection.getFirstElement();
        if (object == null) {
            return;
        }
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.mTreeViewer.getContentProvider();
        Object[] objectArray = iTreeContentProvider.getElements(object);
        if (objectArray == null) {
            return;
        }
        if (objectArray.length > 0) {
            if (this.mTreeViewer.getExpandedState(object)) {
                this.mTreeViewer.collapseToLevel(object, 1);
            } else {
                this.mTreeViewer.expandToLevel(object, 1);
            }
        } else {
            this.checkAndExpandItem(object, !this.mTreeViewer.getChecked(object), false, true);
            this.updateButtonsState();
        }
    }

    private void checkAndExpandItem(Object object, boolean bl, boolean bl2, boolean bl3) {
        Object object2;
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.mTreeViewer.getContentProvider();
        if (bl != this.mTreeViewer.getChecked(object)) {
            this.mTreeViewer.setChecked(object, bl);
        }
        if (object instanceof PkgItem) {
            ((PkgItem)object).setChecked(bl);
        }
        if (!bl) {
            Object[] objectArray;
            if (bl2) {
                this.mTreeViewer.setSubtreeChecked(object, bl);
                objectArray = iTreeContentProvider.getChildren(object);
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object3 = objectArray[i];
                    this.checkAndExpandItem(object3, bl, bl2, false);
                }
            }
            if (bl3 && (objectArray = iTreeContentProvider.getParent(object)) != null && this.mTreeViewer.getChecked((Object)objectArray)) {
                this.mTreeViewer.setChecked((Object)objectArray, false);
            }
            return;
        }
        if (bl2) {
            if (object instanceof PkgCategory || object instanceof PkgItem) {
                for (Object object4 : object2 = iTreeContentProvider.getChildren(object)) {
                    this.checkAndExpandItem(object4, true, bl2, false);
                }
                if (object instanceof PkgCategory) {
                    if (((Object[])object2).length > 0) {
                        this.checkAndExpandItem(object2[0], true, false, true);
                    } else {
                        this.mTreeViewer.setChecked(object, false);
                    }
                }
            } else if (object instanceof Package) {
                this.selectCompatibleArchives(object, iTreeContentProvider);
            }
        }
        if (bl3 && bl && object instanceof PkgItem && !this.mTreeViewer.getChecked(object2 = iTreeContentProvider.getParent(object))) {
            Object[] objectArray = iTreeContentProvider.getChildren(object2);
            int n = objectArray.length > 0 ? 1 : 0;
            for (Object object5 : objectArray) {
                if (this.mTreeViewer.getChecked(object5)) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                this.mTreeViewer.setChecked(object2, true);
            }
        }
    }

    private void selectCompatibleArchives(Object object, ITreeContentProvider iTreeContentProvider) {
        for (Object object2 : iTreeContentProvider.getChildren(object)) {
            if (!(object2 instanceof Archive)) continue;
            this.mTreeViewer.setChecked(object2, ((Archive)object2).isCompatible());
        }
    }

    private void onSelectNewUpdates(boolean bl, boolean bl2, boolean bl3) {
        this.mImpl.onSelectNewUpdates(bl, bl2, bl3);
    }

    private void onDeselectAll() {
        this.mImpl.onDeselectAll();
        this.syncViewerSelection();
    }

    private void copySelection(boolean bl) {
        List<PkgItem> list = this.mImpl.mDiffLogic.getAllPkgItems(!bl, bl);
        List<PkgItem> list2 = this.mImpl.mDiffLogic.getAllPkgItems(bl, !bl);
        for (PkgItem pkgItem : list2) {
            pkgItem.setChecked(false);
        }
        block1: for (PkgItem pkgItem : list) {
            if (!pkgItem.isChecked()) continue;
            for (PkgItem pkgItem2 : list2) {
                if (!pkgItem2.isSameMainPackageAs(pkgItem.getMainPackage())) continue;
                pkgItem2.setChecked(true);
                continue block1;
            }
        }
    }

    private void syncViewerSelection() {
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.mTreeViewer.getContentProvider();
        Object object = this.mTreeViewer.getInput();
        if (object != null) {
            for (Object object2 : iTreeContentProvider.getElements(object)) {
                Object[] objectArray = iTreeContentProvider.getElements(object2);
                boolean bl = objectArray.length > 0;
                for (Object object3 : objectArray) {
                    if (!(object3 instanceof PkgItem)) continue;
                    PkgItem pkgItem = (PkgItem)object3;
                    boolean bl2 = pkgItem.isChecked();
                    bl &= bl2;
                    if (bl2 == this.mTreeViewer.getChecked((Object)pkgItem)) continue;
                    if (bl2 && !this.mTreeViewer.getExpandedState(object2)) {
                        this.mTreeViewer.setExpandedState(object2, true);
                    }
                    this.checkAndExpandItem(pkgItem, bl2, true, false);
                }
                if (bl == this.mTreeViewer.getChecked(object2)) continue;
                this.mTreeViewer.setChecked(object2, bl);
            }
        }
        this.updateButtonsState();
    }

    private void beginOperationPending() {
        this.mOperationPending = true;
        this.updateButtonsState();
    }

    private void endOperationPending() {
        this.mOperationPending = false;
        this.updateButtonsState();
    }

    private void updateButtonsState() {
        int n;
        if (!this.mButtonInstall.isDisposed()) {
            n = this.getArchivesForInstall(null);
            this.mButtonInstall.setEnabled(n > 0 && !this.mOperationPending);
            this.mButtonInstall.setText(n == 0 ? "Install packages..." : (n == 1 ? "Install 1 package..." : String.format("Install %d packages...", n)));
        }
        if (!this.mButtonDelete.isDisposed()) {
            n = this.getArchivesToDelete(null, null);
            this.mButtonDelete.setEnabled(n > 0 && !this.mOperationPending);
            this.mButtonDelete.setText(n == 0 ? "Delete packages..." : (n == 1 ? "Delete 1 package..." : String.format("Delete %d packages...", n)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onButtonInstall() {
        ArrayList<Archive> arrayList = new ArrayList<Archive>();
        this.getArchivesForInstall(arrayList);
        if (this.mImpl.mUpdaterData != null) {
            boolean bl = false;
            try {
                this.beginOperationPending();
                List<Archive> list = this.mImpl.mUpdaterData.updateOrInstallAll_WithGUI(arrayList, this.mCheckFilterObsolete.getSelection(), this.mContext == SdkUpdaterWindow.SdkInvocationContext.IDE ? 1 : 2);
                bl = list != null && !list.isEmpty();
            }
            finally {
                this.endOperationPending();
                if (bl) {
                    this.mImpl.localReload();
                }
            }
        }
    }

    private int getArchivesForInstall(List<Archive> list) {
        boolean bl;
        if (this.mTreeViewer == null || this.mTreeViewer.getTree() == null || this.mTreeViewer.getTree().isDisposed()) {
            return 0;
        }
        Object[] objectArray = this.mTreeViewer.getCheckedElements();
        if (objectArray == null) {
            return 0;
        }
        int n = 0;
        boolean bl2 = bl = System.getenv("ANDROID_SDK_IGNORE_COMPAT") == null;
        if (this.mDisplayArchives) {
            for (Object object : objectArray) {
                Archive archive;
                if (!(object instanceof Archive) || (archive = (Archive)object) == null || bl && !archive.isCompatible()) continue;
                ++n;
                if (list == null) continue;
                list.add((Archive)object);
            }
        } else {
            for (Object object : objectArray) {
                Package package_ = null;
                if (object instanceof Package) {
                    package_ = (Package)object;
                } else if (object instanceof PkgItem) {
                    package_ = ((PkgItem)object).getMainPackage();
                    PkgItem pkgItem = (PkgItem)object;
                    if (pkgItem.getState() == PkgItem.PkgState.INSTALLED) {
                        package_ = pkgItem.getUpdatePkg();
                    } else if (pkgItem.getState() == PkgItem.PkgState.NEW) {
                        package_ = pkgItem.getMainPackage();
                    }
                }
                if (package_ == null) continue;
                for (Archive archive : package_.getArchives()) {
                    if (archive == null || bl && !archive.isCompatible()) continue;
                    ++n;
                    if (list == null) continue;
                    list.add(archive);
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onButtonDelete() {
        StringBuilder stringBuilder = new StringBuilder("Are you sure you want to delete:");
        final ArrayList<Archive> arrayList = new ArrayList<Archive>();
        this.getArchivesToDelete(stringBuilder, arrayList);
        if (!arrayList.isEmpty()) {
            stringBuilder.append("\n").append("This cannot be undone.");
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"Delete SDK Package", (String)stringBuilder.toString())) {
                try {
                    this.beginOperationPending();
                    this.mImpl.mUpdaterData.getTaskFactory().start("Delete Package", new ITask(){

                        public void run(ITaskMonitor iTaskMonitor) {
                            iTaskMonitor.setProgressMax(arrayList.size() + 1);
                            for (Archive archive : arrayList) {
                                iTaskMonitor.setDescription("Deleting '%1$s' (%2$s)", new Object[]{archive.getParentPackage().getShortDescription(), archive.getLocalOsPath()});
                                archive.deleteLocal();
                                iTaskMonitor.incProgress(1);
                                if (!iTaskMonitor.isCancelRequested()) continue;
                                break;
                            }
                            iTaskMonitor.incProgress(1);
                            iTaskMonitor.setDescription("Done", new Object[0]);
                        }
                    });
                }
                finally {
                    this.endOperationPending();
                    this.mImpl.localReload();
                }
            }
        }
    }

    private int getArchivesToDelete(StringBuilder stringBuilder, List<Archive> list) {
        if (this.mTreeViewer == null || this.mTreeViewer.getTree() == null || this.mTreeViewer.getTree().isDisposed()) {
            return 0;
        }
        Object[] objectArray = this.mTreeViewer.getCheckedElements();
        if (objectArray == null) {
            return 0;
        }
        int n = 0;
        if (this.mDisplayArchives) {
            for (Object object : objectArray) {
                Archive archive;
                if (!(object instanceof Archive) || (archive = (Archive)object) == null || !archive.isLocal()) continue;
                ++n;
                if (stringBuilder != null) {
                    String string = archive.getLocalOsPath();
                    File file = new File(string);
                    Package package_ = archive.getParentPackage();
                    if (package_ != null && file.isDirectory()) {
                        stringBuilder.append("\n - ").append(package_.getShortDescription());
                    }
                }
                if (list == null) continue;
                list.add(archive);
            }
        } else {
            for (Object object : objectArray) {
                PkgItem pkgItem;
                PkgItem.PkgState pkgState;
                if (!(object instanceof PkgItem) || (pkgState = (pkgItem = (PkgItem)object).getState()) != PkgItem.PkgState.INSTALLED) continue;
                Package package_ = pkgItem.getMainPackage();
                for (Archive archive : package_.getArchives()) {
                    String string;
                    File file;
                    if (archive == null || !archive.isLocal()) continue;
                    ++n;
                    if (stringBuilder != null && (file = new File(string = archive.getLocalOsPath())).isDirectory()) {
                        stringBuilder.append("\n - ").append(package_.getShortDescription());
                    }
                    if (list == null) continue;
                    list.add(archive);
                }
            }
        }
        return n;
    }

    @Override
    public void onSdkLoaded() {
        this.onSdkReload();
    }

    @Override
    public void onSdkReload() {
        this.mImpl.loadPackages();
    }

    @Override
    public void preInstallHook() {
    }

    @Override
    public void postInstallHook() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MenuAction {
        RELOAD(0, "Reload"),
        SHOW_ADDON_SITES(0, "Manage Add-on Sites..."),
        TOGGLE_SHOW_ARCHIVES(32, "Show Archives Details"),
        TOGGLE_SHOW_INSTALLED_PKG(32, "Show Installed Packages"),
        TOGGLE_SHOW_OBSOLETE_PKG(32, "Show Obsolete Packages"),
        TOGGLE_SHOW_UPDATE_NEW_PKG(32, "Show Updates/New Packages"),
        SORT_API_LEVEL(16, "Sort by API Level"),
        SORT_SOURCE(16, "Sort by Repository");

        private final int mMenuStyle;
        private final String mMenuTitle;

        private MenuAction(int n2, String string2) {
            this.mMenuStyle = n2;
            this.mMenuTitle = string2;
        }

        public int getMenuStyle() {
            return this.mMenuStyle;
        }

        public String getMenuTitle() {
            return this.mMenuTitle;
        }
    }
}

