/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.tasks;

import com.android.SdkConstants;
import com.android.sdklib.internal.repository.UserCredentials;
import com.android.sdkuilib.internal.tasks.IProgressUiProvider;
import com.android.sdkuilib.ui.AuthenticationDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class ProgressTaskDialog
extends Dialog
implements IProgressUiProvider {
    private static final int MIN_Y = SdkConstants.CURRENT_PLATFORM == 3 ? 20 : 0;
    private CancelMode mCancelMode = CancelMode.ACTIVE;
    private static Point sLastSize;
    private Shell mDialogShell;
    private Composite mRootComposite;
    private Label mLabel;
    private ProgressBar mProgressBar;
    private Button mCancelButton;
    private Text mResultText;

    public ProgressTaskDialog(Shell shell) {
        super(shell, 65536);
    }

    public void open(Thread thread) {
        this.createContents();
        this.positionShell();
        this.mDialogShell.open();
        this.mDialogShell.layout();
        this.startThread(thread);
        Display display = this.getParent().getDisplay();
        while (!this.mDialogShell.isDisposed() && this.mCancelMode != CancelMode.CLOSE_AUTO) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.setCancelRequested();
        if (!this.mDialogShell.isDisposed()) {
            sLastSize = this.mDialogShell.getSize();
            this.mDialogShell.close();
        }
    }

    private void createContents() {
        this.mDialogShell = new Shell(this.getParent(), 2160);
        this.mDialogShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                ProgressTaskDialog.this.onShellClosed(shellEvent);
            }
        });
        this.mDialogShell.setLayout((Layout)new GridLayout(1, false));
        this.mDialogShell.setSize(450, 300);
        this.mDialogShell.setText(this.getText());
        this.mRootComposite = new Composite((Composite)this.mDialogShell, 0);
        this.mRootComposite.setLayout((Layout)new GridLayout(2, false));
        this.mRootComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mLabel = new Label(this.mRootComposite, 0);
        this.mLabel.setText("Task");
        this.mLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mProgressBar = new ProgressBar(this.mRootComposite, 0);
        this.mProgressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mCancelButton = new Button(this.mRootComposite, 0);
        this.mCancelButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProgressTaskDialog.this.onCancelSelected();
            }
        });
        this.mResultText = new Text(this.mRootComposite, 2890);
        this.mResultText.setEditable(true);
        this.mResultText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
    }

    public boolean isCancelRequested() {
        return this.mCancelMode != CancelMode.ACTIVE;
    }

    public void setCancelRequested() {
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    CancelMode cancelMode = ProgressTaskDialog.this.mCancelMode;
                    synchronized (cancelMode) {
                        if (ProgressTaskDialog.this.mCancelMode == CancelMode.ACTIVE) {
                            ProgressTaskDialog.this.mCancelMode = CancelMode.CANCEL_PENDING;
                            if (!ProgressTaskDialog.this.mCancelButton.isDisposed()) {
                                ProgressTaskDialog.this.mCancelButton.setEnabled(false);
                            }
                        }
                    }
                }
            });
        } else if (this.mCancelMode == CancelMode.ACTIVE) {
            this.mCancelMode = CancelMode.CANCEL_PENDING;
        }
    }

    public void setManualCloseRequested() {
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    CancelMode cancelMode = ProgressTaskDialog.this.mCancelMode;
                    synchronized (cancelMode) {
                        if (ProgressTaskDialog.this.mCancelMode != CancelMode.CLOSE_MANUAL && ProgressTaskDialog.this.mCancelMode != CancelMode.CLOSE_AUTO) {
                            ProgressTaskDialog.this.mCancelMode = CancelMode.CLOSE_MANUAL;
                            if (!ProgressTaskDialog.this.mCancelButton.isDisposed()) {
                                ProgressTaskDialog.this.mCancelButton.setEnabled(true);
                                ProgressTaskDialog.this.mCancelButton.setText("Close");
                            }
                        }
                    }
                }
            });
        } else if (this.mCancelMode != CancelMode.CLOSE_MANUAL && this.mCancelMode != CancelMode.CLOSE_AUTO) {
            this.mCancelMode = CancelMode.CLOSE_MANUAL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCloseRequested() {
        CancelMode cancelMode = this.mCancelMode;
        synchronized (cancelMode) {
            if (this.mCancelMode != CancelMode.CLOSE_AUTO) {
                this.mCancelMode = CancelMode.CLOSE_AUTO;
            }
        }
    }

    private void onCancelSelected() {
        if (this.mCancelMode == CancelMode.CLOSE_MANUAL) {
            this.setAutoCloseRequested();
        } else {
            this.setCancelRequested();
        }
    }

    private void onShellClosed(ShellEvent shellEvent) {
        if (this.mCancelMode != CancelMode.CLOSE_AUTO) {
            shellEvent.doit = false;
            this.onCancelSelected();
        }
    }

    public void setDescription(final String string) {
        this.mDialogShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (!ProgressTaskDialog.this.mLabel.isDisposed()) {
                    ProgressTaskDialog.this.mLabel.setText(string);
                }
            }
        });
    }

    public void log(final String string) {
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!ProgressTaskDialog.this.mResultText.isDisposed()) {
                        ProgressTaskDialog.this.mResultText.setVisible(true);
                        String string2 = ProgressTaskDialog.this.mResultText.getText();
                        if (string2 != null && string2.length() > 0 && !string2.endsWith("\n") && !string.startsWith("\n")) {
                            ProgressTaskDialog.this.mResultText.append("\n");
                        }
                        ProgressTaskDialog.this.mResultText.append(string);
                    }
                }
            });
        }
    }

    public void logError(String string) {
        this.log(string);
    }

    public void logVerbose(String string) {
        this.log(string);
    }

    public void setProgressMax(final int n) {
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!ProgressTaskDialog.this.mProgressBar.isDisposed()) {
                        ProgressTaskDialog.this.mProgressBar.setMaximum(n);
                    }
                }
            });
        }
    }

    public void setProgress(final int n) {
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!ProgressTaskDialog.this.mProgressBar.isDisposed()) {
                        ProgressTaskDialog.this.mProgressBar.setSelection(n);
                    }
                }
            });
        }
    }

    public int getProgress() {
        final int[] nArray = new int[]{0};
        if (!this.mDialogShell.isDisposed()) {
            this.mDialogShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!ProgressTaskDialog.this.mProgressBar.isDisposed()) {
                        nArray[0] = ProgressTaskDialog.this.mProgressBar.getSelection();
                    }
                }
            });
        }
        return nArray[0];
    }

    public boolean displayPrompt(final String string, final String string2) {
        Display display = this.mDialogShell.getDisplay();
        final boolean[] blArray = new boolean[]{false};
        display.syncExec(new Runnable(){

            public void run() {
                blArray[0] = MessageDialog.openQuestion((Shell)ProgressTaskDialog.this.mDialogShell, (String)string, (String)string2);
            }
        });
        return blArray[0];
    }

    public UserCredentials displayLoginCredentialsPrompt(String string, String string2) {
        Display display = this.mDialogShell.getDisplay();
        GetUserCredentialsTask getUserCredentialsTask = new GetUserCredentialsTask(this.mDialogShell, string, string2);
        display.syncExec((Runnable)getUserCredentialsTask);
        return getUserCredentialsTask.getUserCredentials();
    }

    private void startThread(Thread thread) {
        if (thread != null) {
            thread.start();
        }
    }

    private void positionShell() {
        Shell shell = this.mDialogShell;
        Shell shell2 = this.getParent();
        if (shell != null && shell2 != null) {
            int n;
            Rectangle rectangle = shell2.getClientArea();
            Point point = shell2.getLocation();
            int n2 = point.x;
            int n3 = point.y;
            int n4 = rectangle.width;
            int n5 = rectangle.height;
            Point point2 = sLastSize != null ? sLastSize : shell.getSize();
            int n6 = point2.x;
            int n7 = point2.y;
            int n8 = n2 + (n4 - n6) / 2;
            if (n8 < 0) {
                n8 = 0;
            }
            if ((n = n3 + (n5 - n7) / 2) < MIN_Y) {
                n = MIN_Y;
            }
            shell.setLocation(n8, n);
            shell.setSize(n6, n7);
        }
    }

    private static class GetUserCredentialsTask
    implements Runnable {
        private UserCredentials mResult = null;
        private Shell mShell;
        private String mTitle;
        private String mMessage;

        public GetUserCredentialsTask(Shell shell, String string, String string2) {
            this.mShell = shell;
            this.mTitle = string;
            this.mMessage = string2;
        }

        public void run() {
            AuthenticationDialog authenticationDialog = new AuthenticationDialog(this.mShell, this.mTitle, this.mMessage);
            int n = authenticationDialog.open();
            if (n == 0) {
                this.mResult = new UserCredentials(authenticationDialog.getLogin(), authenticationDialog.getPassword(), authenticationDialog.getWorkstation(), authenticationDialog.getDomain());
            }
        }

        public UserCredentials getUserCredentials() {
            return this.mResult;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CancelMode {
        ACTIVE,
        CANCEL_PENDING,
        CLOSE_MANUAL,
        CLOSE_AUTO;

    }
}

