/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.sdkuilib.ui.GridDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class ResolutionChooserDialog
extends GridDialog {
    public static final float[] MONITOR_SIZES = new float[]{13.3f, 14.0f, 15.4f, 15.6f, 17.0f, 19.0f, 20.0f, 21.0f, 24.0f, 30.0f};
    private Button mButton;
    private Combo mScreenSizeCombo;
    private Combo mMonitorCombo;
    private Monitor[] mMonitors;
    private int mScreenSizeIndex = -1;
    private int mMonitorIndex = 0;

    public ResolutionChooserDialog(Shell shell) {
        super(shell, 2, false);
    }

    public int getDensity() {
        float f = MONITOR_SIZES[this.mScreenSizeIndex];
        Rectangle rectangle = this.mMonitors[this.mMonitorIndex].getBounds();
        double d = Math.sqrt(rectangle.width * rectangle.width + rectangle.height * rectangle.height) / (double)f;
        return (int)Math.round(d);
    }

    protected void configureShell(Shell shell) {
        shell.setText("Monitor Density");
        super.configureShell(shell);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.mButton = this.getButton(0);
        this.mButton.setEnabled(false);
        return control;
    }

    public void createDialogContent(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Screen Size:");
        this.mScreenSizeCombo = new Combo(composite, 12);
        for (float f : MONITOR_SIZES) {
            if ((float)Math.round(f) == f) {
                this.mScreenSizeCombo.add(String.format("%.0f\"", Float.valueOf(f)));
                continue;
            }
            this.mScreenSizeCombo.add(String.format("%.1f\"", Float.valueOf(f)));
        }
        this.mScreenSizeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResolutionChooserDialog.this.mScreenSizeIndex = ResolutionChooserDialog.this.mScreenSizeCombo.getSelectionIndex();
                ResolutionChooserDialog.this.mButton.setEnabled(ResolutionChooserDialog.this.mScreenSizeIndex != -1);
            }
        });
        label = new Label(composite, 0);
        label.setText("Resolution:");
        this.mMonitorCombo = new Combo(composite, 12);
        for (Monitor monitor : this.mMonitors = composite.getDisplay().getMonitors()) {
            Rectangle rectangle = monitor.getBounds();
            this.mMonitorCombo.add(String.format("%d x %d", rectangle.width, rectangle.height));
        }
        this.mMonitorCombo.select(this.mMonitorIndex);
        this.mMonitorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ResolutionChooserDialog.this.mMonitorIndex = ResolutionChooserDialog.this.mMonitorCombo.getSelectionIndex();
            }
        });
    }
}

