/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ToggleButton
extends CLabel {
    private Image[] mImage = new Image[2];
    private String[] mTooltip = new String[2];
    private boolean mMouseIn;
    private int mState = 0;

    public ToggleButton(Composite composite, int n, Image image, Image image2, String string, String string2) {
        super(composite, n);
        this.mImage[0] = image;
        this.mImage[1] = image2;
        this.mTooltip[0] = string;
        this.mTooltip[1] = string2;
        this.updateImageAndTooltip();
        this.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (ToggleButton.this.mMouseIn && mouseEvent.button == 1) {
                    ToggleButton.this.notifyListeners(13, new Event());
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (ToggleButton.this.mMouseIn && mouseEvent.button == 1) {
                    ToggleButton.this.notifyListeners(14, new Event());
                }
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseExit(MouseEvent mouseEvent) {
                if (ToggleButton.this.mMouseIn) {
                    ToggleButton.this.mMouseIn = false;
                    ToggleButton.this.redraw();
                }
            }

            public void mouseEnter(MouseEvent mouseEvent) {
                if (!ToggleButton.this.mMouseIn) {
                    ToggleButton.this.mMouseIn = true;
                    ToggleButton.this.redraw();
                }
            }

            public void mouseHover(MouseEvent mouseEvent) {
            }
        });
    }

    public int getStyle() {
        int n = super.getStyle();
        if (this.mMouseIn) {
            n |= 4;
        }
        return n;
    }

    public void setState(int n) {
        assert (n == 0 || n == 1);
        this.mState = n;
        this.updateImageAndTooltip();
        this.redraw();
    }

    public int getState() {
        return this.mState;
    }

    protected void updateImageAndTooltip() {
        this.setImage(this.mImage[this.getState()]);
        this.setToolTipText(this.mTooltip[this.getState()]);
    }
}

