/*
 * Decompiled with CFR 0.152.
 */
package com.android.menubar;

import com.android.menubar.IMenuBarCallback;
import com.android.menubar.IMenuBarEnhancer;
import com.android.menubar.MenuBarEnhancer37;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class MenuBarEnhancer {
    private MenuBarEnhancer() {
    }

    public static IMenuBarEnhancer setupMenu(String string, Menu menu, IMenuBarCallback iMenuBarCallback) {
        IMenuBarEnhancer iMenuBarEnhancer;
        block5: {
            iMenuBarEnhancer = MenuBarEnhancer.getEnhancer(iMenuBarCallback, menu.getDisplay());
            if (iMenuBarEnhancer == null) {
                iMenuBarEnhancer = MenuBarEnhancer.getGenericEnhancer(menu);
            }
            try {
                iMenuBarEnhancer.setupMenu(string, menu.getDisplay(), iMenuBarCallback);
            }
            catch (Exception exception) {
                if (iMenuBarEnhancer.getMenuBarMode() == IMenuBarEnhancer.MenuBarMode.GENERIC) break block5;
                iMenuBarEnhancer = MenuBarEnhancer.getGenericEnhancer(menu);
                try {
                    iMenuBarEnhancer.setupMenu(string, menu.getDisplay(), iMenuBarCallback);
                }
                catch (Exception exception2) {
                    iMenuBarCallback.printError("SWTMenuBar failed: %s", exception2.toString());
                    return null;
                }
            }
        }
        return iMenuBarEnhancer;
    }

    private static IMenuBarEnhancer getGenericEnhancer(final Menu menu) {
        IMenuBarEnhancer iMenuBarEnhancer = new IMenuBarEnhancer(){

            public IMenuBarEnhancer.MenuBarMode getMenuBarMode() {
                return IMenuBarEnhancer.MenuBarMode.GENERIC;
            }

            public void setupMenu(String string, Display display, final IMenuBarCallback iMenuBarCallback) {
                if (menu.getItemCount() > 0) {
                    new MenuItem(menu, 2);
                }
                final MenuItem menuItem = new MenuItem(menu, 0);
                menuItem.setText("&Options...");
                final MenuItem menuItem2 = new MenuItem(menu, 0);
                menuItem2.setText("&About...");
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        try {
                            menuItem.setEnabled(false);
                            iMenuBarCallback.onPreferencesMenuSelected();
                            super.widgetSelected(selectionEvent);
                        }
                        finally {
                            menuItem.setEnabled(true);
                        }
                    }
                });
                menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        try {
                            menuItem2.setEnabled(false);
                            iMenuBarCallback.onAboutMenuSelected();
                            super.widgetSelected(selectionEvent);
                        }
                        finally {
                            menuItem2.setEnabled(true);
                        }
                    }
                });
            }
        };
        return iMenuBarEnhancer;
    }

    public static IMenuBarEnhancer setupMenuManager(String string, Display display, final IMenuManager iMenuManager, final IAction iAction, final IAction iAction2, final IAction iAction3) {
        IMenuBarCallback iMenuBarCallback = new IMenuBarCallback(){

            public void printError(String string, Object ... objectArray) {
                System.err.println(String.format(string, objectArray));
            }

            public void onPreferencesMenuSelected() {
                if (iAction2 != null) {
                    iAction2.run();
                }
            }

            public void onAboutMenuSelected() {
                if (iAction != null) {
                    iAction.run();
                }
            }
        };
        IMenuBarEnhancer iMenuBarEnhancer = MenuBarEnhancer.getEnhancer(iMenuBarCallback, display);
        if (iMenuBarEnhancer == null) {
            iMenuBarEnhancer = new IMenuBarEnhancer(){

                public IMenuBarEnhancer.MenuBarMode getMenuBarMode() {
                    return IMenuBarEnhancer.MenuBarMode.GENERIC;
                }

                public void setupMenu(String string, Display display, IMenuBarCallback iMenuBarCallback) {
                    if (!iMenuManager.isEmpty()) {
                        iMenuManager.add((IContributionItem)new Separator());
                    }
                    if (iAction != null) {
                        iMenuManager.add(iAction);
                    }
                    if (iAction2 != null) {
                        iMenuManager.add(iAction2);
                    }
                    if (iAction3 != null) {
                        if (iAction != null || iAction2 != null) {
                            iMenuManager.add((IContributionItem)new Separator());
                        }
                        iMenuManager.add(iAction3);
                    }
                }
            };
        }
        iMenuBarEnhancer.setupMenu(string, display, iMenuBarCallback);
        return iMenuBarEnhancer;
    }

    private static IMenuBarEnhancer getEnhancer(IMenuBarCallback iMenuBarCallback, Display display) {
        IMenuBarEnhancer iMenuBarEnhancer = null;
        String string = SWT.getPlatform();
        String string2 = null;
        if ("cocoa".equals(string)) {
            string2 = "com.android.menubar.internal.MenuBarEnhancerCocoa";
            if (SWT.getVersion() >= 3700 && MenuBarEnhancer37.isSupported(display)) {
                string2 = MenuBarEnhancer37.class.getName();
            }
        }
        if (System.getenv("DEBUG_SWTMENUBAR") != null) {
            iMenuBarCallback.printError("DEBUG SwtMenuBar: SWT=%1$s, class=%2$s", string, string2);
        }
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                iMenuBarEnhancer = (IMenuBarEnhancer)clazz.newInstance();
            }
            catch (Exception exception) {
                iMenuBarCallback.printError("Failed to instantiate %1$s: %2$s", string2, exception.toString());
            }
        }
        return iMenuBarEnhancer;
    }
}

