/*
 * Decompiled with CFR 0.152.
 */
package com.android.menubar;

import com.android.menubar.IMenuBarCallback;
import com.android.menubar.IMenuBarEnhancer;
import java.lang.reflect.Method;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuBarEnhancer37
implements IMenuBarEnhancer {
    private static final int kAboutMenuItem = -1;
    private static final int kPreferencesMenuItem = -2;
    private static final int kQuitMenuItem = -6;

    public IMenuBarEnhancer.MenuBarMode getMenuBarMode() {
        return IMenuBarEnhancer.MenuBarMode.MAC_OS;
    }

    public void setupMenu(String string, Display display, IMenuBarCallback iMenuBarCallback) {
        try {
            this.initialize(display, string, iMenuBarCallback);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        display.disposeExec(new Runnable(){

            public void run() {
            }
        });
    }

    public static boolean isSupported(Display display) {
        try {
            Object object = MenuBarEnhancer37.call0(display, "getSystemMenu");
            if (object instanceof Menu) {
                return MenuBarEnhancer37.findMenuById((Menu)object, -2) != null && MenuBarEnhancer37.findMenuById((Menu)object, -1) != null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void initialize(Display display, String string, final IMenuBarCallback iMenuBarCallback) throws Exception {
        Object object = MenuBarEnhancer37.call0(display, "getSystemMenu");
        if (object instanceof Menu) {
            MenuItem menuItem = MenuBarEnhancer37.findMenuById((Menu)object, -2);
            if (menuItem != null) {
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        iMenuBarCallback.onPreferencesMenuSelected();
                    }
                });
            }
            if ((menuItem = MenuBarEnhancer37.findMenuById((Menu)object, -1)) != null) {
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        iMenuBarCallback.onAboutMenuSelected();
                    }
                });
                menuItem.setText("About " + string);
            }
            if ((menuItem = MenuBarEnhancer37.findMenuById((Menu)object, -6)) != null) {
                menuItem.setText("Quit " + string);
            }
        }
    }

    private static Object call0(Object object, String string) {
        try {
            Method method = object.getClass().getMethod(string, null);
            if (method != null) {
                return method.invoke(object, (Object[])null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static MenuItem findMenuById(Menu menu, int n) {
        MenuItem[] menuItemArray = menu.getItems();
        for (int i = menuItemArray.length - 1; i >= 0; --i) {
            MenuItem menuItem = menuItemArray[i];
            Object object = MenuBarEnhancer37.call0(menuItem, "getID");
            if (!(object instanceof Integer) || (Integer)object != n) continue;
            return menuItem;
        }
        return null;
    }
}

