/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.Call;
import com.android.traceview.ProfileData;
import com.android.traceview.ProfileNode;
import com.android.traceview.ProfileSelf;
import com.android.traceview.TimeBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodData {
    private int mId;
    private int mRank = -1;
    private String mClassName;
    private String mMethodName;
    private String mSignature;
    private String mName;
    private String mProfileName;
    private String mPathname;
    private int mLineNumber;
    private long mElapsedExclusiveCpuTime;
    private long mElapsedInclusiveCpuTime;
    private long mTopExclusiveCpuTime;
    private long mElapsedExclusiveRealTime;
    private long mElapsedInclusiveRealTime;
    private long mTopExclusiveRealTime;
    private int[] mNumCalls = new int[2];
    private Color mColor;
    private Color mFadedColor;
    private Image mImage;
    private Image mFadedImage;
    private HashMap<Integer, ProfileData> mParents;
    private HashMap<Integer, ProfileData> mChildren;
    private HashMap<Integer, ProfileData> mRecursiveParents;
    private HashMap<Integer, ProfileData> mRecursiveChildren;
    private ProfileNode[] mProfileNodes;
    private int mX;
    private int mY;
    private double mWeight;

    public MethodData(int n, String string) {
        this.mId = n;
        this.mClassName = string;
        this.mMethodName = null;
        this.mSignature = null;
        this.mPathname = null;
        this.mLineNumber = -1;
        this.computeName();
        this.computeProfileName();
    }

    public MethodData(int n, String string, String string2, String string3, String string4, int n2) {
        this.mId = n;
        this.mClassName = string;
        this.mMethodName = string2;
        this.mSignature = string3;
        this.mPathname = string4;
        this.mLineNumber = n2;
        this.computeName();
        this.computeProfileName();
    }

    public double addWeight(int n, int n2, double d) {
        if (this.mX == n && this.mY == n2) {
            this.mWeight += d;
        } else {
            this.mX = n;
            this.mY = n2;
            this.mWeight = d;
        }
        return this.mWeight;
    }

    public void clearWeight() {
        this.mWeight = 0.0;
    }

    public int getRank() {
        return this.mRank;
    }

    public void setRank(int n) {
        this.mRank = n;
        this.computeProfileName();
    }

    public void addElapsedExclusive(long l, long l2) {
        this.mElapsedExclusiveCpuTime += l;
        this.mElapsedExclusiveRealTime += l2;
    }

    public void addElapsedInclusive(long l, long l2, boolean bl, Call call) {
        if (!bl) {
            this.mElapsedInclusiveCpuTime += l;
            this.mElapsedInclusiveRealTime += l2;
            this.mNumCalls[0] = this.mNumCalls[0] + 1;
        } else {
            this.mNumCalls[1] = this.mNumCalls[1] + 1;
        }
        if (call == null) {
            return;
        }
        MethodData methodData = call.getMethodData();
        if (call.isRecursive()) {
            methodData.mRecursiveChildren = this.updateInclusive(l, l2, methodData, this, false, methodData.mRecursiveChildren);
        } else {
            methodData.mChildren = this.updateInclusive(l, l2, methodData, this, false, methodData.mChildren);
        }
        if (bl) {
            this.mRecursiveParents = this.updateInclusive(l, l2, this, methodData, true, this.mRecursiveParents);
        } else {
            this.mParents = this.updateInclusive(l, l2, this, methodData, true, this.mParents);
        }
    }

    private HashMap<Integer, ProfileData> updateInclusive(long l, long l2, MethodData methodData, MethodData methodData2, boolean bl, HashMap<Integer, ProfileData> hashMap) {
        ProfileData profileData;
        if (hashMap == null) {
            hashMap = new HashMap(4);
        } else {
            profileData = hashMap.get(methodData2.mId);
            if (profileData != null) {
                profileData.addElapsedInclusive(l, l2);
                return hashMap;
            }
        }
        profileData = new ProfileData(methodData, methodData2, bl);
        profileData.setElapsedInclusive(l, l2);
        profileData.setNumCalls(1);
        hashMap.put(methodData2.mId, profileData);
        return hashMap;
    }

    public void analyzeData(TimeBase timeBase) {
        ProfileNode profileNode;
        ProfileData[] profileDataArray = this.sortProfileData(this.mParents, timeBase);
        ProfileData[] profileDataArray2 = this.sortProfileData(this.mChildren, timeBase);
        ProfileData[] profileDataArray3 = this.sortProfileData(this.mRecursiveParents, timeBase);
        ProfileData[] profileDataArray4 = this.sortProfileData(this.mRecursiveChildren, timeBase);
        profileDataArray2 = this.addSelf(profileDataArray2);
        ArrayList<ProfileNode> arrayList = new ArrayList<ProfileNode>();
        if (this.mParents != null) {
            profileNode = new ProfileNode("Parents", this, profileDataArray, true, false);
            arrayList.add(profileNode);
        }
        if (this.mChildren != null) {
            profileNode = new ProfileNode("Children", this, profileDataArray2, false, false);
            arrayList.add(profileNode);
        }
        if (this.mRecursiveParents != null) {
            profileNode = new ProfileNode("Parents while recursive", this, profileDataArray3, true, true);
            arrayList.add(profileNode);
        }
        if (this.mRecursiveChildren != null) {
            profileNode = new ProfileNode("Children while recursive", this, profileDataArray4, false, true);
            arrayList.add(profileNode);
        }
        this.mProfileNodes = arrayList.toArray(new ProfileNode[arrayList.size()]);
    }

    private ProfileData[] sortProfileData(HashMap<Integer, ProfileData> hashMap, final TimeBase timeBase) {
        if (hashMap == null) {
            return null;
        }
        Collection<ProfileData> collection = hashMap.values();
        ProfileData[] profileDataArray = collection.toArray(new ProfileData[collection.size()]);
        Arrays.sort(profileDataArray, new Comparator<ProfileData>(){

            @Override
            public int compare(ProfileData profileData, ProfileData profileData2) {
                if (timeBase.getElapsedInclusiveTime(profileData2) > timeBase.getElapsedInclusiveTime(profileData)) {
                    return 1;
                }
                if (timeBase.getElapsedInclusiveTime(profileData2) < timeBase.getElapsedInclusiveTime(profileData)) {
                    return -1;
                }
                return 0;
            }
        });
        return profileDataArray;
    }

    private ProfileData[] addSelf(ProfileData[] profileDataArray) {
        ProfileData[] profileDataArray2;
        if (profileDataArray == null) {
            profileDataArray2 = new ProfileData[1];
        } else {
            profileDataArray2 = new ProfileData[profileDataArray.length + 1];
            System.arraycopy(profileDataArray, 0, profileDataArray2, 1, profileDataArray.length);
        }
        profileDataArray2[0] = new ProfileSelf(this);
        return profileDataArray2;
    }

    public void addTopExclusive(long l, long l2) {
        this.mTopExclusiveCpuTime += l;
        this.mTopExclusiveRealTime += l2;
    }

    public long getTopExclusiveCpuTime() {
        return this.mTopExclusiveCpuTime;
    }

    public long getTopExclusiveRealTime() {
        return this.mTopExclusiveRealTime;
    }

    public int getId() {
        return this.mId;
    }

    private void computeName() {
        if (this.mMethodName == null) {
            this.mName = this.mClassName;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mClassName);
        stringBuilder.append(".");
        stringBuilder.append(this.mMethodName);
        stringBuilder.append(" ");
        stringBuilder.append(this.mSignature);
        this.mName = stringBuilder.toString();
    }

    public String getName() {
        return this.mName;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getMethodName() {
        return this.mMethodName;
    }

    public String getProfileName() {
        return this.mProfileName;
    }

    public String getSignature() {
        return this.mSignature;
    }

    public void computeProfileName() {
        if (this.mRank == -1) {
            this.mProfileName = this.mName;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mRank);
        stringBuilder.append(" ");
        stringBuilder.append(this.getName());
        this.mProfileName = stringBuilder.toString();
    }

    public String getCalls() {
        return String.format("%d+%d", this.mNumCalls[0], this.mNumCalls[1]);
    }

    public int getTotalCalls() {
        return this.mNumCalls[0] + this.mNumCalls[1];
    }

    public Color getColor() {
        return this.mColor;
    }

    public void setColor(Color color) {
        this.mColor = color;
    }

    public void setImage(Image image) {
        this.mImage = image;
    }

    public Image getImage() {
        return this.mImage;
    }

    public String toString() {
        return this.getName();
    }

    public long getElapsedExclusiveCpuTime() {
        return this.mElapsedExclusiveCpuTime;
    }

    public long getElapsedExclusiveRealTime() {
        return this.mElapsedExclusiveRealTime;
    }

    public long getElapsedInclusiveCpuTime() {
        return this.mElapsedInclusiveCpuTime;
    }

    public long getElapsedInclusiveRealTime() {
        return this.mElapsedInclusiveRealTime;
    }

    public void setFadedColor(Color color) {
        this.mFadedColor = color;
    }

    public Color getFadedColor() {
        return this.mFadedColor;
    }

    public void setFadedImage(Image image) {
        this.mFadedImage = image;
    }

    public Image getFadedImage() {
        return this.mFadedImage;
    }

    public void setPathname(String string) {
        this.mPathname = string;
    }

    public String getPathname() {
        return this.mPathname;
    }

    public void setLineNumber(int n) {
        this.mLineNumber = n;
    }

    public int getLineNumber() {
        return this.mLineNumber;
    }

    public ProfileNode[] getProfileNodes() {
        return this.mProfileNodes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Sorter
    implements Comparator<MethodData> {
        private Column mColumn;
        private Direction mDirection;

        @Override
        public int compare(MethodData methodData, MethodData methodData2) {
            if (this.mColumn == Column.BY_NAME) {
                int n = methodData.getName().compareTo(methodData2.getName());
                return this.mDirection == Direction.INCREASING ? n : -n;
            }
            if (this.mColumn == Column.BY_INCLUSIVE_CPU_TIME) {
                if (methodData2.getElapsedInclusiveCpuTime() > methodData.getElapsedInclusiveCpuTime()) {
                    return this.mDirection == Direction.INCREASING ? -1 : 1;
                }
                if (methodData2.getElapsedInclusiveCpuTime() < methodData.getElapsedInclusiveCpuTime()) {
                    return this.mDirection == Direction.INCREASING ? 1 : -1;
                }
                return methodData.getName().compareTo(methodData2.getName());
            }
            if (this.mColumn == Column.BY_EXCLUSIVE_CPU_TIME) {
                if (methodData2.getElapsedExclusiveCpuTime() > methodData.getElapsedExclusiveCpuTime()) {
                    return this.mDirection == Direction.INCREASING ? -1 : 1;
                }
                if (methodData2.getElapsedExclusiveCpuTime() < methodData.getElapsedExclusiveCpuTime()) {
                    return this.mDirection == Direction.INCREASING ? 1 : -1;
                }
                return methodData.getName().compareTo(methodData2.getName());
            }
            if (this.mColumn == Column.BY_INCLUSIVE_REAL_TIME) {
                if (methodData2.getElapsedInclusiveRealTime() > methodData.getElapsedInclusiveRealTime()) {
                    return this.mDirection == Direction.INCREASING ? -1 : 1;
                }
                if (methodData2.getElapsedInclusiveRealTime() < methodData.getElapsedInclusiveRealTime()) {
                    return this.mDirection == Direction.INCREASING ? 1 : -1;
                }
                return methodData.getName().compareTo(methodData2.getName());
            }
            if (this.mColumn == Column.BY_EXCLUSIVE_REAL_TIME) {
                if (methodData2.getElapsedExclusiveRealTime() > methodData.getElapsedExclusiveRealTime()) {
                    return this.mDirection == Direction.INCREASING ? -1 : 1;
                }
                if (methodData2.getElapsedExclusiveRealTime() < methodData.getElapsedExclusiveRealTime()) {
                    return this.mDirection == Direction.INCREASING ? 1 : -1;
                }
                return methodData.getName().compareTo(methodData2.getName());
            }
            if (this.mColumn == Column.BY_CALLS) {
                int n = methodData.getTotalCalls() - methodData2.getTotalCalls();
                if (n == 0) {
                    return methodData.getName().compareTo(methodData2.getName());
                }
                return this.mDirection == Direction.INCREASING ? n : -n;
            }
            if (this.mColumn == Column.BY_CPU_TIME_PER_CALL) {
                double d = methodData.getElapsedInclusiveCpuTime();
                double d2 = methodData2.getElapsedInclusiveCpuTime();
                double d3 = (d /= (double)methodData.getTotalCalls()) - (d2 /= (double)methodData2.getTotalCalls());
                int n = 0;
                if (d3 < 0.0) {
                    n = -1;
                } else if (d3 > 0.0) {
                    n = 1;
                }
                if (n == 0) {
                    return methodData.getName().compareTo(methodData2.getName());
                }
                return this.mDirection == Direction.INCREASING ? n : -n;
            }
            if (this.mColumn == Column.BY_REAL_TIME_PER_CALL) {
                double d = methodData.getElapsedInclusiveRealTime();
                double d4 = methodData2.getElapsedInclusiveRealTime();
                double d5 = (d /= (double)methodData.getTotalCalls()) - (d4 /= (double)methodData2.getTotalCalls());
                int n = 0;
                if (d5 < 0.0) {
                    n = -1;
                } else if (d5 > 0.0) {
                    n = 1;
                }
                if (n == 0) {
                    return methodData.getName().compareTo(methodData2.getName());
                }
                return this.mDirection == Direction.INCREASING ? n : -n;
            }
            return 0;
        }

        public void setColumn(Column column) {
            this.mDirection = this.mColumn == column ? (this.mDirection == Direction.INCREASING ? Direction.DECREASING : Direction.INCREASING) : (column == Column.BY_NAME ? Direction.INCREASING : Direction.DECREASING);
            this.mColumn = column;
        }

        public Column getColumn() {
            return this.mColumn;
        }

        public void setDirection(Direction direction) {
            this.mDirection = direction;
        }

        public Direction getDirection() {
            return this.mDirection;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Direction {
            INCREASING,
            DECREASING;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Column {
            BY_NAME,
            BY_EXCLUSIVE_CPU_TIME,
            BY_EXCLUSIVE_REAL_TIME,
            BY_INCLUSIVE_CPU_TIME,
            BY_INCLUSIVE_REAL_TIME,
            BY_CALLS,
            BY_REAL_TIME_PER_CALL,
            BY_CPU_TIME_PER_CALL;

        }
    }
}

