/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.Call;
import com.android.traceview.MethodData;
import com.android.traceview.ProfileData;
import com.android.traceview.ProfileNode;
import com.android.traceview.ProfileProvider;
import com.android.traceview.Selection;
import com.android.traceview.SelectionController;
import com.android.traceview.TraceReader;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ProfileView
extends Composite
implements Observer {
    private TreeViewer mTreeViewer;
    private Text mSearchBox;
    private SelectionController mSelectionController;
    private ProfileProvider mProfileProvider;
    private Color mColorNoMatch;
    private Color mColorMatch;
    private MethodData mCurrentHighlightedMethod;
    private MethodHandler mMethodHandler;

    public ProfileView(Composite composite, TraceReader traceReader, SelectionController selectionController) {
        super(composite, 0);
        TreeColumn treeColumn;
        this.setLayout((Layout)new GridLayout(1, false));
        this.mSelectionController = selectionController;
        this.mSelectionController.addObserver(this);
        this.mTreeViewer = new TreeViewer((Composite)this, 2);
        this.mTreeViewer.setUseHashlookup(true);
        this.mProfileProvider = traceReader.getProfileProvider();
        this.mProfileProvider.setTreeViewer(this.mTreeViewer);
        SelectionAdapter selectionAdapter = this.mProfileProvider.getColumnListener();
        final Tree tree = this.mTreeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        String[] stringArray = this.mProfileProvider.getColumnNames();
        int[] nArray = this.mProfileProvider.getColumnWidths();
        int[] nArray2 = this.mProfileProvider.getColumnAlignments();
        for (int i = 0; i < nArray.length; ++i) {
            treeColumn = new TreeColumn(tree, 16384);
            treeColumn.setText(stringArray[i]);
            treeColumn.setWidth(nArray[i]);
            treeColumn.setMoveable(true);
            treeColumn.addSelectionListener((SelectionListener)selectionAdapter);
            treeColumn.setAlignment(nArray2[i]);
        }
        tree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                int n;
                event.height = n = event.gc.getFontMetrics().getHeight();
            }
        });
        this.mTreeViewer.setContentProvider((IContentProvider)this.mProfileProvider);
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)this.mProfileProvider.getLabelProvider());
        this.mTreeViewer.setInput(this.mProfileProvider.getRoot());
        Composite composite2 = new Composite((Composite)this, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(768));
        treeColumn = new Label(composite2, 0);
        treeColumn.setText("Find:");
        this.mSearchBox = new Text(composite2, 2048);
        this.mSearchBox.setLayoutData((Object)new GridData(768));
        Display display = this.getDisplay();
        this.mColorNoMatch = new Color((Device)display, 255, 200, 200);
        this.mColorMatch = this.mSearchBox.getBackground();
        this.mSearchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = ProfileView.this.mSearchBox.getText();
                if (string.length() == 0) {
                    return;
                }
                ProfileView.this.findName(string);
            }
        });
        this.mSearchBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 27) {
                    ProfileView.this.mSearchBox.setText("");
                } else if (keyEvent.keyCode == 13) {
                    String string = ProfileView.this.mSearchBox.getText();
                    if (string.length() == 0) {
                        return;
                    }
                    ProfileView.this.findNextName(string);
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 27) {
                    ProfileView.this.mSearchBox.setText("");
                } else if (keyEvent.keyCode == 8) {
                    String string = ProfileView.this.mSearchBox.getText();
                    int n = string.length();
                    String string2 = n <= 1 ? "" : string.substring(0, n - 1);
                    ProfileView.this.mSearchBox.setText(string2);
                } else if (keyEvent.keyCode == 13) {
                    String string = ProfileView.this.mSearchBox.getText();
                    if (string.length() == 0) {
                        return;
                    }
                    ProfileView.this.findNextName(string);
                } else {
                    String string = String.valueOf(keyEvent.character);
                    ProfileView.this.mSearchBox.append(string);
                }
                keyEvent.doit = false;
            }
        });
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection.isEmpty()) {
                    return;
                }
                if (iSelection instanceof IStructuredSelection) {
                    MethodData methodData;
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                    Object object = iStructuredSelection.getFirstElement();
                    if (object == null) {
                        return;
                    }
                    if (object instanceof MethodData) {
                        methodData = (MethodData)object;
                        ProfileView.this.highlightMethod(methodData, true);
                    }
                    if (object instanceof ProfileData) {
                        methodData = ((ProfileData)object).getMethodData();
                        ProfileView.this.highlightMethod(methodData, true);
                    }
                }
            }
        });
        this.mTreeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                Object object = treeExpansionEvent.getElement();
                if (object instanceof MethodData) {
                    MethodData methodData = (MethodData)object;
                    ProfileView.this.expandNode(methodData);
                }
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        tree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem treeItem = tree.getItem(point);
                MethodData methodData = ProfileView.this.mProfileProvider.findMatchingTreeItem(treeItem);
                if (methodData == null) {
                    return;
                }
                ArrayList<Selection> arrayList = new ArrayList<Selection>();
                arrayList.add(Selection.highlight("MethodData", methodData));
                ProfileView.this.mSelectionController.change(arrayList, "ProfileView");
                if (ProfileView.this.mMethodHandler != null && (event.stateMask & SWT.MOD1) != 0) {
                    ProfileView.this.mMethodHandler.handleMethod(methodData);
                }
            }
        });
    }

    public void setMethodHandler(MethodHandler methodHandler) {
        this.mMethodHandler = methodHandler;
    }

    private void findName(String string) {
        MethodData methodData = this.mProfileProvider.findMatchingName(string);
        this.selectMethod(methodData);
    }

    private void findNextName(String string) {
        MethodData methodData = this.mProfileProvider.findNextMatchingName(string);
        this.selectMethod(methodData);
    }

    private void selectMethod(MethodData methodData) {
        if (methodData == null) {
            this.mSearchBox.setBackground(this.mColorNoMatch);
            return;
        }
        this.mSearchBox.setBackground(this.mColorMatch);
        this.highlightMethod(methodData, false);
    }

    public void update(Observable observable, Object object) {
        if (object == "ProfileView") {
            return;
        }
        ArrayList<Selection> arrayList = this.mSelectionController.getSelections();
        for (Selection selection : arrayList) {
            Selection.Action action = selection.getAction();
            if (action != Selection.Action.Highlight) continue;
            String string = selection.getName();
            if (string == "MethodData") {
                MethodData methodData = (MethodData)selection.getValue();
                this.highlightMethod(methodData, true);
                return;
            }
            if (string != "Call") continue;
            Call call = (Call)selection.getValue();
            MethodData methodData = call.getMethodData();
            this.highlightMethod(methodData, true);
            return;
        }
    }

    private void highlightMethod(MethodData methodData, boolean bl) {
        if (methodData == null) {
            return;
        }
        if (methodData == this.mCurrentHighlightedMethod) {
            return;
        }
        if (bl) {
            this.mSearchBox.setText("");
            this.mSearchBox.setBackground(this.mColorMatch);
        }
        this.mCurrentHighlightedMethod = methodData;
        this.mTreeViewer.collapseAll();
        this.expandNode(methodData);
        StructuredSelection structuredSelection = new StructuredSelection((Object)methodData);
        this.mTreeViewer.setSelection((ISelection)structuredSelection, true);
        Tree tree = this.mTreeViewer.getTree();
        TreeItem[] treeItemArray = tree.getSelection();
        if (treeItemArray.length != 0) {
            tree.setTopItem(treeItemArray[0]);
            tree.showItem(treeItemArray[0]);
        }
    }

    private void expandNode(MethodData methodData) {
        ProfileNode[] profileNodeArray = methodData.getProfileNodes();
        this.mTreeViewer.setExpandedState((Object)methodData, true);
        if (profileNodeArray != null) {
            for (ProfileNode profileNode : profileNodeArray) {
                if (profileNode.isRecursive()) continue;
                this.mTreeViewer.setExpandedState((Object)profileNode, true);
            }
        }
    }

    public static interface MethodHandler {
        public void handleMethod(MethodData var1);
    }
}

